/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.PlotWindow;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.util.StringTokenizer;

public class Calibrator
implements PlugInFilter,
Measurements {
    private static final String NONE = "None";
    private static final String INVERTER = "Pixel Inverter";
    private static final String UNCALIBRATED_OD = "Uncalibrated OD";
    private static boolean showSettings;
    static boolean global;
    private static boolean oldGlobal;
    private ImagePlus imp;
    private int choiceIndex;
    private String[] functions;
    private int nFits = CurveFitter.fitList.length;
    private int spacerIndex = this.nFits + 1;
    private int inverterIndex = this.nFits + 2;
    private int odIndex = this.nFits + 3;
    private String xText;
    private static String yText;
    private String unit;
    private double lx = 0.02;
    private double ly = 0.1;
    private int oldFunction;
    private String sumResiduals;
    private String fitGoodness;
    static /* synthetic */ Class class$ij$plugin$filter$Calibrator;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        IJ.register(class$ij$plugin$filter$Calibrator == null ? (class$ij$plugin$filter$Calibrator = Calibrator.class$("ij.plugin.filter.Calibrator")) : class$ij$plugin$filter$Calibrator);
        return 135;
    }

    public void run(ImageProcessor imageProcessor) {
        oldGlobal = global;
        if (!this.showDialog(this.imp)) {
            return;
        }
        this.calibrate(this.imp);
        if (global || global != oldGlobal) {
            int[] nArray = WindowManager.getIDList();
            if (nArray == null) {
                return;
            }
            int n = 0;
            while (n < nArray.length) {
                ImagePlus imagePlus = WindowManager.getImage(nArray[n]);
                if (imagePlus != null) {
                    imagePlus.getWindow().repaint();
                }
                ++n;
            }
        } else {
            this.imp.getWindow().repaint();
        }
    }

    public boolean showDialog(ImagePlus imagePlus) {
        int n;
        Calibration calibration = imagePlus.getCalibration();
        this.functions = this.getFunctionList();
        this.oldFunction = n = calibration.getFunction();
        double[] dArray = calibration.getCoefficients();
        this.unit = calibration.getValueUnit();
        String string = n == 20 ? NONE : (n < this.nFits && n == 0 && dArray != null && dArray[0] == 255.0 && dArray[1] == -1.0 ? INVERTER : (n < this.nFits ? CurveFitter.fitList[n] : (n == 21 ? UNCALIBRATED_OD : NONE)));
        this.xText = this.getMeans();
        GenericDialog genericDialog = new GenericDialog("Calibrate...");
        genericDialog.addChoice("Function:", this.functions, string);
        genericDialog.addStringField("Unit:", this.unit, 16);
        genericDialog.addTextAreas(this.xText, yText, 20, 14);
        genericDialog.addCheckbox("Global Calibration", global);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        this.choiceIndex = genericDialog.getNextChoiceIndex();
        this.unit = genericDialog.getNextString();
        this.xText = genericDialog.getNextText();
        yText = genericDialog.getNextText();
        global = genericDialog.getNextBoolean();
        return true;
    }

    public void calibrate(ImagePlus imagePlus) {
        Calibration calibration = imagePlus.getCalibration();
        int n = 20;
        boolean bl = imagePlus.getType() == 1;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        boolean bl2 = false;
        if (this.choiceIndex <= 0) {
            if (this.oldFunction == 20 && !yText.equals("") && !this.xText.equals("")) {
                IJ.showMessage("Calibrator", "Please select a function");
            }
            n = 20;
        } else if (this.choiceIndex <= this.nFits) {
            n = this.choiceIndex - 1;
            if (n > 0 && bl) {
                IJ.error("Calibration of 16-bit images, except with straight\nline functions, is currently not supported.");
                return;
            }
            dArray2 = this.getData(this.xText);
            dArray3 = this.getData(yText);
            if (!(calibration.calibrated() && dArray3.length == 0 && n == this.oldFunction || (dArray = this.doCurveFitting(dArray2, dArray3, n)) != null)) {
                return;
            }
            bl2 = true;
            int n2 = 0;
            while (n2 < dArray3.length) {
                if (dArray3[n2] < 0.0) {
                    bl2 = false;
                }
                ++n2;
            }
        } else if (this.choiceIndex == this.inverterIndex) {
            n = 0;
            dArray = new double[]{bl ? 65535.0 : 255.0, -1.0};
            this.unit = "Inverted Gray Value";
        } else if (this.choiceIndex == this.odIndex) {
            if (bl) {
                IJ.error("Uncalibrated OD is not supported on 16-bit images.");
                return;
            }
            n = 21;
            this.unit = UNCALIBRATED_OD;
        }
        calibration.setFunction(n, dArray, this.unit, bl2);
        if (global) {
            imagePlus.setGlobalCalibration(calibration);
        } else {
            imagePlus.setCalibration(calibration);
            imagePlus.setGlobalCalibration(null);
        }
        if (n != 20) {
            this.showPlot(dArray2, dArray3, calibration, this.sumResiduals, this.fitGoodness);
        }
    }

    double[] doCurveFitting(double[] dArray, double[] dArray2, int n) {
        if (dArray.length != dArray2.length || dArray2.length == 0) {
            IJ.showMessage("Calibrator", "To create a calibration curve, the left column must\ncontain a list of measured mean pixel values and the\nright column must contain the same number of calibration\nstandard values. Use the Measure command to add mean\npixel value measurements to the left column.\n \n    Left column: " + dArray.length + " values\n" + "    Right column: " + dArray2.length + " values\n");
            return null;
        }
        int n2 = dArray.length;
        double d = 0.0;
        double d2 = this.imp.getType() == 1 ? 65535.0 : 255.0;
        double[] dArray3 = Tools.getMinMax(dArray2);
        double d3 = dArray3[0];
        double d4 = dArray3[1];
        CurveFitter curveFitter = new CurveFitter(dArray, dArray2);
        curveFitter.doFit(n, showSettings);
        int n3 = curveFitter.getNumParams();
        double[] dArray4 = curveFitter.getParams();
        double d5 = dArray4[n3];
        double d6 = 0.0;
        int n4 = 0;
        while (n4 < n2) {
            d6 += dArray2[n4];
            ++n4;
        }
        this.sumResiduals = IJ.d2s(Math.sqrt(d5 / (double)n2), 6);
        double d7 = d6 / (double)n2;
        double d8 = 0.0;
        int n5 = n2 - n3;
        double d9 = 1.0;
        int n6 = 0;
        while (n6 < n2) {
            if ((d8 += this.sqr(dArray2[n6] - d7)) > 0.0 && n5 != 0) {
                d9 = 1.0 - d5 / (double)n5 * ((double)(n2 - 1) / d8);
            }
            ++n6;
        }
        this.fitGoodness = IJ.d2s(d9, 6);
        double[] dArray5 = new double[n3];
        int n7 = 0;
        while (n7 < n3) {
            dArray5[n7] = dArray4[n7];
            ++n7;
        }
        return dArray5;
    }

    void showPlot(double[] dArray, double[] dArray2, Calibration calibration, String string, String string2) {
        int n;
        boolean bl;
        if (!calibration.calibrated()) {
            return;
        }
        float[] fArray = calibration.getCTable();
        if (fArray.length == 256) {
            bl = false;
            n = 255;
        } else {
            bl = false;
            n = 65535;
        }
        int n2 = 256;
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n2];
        int n3 = 0;
        while (n3 < n2) {
            fArray2[n3] = (float)((double)n3 / 255.0 * (double)n);
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            fArray3[n4] = fArray[(int)fArray2[n4]];
            ++n4;
        }
        double[] dArray3 = Tools.getMinMax(fArray3);
        double d = dArray3[0];
        double d2 = dArray3[1];
        int n5 = calibration.getFunction();
        String string3 = calibration.getValueUnit();
        PlotWindow plotWindow = new PlotWindow("Calibration Function", "pixel value", string3, fArray2, fArray3);
        plotWindow.setLimits((double)bl, n, d, d2);
        if (dArray != null && dArray2 != null && dArray.length > 0 && dArray2.length > 0) {
            plotWindow.addPoints(dArray, dArray2, 0);
        }
        double[] dArray4 = calibration.getCoefficients();
        if (n5 <= 8) {
            this.drawLabel(plotWindow, CurveFitter.fList[n5]);
            this.ly += 0.04;
        }
        if (dArray4 != null) {
            int n6 = dArray4.length;
            this.drawLabel(plotWindow, "a=" + IJ.d2s(dArray4[0], 6));
            this.drawLabel(plotWindow, "b=" + IJ.d2s(dArray4[1], 6));
            if (n6 >= 3) {
                this.drawLabel(plotWindow, "c=" + IJ.d2s(dArray4[2], 6));
            }
            if (n6 >= 4) {
                this.drawLabel(plotWindow, "d=" + IJ.d2s(dArray4[3], 6));
            }
            if (n6 >= 5) {
                this.drawLabel(plotWindow, "e=" + IJ.d2s(dArray4[4], 6));
            }
            this.ly += 0.04;
        }
        if (string != null) {
            this.drawLabel(plotWindow, "S.D.=" + string);
            string = null;
        }
        if (string2 != null) {
            this.drawLabel(plotWindow, "R^2=" + string2);
            string2 = null;
        }
        plotWindow.draw();
    }

    void drawLabel(PlotWindow plotWindow, String string) {
        plotWindow.addLabel(this.lx, this.ly, string);
        this.ly += 0.08;
    }

    double sqr(double d) {
        return d * d;
    }

    String[] getFunctionList() {
        String[] stringArray = new String[this.nFits + 4];
        stringArray[0] = NONE;
        int n = 0;
        while (n < this.nFits) {
            stringArray[1 + n] = CurveFitter.fitList[n];
            ++n;
        }
        stringArray[this.spacerIndex] = "-";
        stringArray[this.inverterIndex] = INVERTER;
        stringArray[this.odIndex] = UNCALIBRATED_OD;
        return stringArray;
    }

    String getMeans() {
        float[] fArray = Analyzer.getUMeans();
        int n = Analyzer.getCounter();
        if (fArray == null || n == 0) {
            return "";
        }
        if (n > 20) {
            n = 20;
        }
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + IJ.d2s(fArray[n2], 2) + "\n";
            ++n2;
        }
        return string;
    }

    double[] getData(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n < 1) {
            return new double[0];
        }
        int n2 = n;
        double[] dArray = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3] = this.getNum(stringTokenizer);
            ++n3;
        }
        return dArray;
    }

    double getNum(StringTokenizer stringTokenizer) {
        Double d;
        String string = stringTokenizer.nextToken();
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        yText = "";
    }
}

