/*
 * Decompiled with CFR 0.152.
 */
package de.globalcube.gui;

import de.globalcube.bean.ScorecardBean;
import de.globalcube.gui.DefaultDialog;
import de.globalcube.gui.ScorecardsPanel;
import de.globalcube.gui.WebMISCreator;
import de.globalcube.util.Utility;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class ScorecardDialog
extends DefaultDialog {
    private JLabel lblID;
    private JLabel lblName;
    private JLabel lblDirectory;
    private JTextField txtID;
    private JTextField txtName;
    private JTextField txtDirectory;
    private JPanel pnlDetail;
    private JPanel pnlButton;
    private JScrollPane scrollPane;
    private String mode;
    private int index;
    private ScorecardsPanel parentPanel;

    public ScorecardDialog(ScorecardsPanel scorecardsPanel, String string, int n) {
        super(WebMISCreator.instance.getOwner());
        this.setTitle("Scorecards Data");
        this.mode = string;
        this.index = n;
        this.parentPanel = scorecardsPanel;
        this.initComponents();
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.pnlButton, "South");
        this.pack();
        this.centerScreen();
    }

    private void initComponents() {
        this.lblID = new JLabel("ID");
        this.txtID = new JTextField(10);
        this.lblName = new JLabel("Name");
        this.txtName = new JTextField(15);
        this.lblDirectory = new JLabel("Directory");
        this.txtDirectory = new JTextField();
        this.pnlDetail = new JPanel(new GridLayout(3, 2));
        this.pnlDetail.add(this.lblID);
        this.pnlDetail.add(this.txtID);
        this.pnlDetail.add(this.lblName);
        this.pnlDetail.add(this.txtName);
        this.pnlDetail.add(this.lblDirectory);
        this.pnlDetail.add(this.txtDirectory);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().setView(this.pnlDetail);
        this.pnlButton = new JPanel(new GridLayout(1, 2));
        this.pnlButton.add(this.btnOK);
        this.pnlButton.add(this.btnCancel);
        if (this.mode.equals("MODIFY")) {
            this.initValues();
        }
    }

    protected void saveData() {
        if (this.validateData()) {
            if (this.mode.equals("NEW")) {
                ScorecardBean scorecardBean = new ScorecardBean();
                scorecardBean.setID(this.txtID.getText());
                scorecardBean.setName(this.txtName.getText());
                scorecardBean.setDirectory(this.txtDirectory.getText().trim());
                scorecardBean.setReports(new Vector());
                Utility.getConfigBean().getScorecards().addElement(scorecardBean);
                WebMISCreator.instance.refreshScorecardsNodes();
                this.parentPanel.initValues();
            } else if (this.mode.equals("MODIFY")) {
                ((ScorecardBean)Utility.getConfigBean().getScorecards().get(this.index)).setID(this.txtID.getText());
                ((ScorecardBean)Utility.getConfigBean().getScorecards().get(this.index)).setName(this.txtName.getText());
                ((ScorecardBean)Utility.getConfigBean().getScorecards().get(this.index)).setDirectory(this.txtDirectory.getText().trim());
                WebMISCreator.instance.refreshScorecardsNodes();
                this.parentPanel.initValues();
            }
            this.dispose();
        }
    }

    private void initValues() {
        ScorecardBean scorecardBean = (ScorecardBean)Utility.getConfigBean().getScorecards().get(this.index);
        this.txtID.setText(scorecardBean.getID());
        this.txtName.setText(scorecardBean.getName());
        this.txtDirectory.setText(scorecardBean.getDirectory());
    }

    private boolean validateData() {
        String string = "";
        JTextField jTextField = null;
        if (this.txtID.getText().trim().length() == 0) {
            jTextField = this.txtID;
            string = "ID";
        } else if (!Utility.isNumeric(this.txtID.getText().trim())) {
            string = "Scorecard ID muss ein numerischer";
            jTextField = this.txtID;
        } else if (this.txtName.getText().trim().length() == 0) {
            jTextField = this.txtName;
            string = "Name";
        }
        if (string.equals("")) {
            return true;
        }
        string = string + " muss angegeben werden";
        JOptionPane.showMessageDialog(this, string, "Message", 0);
        jTextField.requestFocus();
        return false;
    }
}

