/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.MedianCut;

public class StackConverter {
    ImagePlus imp;
    int type;
    int nSlices;
    int width;
    int height;

    public StackConverter(ImagePlus imagePlus) {
        this.imp = imagePlus;
        this.type = imagePlus.getType();
        this.nSlices = imagePlus.getStackSize();
        if (this.nSlices < 2) {
            throw new IllegalArgumentException("Stack required");
        }
        this.width = imagePlus.getWidth();
        this.height = imagePlus.getHeight();
    }

    public void convertToGray8() {
        ImageStack imageStack = this.imp.getStack();
        int n = this.imp.getCurrentSlice();
        if (this.type == 4 || this.type == 3) {
            this.convertRGBToGray8();
            this.imp.setSlice(n);
            return;
        }
        ImageStack imageStack2 = new ImageStack(this.width, this.height);
        ImageProcessor imageProcessor = this.imp.getProcessor();
        double d = imageProcessor.getMin();
        double d2 = imageProcessor.getMax();
        int n2 = this.nSlices / 20;
        if (n2 < 1) {
            n2 = 1;
        }
        int n3 = 1;
        while (n3 <= this.nSlices) {
            String string = imageStack.getSliceLabel(1);
            imageProcessor = imageStack.getProcessor(1);
            imageStack.deleteSlice(1);
            imageProcessor.setMinAndMax(d, d2);
            boolean bl = ImageConverter.getDoScaling();
            imageStack2.addSlice(string, imageProcessor.convertToByte(bl));
            if (n3 % n2 == 0) {
                IJ.showProgress((double)n3 / (double)this.nSlices);
                IJ.showStatus("Converting to 8-bits: " + n3 + "/" + this.nSlices);
            }
            ++n3;
        }
        this.imp.setStack(null, imageStack2);
        this.imp.setSlice(n);
        this.imp.setCalibration(this.imp.getCalibration());
        IJ.showProgress(1.0);
    }

    void convertRGBToGray8() {
        ImageStack imageStack = this.imp.getStack();
        ImageStack imageStack2 = new ImageStack(this.width, this.height);
        int n = this.nSlices / 20;
        if (n < 1) {
            n = 1;
        }
        int n2 = 1;
        while (n2 <= this.nSlices) {
            String string = imageStack.getSliceLabel(1);
            ImageProcessor imageProcessor = imageStack.getProcessor(1);
            imageStack.deleteSlice(1);
            if (imageProcessor instanceof ByteProcessor) {
                imageProcessor = new ColorProcessor(imageProcessor.createImage());
            }
            boolean bl = ImageConverter.getDoScaling();
            imageStack2.addSlice(string, imageProcessor.convertToByte(bl));
            if (n2 % n == 0) {
                IJ.showProgress((double)n2 / (double)this.nSlices);
                IJ.showStatus("Converting to 8-bits: " + n2 + "/" + this.nSlices);
            }
            ++n2;
        }
        this.imp.setStack(null, imageStack2);
        IJ.showProgress(1.0);
    }

    public void convertToGray16() {
        int n = this.imp.getType();
        if (n != 0 && n != 2) {
            throw new IllegalArgumentException("Unsupported conversion");
        }
        ImageStack imageStack = this.imp.getStack();
        ImageStack imageStack2 = new ImageStack(this.width, this.height);
        int n2 = this.nSlices / 20;
        if (n2 < 1) {
            n2 = 1;
        }
        boolean bl = n == 2 && ImageConverter.getDoScaling();
        int n3 = 1;
        while (n3 <= this.nSlices) {
            String string = imageStack.getSliceLabel(1);
            ImageProcessor imageProcessor = imageStack.getProcessor(1);
            ImageProcessor imageProcessor2 = imageProcessor.convertToShort(bl);
            imageStack.deleteSlice(1);
            imageStack2.addSlice(string, imageProcessor2);
            if (n3 % n2 == 0) {
                IJ.showProgress((double)n3 / (double)this.nSlices);
                IJ.showStatus("Converting to 16-bits: " + n3 + "/" + this.nSlices);
            }
            ++n3;
        }
        IJ.showProgress(1.0);
        this.imp.setStack(null, imageStack2);
    }

    public void convertToGray32() {
        int n = this.imp.getType();
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Unsupported conversion");
        }
        ImageStack imageStack = this.imp.getStack();
        ImageStack imageStack2 = new ImageStack(this.width, this.height);
        int n2 = this.nSlices / 20;
        if (n2 < 1) {
            n2 = 1;
        }
        Calibration calibration = this.imp.getCalibration();
        int n3 = 1;
        while (n3 <= this.nSlices) {
            String string = imageStack.getSliceLabel(1);
            ImageProcessor imageProcessor = imageStack.getProcessor(1);
            imageProcessor.setCalibrationTable(calibration.getCTable());
            ImageProcessor imageProcessor2 = imageProcessor.convertToFloat();
            imageStack.deleteSlice(1);
            imageStack2.addSlice(string, imageProcessor2);
            if (n3 % n2 == 0) {
                IJ.showProgress((double)n3 / (double)this.nSlices);
                IJ.showStatus("Converting to 32-bits: " + n3 + "/" + this.nSlices);
            }
            ++n3;
        }
        IJ.showProgress(1.0);
        this.imp.setStack(null, imageStack2);
        this.imp.setCalibration(this.imp.getCalibration());
    }

    public void convertToRGB() {
        ImageStack imageStack = this.imp.getStack();
        ImageStack imageStack2 = new ImageStack(this.width, this.height);
        int n = this.nSlices / 20;
        if (n < 1) {
            n = 1;
        }
        Calibration calibration = this.imp.getCalibration();
        int n2 = 1;
        while (n2 <= this.nSlices) {
            String string = imageStack.getSliceLabel(n2);
            ImageProcessor imageProcessor = imageStack.getProcessor(n2);
            ImageProcessor imageProcessor2 = imageProcessor.convertToRGB();
            imageStack2.addSlice(string, imageProcessor2);
            if (n2 % n == 0) {
                IJ.showProgress((double)n2 / (double)this.nSlices);
                IJ.showStatus("Converting to RGB: " + n2 + "/" + this.nSlices);
            }
            ++n2;
        }
        IJ.showProgress(1.0);
        this.imp.setStack(null, imageStack2);
        this.imp.setCalibration(this.imp.getCalibration());
    }

    public void convertToIndexedColor(int n) {
        if (this.type != 4) {
            throw new IllegalArgumentException("RGB stack required");
        }
        ImageStack imageStack = this.imp.getStack();
        int n2 = imageStack.getSize();
        ImageProcessor imageProcessor = new ColorProcessor(this.width * n2, this.height);
        int n3 = 0;
        while (n3 < n2) {
            imageProcessor.insert(imageStack.getProcessor(n3 + 1), n3 * this.width, 0);
            ++n3;
        }
        MedianCut medianCut = new MedianCut((ColorProcessor)imageProcessor);
        imageProcessor = medianCut.convertToByte(n);
        ImageStack imageStack2 = new ImageStack(this.width, this.height);
        int n4 = 0;
        while (n4 < n2) {
            imageProcessor.setRoi(n4 * this.width, 0, this.width, this.height);
            imageStack2.addSlice(null, imageProcessor.crop());
            ++n4;
        }
        this.imp.setStack(null, imageStack2);
    }
}

