/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class EDM
implements PlugInFilter {
    ImagePlus imp;
    String arg;
    int maxEDM;
    short[] xCoordinate;
    short[] yCoordinate;
    int[] levelStart;
    int[] levelOffset;
    int[] histogram;
    int slice;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        this.arg = string;
        return IJ.setupDialog(imagePlus, 1);
    }

    public void run(ImageProcessor imageProcessor) {
        ++this.slice;
        ImageStatistics imageStatistics = this.imp.getStatistics();
        if (this.slice == 1 && imageStatistics.histogram[0] + imageStatistics.histogram[255] != imageStatistics.pixelCount) {
            IJ.error("8-bit binary image (0 and 255) required.");
            return;
        }
        ImageProcessor imageProcessor2 = this.makeEDM(imageProcessor);
        if (this.arg.equals("points")) {
            this.findUltimatePoints(imageProcessor2);
        }
        imageProcessor.copyBits(imageProcessor2, 0, 0, 0);
    }

    public ImageProcessor makeEDM(ImageProcessor imageProcessor) {
        int n;
        int n2;
        int n3 = 41;
        int n4 = 58;
        int n5 = 92;
        this.imp.killRoi();
        int n6 = this.imp.getWidth();
        int n7 = this.imp.getHeight();
        int n8 = n6;
        int n9 = n6 - 3;
        int n10 = n7 - 3;
        ImageProcessor imageProcessor2 = imageProcessor.convertToShort(false);
        imageProcessor2.multiply(n3);
        short[] sArray = (short[])imageProcessor2.getPixels();
        int n11 = 0;
        while (n11 < n7) {
            n2 = 0;
            while (n2 < n6) {
                n = n2 + n11 * n8;
                if (sArray[n] > 0) {
                    if (n2 < 2 || n2 > n9 || n11 < 2 || n11 > n10) {
                        this.setEdgeValue(n, n8, sArray, n2, n11, n9, n10);
                    } else {
                        this.setValue(n, n8, sArray);
                    }
                }
                ++n2;
            }
            ++n11;
        }
        n2 = n7 - 1;
        while (n2 >= 0) {
            int n12 = n6 - 1;
            while (n12 >= 0) {
                n = n12 + n2 * n8;
                if (sArray[n] > 0) {
                    if (n12 < 2 || n12 > n9 || n2 < 2 || n2 > n10) {
                        this.setEdgeValue(n, n8, sArray, n12, n2, n9, n10);
                    } else {
                        this.setValue(n, n8, sArray);
                    }
                }
                --n12;
            }
            --n2;
        }
        ImageProcessor imageProcessor3 = imageProcessor.createProcessor(n6, n7);
        byte[] byArray = (byte[])imageProcessor3.getPixels();
        this.convertToBytes(n6, n7, sArray, byArray);
        return imageProcessor3;
    }

    void setValue(int n, int n2, short[] sArray) {
        int n3 = 41;
        int n4 = 58;
        int n5 = 92;
        int n6 = n - n2 - n2 - 2;
        int n7 = n6 + n2;
        int n8 = n7 + n2;
        int n9 = n8 + n2;
        int n10 = n9 + n2;
        int n11 = sArray[n7 + 2] + n3;
        int n12 = Short.MAX_VALUE;
        if (n11 < n12) {
            n12 = n11;
        }
        if ((n11 = sArray[n8 + 1] + n3) < n12) {
            n12 = n11;
        }
        if ((n11 = sArray[n8 + 3] + n3) < n12) {
            n12 = n11;
        }
        if ((n11 = sArray[n9 + 2] + n3) < n12) {
            n12 = n11;
        }
        if ((n11 = sArray[n7 + 1] + n4) < n12) {
            n12 = n11;
        }
        if ((n11 = sArray[n7 + 3] + n4) < n12) {
            n12 = n11;
        }
        if ((n11 = sArray[n9 + 1] + n4) < n12) {
            n12 = n11;
        }
        if ((n11 = sArray[n9 + 3] + n4) < n12) {
            n12 = n11;
        }
        if ((n11 = sArray[n6 + 1] + n5) < n12) {
            n12 = n11;
        }
        if ((n11 = sArray[n6 + 3] + n5) < n12) {
            n12 = n11;
        }
        if ((n11 = sArray[n7 + 4] + n5) < n12) {
            n12 = n11;
        }
        if ((n11 = sArray[n9 + 4] + n5) < n12) {
            n12 = n11;
        }
        if ((n11 = sArray[n10 + 3] + n5) < n12) {
            n12 = n11;
        }
        if ((n11 = sArray[n10 + 1] + n5) < n12) {
            n12 = n11;
        }
        if ((n11 = sArray[n9] + n5) < n12) {
            n12 = n11;
        }
        if ((n11 = sArray[n7] + n5) < n12) {
            n12 = n11;
        }
        sArray[n] = (short)n12;
    }

    void setEdgeValue(int n, int n2, short[] sArray, int n3, int n4, int n5, int n6) {
        int n7 = 41;
        int n8 = 58;
        int n9 = 92;
        int n10 = n - n2 - n2 - 2;
        int n11 = n10 + n2;
        int n12 = n11 + n2;
        int n13 = n12 + n2;
        int n14 = n13 + n2;
        int n15 = Short.MAX_VALUE;
        short s = sArray[n12 + 2];
        int n16 = n4 < 2 ? s + n7 : sArray[n11 + 2] + n7;
        if (n16 < n15) {
            n15 = n16;
        }
        if ((n16 = n3 < 2 ? s + n7 : sArray[n12 + 1] + n7) < n15) {
            n15 = n16;
        }
        if ((n16 = n3 > n5 ? s + n7 : sArray[n12 + 3] + n7) < n15) {
            n15 = n16;
        }
        if ((n16 = n4 > n6 ? s + n7 : sArray[n13 + 2] + n7) < n15) {
            n15 = n16;
        }
        if ((n16 = n3 < 2 || n4 < 2 ? s + n8 : sArray[n11 + 1] + n8) < n15) {
            n15 = n16;
        }
        if ((n16 = n3 > n5 || n4 < 2 ? s + n8 : sArray[n11 + 3] + n8) < n15) {
            n15 = n16;
        }
        if ((n16 = n3 < 2 || n4 > n6 ? s + n8 : sArray[n13 + 1] + n8) < n15) {
            n15 = n16;
        }
        if ((n16 = n3 > n5 || n4 > n6 ? s + n8 : sArray[n13 + 3] + n8) < n15) {
            n15 = n16;
        }
        if ((n16 = n3 < 2 || n4 < 2 ? s + n9 : sArray[n10 + 1] + n9) < n15) {
            n15 = n16;
        }
        if ((n16 = n3 > n5 || n4 < 2 ? s + n9 : sArray[n10 + 3] + n9) < n15) {
            n15 = n16;
        }
        if ((n16 = n3 > n5 || n4 < 2 ? s + n9 : sArray[n11 + 4] + n9) < n15) {
            n15 = n16;
        }
        if ((n16 = n3 > n5 || n4 > n6 ? s + n9 : sArray[n13 + 4] + n9) < n15) {
            n15 = n16;
        }
        if ((n16 = n3 > n5 || n4 > n6 ? s + n9 : sArray[n14 + 3] + n9) < n15) {
            n15 = n16;
        }
        if ((n16 = n3 < 2 || n4 > n6 ? s + n9 : sArray[n14 + 1] + n9) < n15) {
            n15 = n16;
        }
        if ((n16 = n3 < 2 || n4 > n6 ? s + n9 : sArray[n13] + n9) < n15) {
            n15 = n16;
        }
        if ((n16 = n3 < 2 || n4 < 2 ? s + n9 : sArray[n11] + n9) < n15) {
            n15 = n16;
        }
        sArray[n] = (short)n15;
    }

    void convertToBytes(int n, int n2, short[] sArray, byte[] byArray) {
        int n3 = 41;
        int n4 = n3 / 2;
        this.maxEDM = 0;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = 0;
            while (n6 < n) {
                int n7 = n6 + n5 * n;
                int n8 = (sArray[n7] + n4) / n3;
                if (n8 > 255) {
                    n8 = 255;
                }
                if (n8 > this.maxEDM) {
                    this.maxEDM = n8;
                }
                byArray[n7] = (byte)n8;
                ++n6;
            }
            ++n5;
        }
    }

    public void findUltimatePoints(ImageProcessor imageProcessor) {
        int n;
        this.smoothEDM(imageProcessor);
        this.makeCoordinateArrays(imageProcessor);
        byte[] byArray = (byte[])imageProcessor.getPixels();
        ImageProcessor imageProcessor2 = imageProcessor.duplicate();
        byte[] byArray2 = (byte[])imageProcessor2.getPixels();
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        int n4 = n2;
        int n5 = n2 - 1;
        int n6 = n3 - 1;
        int n7 = this.maxEDM - 1;
        while (n7 >= 1) {
            int n8;
            do {
                n8 = 0;
                n = 0;
                while (n < this.histogram[n7]) {
                    int n9 = this.levelStart[n7] + n;
                    short s = this.xCoordinate[n9];
                    short s2 = this.yCoordinate[n9];
                    int n10 = s + s2 * n4;
                    if ((byArray[n10] & 0xFF) != 255) {
                        boolean bl = false;
                        if (s > 0 && s2 > 0 && (byArray[n10 - n4 - 1] & 0xFF) > n7) {
                            bl = true;
                        }
                        if (s2 > 0 && (byArray[n10 - n4] & 0xFF) > n7) {
                            bl = true;
                        }
                        if (s < n5 && s2 > 0 && (byArray[n10 - n4 + 1] & 0xFF) > n7) {
                            bl = true;
                        }
                        if (s < n5 && (byArray[n10 + 1] & 0xFF) > n7) {
                            bl = true;
                        }
                        if (s < n5 && s2 < n6 && (byArray[n10 + n4 + 1] & 0xFF) > n7) {
                            bl = true;
                        }
                        if (s2 < n6 && (byArray[n10 + n4] & 0xFF) > n7) {
                            bl = true;
                        }
                        if (s > 0 && s2 < n6 && (byArray[n10 + n4 - 1] & 0xFF) > n7) {
                            bl = true;
                        }
                        if (s > 0 && (byArray[n10 - 1] & 0xFF) > n7) {
                            bl = true;
                        }
                        if (bl) {
                            byArray[n10] = -1;
                            ++n8;
                        }
                    }
                    ++n;
                }
            } while (n8 != 0);
            --n7;
        }
        n = 0;
        while (n < n2 * n3) {
            if ((byArray[n] & 0xFF) == 255) {
                byArray[n] = 0;
            }
            ++n;
        }
    }

    void smoothEDM(ImageProcessor imageProcessor) {
        byte[] byArray = (byte[])imageProcessor.getPixels();
        ImageProcessor imageProcessor2 = imageProcessor.duplicate();
        byte[] byArray2 = (byte[])imageProcessor2.getPixels();
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        int n3 = n;
        int n4 = n - 1;
        int n5 = n2 - 1;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 0;
            while (n7 < n) {
                int n8 = n7 + n6 * n3;
                if (byArray2[n8] != 1) {
                    int n9 = byArray2[n8] * 2;
                    if (n7 > 0 && n6 > 0) {
                        n9 += byArray2[n8 - n3 - 1];
                    }
                    if (n6 > 0) {
                        n9 += byArray2[n8 - n3];
                    }
                    if (n7 < n4 && n6 > 0) {
                        n9 += byArray2[n8 - n3 + 1];
                    }
                    if (n7 < n4) {
                        n9 += byArray2[n8 + 1];
                    }
                    if (n7 < n4 && n6 < n5) {
                        n9 += byArray2[n8 + n3 + 1];
                    }
                    if (n6 < n5) {
                        n9 += byArray2[n8 + n3];
                    }
                    if (n7 > 0 && n6 < n5) {
                        n9 += byArray2[n8 + n3 - 1];
                    }
                    if (n7 > 0) {
                        n9 += byArray2[n8 - 1];
                    }
                    byArray[n8] = (byte)(n9 / 10);
                }
                ++n7;
            }
            ++n6;
        }
    }

    void makeCoordinateArrays(ImageProcessor imageProcessor) {
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        this.histogram = imageProcessor.getHistogram();
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.maxEDM - 1) {
            n3 += this.histogram[n4];
            ++n4;
        }
        this.xCoordinate = new short[n3];
        this.yCoordinate = new short[n3];
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n5 = 0;
        this.levelStart = new int[256];
        int n6 = 0;
        while (n6 < 256) {
            this.levelStart[n6] = n5;
            if (n6 > 0 && n6 < this.maxEDM) {
                n5 += this.histogram[n6];
            }
            ++n6;
        }
        this.levelOffset = new int[256];
        int n7 = n;
        int n8 = 0;
        while (n8 < n2) {
            int n9 = 0;
            while (n9 < n) {
                int n10 = byArray[n9 + n8 * n7] & 0xFF;
                if (n10 > 0 && n10 < this.maxEDM) {
                    n5 = this.levelStart[n10] + this.levelOffset[n10];
                    this.xCoordinate[n5] = (short)n9;
                    this.yCoordinate[n5] = (short)n8;
                    int n11 = n10;
                    this.levelOffset[n11] = this.levelOffset[n11] + 1;
                }
                ++n9;
            }
            ++n8;
        }
    }
}

