/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.IJ;
import ij.ImageJ;
import ij.io.SaveDialog;
import ij.plugin.filter.Analyzer;
import ij.text.TextCanvas;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextPanel
extends Panel
implements AdjustmentListener,
MouseListener,
MouseMotionListener,
KeyListener,
ClipboardOwner,
ActionListener {
    int iGridWidth;
    int iGridHeight;
    int iX;
    int iY;
    String[] sColHead;
    Vector vData;
    int[] iColWidth;
    int iColCount;
    int iRowCount;
    int iRowHeight;
    int iFirstRow;
    Scrollbar sbHoriz;
    Scrollbar sbVert;
    int iSbWidth;
    int iSbHeight;
    boolean bDrag;
    int iXDrag;
    int iColDrag;
    boolean headings = true;
    String title = "";
    String labels;
    KeyListener keyListener;
    Cursor resizeCursor = new Cursor(11);
    Cursor defaultCursor = new Cursor(0);
    int selStart = -1;
    int selEnd = -1;
    int selOrigin = -1;
    TextCanvas tc = new TextCanvas(this);
    PopupMenu pm;
    boolean columnsManuallyAdjusted;

    public TextPanel() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.tc);
        this.sbHoriz = new Scrollbar(0);
        this.sbHoriz.addAdjustmentListener(this);
        this.add("South", this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.sbVert.addAdjustmentListener(this);
        this.add("East", this.sbVert);
        this.addPopupMenu();
    }

    public TextPanel(String string) {
        this();
        if (string.equals("Results")) {
            this.pm.addSeparator();
            this.addPopupItem("Clear Results");
            this.addPopupItem("Summarize");
            this.addPopupItem("Set Measurements...");
        }
    }

    void addPopupMenu() {
        this.pm = new PopupMenu();
        this.addPopupItem("Save As...");
        this.pm.addSeparator();
        this.addPopupItem("Cut");
        this.addPopupItem("Copy");
        this.addPopupItem("Clear");
        this.addPopupItem("Select All");
        this.addPopupItem("Copy All");
        this.add(this.pm);
    }

    void addPopupItem(String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(this);
        this.pm.add(menuItem);
    }

    public synchronized void setColumnHeadings(String string) {
        boolean bl = string.equals(this.labels);
        this.labels = string;
        if (string.equals("")) {
            this.iColCount = 1;
            this.sColHead = new String[1];
            this.sColHead[0] = "";
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
            this.iColCount = stringTokenizer.countTokens();
            this.sColHead = new String[this.iColCount];
            int n = 0;
            while (n < this.iColCount) {
                this.sColHead[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
        this.flush();
        this.vData = new Vector();
        if (this.iColWidth == null || this.iColWidth.length != this.iColCount || !bl || this.iColCount == 1) {
            this.iColWidth = new int[this.iColCount];
            this.columnsManuallyAdjusted = false;
        }
        this.iRowCount = 0;
        this.resetSelection();
        this.adjustHScroll();
        this.tc.repaint();
    }

    public String getColumnHeadings() {
        return this.labels == null ? "" : this.labels;
    }

    public void setFont(Font font) {
        this.tc.fFont = font;
        this.tc.iImage = null;
        this.tc.fMetrics = null;
        this.iColWidth[0] = 0;
    }

    public void appendLine(String string) {
        if (this.vData == null) {
            this.setColumnHeadings("");
        }
        char[] cArray = string.toCharArray();
        this.vData.addElement(cArray);
        ++this.iRowCount;
        if (this.isShowing()) {
            if (this.iColCount == 1 && this.tc.fMetrics != null) {
                this.iColWidth[0] = Math.max(this.iColWidth[0], this.tc.fMetrics.charsWidth(cArray, 0, cArray.length));
                this.adjustHScroll();
            }
            this.iY = this.iRowHeight * (this.iRowCount + 1);
            this.adjustVScroll();
            if (this.iColCount > 1 && this.iRowCount <= 10 && !this.columnsManuallyAdjusted) {
                this.iColWidth[0] = 0;
            }
            this.tc.repaint();
            Thread.yield();
        }
    }

    public void append(String string) {
        int n;
        if (string == null) {
            string = "null";
        }
        do {
            if ((n = string.indexOf(10)) < 0) {
                this.appendLine(string);
                break;
            }
            this.appendLine(string.substring(0, n));
        } while (!(string = string.substring(n + 1)).equals(""));
    }

    String getCell(int n, int n2) {
        if (n < 0 || n >= this.iColCount || n2 < 0 || n2 >= this.iRowCount) {
            return null;
        }
        return new String(this.tc.getChars(n, n2));
    }

    synchronized void adjustVScroll() {
        if (this.iRowHeight == 0) {
            return;
        }
        Dimension dimension = this.tc.getSize();
        int n = this.iY / this.iRowHeight;
        int n2 = dimension.height / this.iRowHeight;
        int n3 = this.iRowCount + 1;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        if (n > n3 - n2) {
            n = n3 - n2;
        }
        this.sbVert.setValues(n, n2, 0, n3);
        this.iY = this.iRowHeight * n;
    }

    synchronized void adjustHScroll() {
        if (this.iRowHeight == 0) {
            return;
        }
        Dimension dimension = this.tc.getSize();
        int n = 0;
        int n2 = 0;
        while (n2 < this.iColCount) {
            n += this.iColWidth[n2];
            ++n2;
        }
        this.iGridWidth = n;
        this.sbHoriz.setValues(this.iX, dimension.width, 0, this.iGridWidth);
        this.iX = this.sbHoriz.getValue();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.iX = this.sbHoriz.getValue();
        this.iY = this.iRowHeight * this.sbVert.getValue();
        this.tc.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown()) {
            this.pm.show(mouseEvent.getComponent(), n, n2);
        } else if (mouseEvent.isShiftDown()) {
            this.extendSelection(n, n2);
        } else {
            this.select(n, n2);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.bDrag) {
            this.setCursor(this.defaultCursor);
            this.bDrag = false;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n2 <= this.iRowHeight) {
            int n3 = n;
            n = n + this.iX - this.iGridWidth;
            int n4 = this.iColCount - 1;
            while (n4 >= 0) {
                if (n > -7 && n < 7) break;
                n += this.iColWidth[n4];
                --n4;
            }
            if (n4 >= 0) {
                if (!this.bDrag) {
                    this.setCursor(this.resizeCursor);
                    this.bDrag = true;
                    this.iXDrag = n3 - this.iColWidth[n4];
                    this.iColDrag = n4;
                }
                return;
            }
        }
        if (this.bDrag) {
            this.setCursor(this.defaultCursor);
            this.bDrag = false;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.isMetaDown()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.bDrag && n < this.tc.getSize().width) {
            int n3 = n - this.iXDrag;
            if (n3 < 0) {
                n3 = 0;
            }
            this.iColWidth[this.iColDrag] = n3;
            this.columnsManuallyAdjusted = true;
            this.adjustHScroll();
            this.tc.repaint();
        } else {
            this.extendSelection(n, n2);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyListener = keyListener;
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl;
        boolean bl2 = bl = (keyEvent.isControlDown() || keyEvent.isMetaDown()) && this.selStart != -1 && this.selEnd != -1;
        if (bl && keyEvent.getKeyCode() == 67) {
            this.copySelection();
        } else if (bl && keyEvent.getKeyCode() == 88) {
            if (this.copySelection() > 0) {
                this.clearSelection();
            }
        } else if (this.keyListener != null) {
            this.keyListener.keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.doCommand(string);
    }

    void doCommand(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("Save As...")) {
            this.saveAs("");
        } else if (string.equals("Cut")) {
            this.copySelection();
            this.clearSelection();
        } else if (string.equals("Copy")) {
            this.copySelection();
        } else if (string.equals("Clear")) {
            this.clearSelection();
        } else if (string.equals("Select All")) {
            this.selectAll();
        } else if (string.equals("Copy All")) {
            this.selectAll();
            this.copySelection();
            this.resetSelection();
        } else if (string.equals("Summarize")) {
            IJ.doCommand("Summarize");
        } else if (string.equals("Clear Results")) {
            IJ.doCommand("Clear Results");
        } else if (string.equals("Set Measurements...")) {
            IJ.doCommand("Set Measurements...");
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    void select(int n, int n2) {
        Dimension dimension = this.tc.getSize();
        if (this.iRowHeight == 0 || n > dimension.width || n2 > dimension.height) {
            return;
        }
        int n3 = n2 / this.iRowHeight - 1 + this.iFirstRow;
        if (n3 >= 0 && n3 < this.iRowCount) {
            this.selOrigin = n3;
            this.selStart = -1;
            this.selEnd = -1;
        }
        this.tc.repaint();
    }

    void extendSelection(int n, int n2) {
        Dimension dimension = this.tc.getSize();
        if (this.iRowHeight == 0 || n > dimension.width || n2 > dimension.height) {
            return;
        }
        int n3 = n2 / this.iRowHeight - 1 + this.iFirstRow;
        if (n3 >= 0 && n3 < this.iRowCount) {
            if (n3 < this.selOrigin) {
                this.selStart = n3;
                this.selEnd = this.selOrigin;
            } else {
                this.selStart = this.selOrigin;
                this.selEnd = n3;
            }
        }
        this.tc.repaint();
    }

    public int copySelection() {
        Object object;
        if (this.selStart == -1 || this.selEnd == -1) {
            return 0;
        }
        String string = "";
        int n = this.selStart;
        while (n <= this.selEnd) {
            object = (char[])this.vData.elementAt(n);
            string = string + new String((char[])object) + "\n";
            ++n;
        }
        object = this.getToolkit().getSystemClipboard();
        if (object == null) {
            return 0;
        }
        StringSelection stringSelection = new StringSelection(string);
        ((Clipboard)object).setContents(stringSelection, this);
        if (string.length() > 0) {
            IJ.showStatus(this.selEnd - this.selStart + 1 + " lines copied to clipboard");
            if (this.getParent() instanceof ImageJ) {
                Analyzer.setSaved();
            }
        }
        return string.length();
    }

    public void clearSelection() {
        if (this.selStart == -1 || this.selEnd == -1) {
            return;
        }
        if (this.selStart == 0 && this.selEnd == this.iRowCount - 1) {
            this.vData.removeAllElements();
            this.iRowCount = 0;
            if (IJ.isResultsWindow() && IJ.getTextPanel() == this) {
                Analyzer.setSaved();
                Analyzer.resetCounter();
            }
        } else {
            int n = this.selEnd - this.selStart + 1;
            int n2 = 0;
            while (n2 < n) {
                this.vData.removeElementAt(this.selStart);
                --this.iRowCount;
                ++n2;
            }
        }
        this.selStart = -1;
        this.selEnd = -1;
        this.selOrigin = -1;
        this.adjustVScroll();
        this.tc.repaint();
    }

    public void selectAll() {
        this.selStart = 0;
        this.selEnd = this.iRowCount - 1;
        this.selOrigin = 0;
        this.tc.repaint();
    }

    public void resetSelection() {
        this.selStart = -1;
        this.selEnd = -1;
        this.selOrigin = -1;
        if (this.iRowCount > 0) {
            this.tc.repaint();
        }
    }

    public void save(PrintWriter printWriter) {
        this.resetSelection();
        if (this.labels != null && !this.labels.equals("")) {
            printWriter.println(this.labels);
        }
        int n = 0;
        while (n < this.iRowCount) {
            char[] cArray = (char[])this.vData.elementAt(n);
            printWriter.println(new String(cArray));
            ++n;
        }
    }

    public void saveAs(String string) {
        Object object;
        Object object2;
        if (string.equals("")) {
            object2 = new SaveDialog("Save as Text", this.title, ".txt");
            object = ((SaveDialog)object2).getFileName();
            if (object == null) {
                return;
            }
            string = ((SaveDialog)object2).getDirectory() + (String)object;
        }
        object2 = null;
        try {
            object = new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
            object2 = new PrintWriter(bufferedOutputStream);
        }
        catch (IOException iOException) {
            return;
        }
        this.save((PrintWriter)object2);
        ((PrintWriter)object2).close();
        if (IJ.isResultsWindow() && IJ.getTextPanel() == this) {
            Analyzer.setSaved();
        }
        IJ.showStatus("");
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getLineCount() {
        return this.iRowCount;
    }

    public String getLine(int n) {
        if (n < 0 || n >= this.iRowCount) {
            throw new IllegalArgumentException("index out of range: " + n);
        }
        return new String((char[])this.vData.elementAt(n));
    }

    void flush() {
        if (this.vData != null) {
            this.vData.removeAllElements();
        }
        this.vData = null;
    }
}

