/*
 * Decompiled with CFR 0.152.
 */
package de.globalcube.gui;

import de.globalcube.bean.PublishBean;
import de.globalcube.bean.ScorecardBean;
import de.globalcube.gui.DefaultTable;
import de.globalcube.gui.WebMISCreator;
import de.globalcube.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class TablePanel
extends JPanel {
    DefaultTable table;
    DefaultTableModel model;
    private JScrollPane scroll;
    private String from;
    private boolean activateMenu;
    JPopupMenu popupMenu;

    public TablePanel(Vector vector, String string) {
        this.initComponents(vector);
        this.from = string;
    }

    private void initComponents(Vector vector) {
        this.table = new DefaultTable(vector);
        this.model = (DefaultTableModel)this.table.getModel();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    WebMISCreator.instance.setRemoveEnable();
                    TablePanel.this.setPromoteDemote();
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    TablePanel.this.removeRowData();
                } else if (keyEvent.getKeyCode() == 155) {
                    TablePanel.this.newRowData();
                } else if (keyEvent.getKeyCode() == 10) {
                    TablePanel.this.modifyRowData(true);
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getComponent() instanceof JTable && TablePanel.this.table.getSelectedRow() > -1) {
                    if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() > 1) {
                        TablePanel.this.modifyRowData(false);
                    } else if ((mouseEvent.getModifiers() & 4) != 0 && TablePanel.this.activateMenu) {
                        Point point = TablePanel.this.table.getLocationOnScreen();
                        TablePanel.this.popupMenu.setLocation(point.x + mouseEvent.getX(), point.y + mouseEvent.getY());
                        TablePanel.this.popupMenu.setVisible(true);
                    }
                }
            }
        });
        this.scroll = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroll, "Center");
    }

    public void initValues() {
    }

    protected void writeValues() {
    }

    public void newRowData() {
    }

    protected void modifyRowData(boolean bl) {
    }

    protected void removeRowData() {
        int n;
        int n2 = this.table.getSelectedRow();
        if (n2 > -1 && (n = JOptionPane.showConfirmDialog(null, "Tabellen Daten loeschen ?", "Best\u00e4tigung", 0, 1)) == 0) {
            this.model.removeRow(n2);
            int n3 = n2;
            if (n2 >= this.table.getRowCount()) {
                n3 = n2 - 1;
            }
            if (n3 > -1) {
                this.table.setRowSelectionInterval(n3, n3);
            }
            if (this.from.equals("Publishes")) {
                Utility.getConfigBean().getPublishes().remove(n2);
                WebMISCreator.instance.refreshPublishesNodes();
                WebMISCreator.instance.selectTree(3);
            } else if (this.from.equals("Scorecards")) {
                Utility.getConfigBean().getScorecards().remove(n2);
                WebMISCreator.instance.refreshScorecardsNodes();
                WebMISCreator.instance.selectTree(2);
            } else if (this.from.equals("Scorecard")) {
                ScorecardBean scorecardBean = (ScorecardBean)WebMISCreator.instance.getLastSelected();
                scorecardBean.getReports().remove(n2);
            } else if (this.from.equals("Publish")) {
                PublishBean publishBean = (PublishBean)WebMISCreator.instance.getLastSelected();
                publishBean.getImages().remove(n2);
            }
        }
    }

    public boolean isRowSelected() {
        int n = this.table.getSelectedRow();
        int n2 = this.table.getRowCount();
        return n2 == 0 || n > -1;
    }

    public boolean getActivatePopup() {
        return this.activateMenu;
    }

    public void setActivatePopup(boolean bl) {
        this.activateMenu = bl;
    }

    protected void promoteData() {
        int n = this.table.getSelectedRow();
        if (this.from.equals("Publishes")) {
            Object e = Utility.getConfigBean().getPublishes().remove(n);
            Utility.getConfigBean().getPublishes().insertElementAt(e, n - 1);
            this.initValues();
            WebMISCreator.instance.refreshPublishesNodes();
            WebMISCreator.instance.selectTree(3);
        } else if (this.from.equals("Scorecards")) {
            Object e = Utility.getConfigBean().getScorecards().remove(n);
            Utility.getConfigBean().getScorecards().insertElementAt(e, n - 1);
            this.initValues();
            WebMISCreator.instance.refreshScorecardsNodes();
            WebMISCreator.instance.selectTree(2);
        } else if (this.from.equals("Scorecard")) {
            ScorecardBean scorecardBean = (ScorecardBean)WebMISCreator.instance.getLastSelected();
            Object e = scorecardBean.getReports().remove(n);
            scorecardBean.getReports().insertElementAt(e, n - 1);
            this.initValues();
        } else if (this.from.equals("Publish")) {
            PublishBean publishBean = (PublishBean)WebMISCreator.instance.getLastSelected();
            Object e = publishBean.getImages().remove(n);
            publishBean.getImages().insertElementAt(e, n - 1);
            this.initValues();
        }
        this.table.setRowSelectionInterval(n - 1, n - 1);
    }

    protected void demoteData() {
        int n = this.table.getSelectedRow();
        if (this.from.equals("Publishes")) {
            Object e = Utility.getConfigBean().getPublishes().remove(n);
            Utility.getConfigBean().getPublishes().insertElementAt(e, n + 1);
            this.initValues();
            WebMISCreator.instance.refreshPublishesNodes();
            WebMISCreator.instance.selectTree(3);
        } else if (this.from.equals("Scorecards")) {
            Object e = Utility.getConfigBean().getScorecards().remove(n);
            Utility.getConfigBean().getScorecards().insertElementAt(e, n + 1);
            this.initValues();
            WebMISCreator.instance.refreshScorecardsNodes();
            WebMISCreator.instance.selectTree(2);
        } else if (this.from.equals("Scorecard")) {
            ScorecardBean scorecardBean = (ScorecardBean)WebMISCreator.instance.getLastSelected();
            Object e = scorecardBean.getReports().remove(n);
            scorecardBean.getReports().insertElementAt(e, n + 1);
            this.initValues();
        } else if (this.from.equals("Publish")) {
            PublishBean publishBean = (PublishBean)WebMISCreator.instance.getLastSelected();
            Object e = publishBean.getImages().remove(n);
            publishBean.getImages().insertElementAt(e, n + 1);
            this.initValues();
        }
        this.table.setRowSelectionInterval(n + 1, n + 1);
    }

    private void setPromoteDemote() {
        int n = this.table.getSelectedRow();
        int n2 = this.table.getRowCount();
        WebMISCreator.instance.setPromoteEnable(true);
        WebMISCreator.instance.setDemoteEnable(true);
        if (n == 0) {
            WebMISCreator.instance.setPromoteEnable(false);
        }
        if (n == n2 - 1) {
            WebMISCreator.instance.setDemoteEnable(false);
        }
    }
}

