/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.filter.Convolver;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.text.TextWindow;
import java.awt.Rectangle;

public class GaussianBlur
implements PlugInFilter {
    private static final int BYTE = 0;
    private static final int SHORT = 1;
    private static final int FLOAT = 2;
    private static final int RGB = 3;
    private ImagePlus imp;
    private boolean canceled;
    private int slice;
    private ImageWindow win;
    private boolean isLineRoi;
    private boolean isAreaRoi;
    private boolean displayKernel;
    private static int radius = 2;
    static /* synthetic */ Class class$ij$plugin$filter$GaussianBlur;

    public int setup(String string, ImagePlus imagePlus) {
        IJ.register(class$ij$plugin$filter$GaussianBlur == null ? (class$ij$plugin$filter$GaussianBlur = GaussianBlur.class$("ij.plugin.filter.GaussianBlur")) : class$ij$plugin$filter$GaussianBlur);
        this.imp = imagePlus;
        if (imagePlus != null) {
            this.win = imagePlus.getWindow();
            this.win.running = true;
            Roi roi = imagePlus.getRoi();
            this.isLineRoi = roi != null && roi.getType() >= 5;
            boolean bl = this.isAreaRoi = roi != null && !this.isLineRoi;
        }
        if (imagePlus != null && !this.showDialog()) {
            return 4096;
        }
        return IJ.setupDialog(imagePlus, 31);
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.canceled) {
            return;
        }
        if (!this.win.running) {
            this.canceled = true;
            IJ.beep();
            return;
        }
        ++this.slice;
        if (this.slice == 1) {
            if (this.imp.getType() == 2 && !this.isAreaRoi && this.imp.getStackSize() == 1) {
                Undo.setup(4, this.imp);
                this.blur(imageProcessor, radius);
                Undo.setup(5, this.imp);
                return;
            }
        } else {
            IJ.showStatus("Gaussian Blur: " + this.slice + "/" + this.imp.getStackSize());
        }
        if (this.isLineRoi) {
            imageProcessor.resetRoi();
        }
        this.blur(imageProcessor, radius);
    }

    public void blur(ImageProcessor imageProcessor, double d) {
        boolean bl;
        Rectangle rectangle = imageProcessor.getRoi();
        ImageProcessor imageProcessor2 = imageProcessor;
        boolean bl2 = rectangle.width != imageProcessor.getWidth() || rectangle.height != imageProcessor.getHeight();
        boolean bl3 = bl = imageProcessor.getMask() != null;
        if (bl2) {
            imageProcessor2.setRoi(rectangle);
            imageProcessor2 = imageProcessor2.crop();
        }
        int n = imageProcessor2 instanceof ByteProcessor ? 0 : (imageProcessor2 instanceof ShortProcessor ? 1 : (imageProcessor2 instanceof FloatProcessor ? 2 : 3));
        float[] fArray = this.makeKernel(d);
        if (this.slice == 1 && this.displayKernel) {
            TextWindow textWindow = new TextWindow("Kernel", "", 150, 300);
            int n2 = 0;
            while (n2 < fArray.length) {
                textWindow.append(n2 + "  " + IJ.d2s(fArray[n2], 3));
                ++n2;
            }
        }
        if (n == 3) {
            if (bl) {
                imageProcessor2.snapshot();
                this.blurRGB(imageProcessor2, fArray);
                imageProcessor2.reset(imageProcessor.getMask());
            } else {
                this.blurRGB(imageProcessor2, fArray);
            }
            if (bl) {
                imageProcessor2.reset(imageProcessor.getMask());
            }
            if (bl2) {
                imageProcessor.insert(imageProcessor2, rectangle.x, rectangle.y);
            }
            return;
        }
        imageProcessor2.setCalibrationTable(null);
        imageProcessor2 = imageProcessor2.convertToFloat();
        this.blurFloat(imageProcessor2, fArray);
        if (bl) {
            imageProcessor.snapshot();
        }
        switch (n) {
            case 0: {
                imageProcessor2 = imageProcessor2.convertToByte(false);
                imageProcessor.insert(imageProcessor2, rectangle.x, rectangle.y);
                break;
            }
            case 1: {
                imageProcessor2 = imageProcessor2.convertToShort(false);
                imageProcessor.insert(imageProcessor2, rectangle.x, rectangle.y);
                break;
            }
            case 2: {
                if (!bl2) break;
                imageProcessor.insert(imageProcessor2, rectangle.x, rectangle.y);
            }
        }
        if (bl) {
            imageProcessor.reset(imageProcessor.getMask());
        }
    }

    void blurFloat(ImageProcessor imageProcessor, float[] fArray) {
        new Convolver().convolve(imageProcessor, fArray, fArray.length, 1);
        imageProcessor.snapshot();
        new Convolver().convolve(imageProcessor, fArray, 1, fArray.length);
    }

    public void blurRGB(ImageProcessor imageProcessor, float[] fArray) {
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        int n3 = n * n2;
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        ((ColorProcessor)imageProcessor).getRGB(byArray, byArray2, byArray3);
        ByteProcessor byteProcessor = new ByteProcessor(n, n2, byArray, null);
        ByteProcessor byteProcessor2 = new ByteProcessor(n, n2, byArray2, null);
        ByteProcessor byteProcessor3 = new ByteProcessor(n, n2, byArray3, null);
        ImageProcessor imageProcessor2 = byteProcessor.convertToFloat();
        this.blurFloat(imageProcessor2, fArray);
        ImageProcessor imageProcessor3 = imageProcessor2.convertToByte(false);
        imageProcessor2 = byteProcessor2.convertToFloat();
        this.blurFloat(imageProcessor2, fArray);
        ImageProcessor imageProcessor4 = imageProcessor2.convertToByte(false);
        imageProcessor2 = byteProcessor3.convertToFloat();
        this.blurFloat(imageProcessor2, fArray);
        ImageProcessor imageProcessor5 = imageProcessor2.convertToByte(false);
        ((ColorProcessor)imageProcessor).setRGB((byte[])imageProcessor3.getPixels(), (byte[])imageProcessor4.getPixels(), (byte[])imageProcessor5.getPixels());
    }

    public float[] makeKernel(double d) {
        int n = (int)(d += 1.0) * 2 + 1;
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = (float)Math.exp(-0.5 * this.sqr(((double)n2 - d) / (d * 2.0)) / this.sqr(0.2));
            ++n2;
        }
        float[] fArray2 = new float[n - 2];
        int n3 = 0;
        while (n3 < n - 2) {
            fArray2[n3] = fArray[n3 + 1];
            ++n3;
        }
        if (fArray2.length == 1) {
            fArray2[0] = 1.0f;
        }
        return fArray2;
    }

    double sqr(double d) {
        return d * d;
    }

    public boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog("Gaussian Blur...");
        genericDialog.addNumericField("Radius (pixels)", radius, 0);
        genericDialog.addCheckbox("Show Kernel", this.displayKernel);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            this.canceled = true;
            return false;
        }
        radius = (int)genericDialog.getNextNumber();
        this.displayKernel = genericDialog.getNextBoolean();
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

