/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;

public class RGBStackMerge
implements PlugIn {
    private ImagePlus imp;
    private byte[] blank;

    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        this.mergeStacks();
    }

    public void mergeStacks() {
        ImagePlus imagePlus;
        Object object;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error("No images are open.");
            return;
        }
        String[] stringArray = new String[nArray.length + 1];
        int n = 0;
        while (n < nArray.length) {
            object = WindowManager.getImage(nArray[n]);
            stringArray[n] = object != null ? ((ImagePlus)object).getTitle() : "";
            ++n;
        }
        stringArray[nArray.length] = object = "*None*";
        GenericDialog genericDialog = new GenericDialog("RGB Stack Merge");
        genericDialog.addChoice("Red Stack:", stringArray, stringArray[0]);
        genericDialog.addChoice("Green Stack:", stringArray, stringArray[1]);
        Object object2 = stringArray.length > 2 ? stringArray[2] : object;
        genericDialog.addChoice("Blue Stack:", stringArray, (String)object2);
        genericDialog.addCheckbox("Keep source stacks", false);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int[] nArray2 = new int[]{genericDialog.getNextChoiceIndex(), genericDialog.getNextChoiceIndex(), genericDialog.getNextChoiceIndex()};
        boolean bl = genericDialog.getNextBoolean();
        ImagePlus[] imagePlusArray = new ImagePlus[3];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < 3) {
            if (nArray2[n5] < nArray.length) {
                imagePlusArray[n5] = WindowManager.getImage(nArray[nArray2[n5]]);
                n3 = imagePlusArray[n5].getWidth();
                n4 = imagePlusArray[n5].getHeight();
                n2 = imagePlusArray[n5].getStackSize();
            }
            ++n5;
        }
        if (n3 == 0) {
            IJ.error("There must be at least one 8-bit or RGB source stack.");
            return;
        }
        int n6 = 0;
        while (n6 < 3) {
            imagePlus = imagePlusArray[n6];
            if (imagePlus != null) {
                if (imagePlus.getStackSize() != n2) {
                    IJ.error("The source stacks must all have the same number of slices.");
                    return;
                }
                if (imagePlus.getType() != 0 && imagePlus.getType() != 4) {
                    IJ.error("The source stacks must be 8-bit grayscale or RGB.");
                    return;
                }
                if (imagePlus.getWidth() != n3 || imagePlusArray[n6].getHeight() != n4) {
                    IJ.error("The source stacks must have the same width and height.");
                    return;
                }
            }
            ++n6;
        }
        imagePlus = imagePlusArray[0] != null ? imagePlusArray[0].getStack() : null;
        ImageStack imageStack = imagePlusArray[1] != null ? imagePlusArray[1].getStack() : null;
        ImageStack imageStack2 = imagePlusArray[2] != null ? imagePlusArray[2].getStack() : null;
        ImageStack imageStack3 = this.mergeStacks(n3, n4, n2, (ImageStack)((Object)imagePlus), imageStack, imageStack2, bl);
        if (!bl) {
            int n7 = 0;
            while (n7 < 3) {
                if (imagePlusArray[n7] != null) {
                    imagePlusArray[n7].changes = false;
                    ImageWindow imageWindow = imagePlusArray[n7].getWindow();
                    if (imageWindow != null) {
                        imageWindow.close();
                    }
                }
                ++n7;
            }
        }
        new ImagePlus("RGB", imageStack3).show();
    }

    public ImageStack mergeStacks(int n, int n2, int n3, ImageStack imageStack, ImageStack imageStack2, ImageStack imageStack3, boolean bl) {
        ImageStack imageStack4 = new ImageStack(n, n2);
        int n4 = n3 / 10;
        if (n4 < 1) {
            n4 = 1;
        }
        int n5 = 1;
        this.blank = new byte[n * n2];
        boolean bl2 = imageStack != null ? imageStack.getProcessor(1).isInvertedLut() : false;
        boolean bl3 = imageStack2 != null ? imageStack2.getProcessor(1).isInvertedLut() : false;
        boolean bl4 = imageStack3 != null ? imageStack3.getProcessor(1).isInvertedLut() : false;
        try {
            int n6 = 1;
            while (n6 <= n3) {
                ColorProcessor colorProcessor = new ColorProcessor(n, n2);
                byte[] byArray = this.getPixels(imageStack, n5, 0);
                byte[] byArray2 = this.getPixels(imageStack2, n5, 1);
                byte[] byArray3 = this.getPixels(imageStack3, n5, 2);
                if (bl2) {
                    this.invert(byArray);
                }
                if (bl3) {
                    this.invert(byArray2);
                }
                if (bl4) {
                    this.invert(byArray3);
                }
                colorProcessor.setRGB(byArray, byArray2, byArray3);
                if (bl) {
                    ++n5;
                    if (bl2) {
                        this.invert(byArray);
                    }
                    if (bl3) {
                        this.invert(byArray2);
                    }
                    if (bl4) {
                        this.invert(byArray3);
                    }
                } else {
                    if (imageStack != null) {
                        imageStack.deleteSlice(1);
                    }
                    if (imageStack2 != null && imageStack2 != imageStack) {
                        imageStack2.deleteSlice(1);
                    }
                    if (imageStack3 != null && imageStack3 != imageStack && imageStack3 != imageStack2) {
                        imageStack3.deleteSlice(1);
                    }
                }
                imageStack4.addSlice(null, colorProcessor);
                if (n6 % n4 == 0) {
                    IJ.showProgress((double)n6 / (double)n3);
                }
                ++n6;
            }
            IJ.showProgress(1.0);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.outOfMemory("Merge Stacks");
            IJ.showProgress(1.0);
        }
        return imageStack4;
    }

    byte[] getPixels(ImageStack imageStack, int n, int n2) {
        if (imageStack == null) {
            return this.blank;
        }
        if (imageStack.getPixels(n) instanceof byte[]) {
            return (byte[])imageStack.getPixels(n);
        }
        int n3 = imageStack.getWidth() * imageStack.getHeight();
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        ColorProcessor colorProcessor = (ColorProcessor)imageStack.getProcessor(n);
        colorProcessor.getRGB(byArray, byArray2, byArray3);
        switch (n2) {
            case 0: {
                return byArray;
            }
            case 1: {
                return byArray2;
            }
            case 2: {
                return byArray3;
            }
        }
        return null;
    }

    void invert(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(255 - byArray[n] & 0xFF);
            ++n;
        }
    }
}

