/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.plugin.frame.Editor;

public class NewPlugin
implements PlugIn {
    public static final int MACRO = 0;
    public static final int PLUGIN = 1;
    public static final int PLUGIN_FILTER = 2;
    public static final int PLUGIN_FRAME = 3;
    private static int type = 0;
    private static String name = "Macro";
    private static String[] types = new String[]{"Macro", "Plugin", "Plugin Filter", "Plugin Frame"};
    static /* synthetic */ Class class$ij$plugin$NewPlugin;

    public void run(String string) {
        if (string.equals("") && !this.showDialog()) {
            return;
        }
        if (!string.equals("")) {
            type = 1;
        }
        if (string.equals("")) {
            if (type == 0) {
                this.createMacro(name);
            } else {
                this.createPlugin(name, type, string);
            }
        } else {
            this.createPlugin("Macro_.java", type, string);
        }
        IJ.register(class$ij$plugin$NewPlugin == null ? (class$ij$plugin$NewPlugin = NewPlugin.class$("ij.plugin.NewPlugin")) : class$ij$plugin$NewPlugin);
    }

    public void createMacro(String string) {
        Editor editor = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
        if (editor == null) {
            return;
        }
        if (string.endsWith(".java")) {
            string = string.substring(0, string.length() - 5);
        }
        if (string.endsWith("_")) {
            string = string.substring(0, string.length() - 1);
        }
        if (!string.endsWith(".txt") && !string.endsWith(".macro")) {
            string = string + ".txt";
        }
        String string2 = "";
        string2 = string2 + "// This is an ImageJ macro. Run it by typing ctrl-R.\n";
        string2 = string2 + "// If there is a selection, only the selection runs.\n";
        string2 = string2 + "  \n";
        string2 = string2 + "  var n = 2\n";
        string2 = string2 + "  \"n = \"+n\n";
        string2 = string2 + "  \"(n+3)/2 = \"+(n+3)/2+\",   sqrt(n) = \"+sqrt(n)\n";
        string2 = string2 + "  \"1.234567 to 3 decimal places is \"+d2s(1.234567,3)\n";
        string2 = string2 + "  \"1023 in hex is \"+toHex(1023)\n";
        string2 = string2 + "  \"3ff in decimal is \"+0x3ff\n";
        string2 = string2 + "  \n";
        string2 = string2 + "  var w=400, h=w/2;\n";
        string2 = string2 + "  \"opening \"+w+\"x\"+h+\" image...\"\n";
        string2 = string2 + "  run(\"New...\",  \"name=Test fill=Ramp width=\"+w+\" height=\"+h);\n";
        string2 = string2 + "  run(\"AND...\", \"value=11100000\");\n";
        string2 = string2 + "  run(\"Find Edges\");\n";
        string2 = string2 + "  run(\"Invert\");\n";
        editor.create(string, string2);
    }

    public void createPlugin(String string, int n, String string2) {
        Editor editor = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
        if (editor == null) {
            return;
        }
        String string3 = string;
        if (!string.endsWith(".java") && !string.endsWith(".JAVA")) {
            string3 = string3 + ".java";
        }
        if (string.indexOf(95) == -1) {
            string3 = string3.substring(0, string3.length() - 5);
            string3 = string3 + "_.java";
        }
        String string4 = string3.substring(0, string3.length() - 5);
        String string5 = "";
        string5 = string5 + "import ij.*;\n";
        string5 = string5 + "import ij.process.*;\n";
        string5 = string5 + "import ij.gui.*;\n";
        string5 = string5 + "import java.awt.*;\n";
        switch (n) {
            case 1: {
                string5 = string5 + "import ij.plugin.*;\n";
                string5 = string5 + "\n";
                string5 = string5 + "public class " + string4 + " implements PlugIn {\n";
                string5 = string5 + "\n";
                string5 = string5 + "\tpublic void run(String arg) {\n";
                string5 = string2.equals("") ? string5 + "\t\tIJ.showMessage(\"" + string4 + "\",\"Hello world!\");\n" : string5 + string2;
                string5 = string5 + "\t}\n";
                break;
            }
            case 2: {
                string5 = string5 + "import ij.plugin.filter.*;\n";
                string5 = string5 + "\n";
                string5 = string5 + "public class " + string4 + " implements PlugInFilter {\n";
                string5 = string5 + "\tImagePlus imp;\n";
                string5 = string5 + "\n";
                string5 = string5 + "\tpublic int setup(String arg, ImagePlus imp) {\n";
                string5 = string5 + "\t\tthis.imp = imp;\n";
                string5 = string5 + "\t\treturn DOES_ALL;\n";
                string5 = string5 + "\t}\n";
                string5 = string5 + "\n";
                string5 = string5 + "\tpublic void run(ImageProcessor ip) {\n";
                string5 = string5 + "\t\tip.invert();\n";
                string5 = string5 + "\t\timp.updateAndDraw();\n";
                string5 = string5 + "\t\tIJ.wait(500);\n";
                string5 = string5 + "\t\tip.invert();\n";
                string5 = string5 + "\t\timp.updateAndDraw();\n";
                string5 = string5 + "\t}\n";
                break;
            }
            case 3: {
                string5 = string5 + "import ij.plugin.frame.*;\n";
                string5 = string5 + "\n";
                string5 = string5 + "public class " + string4 + " extends PlugInFrame {\n";
                string5 = string5 + "\n";
                string5 = string5 + "\tpublic " + string4 + "() {\n";
                string5 = string5 + "\t\tsuper(\"" + string4 + "\");\n";
                string5 = string5 + "\t\tTextArea ta = new TextArea();\n";
                string5 = string5 + "\t\tadd(ta);\n";
                string5 = string5 + "\t\tpack();\n";
                string5 = string5 + "\t\tGUI.center(this);\n";
                string5 = string5 + "\t\tshow();\n";
                string5 = string5 + "\t}\n";
            }
        }
        string5 = string5 + "\n";
        string5 = string5 + "}\n";
        editor.create(string3, string5);
    }

    public boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog("New Plugin...");
        genericDialog.addStringField("Name:", name, 16);
        genericDialog.addChoice("Type:", types, types[type]);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        name = genericDialog.getNextString();
        type = genericDialog.getNextChoiceIndex();
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

