/*
 * Decompiled with CFR 0.152.
 */
package de.globalcube.gui;

import de.globalcube.Generate;
import de.globalcube.bean.ConfigBean;
import de.globalcube.bean.PublishBean;
import de.globalcube.bean.ScorecardBean;
import de.globalcube.gui.AlarmConfigPanel;
import de.globalcube.gui.BatchConfigPanel;
import de.globalcube.gui.DefaultTreeFolderRenderer;
import de.globalcube.gui.GeneralPanel;
import de.globalcube.gui.ImageColorPanel;
import de.globalcube.gui.ImageConfigPanel;
import de.globalcube.gui.JRollOverButton;
import de.globalcube.gui.LogonPanel;
import de.globalcube.gui.PublishPanel;
import de.globalcube.gui.PublishesPanel;
import de.globalcube.gui.ScorecardPanel;
import de.globalcube.gui.ScorecardsPanel;
import de.globalcube.gui.SuffixFilter;
import de.globalcube.util.Utility;
import de.globalcube.xml.XMLConfigReader;
import de.globalcube.xml.XMLConfigWriter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class WebMISCreator
extends JPanel
implements TreeSelectionListener {
    public static final int ROOT_NODE = 0;
    public static final int GENERAL_NODE = 1;
    public static final int SCORECARDS_NODE = 2;
    public static final int PUBLISHES_NODE = 3;
    public static final int LOGON_NODE = 4;
    public static WebMISCreator instance;
    private DefaultTreeModel model;
    private JSplitPane splitPane;
    private JTree treeMessenger;
    private static DefaultMutableTreeNode root;
    private CardLayout cardLayout = new CardLayout();
    private DefaultMutableTreeNode einstellungenNode;
    private DefaultMutableTreeNode alarmConfigNode;
    private DefaultMutableTreeNode imageConfigNode;
    private DefaultMutableTreeNode batchConfigNode;
    private DefaultMutableTreeNode imageColorNode;
    private DefaultMutableTreeNode scorecardsNode;
    private HashMap scorecardMap;
    private DefaultMutableTreeNode publishesNode;
    private HashMap publishMap;
    private DefaultMutableTreeNode logonInfoNode;
    private GeneralPanel pnlGeneral;
    private AlarmConfigPanel pnlAlarmConfig;
    private ImageConfigPanel pnlImageConfig;
    private BatchConfigPanel pnlBatchConfig;
    private PublishesPanel pnlPublishes;
    private PublishPanel pnlPublish;
    private ScorecardsPanel pnlScorecards;
    private ScorecardPanel pnlScorecard;
    private LogonPanel pnlLogonInfo;
    private ImageColorPanel pnlImageColor;
    private JPanel pnlMain;
    private JScrollPane scrollTree;
    private JScrollPane scrollGeneral;
    private JScrollPane scrollAlarmConfig;
    private JScrollPane scrollImageConfig;
    private JScrollPane scrollBatchConfig;
    private JScrollPane scrollScorecards;
    private JScrollPane scrollScorecard;
    private JScrollPane scrollPublishes;
    private JScrollPane scrollPublish;
    private JScrollPane scrollLogonInfo;
    private JScrollPane scrollImageColor;
    private JFrame owner;
    private String mainTitle;
    private String windowTitle;
    private File file;
    private JRollOverButton btnAdd;
    private JRollOverButton btnRemove;
    private JRollOverButton btnPromote;
    private JRollOverButton btnDemote;

    public WebMISCreator(JFrame jFrame, File file) {
        this.enableEvents(64L);
        try {
            instance = this;
            this.owner = jFrame;
            this.file = file;
            this.initComponents();
            this.mainTitle = "Web MIS Creator";
            this.setTitle("");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JFrame getOwner() {
        return this.owner;
    }

    public JPanel getPanel(String string) {
        if (string.equals("General")) {
            return this.pnlGeneral;
        }
        if (string.equals("AlarmConfig")) {
            return this.pnlAlarmConfig;
        }
        if (string.equals("ImageConfig")) {
            return this.pnlImageConfig;
        }
        if (string.equals("AlarmConfig")) {
            return this.pnlBatchConfig;
        }
        if (string.equals("Publishes")) {
            return this.pnlPublishes;
        }
        if (string.equals("Reports")) {
            return this.pnlPublish;
        }
        if (string.equals("Scorecards")) {
            return this.pnlScorecards;
        }
        if (string.equals("Images")) {
            return this.pnlScorecard;
        }
        if (string.equals("LogonInfo")) {
            return this.pnlLogonInfo;
        }
        if (string.equals("ImageColor")) {
            return this.pnlImageColor;
        }
        return null;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.showSelected(treeSelectionEvent.getPath().getLastPathComponent());
    }

    private void showSelected(Object object) {
        String string = object.toString();
        if (string.equals("Einstellungen")) {
            this.showScreen("General");
            this.scrollGeneral.getViewport().setView(this.pnlGeneral);
        } else if (string.equals("Alarm Einstellungen")) {
            this.showScreen("AlarmConfig");
            this.scrollAlarmConfig.getViewport().setView(this.pnlAlarmConfig);
        } else if (string.equals("Image Einstellungen")) {
            this.showScreen("ImageConfig");
            this.scrollImageConfig.getViewport().setView(this.pnlImageConfig);
        } else if (string.equals("Batch Einstellungen")) {
            this.showScreen("BatchConfig");
            this.scrollBatchConfig.getViewport().setView(this.pnlBatchConfig);
        } else if (string.equals("Scorecards")) {
            this.showScreen("Scorecards");
            this.scrollScorecards.getViewport().setView(this.pnlScorecards);
            if (this.pnlScorecards.isRowSelected()) {
                this.btnDemote.setEnabled(true);
            }
        } else if (string.equals("Publish Struktur")) {
            this.showScreen("Publishes");
            this.scrollPublishes.getViewport().setView(this.pnlPublishes);
            if (this.pnlPublishes.isRowSelected()) {
                this.btnRemove.setEnabled(true);
            }
        } else if (string.equals("Zugriff")) {
            this.showScreen("LogonInfo");
            this.scrollLogonInfo.getViewport().setView(this.pnlLogonInfo);
        } else if (string.equals("Image Color")) {
            this.showScreen("ImageColor");
            this.scrollImageColor.getViewport().setView(this.pnlImageColor);
        } else if (this.scorecardMap.containsKey(object)) {
            this.showScorecard((ScorecardBean)this.scorecardMap.get(object));
        } else if (this.publishMap.containsKey(object)) {
            this.showPublish((PublishBean)this.publishMap.get(object));
        } else {
            this.showScreen("BLANK");
        }
    }

    private void showScorecard(ScorecardBean scorecardBean) {
        this.pnlScorecard = new ScorecardPanel(scorecardBean);
        this.showScreen("Reports" + scorecardBean.getName());
        this.scrollScorecard.getViewport().setView(this.pnlScorecard);
        this.btnRemove.setEnabled(true);
    }

    private void showPublish(PublishBean publishBean) {
        this.pnlPublish = new PublishPanel(publishBean);
        this.showScreen("Images" + publishBean.getName());
        this.scrollPublish.getViewport().setView(this.pnlPublish);
        this.btnRemove.setEnabled(true);
    }

    private void initComponents() throws Exception {
        this.setLayout(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setMaximumSize(new Dimension(0, 35));
        jToolBar.setPreferredSize(new Dimension(0, 35));
        jToolBar.setMinimumSize(new Dimension(0, 35));
        jToolBar.setBorder(BorderFactory.createEtchedBorder());
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setHgap(2);
        flowLayout.setAlignment(0);
        flowLayout.setVgap(2);
        jToolBar.setLayout(flowLayout);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JRollOverButton jRollOverButton = new JRollOverButton(Utility.getImageIcon("New"), (Icon)Utility.getImageIcon("New"));
        jRollOverButton.setToolTipText("Create New Project");
        jRollOverButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebMISCreator.this.createNewProject();
            }
        });
        this.doResizeButton(jRollOverButton);
        jToolBar.add(jRollOverButton);
        jToolBar.addSeparator();
        JRollOverButton jRollOverButton2 = new JRollOverButton(Utility.getImageIcon("Open"), (Icon)Utility.getImageIcon("Open"));
        jRollOverButton2.setToolTipText("Open Project...");
        jRollOverButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebMISCreator.this.openProject();
            }
        });
        this.doResizeButton(jRollOverButton2);
        jToolBar.add(jRollOverButton2);
        jToolBar.addSeparator();
        JRollOverButton jRollOverButton3 = new JRollOverButton(Utility.getImageIcon("Save"), (Icon)Utility.getImageIcon("Save"));
        jRollOverButton3.setToolTipText("Save Project");
        jRollOverButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebMISCreator.this.saveProject();
            }
        });
        this.doResizeButton(jRollOverButton3);
        jToolBar.add(jRollOverButton3);
        jToolBar.addSeparator();
        JRollOverButton jRollOverButton4 = new JRollOverButton(Utility.getImageIcon("SaveAs"), (Icon)Utility.getImageIcon("SaveAs"));
        jRollOverButton4.setToolTipText("Save Project As...");
        jRollOverButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebMISCreator.this.saveAsProject();
            }
        });
        this.doResizeButton(jRollOverButton4);
        jToolBar.add(jRollOverButton4);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        this.btnAdd = new JRollOverButton(Utility.getImageIcon("Copy"), (Icon)Utility.getImageIcon("Copy"));
        this.btnAdd.setToolTipText("Add New Value");
        this.btnAdd.setEnabled(false);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebMISCreator.this.processInsertKey();
            }
        });
        this.doResizeButton(this.btnAdd);
        jToolBar.add(this.btnAdd);
        this.btnRemove = new JRollOverButton(Utility.getImageIcon("Remove"), (Icon)Utility.getImageIcon("Remove"));
        this.btnRemove.setToolTipText("Remove Value");
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebMISCreator.this.processDeleteKey();
            }
        });
        this.doResizeButton(this.btnRemove);
        jToolBar.add(this.btnRemove);
        jToolBar.addSeparator();
        this.btnPromote = new JRollOverButton(Utility.getImageIcon("Promote"), (Icon)Utility.getImageIcon("Promote"));
        this.btnPromote.setToolTipText("Move Up");
        this.btnPromote.setEnabled(false);
        this.btnPromote.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebMISCreator.this.processPromoteKey();
            }
        });
        this.doResizeButton(this.btnPromote);
        jToolBar.add(this.btnPromote);
        this.btnDemote = new JRollOverButton(Utility.getImageIcon("Demote"), (Icon)Utility.getImageIcon("Demote"));
        this.btnDemote.setToolTipText("Move Down");
        this.btnDemote.setEnabled(false);
        this.btnDemote.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebMISCreator.this.processDemoteKey();
            }
        });
        this.doResizeButton(this.btnDemote);
        jToolBar.add(this.btnDemote);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        JRollOverButton jRollOverButton5 = new JRollOverButton(Utility.getImageIcon("Portal"), (Icon)Utility.getImageIcon("Portal"));
        jRollOverButton5.setToolTipText("Portal Web page");
        jRollOverButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "javascript:location.href='http://" + Utility.getConfigBean().getGeneral().getWebServerName() + "/" + Utility.getConfigBean().getName() + "/" + Utility.getConfigBean().getGeneral().getPortalStartPage() + "'";
                Utility.runFile(string);
            }
        });
        this.doResizeButton(jRollOverButton5);
        jToolBar.add(jRollOverButton5);
        jToolBar.addSeparator();
        JRollOverButton jRollOverButton6 = new JRollOverButton(Utility.getImageIcon("Generate"), (Icon)Utility.getImageIcon("Generate"));
        jRollOverButton6.setToolTipText("Generate Scorecards & Reports");
        jRollOverButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (WebMISCreator.this.saveData()) {
                    Cursor cursor = WebMISCreator.this.getCursor();
                    WebMISCreator.this.setCursor(new Cursor(3));
                    Generate.generate("ALL");
                    WebMISCreator.this.setCursor(cursor);
                }
            }
        });
        this.doResizeButton(jRollOverButton6);
        jToolBar.add(jRollOverButton6);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        JRollOverButton jRollOverButton7 = new JRollOverButton(Utility.getImageIcon("Help"), (Icon)Utility.getImageIcon("Help"));
        jRollOverButton7.setToolTipText("Help");
        jRollOverButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WebMISCreator.this.runHelp();
            }
        });
        this.doResizeButton(jRollOverButton7);
        jToolBar.add(jRollOverButton7);
        jToolBar.setBorder(new EmptyBorder(0, 5, 0, 5));
        jPanel.add((Component)jToolBar, "Center");
        this.add((Component)jPanel, "North");
        this.pnlMain = new JPanel();
        this.pnlMain.setBackground(Color.white);
        this.pnlMain.setLayout(this.cardLayout);
        jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.pnlMain.add((Component)jPanel, "BLANK");
        this.pnlGeneral = new GeneralPanel();
        this.scrollGeneral = new JScrollPane(this.pnlGeneral);
        this.pnlMain.add((Component)this.scrollGeneral, "General");
        this.pnlAlarmConfig = new AlarmConfigPanel();
        this.scrollAlarmConfig = new JScrollPane(this.pnlAlarmConfig);
        this.pnlMain.add((Component)this.scrollAlarmConfig, "AlarmConfig");
        this.pnlImageConfig = new ImageConfigPanel();
        this.scrollImageConfig = new JScrollPane(this.pnlImageConfig);
        this.pnlMain.add((Component)this.scrollImageConfig, "ImageConfig");
        this.pnlBatchConfig = new BatchConfigPanel();
        this.scrollBatchConfig = new JScrollPane(this.pnlBatchConfig);
        this.pnlMain.add((Component)this.scrollBatchConfig, "BatchConfig");
        this.pnlPublishes = new PublishesPanel();
        this.scrollPublishes = new JScrollPane(this.pnlPublishes);
        this.pnlMain.add((Component)this.scrollPublishes, "Publishes");
        this.pnlLogonInfo = new LogonPanel();
        this.scrollLogonInfo = new JScrollPane(this.pnlLogonInfo);
        this.pnlMain.add((Component)this.scrollLogonInfo, "LogonInfo");
        this.pnlImageColor = new ImageColorPanel();
        this.scrollImageColor = new JScrollPane(this.pnlImageColor);
        this.pnlMain.add((Component)this.scrollImageColor, "ImageColor");
        this.scrollPublish = new JScrollPane();
        this.pnlMain.add((Component)this.scrollPublish, "Images");
        this.pnlScorecards = new ScorecardsPanel();
        this.scrollScorecards = new JScrollPane(this.pnlScorecards);
        this.pnlMain.add((Component)this.scrollScorecards, "Scorecards");
        this.scrollScorecard = new JScrollPane();
        this.pnlMain.add((Component)this.scrollScorecard, "Reports");
        this.initTree();
        this.scrollTree = new JScrollPane(this.treeMessenger);
        this.treeMessenger.setMaximumSize(new Dimension(100, 0));
        this.treeMessenger.setPreferredSize(new Dimension(100, 0));
        this.treeMessenger.setMinimumSize(new Dimension(100, 0));
        this.treeMessenger.setCellRenderer(new DefaultTreeFolderRenderer());
        this.treeMessenger.addTreeSelectionListener(this);
        this.splitPane = new JSplitPane();
        this.splitPane.setBorder(BorderFactory.createEtchedBorder());
        this.splitPane.setLeftComponent(this.scrollTree);
        this.splitPane.setDividerSize(2);
        this.splitPane.setDividerLocation(150);
        this.splitPane.setBackground(Color.white);
        this.splitPane.setRightComponent(this.pnlMain);
        this.add((Component)this.splitPane, "Center");
    }

    public void showScreen(String string) {
        String string2 = string;
        if (string.startsWith("Images")) {
            string2 = "Images";
        } else if (string.startsWith("Reports")) {
            string2 = "Reports";
        }
        this.cardLayout.show(this.pnlMain, string2);
        this.setTitle(string);
    }

    private void setTitle(String string) {
        String string2 = "";
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        if (string.equals("General")) {
            string2 = "Einstellungen";
        } else if (string.equals("AlarmConfig")) {
            string2 = "Alarm Einstellungen";
        } else if (string.equals("ImageConfig")) {
            string2 = "Image Einstellungen";
        } else if (string.equals("BatchConfig")) {
            string2 = "Batch Einstellungen";
        } else if (string.equals("LogonInfo")) {
            string2 = "Zugriff";
        } else if (string.equals("ImageColor")) {
            string2 = "Image Color";
        } else if (string.equals("Publishes")) {
            string2 = "Publish Struktur";
            bl = true;
        } else if (string.startsWith("Images")) {
            string2 = "Images Configuration : " + string.substring(6);
            bl = true;
            bl2 = true;
        } else if (string.equals("Scorecards")) {
            string2 = "Scorecard Struktur";
            bl = true;
        } else if (string.startsWith("Reports")) {
            string2 = "Reports Configuration : " + string.substring(7);
            bl = true;
            bl2 = true;
        }
        string3 = this.mainTitle + " (" + this.file.getName() + ")";
        if (string2.length() > 0) {
            string3 = string3 + "  - " + string2;
        }
        this.owner.setTitle(string3);
        this.btnAdd.setEnabled(bl);
        this.btnRemove.setEnabled(bl2);
    }

    private void createNewProject() {
        ConfigBean configBean = new ConfigBean();
        Utility.setConfigBean(configBean);
        this.createNewPanels();
        this.refreshNodes("REMOVE");
        this.treeMessenger.repaint();
        this.file = new File("NEW.XML");
        this.selectTree(0);
    }

    public void selectTree(int n) {
        this.treeMessenger.setSelectionPath(this.treeMessenger.getPathForRow(n));
    }

    private void refreshNodes(String string) {
        Object var2_2 = null;
        if (string.equals("REMOVE")) {
            this.scorecardsNode.removeAllChildren();
            this.publishesNode.removeAllChildren();
            this.model.reload();
            this.scorecardMap = new HashMap();
            this.publishMap = new HashMap();
        } else if (string.equals("REFRESH")) {
            this.refreshPublishesNodes();
            this.refreshScorecardsNodes();
        }
    }

    private void createNewPanels() {
        this.pnlGeneral = new GeneralPanel();
        this.pnlScorecards = new ScorecardsPanel();
        this.pnlPublishes = new PublishesPanel();
        this.pnlLogonInfo = new LogonPanel();
        this.pnlImageColor = new ImageColorPanel();
        this.pnlAlarmConfig = new AlarmConfigPanel();
        this.pnlImageConfig = new ImageConfigPanel();
        this.pnlBatchConfig = new BatchConfigPanel();
    }

    private void openProject() {
        JFileChooser jFileChooser = new JFileChooser(new File("."));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setFileFilter(new SuffixFilter("XML", "XML Files"));
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.file = jFileChooser.getSelectedFile();
            String string = this.file.getAbsolutePath();
            XMLConfigReader xMLConfigReader = new XMLConfigReader();
            xMLConfigReader.parseXML(string);
            this.createNewPanels();
            this.refreshNodes("REFRESH");
            this.model.reload();
            this.selectTree(0);
        }
    }

    private boolean saveData() {
        if (!this.pnlGeneral.validateData(false)) {
            this.selectTree(1);
            this.pnlGeneral.validateData(true);
            return false;
        }
        this.pnlGeneral.writeValues();
        this.pnlAlarmConfig.writeValues();
        this.pnlImageConfig.writeValues();
        this.pnlBatchConfig.writeValues();
        this.pnlLogonInfo.writeValues();
        this.pnlImageColor.writeValues();
        return true;
    }

    private void saveProject() {
        if (this.file.getName().equals("NEW.XML")) {
            this.saveAsProject();
        } else {
            String string = this.file.getAbsolutePath();
            if (this.saveData()) {
                XMLConfigWriter xMLConfigWriter = new XMLConfigWriter(Utility.getConfigBean(), string);
                JOptionPane.showMessageDialog(this.owner, "Datei " + string + " wurde gespeichert", "Message", 1);
            }
        }
    }

    private void saveAsProject() {
        if (this.saveData()) {
            JFileChooser jFileChooser = new JFileChooser(new File("."));
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setFileFilter(new SuffixFilter("XML", "XML Files"));
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                this.file = jFileChooser.getSelectedFile();
                String string = this.file.getAbsolutePath();
                if (!string.toUpperCase().endsWith(".XML")) {
                    string = string + ".xml";
                    this.file = new File(string);
                }
                XMLConfigWriter xMLConfigWriter = new XMLConfigWriter(Utility.getConfigBean(), string);
                this.selectTree(0);
                JOptionPane.showMessageDialog(this.owner, "Datei " + string + " wurde gespeichert", "Message", 1);
            }
        }
    }

    private void doResizeButton(JButton jButton) {
        Dimension dimension = new Dimension(25, 25);
        jButton.setMinimumSize(dimension);
        jButton.setMaximumSize(dimension);
        jButton.setPreferredSize(dimension);
    }

    private void initTree() {
        Vector vector = Utility.getConfigBean().getScorecards();
        Vector vector2 = Utility.getConfigBean().getPublishes();
        Object var3_3 = null;
        root = new DefaultMutableTreeNode("Projekteinstellungen");
        this.einstellungenNode = new DefaultMutableTreeNode("Einstellungen");
        this.scorecardsNode = new DefaultMutableTreeNode("Scorecards");
        this.publishesNode = new DefaultMutableTreeNode("Publish Struktur");
        this.logonInfoNode = new DefaultMutableTreeNode("Zugriff");
        this.alarmConfigNode = new DefaultMutableTreeNode("Alarm Einstellungen");
        this.imageConfigNode = new DefaultMutableTreeNode("Image Einstellungen");
        this.batchConfigNode = new DefaultMutableTreeNode("Batch Einstellungen");
        this.imageColorNode = new DefaultMutableTreeNode("Image Color");
        this.einstellungenNode.add(this.alarmConfigNode);
        this.einstellungenNode.add(this.imageConfigNode);
        this.einstellungenNode.add(this.batchConfigNode);
        this.einstellungenNode.add(this.imageColorNode);
        root.add(this.einstellungenNode);
        this.refreshNodes("REFRESH");
        root.add(this.scorecardsNode);
        root.add(this.publishesNode);
        root.add(this.logonInfoNode);
        this.model = new DefaultTreeModel(root);
        this.treeMessenger = new JTree(this.model);
        this.treeMessenger.setMaximumSize(new Dimension(100, 100));
        this.treeMessenger.setPreferredSize(new Dimension(100, 100));
        this.treeMessenger.setMinimumSize(new Dimension(100, 100));
        this.treeMessenger.getSelectionModel().setSelectionMode(1);
        this.treeMessenger.putClientProperty("JTree.lineStyle", "Angled");
        this.treeMessenger.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 155) {
                    WebMISCreator.this.processInsertKey();
                } else if (keyEvent.getKeyCode() == 127) {
                    WebMISCreator.this.processDeleteKey();
                }
            }
        });
    }

    private void processInsertKey() {
        Object object = this.treeMessenger.getLastSelectedPathComponent();
        String string = object.toString();
        if (!(string.equals("Projekteinstellungen") || string.equals("Einstellungen") || string.equals("Zugriff") || string.equals("Alarm Einstellungen") || string.equals("Image Einstellungen") || string.equals("Batch Einstellungen") || string.equals("Image Color"))) {
            if (string.equals("Scorecards")) {
                this.pnlScorecards.newRowData();
            } else if (string.equals("Publish Struktur")) {
                this.pnlPublishes.newRowData();
            } else if (this.scorecardMap.containsKey(object)) {
                if (this.pnlScorecard.isRowSelected()) {
                    this.pnlScorecard.newRowData();
                } else {
                    this.pnlScorecards.newRowData();
                    this.selectTree(2);
                }
            } else if (this.publishMap.containsKey(object)) {
                if (this.pnlPublish.isRowSelected()) {
                    this.pnlPublish.newRowData();
                } else {
                    this.pnlPublishes.newRowData();
                    this.selectTree(3);
                }
            }
        }
    }

    private void processDeleteKey() {
        Object object = this.treeMessenger.getLastSelectedPathComponent();
        String string = object.toString();
        if (!(string.equals("Projekteinstellungen") || string.equals("Einstellungen") || string.equals("Zugriff") || string.equals("Alarm Einstellungen") || string.equals("Image Einstellungen") || string.equals("Batch Einstellungen") || string.equals("Image Color"))) {
            if (string.equals("Scorecards")) {
                this.pnlScorecards.removeRowData();
            } else if (string.equals("Publish Struktur")) {
                this.pnlPublishes.removeRowData();
            } else if (this.scorecardMap.containsKey(object)) {
                if (this.pnlScorecard.isRowSelected()) {
                    this.pnlScorecard.removeRowData();
                } else {
                    this.removeNode("Scorecard", object);
                }
            } else if (this.publishMap.containsKey(object)) {
                if (this.pnlPublish.isRowSelected()) {
                    this.pnlPublish.removeRowData();
                } else {
                    this.removeNode("Publish", object);
                }
            }
        }
    }

    private void processPromoteKey() {
        Object object = this.treeMessenger.getLastSelectedPathComponent();
        String string = object.toString();
        if (!(string.equals("Projekteinstellungen") || string.equals("Einstellungen") || string.equals("Zugriff") || string.equals("Alarm Einstellungen") || string.equals("Image Einstellungen") || string.equals("Batch Einstellungen") || string.equals("Image Color"))) {
            if (string.equals("Scorecards")) {
                this.pnlScorecards.promoteData();
            } else if (string.equals("Publish Struktur")) {
                this.pnlPublishes.promoteData();
            } else if (this.scorecardMap.containsKey(object)) {
                if (this.pnlScorecard.isRowSelected()) {
                    this.pnlScorecard.promoteData();
                }
            } else if (this.publishMap.containsKey(object) && this.pnlPublish.isRowSelected()) {
                this.pnlPublish.promoteData();
            }
        }
    }

    private void processDemoteKey() {
        Object object = this.treeMessenger.getLastSelectedPathComponent();
        String string = object.toString();
        if (!(string.equals("Projekteinstellungen") || string.equals("Einstellungen") || string.equals("Zugriff") || string.equals("Alarm Einstellungen") || string.equals("Image Einstellungen") || string.equals("Batch Einstellungen") || string.equals("Image Color"))) {
            if (string.equals("Scorecards")) {
                this.pnlScorecards.demoteData();
            } else if (string.equals("Publish Struktur")) {
                this.pnlPublishes.demoteData();
            } else if (this.scorecardMap.containsKey(object)) {
                if (this.pnlScorecard.isRowSelected()) {
                    this.pnlScorecard.demoteData();
                }
            } else if (this.publishMap.containsKey(object) && this.pnlPublish.isRowSelected()) {
                this.pnlPublish.demoteData();
            }
        }
    }

    private void removeNode(String string, Object object) {
        int n = JOptionPane.showConfirmDialog(null, "Remove nodes data ?", "Best\u00e4tigung", 0, 1);
        if (n == 1) {
            return;
        }
        if (string.equals("Scorecard")) {
            ScorecardBean scorecardBean = (ScorecardBean)this.scorecardMap.get(object);
            this.scorecardsNode.remove((MutableTreeNode)object);
            this.scorecardMap.remove(object);
            Utility.getConfigBean().getScorecards().removeElement(scorecardBean);
            this.pnlScorecards.initValues();
            this.model.reload();
            this.selectTree(2);
        } else if (string.equals("Publish")) {
            PublishBean publishBean = (PublishBean)this.publishMap.get(object);
            this.publishesNode.remove((MutableTreeNode)object);
            this.publishMap.remove(object);
            Utility.getConfigBean().getPublishes().removeElement(publishBean);
            this.pnlPublishes.initValues();
            this.model.reload();
            this.selectTree(3);
        }
    }

    public void refreshPublishesNodes() {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Vector vector = Utility.getConfigBean().getPublishes();
        this.publishesNode.removeAllChildren();
        if (vector != null) {
            this.publishMap = new HashMap();
            int n = 0;
            while (n < vector.size()) {
                PublishBean publishBean = (PublishBean)vector.elementAt(n);
                defaultMutableTreeNode = new DefaultMutableTreeNode(publishBean.getName());
                this.publishMap.put(defaultMutableTreeNode, publishBean);
                this.publishesNode.add(defaultMutableTreeNode);
                ++n;
            }
            if (this.model != null) {
                this.model.reload();
            }
        }
    }

    public void refreshScorecardsNodes() {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        Vector vector = Utility.getConfigBean().getScorecards();
        this.scorecardsNode.removeAllChildren();
        if (vector != null) {
            this.scorecardMap = new HashMap();
            int n = 0;
            while (n < vector.size()) {
                ScorecardBean scorecardBean = (ScorecardBean)vector.elementAt(n);
                defaultMutableTreeNode = new DefaultMutableTreeNode(scorecardBean.getName());
                this.scorecardMap.put(defaultMutableTreeNode, scorecardBean);
                this.scorecardsNode.add(defaultMutableTreeNode);
                ++n;
            }
            if (this.model != null) {
                this.model.reload();
            }
        }
    }

    public void setRemoveEnable() {
        this.btnRemove.setEnabled(true);
    }

    public void setPromoteEnable(boolean bl) {
        this.btnPromote.setEnabled(bl);
    }

    public void setDemoteEnable(boolean bl) {
        this.btnDemote.setEnabled(bl);
    }

    public Object getLastSelected() {
        Object object = this.treeMessenger.getLastSelectedPathComponent();
        String string = object.toString();
        Object var3_3 = null;
        if (string.equals("Projekteinstellungen") || string.equals("Einstellungen") || string.equals("Zugriff") || string.equals("Alarm Einstellungen") || string.equals("Image Einstellungen") || string.equals("Batch Einstellungen") || string.equals("Scorecards") || string.equals("Publish Struktur") || string.equals("Image Color")) {
            var3_3 = null;
        } else if (this.scorecardMap.containsKey(object)) {
            var3_3 = this.scorecardMap.get(object);
        } else if (this.publishMap.containsKey(object)) {
            var3_3 = this.publishMap.get(object);
        }
        return var3_3;
    }

    private void runHelp() {
        Object object = this.treeMessenger.getLastSelectedPathComponent();
        String string = null;
        String string2 = null;
        string = object == null ? "Project Einstellungen" : object.toString();
        string2 = string.equals("Einstellungen") ? "Einstellungen.html" : (string.equals("Zugriff") ? "Zugriff.html" : (string.equals("Image Color") ? "ImageColor.html" : (string.equals("Alarm Einstellungen") ? "AlarmEinstellungen.html" : (string.equals("Image Einstellungen") ? "ImageEinstellungen.html" : (string.equals("Batch Einstellungen") ? "BatchEinstellungen.html" : (string.equals("Scorecards") ? "Scorecards.html" : (string.equals("Publish Struktur") ? "Publishes.html" : (this.scorecardMap.containsKey(object) ? "Scorecard.html" : (this.publishMap.containsKey(object) ? "Publish.html" : "Main.html")))))))));
        if (string2 != null) {
            Utility.runFile("help/" + string2);
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        final JFrame jFrame = new JFrame("Web MIS Creator");
        String string = null;
        File file = null;
        if (stringArray.length > 0) {
            string = stringArray[0];
            file = new File(string);
            if (!file.exists()) {
                System.out.println("Cann't find file " + string);
                System.exit(0);
            }
            object = new XMLConfigReader();
            ((XMLConfigReader)object).parseXML(string);
        } else {
            string = "NEW.XML";
            file = new File(string);
            object = new ConfigBean();
            Utility.setConfigBean((ConfigBean)object);
        }
        jFrame.setState(0);
        jFrame.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        jFrame.setIconImage(Utility.getImageIcon("LogoSmall").getImage());
        object = jFrame.getContentPane();
        JScrollPane jScrollPane = new JScrollPane(new WebMISCreator(jFrame, file));
        ((Container)object).add(jScrollPane);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jFrame.dispose();
                System.exit(0);
            }
        });
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setLocation(dimension.width / 2 - jFrame.getPreferredSize().width / 2, dimension.height / 2 - jFrame.getPreferredSize().height / 2);
        jFrame.setVisible(true);
        jFrame.pack();
    }
}

