/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;

public class SimpleCommands
implements PlugIn {
    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        if (string.equals("unlock")) {
            this.unlock(imagePlus);
        } else if (string.equals("rename")) {
            this.rename(imagePlus);
        }
    }

    void unlock(ImagePlus imagePlus) {
        boolean bl = imagePlus.lockSilently();
        if (bl) {
            IJ.showStatus("\"" + imagePlus.getTitle() + "\" is not locked");
        } else {
            IJ.showStatus("\"" + imagePlus.getTitle() + "\" is now unlocked");
            IJ.beep();
        }
        imagePlus.unlock();
    }

    void rename(ImagePlus imagePlus) {
        GenericDialog genericDialog = new GenericDialog("Rename");
        genericDialog.addStringField("Title:", imagePlus.getTitle(), 30);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        imagePlus.setTitle(genericDialog.getNextString());
    }
}

