/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Line;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.Calibrator;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.SetScaleDialog;
import ij.process.ImageProcessor;

public class ScaleDialog
implements PlugInFilter {
    private ImagePlus imp;
    static /* synthetic */ Class class$ij$plugin$filter$ScaleDialog;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        IJ.register(class$ij$plugin$filter$ScaleDialog == null ? (class$ij$plugin$filter$ScaleDialog = ScaleDialog.class$("ij.plugin.filter.ScaleDialog")) : class$ij$plugin$filter$ScaleDialog);
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        Roi roi;
        double d = 0.0;
        double d2 = 1.0;
        double d3 = 1.0;
        String string = "cm";
        boolean bl = Calibrator.global;
        Calibration calibration = this.imp.getCalibration();
        boolean bl2 = calibration.scaled();
        String string2 = "<no scale>";
        int n = 2;
        if (bl2) {
            d = 1.0 / calibration.pixelWidth;
            if ((double)((int)d) == d) {
                n = 0;
            }
            if (d < 0.01) {
                n = 3;
            } else if (d < 0.001) {
                n = 4;
            }
            d2 = 1.0;
            d3 = calibration.pixelHeight / calibration.pixelWidth;
            string = calibration.getUnit();
            string2 = IJ.d2s(d, n) + " pixels per " + string;
        }
        if ((roi = this.imp.getRoi()) != null && roi instanceof Line) {
            d = ((Line)roi).getRawLength();
            d2 = 0.0;
        }
        SetScaleDialog setScaleDialog = new SetScaleDialog("Set Scale", string2);
        setScaleDialog.addNumericField("Distance in Pixels:", d, n);
        setScaleDialog.addNumericField("Known Distance:", d2, 2);
        setScaleDialog.addNumericField("Pixel Aspect Ratio:", d3, 1);
        setScaleDialog.addStringField("Unit of Length:", string);
        setScaleDialog.addMessage("Scale: 12345.789 pixels per centimeter");
        setScaleDialog.addCheckbox("Global", Calibrator.global);
        setScaleDialog.showDialog();
        if (setScaleDialog.wasCanceled()) {
            return;
        }
        d = setScaleDialog.getNextNumber();
        d2 = setScaleDialog.getNextNumber();
        d3 = setScaleDialog.getNextNumber();
        string = setScaleDialog.getNextString();
        if (string.equals("um")) {
            string = "\u00b5m";
        }
        Calibrator.global = setScaleDialog.getNextBoolean();
        if (d != 0.0 && d2 == 0.0) {
            this.imp.setGlobalCalibration(Calibrator.global ? calibration : null);
            return;
        }
        if (d <= 0.0 || string.startsWith("pixel") || string.startsWith("Pixel") || string.equals("")) {
            calibration.pixelWidth = 1.0;
            calibration.pixelHeight = 1.0;
            calibration.setUnit("pixel");
        } else {
            calibration.pixelWidth = d2 / d;
            calibration.pixelHeight = d3 != 0.0 ? calibration.pixelWidth * d3 : calibration.pixelWidth;
            calibration.setUnit(string);
        }
        if (bl && !Calibrator.global) {
            this.imp.setGlobalCalibration(null);
        } else {
            this.imp.setCalibration(calibration);
            this.imp.setGlobalCalibration(Calibrator.global ? calibration : null);
        }
        if (Calibrator.global || Calibrator.global != bl) {
            int[] nArray = WindowManager.getIDList();
            if (nArray == null) {
                return;
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                ImagePlus imagePlus = WindowManager.getImage(nArray[n2]);
                if (imagePlus != null) {
                    imagePlus.getWindow().repaint();
                }
                ++n2;
            }
        } else {
            this.imp.getWindow().repaint();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

