/*
 * Decompiled with CFR 0.152.
 */
package de.globalcube.gui;

import de.globalcube.bean.PublishBean;
import de.globalcube.gui.DefaultDialog;
import de.globalcube.gui.PublishesPanel;
import de.globalcube.gui.WebMISCreator;
import de.globalcube.util.Utility;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class PublishDialog
extends DefaultDialog {
    private JLabel lblName;
    private JLabel lblId;
    private JTextField txtName;
    private JTextField txtId;
    private JPanel pnlDetail;
    private JPanel pnlButton;
    private JScrollPane scrollPane;
    private String mode;
    private int index;
    private PublishesPanel parentPanel;

    public PublishDialog(PublishesPanel publishesPanel, String string, int n) {
        super(WebMISCreator.instance.getOwner());
        this.setTitle("Publishes Data");
        this.mode = string;
        this.index = n;
        this.parentPanel = publishesPanel;
        this.initComponents();
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.pnlButton, "South");
        this.pack();
        this.centerScreen();
    }

    private void initComponents() {
        this.lblName = new JLabel("Name");
        this.txtName = new JTextField(15);
        this.lblId = new JLabel("ID");
        this.txtId = new JTextField(15);
        this.pnlDetail = new JPanel(new GridLayout(2, 2));
        this.pnlDetail.add(this.lblId);
        this.pnlDetail.add(this.txtId);
        this.pnlDetail.add(this.lblName);
        this.pnlDetail.add(this.txtName);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().setView(this.pnlDetail);
        this.pnlButton = new JPanel(new GridLayout(1, 2));
        this.pnlButton.add(this.btnOK);
        this.pnlButton.add(this.btnCancel);
        if (this.mode.equals("MODIFY")) {
            this.initValues();
        }
    }

    protected void saveData() {
        if (this.validateData()) {
            if (this.mode.equals("NEW")) {
                PublishBean publishBean = new PublishBean();
                publishBean.setName(this.txtName.getText());
                publishBean.setId(this.txtName.getText());
                publishBean.setImages(new Vector());
                Utility.getConfigBean().getPublishes().addElement(publishBean);
                WebMISCreator.instance.refreshPublishesNodes();
                this.parentPanel.initValues();
            } else if (this.mode.equals("MODIFY")) {
                ((PublishBean)Utility.getConfigBean().getPublishes().get(this.index)).setName(this.txtName.getText().trim());
                ((PublishBean)Utility.getConfigBean().getPublishes().get(this.index)).setId(this.txtId.getText().trim());
                WebMISCreator.instance.refreshPublishesNodes();
                this.parentPanel.initValues();
            }
            this.dispose();
        }
    }

    private void initValues() {
        PublishBean publishBean = (PublishBean)Utility.getConfigBean().getPublishes().get(this.index);
        this.txtName.setText(publishBean.getName());
        this.txtId.setText(publishBean.getId());
    }

    private boolean validateData() {
        if (this.txtName.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "Name muss angegeben werden !", "Message", 0);
            this.txtName.requestFocus();
            return false;
        }
        if (this.txtId.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "ID muss angegeben werden !", "Message", 0);
            this.txtId.requestFocus();
            return false;
        }
        if (!Utility.isNumeric(this.txtId.getText().trim())) {
            JOptionPane.showMessageDialog(this, "ID muss ein numerischer !", "Message", 0);
            this.txtId.requestFocus();
            return false;
        }
        return true;
    }
}

