/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.modelupdate;

import java.io.File;
import java.io.StringReader;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ModelTransformer {
    TransformerFactory factory = null;
    Transformer transformer = null;

    public ModelTransformer(String xsltStr, boolean shiftToUpperCase, List<String> dataSourceNames) throws Exception {
        try {
            StreamSource xsltSource = new StreamSource(new StringReader(xsltStr));
            this.factory = TransformerFactory.newInstance();
            this.transformer = this.factory.newTransformer(xsltSource);
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            if (!dataSourceNames.isEmpty()) {
                StringBuffer buf = new StringBuffer();
                for (String ds : dataSourceNames) {
                    buf.append(String.valueOf('[') + ds + ']');
                }
                String list_ds = String.valueOf('\'') + buf.toString() + '\'';
                this.transformer.setParameter("LIST_DS", list_ds);
                this.transformer.setParameter("IGNORE_DS", false);
            } else {
                this.transformer.setParameter("IGNORE_DS", true);
            }
        }
        catch (TransformerConfigurationException e) {
            throw new Exception("Error configuring xslt transformer", e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new Exception("Error configuring xslt factory", e);
        }
    }

    public void transform(File sourceFile, File outputFile) throws Exception {
        StreamSource inputSource = new StreamSource(sourceFile.getAbsoluteFile());
        StreamResult result = new StreamResult(outputFile.getAbsoluteFile());
        try {
            this.transformer.transform(inputSource, result);
        }
        catch (TransformerConfigurationException e) {
            throw new Exception("Error configuring xslt transformer", e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new Exception("Error configuring xslt factory", e);
        }
    }
}

