/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.modelupdate;

import com.ibm.cognos.modelupdate.ModelTransformer;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

class UpdateModelXSLT
extends SimpleFileVisitor<Path> {
    private static Logger LOGGER = Logger.getLogger("com.cognos.modelupdate.UpdateModelXSLT");
    private static String MODEL_NAMESPACE = "xmlns=\"http://www.developer.cognos.com/schemas";
    private static String XSLT_NAMESPACE = "xmlns:fm=\"http://www.developer.cognos.com/schemas/bmt/60/7\"";
    private static String FROM_CASE = "<xsl:variable name=\"FROM_CASE\" select=\"$UPPER_CASE\"/>";
    private static String TO_CASE = "<xsl:variable name=\"TO_CASE\"   select=\"$LOWER_CASE\"/>";
    boolean shiftToUpperCase;
    List<String> dataSourceNames;
    String inputLocation;
    String fileName;
    Path outputLocation;
    String outputFileExtension;
    Path xsltFile;
    Map<String, String> excludeQueryObjects;
    Boolean createDir = false;

    UpdateModelXSLT(Path xsltFile, boolean shiftToUpperCase, List<String> dataSourceNames, String inputLocation, String fileName, Path outputLocation, String outputFileExtension, Map<String, String> excludeQueryObjects) {
        this.xsltFile = xsltFile;
        this.shiftToUpperCase = shiftToUpperCase;
        this.dataSourceNames = dataSourceNames;
        this.inputLocation = inputLocation;
        this.fileName = fileName;
        this.outputLocation = outputLocation;
        this.outputFileExtension = outputFileExtension;
        this.excludeQueryObjects = excludeQueryObjects;
        if (this.outputFileExtension == null || this.outputFileExtension.isEmpty()) {
            this.outputFileExtension = ".out.xml";
        }
        try {
            FileHandler fileHandler = new FileHandler("FMMD_ModelUpdate.log");
            ConsoleHandler consolehandler = new ConsoleHandler();
            LOGGER.addHandler(fileHandler);
            LOGGER.setLevel(Level.ALL);
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "Error occur in FileHandler.", exception);
        }
    }

    String getxsltString(Path modelFile, Path xslt) {
        String line;
        StringBuffer strBuffer = new StringBuffer();
        String modelNamespace = null;
        try {
            BufferedReader readermodel = Files.newBufferedReader(modelFile, StandardCharsets.UTF_8);
            block4: while ((line = readermodel.readLine()) != null && modelNamespace == null) {
                if (!line.contains(MODEL_NAMESPACE)) continue;
                String[] split = line.split(" ");
                int i = 0;
                while (i < split.length) {
                    if (split[i].contains(MODEL_NAMESPACE)) {
                        modelNamespace = split[i];
                        modelNamespace = modelNamespace.replaceFirst("xmlns=", "xmlns:fm=");
                        continue block4;
                    }
                    ++i;
                }
            }
            readermodel.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Cannot open the model file", e);
        }
        if (modelNamespace == null) {
            LOGGER.log(Level.WARNING, "Name space is not found in the model file: " + modelFile);
            return strBuffer.toString();
        }
        try {
            BufferedReader readerxslt = Files.newBufferedReader(xslt, StandardCharsets.UTF_8);
            while ((line = readerxslt.readLine()) != null) {
                if ((line = line.trim()).contains(XSLT_NAMESPACE)) {
                    line = line.replaceFirst(XSLT_NAMESPACE, modelNamespace);
                    strBuffer.append(line);
                    continue;
                }
                if (this.excludeQueryObjects.containsValue(line)) {
                    line = line.replaceAll("fm:sql", "fm:sql_exclude");
                    line = line.replaceAll("fm:dataSourceRef", "fm:dataSourceRef_exclude");
                    strBuffer.append(line);
                    continue;
                }
                if (this.shiftToUpperCase) {
                    if (line.contains(FROM_CASE)) {
                        line = line.replaceAll("UPPER_CASE", "LOWER_CASE");
                    }
                    if (line.contains(TO_CASE)) {
                        line = line.replaceAll("LOWER_CASE", "UPPER_CASE");
                    }
                    strBuffer.append(line);
                    continue;
                }
                strBuffer.append(line);
            }
            readerxslt.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Cannot open xslt file", e);
        }
        return strBuffer.toString();
    }

    void applyTransform(Path modelFile) {
        Path name = modelFile.getFileName();
        String basename = UpdateModelXSLT.getBaseName(name.toString());
        String outputname = String.valueOf(basename) + this.outputFileExtension;
        Path outputFile = this.outputLocation.resolve(outputname);
        String xsltStr = this.getxsltString(modelFile, this.xsltFile);
        if (xsltStr.isEmpty()) {
            return;
        }
        try {
            ModelTransformer xform = new ModelTransformer(xsltStr, this.shiftToUpperCase, this.dataSourceNames);
            xform.transform(modelFile.toFile(), outputFile.toFile());
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Fail to apply sxlt file on the model file", e);
        }
    }

    @Override
    public FileVisitResult visitFile(Path modelFile, BasicFileAttributes attrs) {
        if (this.fileName != null && !this.fileName.isEmpty() && !this.fileName.equals(modelFile.getFileName().toString())) {
            return FileVisitResult.CONTINUE;
        }
        this.applyTransform(modelFile);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        Path name = dir.getFileName();
        if (this.createDir.booleanValue()) {
            this.outputLocation = Paths.get(this.outputLocation.toString(), name.toString());
            if (!Files.exists(this.outputLocation, new LinkOption[0])) {
                try {
                    Files.createDirectory(this.outputLocation, new FileAttribute[0]);
                }
                catch (IOException exc) {
                    LOGGER.log(Level.WARNING, "Failed to create the output directory: " + this.outputLocation.toString(), exc);
                }
            }
        }
        this.createDir = true;
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
        this.outputLocation = this.outputLocation.getParent();
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        LOGGER.log(Level.WARNING, "Failed to access the file: " + file.toString(), exc);
        return FileVisitResult.CONTINUE;
    }

    public static String getBaseName(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }
}

