/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Common.Regression;

import com.ibm.cgsBus.Common.CMPointFloat2;
import com.ibm.cgsBus.Common.Regression.CMExponentialFilter;
import com.ibm.cgsBus.Common.Regression.CMILineEquation;
import com.ibm.cgsBus.Common.Regression.CMRegressionEquation;
import java.util.ArrayList;

public class CMExponentialEquation
extends CMRegressionEquation
implements CMILineEquation {
    protected double[] calculateYList(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = this.calculateY(dArray[i]);
        }
        return dArray2;
    }

    @Override
    public double calculateY(double d) {
        return this.m_a * Math.exp(this.m_b * d);
    }

    @Override
    protected double calculateX(double d) {
        return Math.log(d / this.m_a) / Math.log(this.m_b);
    }

    @Override
    public String getEquationToString() {
        if (Double.isNaN(this.m_a) || Double.isNaN(this.m_b)) {
            return "";
        }
        return "y = " + this.formatValue(this.m_a) + "e^" + this.formatValue(this.m_b) + "x";
    }

    private double exponentialRSquared(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = arrayList2.size();
        for (n = 0; n < n2; ++n) {
            d3 += Math.log(arrayList2.get(n));
        }
        d3 /= (double)n2;
        for (n = 0; n < n2; ++n) {
            d += (Math.log(arrayList2.get(n)) - d3) * (Math.log(arrayList2.get(n)) - d3);
        }
        for (n = 0; n < n2; ++n) {
            double d4 = Math.log(arrayList2.get(n)) - Math.log(this.calculateY(arrayList.get(n)));
            d2 += d4 * d4;
        }
        double d5 = 1.0 - d2 / d;
        return d5;
    }

    void calculateWeightedLeastSquares(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        int n = arrayList.size();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        for (int i = 0; i < n; ++i) {
            d9 = arrayList.get(i);
            d10 = arrayList2.get(i);
            if (d10 == 0.0) continue;
            d11 = Math.log(d10);
            d += d9;
            d2 += d10;
            d3 += Math.pow(d9, 2.0);
            d4 += Math.pow(d9, 2.0);
            d6 += Math.pow(d9, 2.0) * d10;
            d5 += d9 * d10;
            d7 += d10 * d11;
            d8 += d9 * d10 * d11;
        }
        double d12 = (d6 * d7 - d5 * d8) / (d2 * d6 - Math.pow(d5, 2.0));
        double d13 = (d2 * d8 - d5 * d7) / (d2 * d6 - Math.pow(d5, 2.0));
        this.m_a = Math.exp(d12);
        this.m_b = d13;
        this.m_rSquared = this.exponentialRSquared(arrayList, arrayList2);
    }

    void calculateLeastSquares(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        int n = arrayList.size();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        for (int i = 0; i < n; ++i) {
            d11 = arrayList.get(i);
            d12 = arrayList2.get(i);
            if (d12 == 0.0) continue;
            d13 = Math.log(d12);
            d += d11;
            d2 += d12;
            d3 += Math.pow(d11, 2.0);
            d4 += Math.pow(d11, 2.0);
            d6 += Math.pow(d11, 2.0) * d12;
            d5 += d11 * d12;
            d7 += d12 * d13;
            d8 += d11 * d12 * d13;
            d9 += d13;
            d10 += d11 * d13;
        }
        double d14 = (d9 * d3 - d * d10) / ((double)n * d3 - Math.pow(d, 2.0));
        double d15 = ((double)n * d10 - d * d9) / ((double)n * d3 - Math.pow(d, 2.0));
        this.m_a = Math.exp(d14);
        this.m_b = d15;
        double[] dArray = this.calculateLeastSquaresCoefficients(arrayList, arrayList2, new CMExponentialFilter());
        this.m_rSquared = dArray[2];
    }

    @Override
    public void calculateEquation(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (arrayList2.get(i) != 0.0) continue;
            arrayList.remove(i);
            arrayList2.remove(i);
        }
        this.calculateWeightedLeastSquares(arrayList, arrayList2);
    }

    @Override
    public CMPointFloat2[] calculateLine(float[] fArray, float[] fArray2) {
        return this.calculateNonLinearLine(fArray, fArray2);
    }
}

