/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Common.Regression;

import com.ibm.cgsBus.Common.CMPointFloat2;
import com.ibm.cgsBus.Common.Regression.CMILineEquation;
import com.ibm.cgsBus.Common.Regression.CMNaturalLogFilter;
import com.ibm.cgsBus.Common.Regression.CMRegressionEquation;
import java.util.ArrayList;

public class CMNaturalLogEquation
extends CMRegressionEquation
implements CMILineEquation {
    @Override
    public double calculateY(double d) {
        return this.m_a + this.m_b * Math.log(d);
    }

    @Override
    protected double calculateX(double d) {
        return 0.0;
    }

    @Override
    public String getEquationToString() {
        if (Double.isNaN(this.m_b)) {
            return "";
        }
        String string = "y = " + this.formatValue(this.m_b) + "Ln(x)";
        if (!Double.isNaN(this.m_a)) {
            string = string + (this.m_a < 0.0 ? " - " + this.formatValue(-this.m_a) : " + " + this.formatValue(this.m_a));
        }
        return string;
    }

    @Override
    public void calculateEquation(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) != 0.0) continue;
            arrayList.remove(i);
            arrayList2.remove(i);
        }
        double[] dArray = this.calculateLeastSquaresCoefficients(arrayList, arrayList2, new CMNaturalLogFilter());
        this.m_a = dArray[1];
        this.m_b = dArray[0];
        this.m_rSquared = dArray[2];
    }

    @Override
    public CMPointFloat2[] calculateLine(float[] fArray, float[] fArray2) {
        return this.calculateNonLinearLine(fArray, fArray2);
    }
}

