/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Common.Regression;

import com.ibm.cgsBus.Common.CMPointFloat2;
import com.ibm.cgsBus.Common.Regression.CMILineFilter;
import com.ibm.cgsBus.FrameWork.CGSFormatter;
import java.util.ArrayList;

public abstract class CMRegressionEquation {
    protected double m_a = 0.0;
    protected double m_b = 0.0;
    protected double m_rSquared = 0.0;
    protected CGSFormatter m_formatter = null;
    private static final String FORMAT_PATTERN = "%.5g";

    public String formatValue(double d) {
        if (this.m_formatter != null) {
            return this.m_formatter.applyFormat(d);
        }
        Object[] objectArray = new Object[]{new Double(d)};
        return String.format(FORMAT_PATTERN, objectArray);
    }

    public void setRSquared(double d) {
        this.m_rSquared = d;
    }

    public double getRSquared() {
        return this.m_rSquared;
    }

    public String getRSquaredtoString() {
        if (Double.isNaN(this.m_rSquared)) {
            return "r^2 = NaN";
        }
        return "r^2 = " + this.formatValue(this.m_rSquared);
    }

    public boolean hasRSquaredValue() {
        return true;
    }

    public boolean hasEquationValue() {
        return true;
    }

    public abstract String getEquationToString();

    protected double calculateY(double d) {
        return Double.NaN;
    }

    protected double calculateX(double d) {
        return Double.NaN;
    }

    public abstract void calculateEquation(ArrayList<Double> var1, ArrayList<Double> var2);

    public abstract CMPointFloat2[] calculateLine(float[] var1, float[] var2);

    protected double[] calculateLeastSquaresCoefficients(ArrayList<Double> arrayList, ArrayList<Double> arrayList2, CMILineFilter cMILineFilter) {
        int n = arrayList.size();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < n; ++i) {
            d6 = cMILineFilter.xFilter(arrayList.get(i));
            d7 = cMILineFilter.yFilter(arrayList2.get(i));
            d += d6;
            d2 += d7;
            d3 += d6 * d7;
            d4 += Math.pow(d6, 2.0);
            d5 += Math.pow(d7, 2.0);
        }
        double d8 = ((double)n * d3 - d * d2) / ((double)n * d4 - Math.pow(d, 2.0));
        double d9 = (d2 - d8 * d) / (double)n;
        double d10 = this.calculateLinearRSquared(n, d, d2, d3, d4, d5);
        double[] dArray = new double[]{d8, d9, d10};
        return dArray;
    }

    protected double calculateLinearRSquared(int n, double d, double d2, double d3, double d4, double d5) {
        double d6 = ((double)n * d3 - d * d2) / Math.sqrt(((double)n * d4 - Math.pow(d, 2.0)) * ((double)n * d5 - Math.pow(d2, 2.0)));
        if (Double.isNaN(d6)) {
            d6 = 1.0;
        }
        return Math.pow(d6, 2.0);
    }

    public CMPointFloat2[] calculateLinearLine(float[] fArray, float[] fArray2) {
        CMPointFloat2 cMPointFloat2;
        CMPointFloat2 cMPointFloat22;
        CMPointFloat2[] cMPointFloat2Array = new CMPointFloat2[2];
        double d = fArray2[0];
        double d2 = fArray2[1];
        double d3 = fArray[0];
        double d4 = this.calculateY(d3);
        if (d4 < d) {
            d4 = fArray2[0];
            d3 = this.calculateX(d4);
        } else if (d4 > d2) {
            d4 = fArray2[1];
            d3 = this.calculateX(d4);
        }
        cMPointFloat2Array[0] = cMPointFloat22 = new CMPointFloat2((float)d3, (float)d4);
        double d5 = fArray[1];
        double d6 = this.calculateY(d5);
        if (d6 < d) {
            d6 = fArray2[0];
            d5 = this.calculateX(d6);
        } else if (d6 > d2) {
            d6 = fArray2[1];
            d5 = this.calculateX(d6);
        }
        cMPointFloat2Array[1] = cMPointFloat2 = new CMPointFloat2((float)d5, (float)d6);
        return cMPointFloat2Array;
    }

    public CMPointFloat2[] calculateNonLinearLine(float[] fArray, float[] fArray2) {
        Object object;
        int n;
        double d = fArray[1];
        double d2 = fArray2[0];
        double d3 = fArray2[1];
        double d4 = fArray[0];
        double d5 = this.calculateY(d4);
        int n2 = n = 200;
        double d6 = (d - d4) / (double)(n2 - 1);
        int n3 = 0;
        ArrayList<CMPointFloat2[]> arrayList = new ArrayList<CMPointFloat2[]>();
        for (n3 = 0; n3 < n2; ++n3) {
            if (!Double.isNaN(d5) && d5 >= d2 && d5 <= d3 && d4 <= d) {
                object = new CMPointFloat2((float)d4, (float)d5);
                arrayList.add((CMPointFloat2[])object);
            }
            d5 = this.calculateY(d4 += d6);
        }
        object = new CMPointFloat2[arrayList.size()];
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            object[n3] = (CMPointFloat2)arrayList.get(n3);
        }
        return object;
    }

    public void setFormatter(CGSFormatter cGSFormatter) {
        this.m_formatter = cGSFormatter;
    }
}

