/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.DrawContext;

import com.avs.openviz3.fw.PointFloat2;
import com.avs.openviz3.fw.PointFloat3;
import com.avs.openviz3.fw.base.ComponentExceptionEvent;
import com.avs.openviz3.fw.base.ComponentSceneNode;
import com.avs.openviz3.fw.base.GroupSceneNode;
import com.avs.openviz3.fw.base.ISceneNode;
import com.avs.openviz3.fw.base.ManageableComponentSceneNode;
import com.avs.openviz3.fw.base.ViewportHorizontalDirectionEnum;
import com.avs.openviz3.layout.BorderContainer;
import com.avs.openviz3.layout.CardContainer;
import com.avs.openviz3.layout.Viewport25D;
import com.avs.openviz3.layout.Workbox;
import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.DrawContext.DCDrawContextOVRef;
import com.ibm.cgsBus.DrawContext.OVBubbleChart;
import com.ibm.cgsBus.DrawContext.OVChart;
import com.ibm.cgsBus.DrawContext.OVComboChart;
import com.ibm.cgsBus.DrawContext.OVDevice;
import com.ibm.cgsBus.DrawContext.OVDeviceRaster;
import com.ibm.cgsBus.DrawContext.OVDeviceSVG;
import com.ibm.cgsBus.DrawContext.OVDeviceVector;
import com.ibm.cgsBus.DrawContext.OVGaugeChart;
import com.ibm.cgsBus.DrawContext.OVHelper;
import com.ibm.cgsBus.DrawContext.OVParetoChart;
import com.ibm.cgsBus.DrawContext.OVPieChart;
import com.ibm.cgsBus.DrawContext.OVProgressiveChart;
import com.ibm.cgsBus.DrawContext.OVScatterChart;
import com.ibm.cgsBus.FrameWork.CGSData;
import com.ibm.cgsBus.FrameWork.CGSDataRow;
import com.ibm.cgsBus.FrameWork.CGSMain;
import com.ibm.cgsBus.FrameWork.CGSWidgetRef;
import com.ibm.cgsBus.Graphics.GRDevice;
import com.ibm.cgsBus.Graphics.GRDeviceVector;
import com.ibm.cgsBus.Graphics.GRHelper;
import com.ibm.cgsBus.Graphics.GRLegend;
import com.ibm.cgsBus.Graphics.GRLegendItemIcon;
import com.ibm.cgsBus.Logging.CGSLogging;
import com.ibm.cgsBus.Properties.CGSPropCanvas;
import com.ibm.cgsBus.Properties.CGSPropChart;
import com.ibm.cgsBus.Properties.CGSPropNote;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeFillEffect;
import com.ibm.cgsBus.Types.CGSTypeSize;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class DCDrawContextOV
implements DCDrawContextOVRef {
    protected int m_width = 0;
    protected int m_height = 0;
    protected CGSWidgetRef m_pWidget = null;
    protected boolean m_chartBuilt = false;
    protected GRLegend m_pLegend = null;
    protected BufferedImage m_pImage = null;
    protected byte[] m_pVectorBlob = null;
    protected String m_pImageMap = null;
    protected BorderContainer m_pWidgetContainer = null;
    protected OVDeviceRaster m_pDeviceRaster = null;
    protected OVDeviceVector m_pDeviceVector = null;
    protected OVDeviceSVG m_pDeviceSVG = null;
    protected OVDevice m_pDevice = null;
    protected DrawTarget m_drawTarget = DrawTarget.eAll;
    protected Vector<CGSPropNote> m_notes = null;
    protected boolean m_forceAutoFontSize = false;
    protected boolean m_forceAxisMaxFontSize = false;
    protected boolean m_fontException = false;
    protected OVChart m_pChart = null;
    protected boolean m_isClipping = false;
    protected String m_pSVGImage = null;

    public DCDrawContextOV(CGSWidgetRef cGSWidgetRef, boolean bl, boolean bl2) {
        this.init(cGSWidgetRef, bl, bl2);
    }

    public void destroy() {
        this.m_pWidget = null;
        this.m_pLegend = null;
        this.m_pImage = null;
        this.m_pImageMap = null;
        this.m_pWidgetContainer = null;
        if (this.m_pChart != null) {
            this.m_pChart.destroy();
        }
        this.m_pChart = null;
        if (this.m_pDeviceRaster != null) {
            this.m_pDeviceRaster.destroy();
            this.m_pDeviceRaster = null;
        }
        if (this.m_pDeviceVector != null) {
            this.m_pDeviceVector.destroy();
            this.m_pDeviceVector = null;
        }
        this.m_pDevice = null;
    }

    public void init(CGSWidgetRef cGSWidgetRef, boolean bl, boolean bl2) {
        this.m_forceAutoFontSize = false;
        this.m_forceAxisMaxFontSize = false;
        this.m_fontException = false;
        this.reset();
        this.m_pWidget = cGSWidgetRef;
        this.setDeviceType(bl, bl2);
    }

    private void reset() {
        this.m_width = 0;
        this.m_height = 0;
        this.m_chartBuilt = false;
        this.m_pLegend = null;
        this.m_pImage = null;
        this.m_pVectorBlob = null;
        this.m_pImageMap = null;
        if (this.m_pWidgetContainer != null) {
            this.m_pWidgetContainer.removeAllChildren();
        }
        if (this.m_pDeviceRaster != null) {
            this.m_pDeviceRaster.reset();
        }
        if (this.m_pDeviceVector != null) {
            this.m_pDeviceVector.reset();
        }
        if (this.m_pDeviceSVG != null) {
            this.m_pDeviceSVG.reset();
        }
        this.m_drawTarget = DrawTarget.eAll;
        if (this.m_notes != null) {
            this.m_notes.clear();
        }
    }

    private void resetDeviceType(boolean bl, boolean bl2) {
        this.reset();
        this.setDeviceType(bl, bl2);
    }

    private void setDeviceType(boolean bl, boolean bl2) {
        if (bl || bl2) {
            CGSPropCanvas cGSPropCanvas = (CGSPropCanvas)this.m_pWidget.getCanvas().getBaseProp();
            boolean bl3 = cGSPropCanvas.getAntiAliasing();
            if (bl) {
                if (this.m_pDeviceRaster == null || this.m_pDeviceRaster.isAntialiased() != bl3) {
                    if (this.m_pDeviceRaster != null) {
                        this.m_pDeviceRaster.destroy();
                    }
                    this.m_pDeviceRaster = new OVDeviceRaster(this, bl3);
                }
                this.m_pDevice = this.m_pDeviceRaster;
            } else if (bl2) {
                if (this.m_pDeviceSVG == null || this.m_pDeviceSVG.isAntialiased() != bl3) {
                    if (this.m_pDeviceSVG != null) {
                        this.m_pDeviceSVG.destroy();
                    }
                    this.m_pDeviceSVG = new OVDeviceSVG(this, bl3);
                }
                this.m_pDevice = this.m_pDeviceSVG;
            }
        } else {
            if (this.m_pDeviceVector != null) {
                this.m_pDeviceVector.destroy();
            }
            this.m_pDeviceVector = new OVDeviceVector(this);
            this.m_pDevice = this.m_pDeviceVector;
        }
    }

    public void prepareLegend(GRLegend gRLegend) {
        CGSLogging.logEnter("DCDrawContextOV::prepareLegend");
        try {
            this.m_pLegend = gRLegend;
            this.m_chartBuilt = true;
            this.applyProperties();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        CGSLogging.logExit("DCDrawContextOV::prepareLegend");
    }

    public GRLegend getLegend() {
        return this.m_pLegend;
    }

    public boolean forceAutoFontSize() {
        return this.m_forceAutoFontSize;
    }

    public boolean forceAxisMaxFontSize() {
        return this.m_forceAxisMaxFontSize;
    }

    public boolean isDrawingLegend() {
        return this.m_pLegend != null;
    }

    public void exceptionOccurred(ComponentExceptionEvent componentExceptionEvent) {
        OVHelper.outputAVSException(componentExceptionEvent);
        switch (componentExceptionEvent.getCode()) {
            case 13: 
            case 31: {
                this.m_fontException = true;
                break;
            }
            case 213: {
                this.m_fontException = true;
                this.m_forceAxisMaxFontSize = true;
                break;
            }
        }
    }

    protected void resetFontExceptions() {
        this.m_fontException = false;
        this.m_forceAutoFontSize = false;
        this.m_forceAxisMaxFontSize = false;
    }

    public void drawRasterWidget(CGSTypeSize cGSTypeSize) {
        try {
            if (this.m_pImage == null) {
                CMHelper.CGS_ASSERT(this.m_pDevice.isRaster(), "Need to have a raster version of DCDrawContextOV.");
                CMHelper.CGS_ASSERT(!this.m_chartBuilt, "Can't call prepareLegend, drawRasterWidget or drawVectorWidget using the same context.");
                this.m_chartBuilt = true;
                this.m_width = cGSTypeSize.m_width;
                this.m_height = cGSTypeSize.m_height;
                this.m_pDevice.setSize(this.m_width, this.m_height);
                this.resetFontExceptions();
                this.applyProperties();
                this.m_pImage = ((OVDeviceRaster)this.m_pDevice).getImage();
                if (this.m_fontException) {
                    this.m_forceAutoFontSize = true;
                    this.reset();
                    this.applyProperties();
                    this.m_pImage = ((OVDeviceRaster)this.m_pDevice).getImage();
                }
                if (CGSMain.getGetImageMap()) {
                    this.m_pImageMap = this.m_pDevice.getImageMap();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void drawSVGWidget(CGSTypeSize cGSTypeSize) {
        try {
            CMHelper.CGS_ASSERT(this.m_pDevice.isSVG(), "Need to have an SVG version of DCDrawContextOV.");
            CMHelper.CGS_ASSERT(!this.m_chartBuilt, "Can't call prepareLegend, drawRasterWidget or drawVectorWidget using the same context.");
            this.m_chartBuilt = true;
            this.m_width = cGSTypeSize.m_width;
            this.m_height = cGSTypeSize.m_height;
            this.m_pDevice.setSize(this.m_width, this.m_height);
            this.resetFontExceptions();
            this.applyProperties();
            this.m_pSVGImage = ((OVDeviceSVG)this.m_pDevice).getSVGImage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String outputSVGWidget() {
        return this.m_pSVGImage;
    }

    @Override
    public String getSVGLegendGlyph(GRLegendItemIcon gRLegendItemIcon, int n, boolean bl) {
        this.resetDeviceType(false, true);
        OVDeviceSVG oVDeviceSVG = (OVDeviceSVG)this.getOutputDevice();
        oVDeviceSVG.setSize(n, n);
        Workbox workbox = new Workbox("OVDeviceRaster::getLegendGlyph::wb");
        if (oVDeviceSVG.isGrayLegendIcon(gRLegendItemIcon)) {
            oVDeviceSVG.addChartGlyph(gRLegendItemIcon, (ComponentSceneNode)workbox, new PointFloat3(), 0.9f);
        } else if (gRLegendItemIcon.iconType == 1) {
            oVDeviceSVG.addLineGlyph(gRLegendItemIcon, (ComponentSceneNode)workbox, n - 4, new PointFloat3(), 1.0f);
        } else if (gRLegendItemIcon.iconType == 2) {
            float f = gRLegendItemIcon.materialEffect == CGSPropChart.MaterialEffect.eMaterialNone ? 0.9f : 2.2f;
            oVDeviceSVG.addAreaGlyph(gRLegendItemIcon, (ComponentSceneNode)workbox, new PointFloat3(), f);
        } else {
            if (gRLegendItemIcon.doRotation) {
                n = (int)((double)n * 0.85);
            }
            oVDeviceSVG.addGlyph(gRLegendItemIcon, n, gRLegendItemIcon.dataPointShapeOutlineColor, (ComponentSceneNode)workbox, new PointFloat3());
        }
        String string = null;
        if (gRLegendItemIcon.doRotation || gRLegendItemIcon.materialEffect != CGSPropChart.MaterialEffect.eMaterialNone) {
            Viewport25D viewport25D = new Viewport25D();
            viewport25D.setObliqueProjectionVector(new PointFloat2(0.0f, 0.0f));
            OVChart.setMaterialEffectLighting(gRLegendItemIcon.materialEffect, viewport25D);
            viewport25D.addChild((ISceneNode)workbox);
            oVDeviceSVG.addChild((GroupSceneNode)viewport25D);
            string = oVDeviceSVG.getSVGImage();
            oVDeviceSVG.reset();
        } else {
            oVDeviceSVG.addChild((GroupSceneNode)workbox);
            string = oVDeviceSVG.getSVGImage();
            oVDeviceSVG.reset();
        }
        return string;
    }

    public void drawVectorWidget(CGSTypeSize cGSTypeSize) {
        try {
            CMHelper.CGS_ASSERT(!this.m_pDevice.isRaster(), "Need to have a vector version of DCDrawContextOV.");
            CMHelper.CGS_ASSERT(!this.m_chartBuilt, "Can't call prepareLegend, drawRasterWidget or drawVectorWidget using the same context.");
            this.m_chartBuilt = true;
            this.m_width = cGSTypeSize.m_width;
            this.m_height = cGSTypeSize.m_height;
            CGSPropCanvas cGSPropCanvas = (CGSPropCanvas)this.m_pWidget.getCanvas().getBaseProp();
            int n = cGSPropCanvas.getDPI();
            double d = 72.0 / (double)n;
            int n2 = (int)((double)this.m_width * d + 0.5);
            int n3 = (int)((double)this.m_height * d + 0.5);
            this.m_pDevice.setSize(n2, n3);
            this.resetFontExceptions();
            this.applyProperties();
            this.m_pVectorBlob = ((OVDeviceVector)this.m_pDevice).getVectorBlob();
            if (this.m_fontException) {
                this.m_forceAutoFontSize = true;
                this.reset();
                this.applyProperties();
                this.m_pVectorBlob = ((OVDeviceVector)this.m_pDevice).getVectorBlob();
            }
            if (CGSMain.getGetImageMap()) {
                this.m_pImageMap = this.m_pDevice.getImageMap();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BufferedImage outputRasterWidget() {
        return this.m_pImage;
    }

    public byte[] outputVectorBlob() {
        return this.m_pVectorBlob;
    }

    public String outputImageMap() {
        return this.m_pImageMap;
    }

    private void applyProperties() {
        if (this.m_pWidgetContainer == null) {
            this.m_pWidgetContainer = new BorderContainer();
        }
        this.m_pDevice.addChild((GroupSceneNode)this.m_pWidgetContainer);
        if (this.m_pChart == null) {
            switch (this.m_pWidget.getType()) {
                case eChartBubble: {
                    this.m_pChart = new OVBubbleChart(this);
                    break;
                }
                case eChartCombo: {
                    this.m_pChart = new OVComboChart(this);
                    break;
                }
                case eChartGauge: {
                    this.m_pChart = new OVGaugeChart(this);
                    break;
                }
                case eChartPareto: {
                    this.m_pChart = new OVParetoChart(this);
                    break;
                }
                case eChartPie: {
                    this.m_pChart = new OVPieChart(this);
                    break;
                }
                case eChartProgressive: {
                    this.m_pChart = new OVProgressiveChart(this);
                    break;
                }
                case eChartScatter: {
                    this.m_pChart = new OVScatterChart(this);
                    break;
                }
            }
        } else {
            this.m_pChart.init(this);
        }
        if (this.m_pChart != null) {
            this.m_pChart.generate();
        }
    }

    protected final CGSWidgetRef getWidget() {
        return this.m_pWidget;
    }

    protected final BorderContainer getContainer() {
        return this.m_pWidgetContainer;
    }

    protected final OVDevice getOutputDevice() {
        return this.m_pDevice;
    }

    public final boolean isRaster() {
        return this.m_pDevice.isRaster();
    }

    public final boolean isSVG() {
        return this.m_pDevice.isSVG();
    }

    protected void addNote(CGSPropNote cGSPropNote) {
        if (this.m_notes == null) {
            this.m_notes = new Vector();
        }
        this.m_notes.add(cGSPropNote);
    }

    public Vector<CGSPropNote> getNotes() {
        return this.m_notes;
    }

    public void setDrawTraget(DrawTarget drawTarget) {
        this.m_drawTarget = drawTarget;
    }

    protected DrawTarget getDrawTarget() {
        return this.m_drawTarget;
    }

    @Override
    public BufferedImage getLegendGlyph(GRLegendItemIcon gRLegendItemIcon, int n, boolean bl) {
        this.resetDeviceType(true, false);
        OVDeviceRaster oVDeviceRaster = (OVDeviceRaster)this.getOutputDevice();
        oVDeviceRaster.setSize(n, n);
        Workbox workbox = new Workbox("OVDeviceRaster::getLegendGlyph::wb");
        if (oVDeviceRaster.isGrayLegendIcon(gRLegendItemIcon)) {
            oVDeviceRaster.addChartGlyph(gRLegendItemIcon, (ComponentSceneNode)workbox, new PointFloat3(), 0.9f);
        } else if (gRLegendItemIcon.iconType == 1) {
            oVDeviceRaster.addLineGlyph(gRLegendItemIcon, (ComponentSceneNode)workbox, n - 4, new PointFloat3(), 1.0f);
        } else if (gRLegendItemIcon.iconType == 2) {
            float f = gRLegendItemIcon.materialEffect == CGSPropChart.MaterialEffect.eMaterialNone ? 0.9f : 2.2f;
            oVDeviceRaster.addAreaGlyph(gRLegendItemIcon, (ComponentSceneNode)workbox, new PointFloat3(), f);
        } else {
            if (gRLegendItemIcon.doRotation) {
                n = (int)((double)n * 0.85);
            }
            oVDeviceRaster.addGlyph(gRLegendItemIcon, n, gRLegendItemIcon.dataPointShapeOutlineColor, (ComponentSceneNode)workbox, new PointFloat3());
        }
        BufferedImage bufferedImage = null;
        if (gRLegendItemIcon.doRotation || gRLegendItemIcon.materialEffect != CGSPropChart.MaterialEffect.eMaterialNone) {
            Viewport25D viewport25D = new Viewport25D();
            viewport25D.setObliqueProjectionVector(new PointFloat2(0.0f, 0.0f));
            OVChart.setMaterialEffectLighting(gRLegendItemIcon.materialEffect, viewport25D);
            viewport25D.addChild((ISceneNode)workbox);
            oVDeviceRaster.addChild((GroupSceneNode)viewport25D);
            bufferedImage = oVDeviceRaster.getImage();
            oVDeviceRaster.reset();
        } else {
            oVDeviceRaster.addChild((GroupSceneNode)workbox);
            bufferedImage = oVDeviceRaster.getImage();
            oVDeviceRaster.reset();
        }
        if (bl) {
            GRHelper.mirrorBufferedImage(bufferedImage);
        }
        return bufferedImage;
    }

    @Override
    public ManageableComponentSceneNode getLegendGlyphViewport(GRLegendItemIcon gRLegendItemIcon, int n, boolean bl) {
        this.resetDeviceType(true, false);
        OVDeviceRaster oVDeviceRaster = (OVDeviceRaster)this.getOutputDevice();
        oVDeviceRaster.setSize(n, n);
        Workbox workbox = new Workbox("OVDeviceRaster::getLegendGlyph::wb");
        if (oVDeviceRaster.isGrayLegendIcon(gRLegendItemIcon)) {
            oVDeviceRaster.addChartGlyph(gRLegendItemIcon, (ComponentSceneNode)workbox, new PointFloat3(), 2.2f);
        } else if (gRLegendItemIcon.iconType == 1) {
            oVDeviceRaster.addLineGlyph(gRLegendItemIcon, (ComponentSceneNode)workbox, n - 4, new PointFloat3(), 2.0f);
        } else if (gRLegendItemIcon.iconType == 2) {
            oVDeviceRaster.addAreaGlyph(gRLegendItemIcon, (ComponentSceneNode)workbox, new PointFloat3(), 2.2f);
        } else {
            if (gRLegendItemIcon.doRotation) {
                n = (int)((double)n * 0.85);
            }
            oVDeviceRaster.addGlyph(gRLegendItemIcon, n, gRLegendItemIcon.dataPointShapeOutlineColor, (ComponentSceneNode)workbox, new PointFloat3());
        }
        Viewport25D viewport25D = new Viewport25D();
        OVChart.setMaterialEffectLighting(gRLegendItemIcon.materialEffect, viewport25D);
        viewport25D.addChild((ISceneNode)workbox);
        if (bl) {
            viewport25D.setViewportHorizontalDirection(ViewportHorizontalDirectionEnum.RIGHT_TO_LEFT);
        }
        return viewport25D;
    }

    @Override
    public void addViewportToLegend(GRDevice gRDevice, GRLegendItemIcon gRLegendItemIcon, int n, int n2, int n3, boolean bl) {
        CGSTypeFillEffect cGSTypeFillEffect = gRLegendItemIcon.dataPointShapeFill;
        if (!gRDevice.isRaster() && !gRDevice.isSVG() && cGSTypeFillEffect != null && !cGSTypeFillEffect.isSimple(true) && cGSTypeFillEffect.isSimple(false)) {
            gRLegendItemIcon.dataPointShapeFill = new CGSTypeFillEffect();
            gRLegendItemIcon.dataPointShapeFill.setType(CGSEnums.FillType.eFillGradient);
            gRLegendItemIcon.dataPointShapeFill.setGradientType(CGSEnums.GradientType.eGradientLinear);
            gRLegendItemIcon.dataPointShapeFill.addGradient(cGSTypeFillEffect.getGradientFromColor(), 0.0);
            gRLegendItemIcon.dataPointShapeFill.addGradient(cGSTypeFillEffect.getGradientToColor(), 100.0);
            gRLegendItemIcon.dataPointShapeFill.setGradientDirection(cGSTypeFillEffect.getGradientDirection());
        }
        int n4 = 4;
        CardContainer cardContainer = new CardContainer();
        cardContainer.addChild((ISceneNode)this.getLegendGlyphViewport(gRLegendItemIcon, n3 - n4, bl));
        this.resetDeviceType(false, false);
        OVDeviceVector oVDeviceVector = (OVDeviceVector)this.m_pDevice;
        int n5 = GRHelper.GR_ROUND(gRDevice.fromPixels(n3));
        oVDeviceVector.setSize(n5, n5);
        oVDeviceVector.addChild((GroupSceneNode)cardContainer);
        byte[] byArray = oVDeviceVector.getVectorBlob();
        oVDeviceVector.reset();
        ((GRDeviceVector)gRDevice).pasteVectorBlob(byArray, n, n2);
        gRLegendItemIcon.dataPointShapeFill = cGSTypeFillEffect;
    }

    public boolean isClipping() {
        return this.m_isClipping;
    }

    public void setClipping(boolean bl) {
        this.m_isClipping = bl;
    }

    public void addConditionalItemsToLegend() {
        CGSData cGSData = this.m_pWidget.getData(0);
        if (!this.m_pChart.isConditionalHilightingRequired()) {
            return;
        }
        Vector<CGSDataRow> vector = cGSData.getOriginalRows();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            int n2 = cGSData.getPaletteIndex(i);
            if (n2 == -1) continue;
            this.m_pChart.addConditionalPaletteItemToLegend(cGSData.getRow(i).getElementIndex(), n2);
        }
    }

    public static enum DrawTarget {
        eAll,
        eTopChart,
        eBottomChart;

    }
}

