/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.DrawContext;

import com.avs.openviz3.chart.AnchorPointDepthPositionEnum;
import com.avs.openviz3.chart.ScatterChart;
import com.avs.openviz3.fw.PointFloat3;
import com.avs.openviz3.fw.base.IAttributeSceneNode;
import com.avs.openviz3.fw.base.IAxisMapSource;
import com.avs.openviz3.fw.base.UnitsEnum;
import com.avs.openviz3.glyphs.IGlyph;
import com.ibm.cgsBus.DrawContext.DCDrawContextOV;
import com.ibm.cgsBus.DrawContext.OVHelper;
import com.ibm.cgsBus.DrawContext.OVScatterBase;
import com.ibm.cgsBus.FrameWork.CGSDataMultimeasure;
import com.ibm.cgsBus.Properties.CGSPropChart;
import com.ibm.cgsBus.Properties.CGSPropChartBubble;
import com.ibm.cgsBus.Properties.CGSPropDataLabelsB;
import com.ibm.cgsBus.Properties.CGSPropRegressionLinesB;
import com.ibm.cgsBus.Types.CGSEnums;
import java.awt.Color;

public class OVBubbleChart
extends OVScatterBase {
    protected CGSPropChartBubble m_propChartBubble = null;
    private static final double MIN_ALLOWED_BUBBLE_SIZE = 0.0;
    private static final double SMALLEST_BUBBLE_SIZE = 1.0;
    private double m_minBubblePointSize;
    private double m_maxBubblePointSize;
    private double m_minDataSize;
    private double m_maxDataSize;
    private double m_sizeScale = 1.0;
    private double[] m_rawBubbleSizes;

    public OVBubbleChart(DCDrawContextOV dCDrawContextOV) {
        super(dCDrawContextOV);
    }

    @Override
    protected void init(DCDrawContextOV dCDrawContextOV) {
        super.init(dCDrawContextOV);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_minBubblePointSize = 0.0;
        this.m_maxBubblePointSize = 0.0;
        this.m_minDataSize = 0.0;
        this.m_maxDataSize = 0.0;
        this.m_sizeScale = 1.0;
        this.m_rawBubbleSizes = null;
    }

    @Override
    public void applyProperties() {
        super.applyProperties();
        OVHelper.applyMaterialEffect((IAttributeSceneNode)this.m_ovScatterChart, this.m_propChartBubble.getMaterialEffect());
        this.populateLegend(this.m_propChartBubble.getDataPointMode(), this.m_propChartBubble.getDataPointShapeB());
        this.createMarkers(this.m_propChartBubble.getMarkerList());
        this.createRegressionLines();
    }

    @Override
    protected void getProperties() {
        this.m_propChartBubble = (CGSPropChartBubble)this.getChart();
        this.m_propDataLabels = (CGSPropDataLabelsB)this.m_propChartBubble.getProp(CGSEnums.PropType.ePropDataLabelsB);
    }

    @Override
    protected void addChartData() {
        CGSDataMultimeasure cGSDataMultimeasure = (CGSDataMultimeasure)this.m_pData;
        int n = cGSDataMultimeasure.getPointCount();
        int n2 = this.m_pData.getGridColumnCount();
        int n3 = 0;
        this.m_glyphs = new IGlyph[n];
        Object[] objectArray = this.m_pData.getGridNulls();
        for (int i = 0; i < n2 - 2; ++i) {
            int n4 = this.m_pData.getGridColumnType(i);
            int n5 = this.m_pData.getGridColumnType(i + 1);
            int n6 = this.m_pData.getGridColumnType(i + 2);
            if (n4 != 4 || n5 != 4 || n6 != 4) continue;
            if (objectArray[i] != null && objectArray[i + 1] != null && objectArray[i + 2] != null) {
                int n7;
                ScatterChart.ScatterSeries scatterSeries = this.m_ovScatterChart.newSeries(i, i + 1, i);
                scatterSeries.setGlyphIndex(Integer.valueOf(this.m_dataRowIndex));
                scatterSeries.setScaleIndex(Integer.valueOf(this.m_gridGlyphSizeCol));
                int n8 = this.getColorByValueIndex(i);
                if (n8 != -1) {
                    scatterSeries.setColorIndex(Integer.valueOf(n8));
                }
                for (n7 = 0; n7 < n; ++n7) {
                    double d = this.m_rawBubbleSizes[n7];
                    float f = this.getBubbleSize(d);
                    boolean bl = d < 0.0 && this.m_propChartBubble.getUseZeroBasedSizing();
                    this.addGlyph(n7, n3, this.m_propChartBubble.getDataPointShapeB(), this.m_propChartBubble.getDataPointMode(), bl, this.m_propChartBubble.getShowOutline(), this.m_propChartBubble.getOutlineColor(), f);
                }
                n7 = this.m_pData.getShowDataValueColumn(i);
                this.setLabelTemplate(n3, n7, n7 + 1, n7 + 2);
                this.addSeriesImageTemplate();
                scatterSeries.getLabelProperties().setAnchorPointDepthPosition(AnchorPointDepthPositionEnum.FRONT);
                scatterSeries.getLabelProperties().setAnchorPointHeightPosition(OVHelper.getLabelAnchorPosition(this.m_propChartBubble.getDataTextLocation()));
                OVBubbleChart.setLabelCollisionMode(scatterSeries, this.m_propDataLabels, this.m_ovScatterChart.getLabelProperties());
                ++n3;
            }
            i += 2;
        }
    }

    private void setLabelTemplate(int n, int n2, int n3, int n4) {
        String string = "";
        CGSDataMultimeasure cGSDataMultimeasure = (CGSDataMultimeasure)this.m_pData;
        string = this.getCategoryLabelTemplate(cGSDataMultimeasure, this.m_propChartBubble.getShowCategoryData());
        string = string + this.getSeriesLabelTemplate(cGSDataMultimeasure, this.m_propChartBubble.getShowSeriesData());
        CGSEnums.DataDisplayType dataDisplayType = CGSEnums.DataDisplayType.eDataDisplayNone;
        CGSEnums.DataDisplayType dataDisplayType2 = CGSEnums.DataDisplayType.eDataDisplayNone;
        if (this.m_propChartBubble.getShowBubbleData() == CGSEnums.BubbleDataDisplayType.eBubbleDataDisplayAllLabelValue) {
            dataDisplayType = CGSEnums.DataDisplayType.eDataDisplayLabelValue;
            dataDisplayType2 = CGSEnums.DataDisplayType.eDataDisplayLabelValue;
        } else if (this.m_propChartBubble.getShowBubbleData() == CGSEnums.BubbleDataDisplayType.eBubbleDataDisplayAllValue) {
            dataDisplayType = CGSEnums.DataDisplayType.eDataDisplayValue;
            dataDisplayType2 = CGSEnums.DataDisplayType.eDataDisplayValue;
        } else if (this.m_propChartBubble.getShowBubbleData() == CGSEnums.BubbleDataDisplayType.eBubbleDataDisplaySizeLabelValue) {
            dataDisplayType2 = CGSEnums.DataDisplayType.eDataDisplayLabelValue;
        } else if (this.m_propChartBubble.getShowBubbleData() == CGSEnums.BubbleDataDisplayType.eBubbleDataDisplaySizeValue) {
            dataDisplayType2 = CGSEnums.DataDisplayType.eDataDisplayValue;
        }
        String string2 = cGSDataMultimeasure.getAxisTitle(0);
        string = string + this.getMeasurelLabelTemplate(string2, n2, dataDisplayType);
        String string3 = cGSDataMultimeasure.getAxisTitle(1);
        string = string + this.getMeasurelLabelTemplate(string3, n3, dataDisplayType);
        String string4 = cGSDataMultimeasure.getAxisTitle(5);
        string = string + this.getMeasurelLabelTemplate(string4, n4, dataDisplayType2);
        this.m_ovScatterChart.getSeries(n).setLabelTemplate(string);
    }

    @Override
    protected void applyChartProperties() {
        OVBubbleChart.setChartLevelLabelProperties(this.m_propDataLabels, this.m_ovScatterChart.getLabelProperties());
        this.applyFontProperties(this.m_propChartBubble, this.m_ovScatterChart.getTextAttributes());
        this.setSeriesGlyphMap();
        this.setDataPointSize();
        this.m_ovScatterChart.getMaterialAttributes().setColorMap(this.getContinuousColorMap(0));
    }

    protected void setDataPointSize() {
        float f = 1.0f;
        this.m_ovScatterChart.getGlyphAttributes().setGlyphSizeUnits(UnitsEnum.POINT);
        this.m_ovScatterChart.getGlyphAttributes().setGlyphSize(new PointFloat3(f, f, f));
    }

    @Override
    protected void calculateBubbleSizeScale() {
        int n;
        this.getProperties();
        CGSDataMultimeasure cGSDataMultimeasure = (CGSDataMultimeasure)this.m_pData;
        int n2 = cGSDataMultimeasure.getPointCount();
        Object[] objectArray = this.m_pData.getGridColumns();
        double d = this.m_propChartBubble.getUseZeroBasedSizing() ? 0.0 : Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        int n3 = 0;
        if (objectArray == null) {
            return;
        }
        this.m_maxBubblePointSize = this.m_propChartBubble.getMaxDataPointSize();
        this.m_maxBubblePointSize = Math.max(this.m_maxBubblePointSize, 0.0);
        this.m_minBubblePointSize = this.m_propChartBubble.getUseZeroBasedSizing() ? 0.0 : this.m_propChartBubble.getMinDataPointSize();
        this.m_minBubblePointSize = Math.max(this.m_minBubblePointSize, 0.0);
        this.m_rawBubbleSizes = new double[n2];
        int n4 = this.m_gridFirstSeriesCol + 2;
        int n5 = this.m_gridGlyphSizeCol;
        double[] dArray = (double[])objectArray[n4];
        double[] dArray2 = (double[])objectArray[n5];
        for (n = 0; n < n2; ++n) {
            double d3 = dArray[n];
            this.m_rawBubbleSizes[n3++] = d3;
            if (Double.isNaN(d3) || d3 < 0.0 && !this.showNegatives()) continue;
            if (this.m_propChartBubble.getUseZeroBasedSizing()) {
                d3 = Math.abs(d3);
            }
            if (!Double.isNaN(d3)) {
                d = Math.min(d3, d);
            }
            if (Double.isNaN(d3)) continue;
            d2 = Math.max(d3, d2);
        }
        this.m_minDataSize = d < d2 ? d : 1.0;
        this.m_maxDataSize = d2 > this.m_minDataSize ? d2 : this.m_minDataSize;
        this.m_sizeScale = (this.m_maxDataSize - this.m_minDataSize) / (this.m_maxBubblePointSize - this.m_minBubblePointSize);
        if (this.m_sizeScale == 0.0) {
            this.m_sizeScale = 1.0;
        }
        for (n = 0; n < n2; ++n) {
            float f = this.getBubbleSize(dArray[n]);
            float f2 = Math.abs(f);
            dArray2[n] = f2;
        }
    }

    private boolean showNegatives() {
        return this.m_propChartBubble.getShowNegativeValues() || !this.m_propChartBubble.getUseZeroBasedSizing();
    }

    protected float getBubbleSize(double d) {
        double d2;
        if (this.m_propChartBubble.getUseZeroBasedSizing()) {
            d = Math.abs(d);
        }
        if (Double.isNaN(d2 = (d - this.m_minDataSize) / this.m_sizeScale + this.m_minBubblePointSize) || d2 < 1.0) {
            d2 = this.m_propChartBubble.getUseZeroBasedSizing() ? 1.0 : this.m_minBubblePointSize;
        }
        return (float)d2;
    }

    @Override
    protected final void createAxis() {
        this.m_pAxisMapX = this.m_ovScatterChart.getOutputXAxisMap();
        this.addOutputValueAxisMap((IAxisMapSource)this.m_ovScatterChart.getOutputYAxisMap(), 1);
        this.setOutputSeriesAxisMap((IAxisMapSource)this.m_ovScatterChart.getOutputSeriesAxisMap());
        this.createAxesXY(CGSEnums.PropType.ePropNumericAxisX, CGSEnums.PropType.ePropNumericAxisY);
        if (this.m_pDrawContext.isDrawingLegend()) {
            return;
        }
        this.m_ovScatterChart.connectInputXAxisMap(this.m_pAxisMapX);
        this.m_ovScatterChart.connectInputYAxisMap(this.m_pAxisMapTopLeft);
    }

    @Override
    protected CGSPropRegressionLinesB getRegressionLines() {
        return (CGSPropRegressionLinesB)this.m_propChartBubble.getProp(CGSEnums.PropType.ePropRegressionLinesB);
    }

    @Override
    protected CGSPropChart.MaterialEffect getMaterialEffect() {
        return this.m_propChartBubble.getMaterialEffect();
    }

    @Override
    protected Color getOutlineColor(int n) {
        return this.m_propChartBubble.getShowOutline() ? this.m_propChartBubble.getOutlineColor() : null;
    }
}

