/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.DrawContext;

import com.avs.openviz3.axis.AxisLabelFormatEnum;
import com.avs.openviz3.axis.AxisLabelZeroFractionsEnum;
import com.avs.openviz3.axis.INumberFormatter;
import com.avs.openviz3.axis.INumericAxis;
import com.avs.openviz3.axis.INumericStyle;
import com.avs.openviz3.cognos.Viewport25D;
import com.avs.openviz3.dial.axis.IDialNumericAxis;
import com.avs.openviz3.filter.ColorInterpolationEnum;
import com.avs.openviz3.filter.LinearDataMap;
import com.avs.openviz3.filter.OutOfRangeBehaviorEnum;
import com.avs.openviz3.filter.ValueMappingEnum;
import com.avs.openviz3.fw.PointFloat3;
import com.avs.openviz3.fw.base.ComponentExceptionEvent;
import com.avs.openviz3.fw.base.ComponentExceptionListener;
import com.avs.openviz3.fw.base.IAttributeSceneNode;
import com.avs.openviz3.fw.base.IDataMapSource;
import com.avs.openviz3.fw.base.IFieldSource;
import com.avs.openviz3.fw.base.ILineAttributes;
import com.avs.openviz3.fw.base.ISurfaceFaceAttributeSceneNode;
import com.avs.openviz3.fw.base.ITextAttributes;
import com.avs.openviz3.fw.base.ManageableComponentSceneNodePropertyEnum;
import com.avs.openviz3.fw.text.FontStyleEnum;
import com.avs.openviz3.fw.text.FontWeightEnum;
import com.avs.openviz3.io.FieldInfo;
import com.avs.openviz3.io.TableMapper;
import com.avs.openviz3.io.UnstructuredFieldBuilder;
import com.avs.openviz3.layout.Workbox;
import com.avs.openviz3.viewer.ILight;
import com.avs.openviz3.viewer.LightTypeEnum;
import com.cognos.i18n.ToolkitResources;
import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.DrawContext.DCDrawContextOV;
import com.ibm.cgsBus.DrawContext.OVHelper;
import com.ibm.cgsBus.FrameWork.CGSData;
import com.ibm.cgsBus.FrameWork.CGSFormatter;
import com.ibm.cgsBus.FrameWork.CGSProp;
import com.ibm.cgsBus.FrameWork.CGSWidget;
import com.ibm.cgsBus.FrameWork.CGSWidgetRef;
import com.ibm.cgsBus.Graphics.GRHelper;
import com.ibm.cgsBus.Graphics.GRLegend;
import com.ibm.cgsBus.Graphics.GRLegendItemIcon;
import com.ibm.cgsBus.Properties.CGSPropChart;
import com.ibm.cgsBus.Properties.CGSPropChartCombo;
import com.ibm.cgsBus.Properties.CGSPropComboElem;
import com.ibm.cgsBus.Properties.CGSPropComboElemLine;
import com.ibm.cgsBus.Properties.CGSPropFont;
import com.ibm.cgsBus.Properties.CGSPropFormatNumeric;
import com.ibm.cgsBus.Properties.CGSPropFormatNumericBase;
import com.ibm.cgsBus.Properties.CGSPropLine;
import com.ibm.cgsBus.Properties.CGSPropMixedLabel;
import com.ibm.cgsBus.Properties.CGSPropMixedLabelItem;
import com.ibm.cgsBus.Properties.CGSPropPaletteConditionalB;
import com.ibm.cgsBus.Properties.CGSPropPaletteConditionalItemB;
import com.ibm.cgsBus.Properties.CGSPropPaletteContinuousB;
import com.ibm.cgsBus.Properties.CGSPropPaletteContinuousItemB;
import com.ibm.cgsBus.Properties.CGSPropPaletteDiscreteB;
import com.ibm.cgsBus.Properties.CGSPropPaletteDiscreteItemB;
import com.ibm.cgsBus.Properties.CGSPropTickLabelNumeric;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeDouble;
import com.ibm.cgsBus.Types.CGSTypeFillEffect;
import java.awt.Color;

abstract class OVChart
implements ComponentExceptionListener {
    private static Color[] s_coloradoPalette = new Color[]{new Color(-8021549, true), new Color(-10979666, true), new Color(-1855892, true), new Color(-3308210, true), new Color(-8152990, true), new Color(-9666730, true), new Color(-4732813, true), new Color(-5261179, true), new Color(-8092504, true), new Color(-11379074, true), new Color(-4141843, true), new Color(-5192987, true), new Color(-7580288, true), new Color(-8830873, true), new Color(-3700292, true), new Color(-4492612, true), new Color(-2770193, true), new Color(-4022319, true), new Color(-8165313, true), new Color(-10467034, true), new Color(-2314150, true), new Color(-4154286, true), new Color(-729186, true), new Color(-1781881, true), new Color(-10515828, true), new Color(-11307655, true), new Color(-6896462, true), new Color(-7753568, true), new Color(-3413785, true), new Color(-4335915, true), new Color(-5347996, true), new Color(-7908526, true), new Color(-2585489, true), new Color(-3900063, true), new Color(-1848912, true), new Color(-2968923, true), new Color(-8092540, true), new Color(-11184811, true), new Color(-5987164, true), new Color(-7303024, true), new Color(-3684409, true), new Color(-4079167, true)};
    protected Viewport25D m_ovViewport = null;
    protected CGSWidgetRef m_pWidget = null;
    protected CGSData m_pData = null;
    protected CGSProp m_pBaseProp = null;
    protected TableMapper m_pTableMapper = null;
    protected Workbox m_pWorkbox = null;
    protected DCDrawContextOV m_pDrawContext = null;
    protected boolean[] m_seenInLegend = null;
    protected ConditionalIconType m_conditionalIconType = ConditionalIconType.eBar;
    private boolean m_viewportIs3D = false;
    protected int m_cbvElementIndex = -1;
    protected double m_cbvDataMin = Double.NaN;
    protected double m_cbvDataMax = Double.NaN;

    protected OVChart(DCDrawContextOV dCDrawContextOV) {
        this.m_pWorkbox = new Workbox("OVChart::OVChart::m_pWorkbox");
        this.m_pWorkbox.addComponentExceptionListener((ComponentExceptionListener)this);
        this.init(dCDrawContextOV);
    }

    protected void destroy() {
        this.m_pWidget = null;
        this.m_pBaseProp = null;
        this.m_pTableMapper = null;
    }

    protected void init(DCDrawContextOV dCDrawContextOV) {
        this.reset();
        this.m_pDrawContext = dCDrawContextOV;
        this.m_pWidget = this.m_pDrawContext.getWidget();
        this.m_pData = this.m_pWidget.getData(0);
        if (dCDrawContextOV.getLegend() == null) {
            this.m_pData.fixGridColumnAmpersandEncoding();
        }
        this.m_pBaseProp = this.m_pWidget.getBaseProp();
        this.m_pTableMapper = new TableMapper("OVChart::OVChart::m_pTableMapper");
        this.m_pTableMapper.addComponentExceptionListener((ComponentExceptionListener)this);
    }

    protected void reset() {
        if (this.m_ovViewport != null) {
            this.m_ovViewport.removeAllChildren();
        }
        this.m_ovViewport = null;
        this.m_pWidget = null;
        this.m_pData = null;
        this.m_pBaseProp = null;
        this.m_pTableMapper = null;
        this.m_pWorkbox.removeAllChildren();
        this.m_pDrawContext = null;
        this.m_seenInLegend = null;
        this.m_conditionalIconType = ConditionalIconType.eBar;
        this.m_viewportIs3D = false;
        this.m_cbvElementIndex = -1;
        this.m_cbvDataMin = Double.NaN;
        this.m_cbvDataMax = Double.NaN;
    }

    protected void generate() {
        boolean bl;
        boolean bl2 = bl = !this.m_pDrawContext.isDrawingLegend();
        if (!bl) {
            bl = this.useContinuousPalette();
        }
        if (!bl) {
            bl = this.m_pWidget.getType() == CGSWidget.WidgetType.eChartProgressive;
        }
        this.prepareData();
        this.applyProperties();
        if (bl) {
            this.populateWorkbox();
            this.populateViewport();
        }
        if (bl) {
            this.postSceneTreeBuild();
        }
    }

    protected void prepareData() {
        this.m_pTableMapper.setColumns(this.m_pData.getGridColumns(), (Class[])this.m_pData.getGridTypes(), this.m_pData.getGridNulls());
    }

    protected IFieldSource getInputField() {
        return this.m_pTableMapper.getOutputField();
    }

    protected Object[] getFieldColumns(IFieldSource iFieldSource) {
        FieldInfo fieldInfo = new FieldInfo();
        fieldInfo.addComponentExceptionListener((ComponentExceptionListener)this);
        fieldInfo.connectInputField(iFieldSource);
        int n = fieldInfo.getNumCoordinates();
        int n2 = this.m_pData.getGridColumnCount();
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            Class<?> clazz = this.m_pData.getGridTypes()[i];
            if (clazz == String.class) {
                objectArray[i] = fieldInfo.getNodeDataSubarrayAsString(i, 0, n);
                continue;
            }
            if (clazz == Double.TYPE) {
                objectArray[i] = fieldInfo.getNodeDataSubarrayAsNumber(i, 0, n);
                continue;
            }
            if (clazz == Integer.TYPE) {
                double[] dArray = fieldInfo.getNodeDataSubarrayAsNumber(i, 0, n);
                objectArray[i] = new int[dArray.length];
                for (int j = 0; j < dArray.length; ++j) {
                    ((int[])objectArray[i])[j] = (int)dArray[j];
                }
                continue;
            }
            throw new Error("Invalid array type");
        }
        return objectArray;
    }

    protected void applyProperties() {
        this.m_viewportIs3D = this.is3DViewportRequired();
    }

    protected double getLineWidth(double d) {
        return this.m_pDrawContext.getOutputDevice().getLineWidth(d);
    }

    protected void applyLineAttributes(ILineAttributes iLineAttributes, Color color, double d, CGSEnums.LineStyleB lineStyleB) {
        this.m_pDrawContext.getOutputDevice().applyLineAttributes(iLineAttributes, color, d, lineStyleB);
    }

    protected void applyPropLineAttributes(ILineAttributes iLineAttributes, CGSPropLine cGSPropLine) {
        this.applyLineAttributes(iLineAttributes, cGSPropLine.getColor(), cGSPropLine.getWeight(), cGSPropLine.getStyleB());
    }

    protected void applyOutline(ILineAttributes iLineAttributes, Color color) {
        this.applyLineAttributes(iLineAttributes, color, 0.0, CGSEnums.LineStyleB.eLineSolidB);
    }

    protected void applyFontProperties(CGSProp cGSProp, ITextAttributes iTextAttributes) {
        CGSPropFont cGSPropFont = (CGSPropFont)cGSProp.getProp(CGSEnums.PropType.ePropFont);
        String string = cGSPropFont.getFaceName();
        string = this.determineFontFaceFromDataTable(string, cGSPropFont);
        iTextAttributes.setFontFamily(string);
        switch (cGSPropFont.getStyle()) {
            case eStyleNormal: {
                iTextAttributes.setFontStyle(FontStyleEnum.NORMAL);
                iTextAttributes.setFontWeight(FontWeightEnum.NORMAL);
                break;
            }
            case eStyleBold: {
                iTextAttributes.setFontStyle(FontStyleEnum.NORMAL);
                iTextAttributes.setFontWeight(FontWeightEnum.BOLD);
                break;
            }
            case eStyleItalic: {
                iTextAttributes.setFontStyle(FontStyleEnum.ITALIC);
                iTextAttributes.setFontWeight(FontWeightEnum.NORMAL);
                break;
            }
            case eStyleBoldItalic: {
                iTextAttributes.setFontStyle(FontStyleEnum.ITALIC);
                iTextAttributes.setFontWeight(FontWeightEnum.BOLD);
                break;
            }
        }
        if (!cGSPropFont.getAutoSize() && !this.m_pDrawContext.forceAutoFontSize()) {
            iTextAttributes.setFontSize(cGSPropFont.getSize());
        }
        iTextAttributes.setTextColor(cGSPropFont.getColor());
        cGSPropFont = null;
    }

    protected String determineFontFaceFromDataTable(String string, CGSPropFont cGSPropFont) {
        int n = this.m_pData.getGridColumnCount();
        Object[] objectArray = this.m_pData.getGridColumns();
        for (int i = 0; i < n; ++i) {
            int n2 = this.m_pData.getGridColumnType(i);
            if (n2 != 0 && n2 != 1 && n2 != 15) continue;
            Object[] objectArray2 = (Object[])objectArray[i];
            for (int j = 0; j < objectArray2.length; ++j) {
                String string2 = (String)objectArray2[j];
                String string3 = GRHelper.getDisplayableFontName(cGSPropFont, string2);
                if (string3.equals(string)) continue;
                return string3;
            }
        }
        return string;
    }

    protected CGSProp getChart() {
        CGSProp cGSProp = null;
        CGSEnums.PropType propType = null;
        switch (this.m_pWidget.getType()) {
            case eChartBubble: {
                propType = CGSEnums.PropType.ePropChartBubble;
                break;
            }
            case eChartCombo: {
                propType = CGSEnums.PropType.ePropChartCombo;
                break;
            }
            case eChartCombo3D: {
                propType = CGSEnums.PropType.ePropChartCombo3D;
                break;
            }
            case eChartGauge: {
                propType = CGSEnums.PropType.ePropChartGauge;
                break;
            }
            case eChartHistory: {
                propType = CGSEnums.PropType.ePropChartHistory;
                break;
            }
            case eChartMap: {
                propType = CGSEnums.PropType.ePropChartMap;
                break;
            }
            case eChartMarimekko: {
                propType = CGSEnums.PropType.ePropChartMarimekko;
                break;
            }
            case eChartPareto: {
                propType = CGSEnums.PropType.ePropChartPareto;
                break;
            }
            case eChartPie: {
                propType = CGSEnums.PropType.ePropChartPie;
                break;
            }
            case eChartPolar: {
                propType = CGSEnums.PropType.ePropChartPolar;
                break;
            }
            case eChartProgressive: {
                propType = CGSEnums.PropType.ePropChartProgressive;
                break;
            }
            case eChartRadar: {
                propType = CGSEnums.PropType.ePropChartRadar;
                break;
            }
            case eChartScatter: {
                propType = CGSEnums.PropType.ePropChartScatter;
                break;
            }
            case eChartScatter3D: {
                propType = CGSEnums.PropType.ePropChartScatter3D;
                break;
            }
        }
        if (propType != null) {
            cGSProp = this.m_pBaseProp.getProp(propType);
        }
        return cGSProp;
    }

    protected static CGSPropPaletteDiscreteItemB getDefaultDiscretePaletteItemB(int n) {
        CGSPropPaletteDiscreteItemB cGSPropPaletteDiscreteItemB = new CGSPropPaletteDiscreteItemB();
        cGSPropPaletteDiscreteItemB.setDataPointFillEffect(OVChart.getDefaultDataPointFillEffect(n));
        cGSPropPaletteDiscreteItemB.setDataPointShape(CGSEnums.MarkerShapeB.eMarkerCircleB);
        cGSPropPaletteDiscreteItemB.setLineFillEffect(OVChart.getDefaultLineFillEffect(n));
        cGSPropPaletteDiscreteItemB.setLineStyle(CGSEnums.LineStyleB.eLineSolidB);
        cGSPropPaletteDiscreteItemB.setLineWeight(1.0);
        return cGSPropPaletteDiscreteItemB;
    }

    private static CGSTypeFillEffect getDefaultDataPointFillEffect(int n) {
        int n2 = n % (s_coloradoPalette.length / 2);
        n2 *= 2;
        CGSTypeFillEffect cGSTypeFillEffect = new CGSTypeFillEffect();
        cGSTypeFillEffect.setType(CGSEnums.FillType.eFillGradient);
        cGSTypeFillEffect.setGradientDirection(CGSEnums.GradientDirection.eGradientUp);
        cGSTypeFillEffect.addGradient(s_coloradoPalette[n2++], 0.0);
        cGSTypeFillEffect.addGradient(s_coloradoPalette[n2], 100.0);
        return cGSTypeFillEffect;
    }

    private static CGSTypeFillEffect getDefaultLineFillEffect(int n) {
        int n2 = n % (s_coloradoPalette.length / 2);
        CGSTypeFillEffect cGSTypeFillEffect = new CGSTypeFillEffect();
        cGSTypeFillEffect.setType(CGSEnums.FillType.eFillPattern);
        cGSTypeFillEffect.setPatternType(CGSEnums.PatternType.ePatternSolid);
        cGSTypeFillEffect.setPatternForeColor(s_coloradoPalette[n2 *= 2]);
        cGSTypeFillEffect.setPatternBackColor(s_coloradoPalette[n2]);
        return cGSTypeFillEffect;
    }

    protected CGSPropPaletteDiscreteB getDiscretePalette() {
        return (CGSPropPaletteDiscreteB)this.getChart().getProp(CGSEnums.PropType.ePropPaletteDiscreteB);
    }

    protected CGSPropPaletteConditionalB getConditionalPalette() {
        return (CGSPropPaletteConditionalB)this.getChart().getProp(CGSEnums.PropType.ePropPaletteConditionalB);
    }

    protected CGSPropPaletteContinuousB getContinuousPalette() {
        return (CGSPropPaletteContinuousB)this.getChart().getProp(CGSEnums.PropType.ePropPaletteContinuousB);
    }

    protected boolean useInternalColorByValue() {
        return false;
    }

    protected boolean useContinuousPalette() {
        CGSPropPaletteContinuousB cGSPropPaletteContinuousB = this.getContinuousPalette();
        return cGSPropPaletteContinuousB == null ? false : cGSPropPaletteContinuousB.getPaletteContinuousItemBCount() != 0;
    }

    protected ContinuousPaletteInfo getContinuousPaletteInfo(int n) {
        int n2;
        CGSPropPaletteContinuousB cGSPropPaletteContinuousB = this.getContinuousPalette();
        int n3 = n2 = cGSPropPaletteContinuousB.getPaletteContinuousItemBCount();
        if (n2 == 1) {
            ++n3;
        }
        Double[] doubleArray = new Double[n3];
        Color[] colorArray = new Color[n3];
        String[] stringArray = new String[n3];
        CGSPropFormatNumeric cGSPropFormatNumeric = (CGSPropFormatNumeric)cGSPropPaletteContinuousB.getProp(CGSEnums.PropType.ePropFormatNumeric);
        CGSFormatter cGSFormatter = this.m_pWidget.getFormatter(cGSPropFormatNumeric);
        boolean bl = cGSPropPaletteContinuousB.getPercentDataMode();
        double d = 0.0;
        double d2 = Double.NaN;
        double d3 = bl ? this.getColorByValueDataMin(n) : Double.NaN;
        double d4 = bl ? this.getColorByValueDataMax(n) : Double.NaN;
        for (int i = 0; i < n2; ++i) {
            CGSPropPaletteContinuousItemB cGSPropPaletteContinuousItemB = cGSPropPaletteContinuousB.getPaletteContinuousItemB(i);
            colorArray[i] = cGSPropPaletteContinuousItemB.getColor();
            d = cGSPropPaletteContinuousItemB.getValue();
            if (!Double.isNaN(d2)) {
                CMHelper.CGS_ASSERT(d >= d2, "Palette entries must be in ascending order");
            }
            doubleArray[i] = new Double(bl ? (d4 - d3) * (d / 100.0) + d3 : cGSPropPaletteContinuousItemB.getValue());
            stringArray[i] = cGSFormatter.applyFormat(doubleArray[i]);
            d2 = d;
        }
        if (n3 != n2) {
            CGSPropPaletteContinuousItemB cGSPropPaletteContinuousItemB = cGSPropPaletteContinuousB.getPaletteContinuousItemB(0);
            colorArray[1] = cGSPropPaletteContinuousItemB.getColor();
            doubleArray[1] = new Double(bl ? (d4 - d3) * (cGSPropPaletteContinuousItemB.getValue() / 100.0) + d3 : cGSPropPaletteContinuousItemB.getValue());
            stringArray[1] = cGSFormatter.applyFormat(doubleArray[1]);
        }
        String string = this.m_pData.getColorByValueMeasure(n);
        return new ContinuousPaletteInfo(string, colorArray, stringArray, doubleArray);
    }

    protected IDataMapSource getContinuousColorMap(int n) {
        if (!this.useContinuousPalette() || this.useInternalColorByValue()) {
            return null;
        }
        LinearDataMap linearDataMap = new LinearDataMap();
        linearDataMap.addComponentExceptionListener((ComponentExceptionListener)this);
        linearDataMap.setColorInterpolation(ColorInterpolationEnum.RGB);
        linearDataMap.setValueMapping(ValueMappingEnum.ABSOLUTE);
        ContinuousPaletteInfo continuousPaletteInfo = this.getContinuousPaletteInfo(n);
        Double[] doubleArray = continuousPaletteInfo.m_values;
        Color[] colorArray = continuousPaletteInfo.m_colors;
        String[] stringArray = continuousPaletteInfo.m_labels;
        linearDataMap.setSourceBounds((Object)doubleArray);
        linearDataMap.setDestinationBounds(Color.class, (Object)colorArray);
        linearDataMap.setDefaultValue((Object)this.getContinuousPalette().getMissingValueColor());
        linearDataMap.setOutOfRangeBehavior(OutOfRangeBehaviorEnum.CLAMP);
        GRLegend gRLegend = this.m_pDrawContext.getLegend();
        if (gRLegend != null && this.m_pWidget.getType() != CGSWidget.WidgetType.eChartGauge) {
            gRLegend.addContinuousPaletteItem(this.m_pData.getColorByValueMeasure(n), colorArray, stringArray, this.getOutlineColor(n), this.m_pWidget.getMaterialEffect());
        }
        return linearDataMap.getOutputDataMap();
    }

    public double getColorByValueDataMin(int n) {
        return this.m_pData.getColorByValueDataMin(n);
    }

    public double getColorByValueDataMax(int n) {
        return this.m_pData.getColorByValueDataMax(n);
    }

    int getColorByValueIndex(int n) {
        return this.useContinuousPalette() ? this.m_pData.getColorByValueColumn(n) : -1;
    }

    protected boolean isConditionalHilightingRequired() {
        CGSPropPaletteConditionalB cGSPropPaletteConditionalB;
        return this.m_pData.hasPaletteColumn() && (cGSPropPaletteConditionalB = this.getConditionalPalette()) != null && cGSPropPaletteConditionalB.getPaletteConditionalItemBCount() != 0;
    }

    protected CGSPropPaletteDiscreteItemB getDiscretePaletteItem(int n) {
        int n2;
        CGSPropPaletteDiscreteItemB cGSPropPaletteDiscreteItemB = null;
        CGSPropPaletteDiscreteB cGSPropPaletteDiscreteB = this.getDiscretePalette();
        int n3 = n2 = cGSPropPaletteDiscreteB == null ? 0 : cGSPropPaletteDiscreteB.getPaletteDiscreteItemBCount();
        if (n2 != 0) {
            cGSPropPaletteDiscreteItemB = cGSPropPaletteDiscreteB.getPaletteDiscreteItemB(n % n2);
        }
        return cGSPropPaletteDiscreteItemB == null ? OVChart.getDefaultDiscretePaletteItemB(n) : cGSPropPaletteDiscreteItemB;
    }

    protected String getMixedLabelToString(CGSPropMixedLabel cGSPropMixedLabel) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = cGSPropMixedLabel.getMixedLabelItemCount();
        for (int i = 0; i < n; ++i) {
            CGSPropMixedLabelItem cGSPropMixedLabelItem = cGSPropMixedLabel.getMixedLabelItem(i);
            stringBuilder.append(cGSPropMixedLabelItem.getLabel());
            CGSPropFormatNumeric cGSPropFormatNumeric = (CGSPropFormatNumeric)cGSPropMixedLabelItem.getProp(CGSEnums.PropType.ePropFormatNumeric);
            CGSFormatter cGSFormatter = this.m_pWidget.getFormatter(cGSPropFormatNumeric);
            stringBuilder.append(cGSFormatter.applyFormat(cGSPropMixedLabelItem.getValue()));
        }
        return stringBuilder.toString();
    }

    protected CGSPropPaletteConditionalItemB getConditionalPaletteItem(int n) {
        int n2;
        CGSPropPaletteConditionalItemB cGSPropPaletteConditionalItemB = null;
        CGSPropPaletteConditionalB cGSPropPaletteConditionalB = this.getConditionalPalette();
        int n3 = n2 = cGSPropPaletteConditionalB == null ? 0 : cGSPropPaletteConditionalB.getPaletteConditionalItemBCount();
        if (n2 != 0) {
            cGSPropPaletteConditionalItemB = cGSPropPaletteConditionalB.getPaletteConditionalItemB(n % n2);
        }
        return cGSPropPaletteConditionalItemB;
    }

    protected void addConditionalPaletteItemToLegend(int n, int n2) {
        CGSPropPaletteConditionalB cGSPropPaletteConditionalB = this.getConditionalPalette();
        int n3 = cGSPropPaletteConditionalB == null ? 0 : cGSPropPaletteConditionalB.getPaletteConditionalItemBCount();
        CGSPropPaletteConditionalItemB cGSPropPaletteConditionalItemB = this.getConditionalPaletteItem(n2);
        GRLegend gRLegend = this.m_pDrawContext.getLegend();
        if (gRLegend != null && cGSPropPaletteConditionalItemB.getShowInLegend()) {
            if (this.m_seenInLegend == null) {
                this.m_seenInLegend = new boolean[n3];
            }
            if (!this.m_seenInLegend[n2 % n3]) {
                this.m_seenInLegend[n2 % n3] = true;
                this.updateConditionalIconForElement(n);
                GRLegendItemIcon gRLegendItemIcon = this.getConditionalLegendIcon(n, (CGSPropPaletteDiscreteItemB)cGSPropPaletteConditionalItemB.getProp(CGSEnums.PropType.ePropPaletteDiscreteItemB));
                StringBuilder stringBuilder = new StringBuilder(cGSPropPaletteConditionalItemB.getLegendLabel());
                CGSPropMixedLabel cGSPropMixedLabel = (CGSPropMixedLabel)cGSPropPaletteConditionalItemB.getProp(CGSEnums.PropType.ePropMixedLabel);
                stringBuilder.append(this.getMixedLabelToString(cGSPropMixedLabel));
                gRLegend.addConditionalItem(stringBuilder.toString(), gRLegendItemIcon);
            }
        }
    }

    private void updateConditionalIconForElement(int n) {
        if (this.m_pWidget.getType() == CGSWidget.WidgetType.eChartCombo) {
            CGSPropChartCombo cGSPropChartCombo = (CGSPropChartCombo)this.m_pBaseProp.getProp(CGSEnums.PropType.ePropChartCombo);
            CGSPropComboElem cGSPropComboElem = cGSPropChartCombo.getChart(n);
            switch (cGSPropComboElem.getPropType()) {
                case ePropComboElemArea: 
                case ePropComboElemArea3D: {
                    this.m_conditionalIconType = ConditionalIconType.eArea;
                    break;
                }
                case ePropComboElemBar: 
                case ePropComboElemBar3D: {
                    this.m_conditionalIconType = ConditionalIconType.eBar;
                    break;
                }
                case ePropComboElemLine: 
                case ePropComboElemLine3D: {
                    CGSPropComboElemLine cGSPropComboElemLine = (CGSPropComboElemLine)cGSPropComboElem;
                    this.updateConditionalIconForLineElement(cGSPropComboElemLine);
                    break;
                }
            }
        }
    }

    private void updateConditionalIconForLineElement(CGSPropComboElemLine cGSPropComboElemLine) {
        switch (cGSPropComboElemLine.getDisplayMode()) {
            case eDataPointsOnly: {
                this.m_conditionalIconType = ConditionalIconType.ePoint;
                break;
            }
            case eLinesAndDataPoints: {
                this.m_conditionalIconType = ConditionalIconType.eLineAndPoint;
                break;
            }
            case eLinesOnly: {
                this.m_conditionalIconType = ConditionalIconType.eLine;
                break;
            }
            case eSparkline: {
                this.m_conditionalIconType = ConditionalIconType.eLine;
                break;
            }
        }
    }

    private GRLegendItemIcon getConditionalLegendIcon(int n, CGSPropPaletteDiscreteItemB cGSPropPaletteDiscreteItemB) {
        CGSEnums.MarkerShapeB markerShapeB = GRLegendItemIcon.SHAPE_NONE;
        Color color = null;
        CGSPropChart.MaterialEffect materialEffect = CGSPropChart.MaterialEffect.eMaterialNone;
        int n2 = 0;
        CGSTypeFillEffect cGSTypeFillEffect = null;
        CGSTypeFillEffect cGSTypeFillEffect2 = null;
        CGSEnums.LineStyleB lineStyleB = CGSEnums.LineStyleB.eLineSolidB;
        CGSTypeDouble cGSTypeDouble = null;
        switch (this.m_conditionalIconType) {
            case eLine: {
                n2 = 1;
                lineStyleB = cGSPropPaletteDiscreteItemB.getLineStyle();
                cGSTypeFillEffect2 = cGSPropPaletteDiscreteItemB.getLineFillEffect();
                cGSTypeDouble = new CGSTypeDouble(1.0);
                cGSTypeDouble.setValue(cGSPropPaletteDiscreteItemB.getLineWeight());
                break;
            }
            case eLineAndPoint: {
                n2 = 1;
                lineStyleB = cGSPropPaletteDiscreteItemB.getLineStyle();
                cGSTypeFillEffect2 = cGSPropPaletteDiscreteItemB.getLineFillEffect();
                markerShapeB = cGSPropPaletteDiscreteItemB.getDataPointShape();
                cGSTypeFillEffect = cGSPropPaletteDiscreteItemB.getDataPointFillEffect();
                color = this.getOutlineColor(n);
                break;
            }
            case ePoint: {
                n2 = 0;
                markerShapeB = cGSPropPaletteDiscreteItemB.getDataPointShape();
                cGSTypeFillEffect = cGSPropPaletteDiscreteItemB.getDataPointFillEffect();
                color = this.getOutlineColor(n);
                break;
            }
            default: {
                markerShapeB = CGSEnums.MarkerShapeB.eMarkerSquareB;
                cGSTypeFillEffect = cGSPropPaletteDiscreteItemB.getDataPointFillEffect();
                color = this.getOutlineColor(n);
            }
        }
        return this.createIcon(n2, markerShapeB, color, materialEffect, cGSTypeFillEffect, cGSTypeFillEffect2, lineStyleB, cGSTypeDouble);
    }

    protected CGSTypeFillEffect getFillEffect(int n, CGSEnums.PropType propType, boolean bl) {
        CGSTypeFillEffect cGSTypeFillEffect = null;
        CGSPropPaletteDiscreteItemB cGSPropPaletteDiscreteItemB = null;
        switch (propType) {
            case ePropPaletteDiscreteB: {
                cGSPropPaletteDiscreteItemB = this.getDiscretePaletteItem(n);
                break;
            }
            case ePropPaletteConditionalB: {
                CGSPropPaletteConditionalItemB cGSPropPaletteConditionalItemB = this.getConditionalPaletteItem(n);
                if (cGSPropPaletteConditionalItemB == null) {
                    cGSPropPaletteDiscreteItemB = OVChart.getDefaultDiscretePaletteItemB(n);
                    break;
                }
                cGSPropPaletteDiscreteItemB = (CGSPropPaletteDiscreteItemB)cGSPropPaletteConditionalItemB.getProp(CGSEnums.PropType.ePropPaletteDiscreteItemB);
                break;
            }
            default: {
                CMHelper.CGS_ASSERT(false, "Unknown palette type");
            }
        }
        cGSTypeFillEffect = bl ? cGSPropPaletteDiscreteItemB.getDataPointFillEffect() : cGSPropPaletteDiscreteItemB.getLineFillEffect();
        return cGSTypeFillEffect;
    }

    protected int getPaletteIndex(int n, int n2, int n3) {
        return n;
    }

    protected int getConditionalPaletteIndex(int n, int n2, int n3) {
        int n4 = -1;
        if (this.isConditionalHilightingRequired()) {
            int n5;
            if (this.m_pWidget.isCategoriesReversed()) {
                n2 = this.m_pData.getCategoryCount(n3) - n2 - 1;
            }
            if ((n5 = this.m_pWidget.getRow(n2, n, n3)) != -1) {
                n4 = this.m_pData.getPaletteIndex(n5);
            }
        }
        return n4;
    }

    protected void applyPalette(int n, int n2, int n3, ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode) {
        this.applyPalette(n, n2, n3, iSurfaceFaceAttributeSceneNode, null, null);
    }

    protected void applyPalette(int n, int n2, int n3, ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode, Float f) {
        this.applyPalette(n, n2, n3, iSurfaceFaceAttributeSceneNode, null, f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void applyPalette(int n, int n2, int n3, ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode, IAttributeSceneNode iAttributeSceneNode, Float f) {
        int n4 = this.getConditionalPaletteIndex(n2, n, n3);
        if (n4 == -1) {
            if (this.useContinuousPalette()) {
                if (!this.useInternalColorByValue()) return;
                this.applyContinuousPaletteItem(iSurfaceFaceAttributeSceneNode, n3, n2, n);
                return;
            } else {
                this.applyDiscretePaletteItem(iSurfaceFaceAttributeSceneNode, this.getPaletteIndex(n2, n, n3), iAttributeSceneNode, f);
            }
            return;
        } else {
            this.applyConditionalPaletteItem(iSurfaceFaceAttributeSceneNode, n4, iAttributeSceneNode, f);
        }
    }

    protected void applyDiscretePaletteItem(ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode, int n) {
        this.applyDiscretePaletteItem(iSurfaceFaceAttributeSceneNode, n, null, null);
    }

    protected void applyDiscretePaletteItem(ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode, int n, IAttributeSceneNode iAttributeSceneNode, Float f) {
        this.applyFillEffectWithRotation(this.getFillEffect(n, CGSEnums.PropType.ePropPaletteDiscreteB, true), iSurfaceFaceAttributeSceneNode, iAttributeSceneNode, f);
    }

    protected void applyConditionalPaletteItem(ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode, int n, IAttributeSceneNode iAttributeSceneNode, Float f) {
        this.applyFillEffectWithRotation(this.getFillEffect(n, CGSEnums.PropType.ePropPaletteConditionalB, true), iSurfaceFaceAttributeSceneNode, iAttributeSceneNode, f);
    }

    protected void applyContinuousPaletteItem(ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode, int n, int n2, int n3) {
        if (this.m_cbvElementIndex != n) {
            this.m_cbvElementIndex = n;
            this.m_cbvDataMin = this.getColorByValueDataMin(n);
            this.m_cbvDataMax = this.getColorByValueDataMax(n);
            GRLegend gRLegend = this.m_pDrawContext.getLegend();
            if (gRLegend != null && this.m_pWidget.getType() != CGSWidget.WidgetType.eChartGauge) {
                ContinuousPaletteInfo continuousPaletteInfo = this.getContinuousPaletteInfo(n);
                gRLegend.addContinuousPaletteItem(continuousPaletteInfo.m_measureName, continuousPaletteInfo.m_colors, continuousPaletteInfo.m_labels, this.getOutlineColor(n), this.m_pWidget.getMaterialEffect());
            }
        }
        double d = this.m_pData.getColorByValueValue(n, n2, n3);
        Color color = GRHelper.calcContinuousColor(this.getContinuousPalette(), d, this.m_cbvDataMin, this.m_cbvDataMax);
        CGSTypeFillEffect cGSTypeFillEffect = new CGSTypeFillEffect();
        cGSTypeFillEffect.setSolidColor(color);
        this.applyFillEffect(cGSTypeFillEffect, iSurfaceFaceAttributeSceneNode);
    }

    protected void applyFillEffect(CGSTypeFillEffect cGSTypeFillEffect, ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode) {
        this.applyFillEffect(cGSTypeFillEffect, iSurfaceFaceAttributeSceneNode, null);
    }

    protected void applyFillEffect(CGSTypeFillEffect cGSTypeFillEffect, ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode, IAttributeSceneNode iAttributeSceneNode) {
        this.applyFillEffect(cGSTypeFillEffect, iSurfaceFaceAttributeSceneNode, iAttributeSceneNode, null);
    }

    protected void applyFillEffect(CGSTypeFillEffect cGSTypeFillEffect, ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode, IAttributeSceneNode iAttributeSceneNode, Float f) {
        if (!this.m_pDrawContext.isDrawingLegend()) {
            this.m_pDrawContext.getOutputDevice().applyFillEffect(cGSTypeFillEffect, iSurfaceFaceAttributeSceneNode, iAttributeSceneNode, f);
        }
    }

    protected void applyFillEffectWithRotation(CGSTypeFillEffect cGSTypeFillEffect, ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode, IAttributeSceneNode iAttributeSceneNode, Float f) {
        if (!this.m_pDrawContext.isDrawingLegend()) {
            if (!this.isVerticalOrientation()) {
                cGSTypeFillEffect.adjustForChartRotation(this.m_pDrawContext.getOutputDevice().isRaster(), this.m_pDrawContext.getOutputDevice().isSVG());
            }
            this.m_pDrawContext.getOutputDevice().applyFillEffect(cGSTypeFillEffect, iSurfaceFaceAttributeSceneNode, iAttributeSceneNode, f);
        }
    }

    protected void applyFillEffectToUSFB(CGSTypeFillEffect cGSTypeFillEffect, UnstructuredFieldBuilder unstructuredFieldBuilder) {
        if (!this.m_pDrawContext.isDrawingLegend()) {
            this.m_pDrawContext.getOutputDevice().applyFillEffectToUSFB(cGSTypeFillEffect, unstructuredFieldBuilder, null);
        }
    }

    private void addSeriesLegendEntry(int n, boolean bl, GRLegendItemIcon gRLegendItemIcon) {
        int n2;
        GRLegend gRLegend = this.m_pDrawContext.getLegend();
        if (gRLegend == null) {
            return;
        }
        CGSWidget.DataType dataType = CGSWidget.DataType.eSeries;
        String string = this.m_pData.getGridSeriesName(n);
        if (string.length() == 0) {
            string = this.m_pData.getGridColumnTitle(n);
            dataType = CGSWidget.DataType.eMeasure;
        }
        double[] dArray = (double[])this.m_pData.getGridColumns()[n];
        int n3 = dArray.length;
        int n4 = -1;
        for (n2 = 0; n2 < n3 && n4 == -1; n2 += 1) {
            n4 = this.m_pData.getTableRowIndex(n2, n);
        }
        n2 = this.m_pWidget.isDetectionAreaRequired(CGSEnums.DetArea.eDetLegendLabel, 0) ? 1 : 0;
        gRLegend.addChartItem(string, dataType, gRLegendItemIcon, n4, n2 != 0, 0);
    }

    protected void addSeriesLegendEntry(int n, int n2, Color color, CGSPropChart.MaterialEffect materialEffect) {
        this.addSeriesLegendEntry(n, n2, false, false, CGSEnums.MarkerShapeB.eMarkerSquareB, color, materialEffect);
    }

    protected void addSeriesLegendEntry(int n, int n2, boolean bl, boolean bl2, CGSEnums.MarkerShapeB markerShapeB, Color color, CGSPropChart.MaterialEffect materialEffect) {
        CGSPropPaletteDiscreteItemB cGSPropPaletteDiscreteItemB = this.getDiscretePaletteItem(n);
        CGSTypeFillEffect cGSTypeFillEffect = cGSPropPaletteDiscreteItemB.getDataPointFillEffect();
        CGSEnums.LineStyleB lineStyleB = CGSEnums.LineStyleB.eLineSolidB;
        CGSTypeFillEffect cGSTypeFillEffect2 = null;
        CGSTypeDouble cGSTypeDouble = null;
        int n3 = 0;
        if (bl) {
            n3 = 1;
        } else if (bl2) {
            n3 = 2;
        }
        if (bl) {
            cGSTypeFillEffect2 = cGSPropPaletteDiscreteItemB.getLineFillEffect();
            lineStyleB = cGSPropPaletteDiscreteItemB.getLineStyle();
            cGSTypeDouble = new CGSTypeDouble(1.0);
            cGSTypeDouble.setValue(cGSPropPaletteDiscreteItemB.getLineWeight());
        }
        GRLegendItemIcon gRLegendItemIcon = this.createIcon(n3, markerShapeB, color, materialEffect, cGSTypeFillEffect, cGSTypeFillEffect2, lineStyleB, cGSTypeDouble);
        this.addSeriesLegendEntry(n2, bl, gRLegendItemIcon);
    }

    private boolean setLabelPatterns(String string, String string2, String string3, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        boolean bl = false;
        if (string.length() > 0) {
            int n = string.indexOf(48);
            int n2 = string.indexOf(35);
            int n3 = n == -1 && n2 == -1 ? string.length() : (n == -1 ? n2 : (n2 == -1 ? n : Math.min(n2, n)));
            stringBuilder.setLength(0);
            stringBuilder.append(string.substring(0, n3));
            int n4 = string.lastIndexOf(48);
            int n5 = string.lastIndexOf(35);
            int n6 = n4 == -1 && n5 == -1 ? string.length() : (n4 == -1 ? n5 : (n5 == -1 ? n4 : Math.max(n5, n4)));
            stringBuilder2.setLength(0);
            stringBuilder2.append(string.substring(n6 + 1));
            bl = true;
        } else {
            if (string2.length() > 0) {
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
                bl = true;
            }
            if (string3.length() > 0) {
                stringBuilder2.setLength(0);
                stringBuilder2.append(string3);
                bl = true;
            }
        }
        return bl;
    }

    protected void applyAxisLabelFormattingProperties(CGSProp cGSProp, INumericAxis iNumericAxis) {
        CGSPropTickLabelNumeric cGSPropTickLabelNumeric = (CGSPropTickLabelNumeric)cGSProp.getProp(CGSEnums.PropType.ePropTickLabelNumeric);
        CGSPropFormatNumeric cGSPropFormatNumeric = (CGSPropFormatNumeric)cGSPropTickLabelNumeric.getProp(CGSEnums.PropType.ePropFormatNumeric);
        CGSFormatter cGSFormatter = this.m_pWidget.getFormatter(cGSPropFormatNumeric);
        iNumericAxis.getNumericStyle().setLabelPower(0);
        iNumericAxis.setExternalFormatter((INumberFormatter)cGSFormatter);
    }

    protected void applyAxisLabelFormattingProperties(CGSProp cGSProp, IDialNumericAxis iDialNumericAxis) {
        CGSPropTickLabelNumeric cGSPropTickLabelNumeric = (CGSPropTickLabelNumeric)cGSProp.getProp(CGSEnums.PropType.ePropTickLabelNumeric);
        CGSPropFormatNumeric cGSPropFormatNumeric = (CGSPropFormatNumeric)cGSPropTickLabelNumeric.getProp(CGSEnums.PropType.ePropFormatNumeric);
        CGSFormatter cGSFormatter = this.m_pWidget.getFormatter(cGSPropFormatNumeric);
        iDialNumericAxis.getNumericStyle().setLabelPower(0);
        iDialNumericAxis.setExternalFormatter((INumberFormatter)cGSFormatter);
    }

    protected void applyAxisLabelFormattingProperties(CGSProp cGSProp, CGSPropFormatNumeric cGSPropFormatNumeric, CGSFormatter cGSFormatter, INumericStyle iNumericStyle) {
        Object object;
        Object object2;
        switch (cGSPropFormatNumeric.getDigitShapeType()) {
            case eDigitShapeNone: {
                iNumericStyle.setZeroSymbol('0');
                break;
            }
            case eDigitShapeNational: {
                iNumericStyle.setZeroSymbol(ToolkitResources.getZeroDigit((String)cGSPropFormatNumeric.getLocale()).charValue());
            }
        }
        Object object3 = CGSEnums.ChartSubType.eChartSubRegular;
        CGSEnums.PropType propType = cGSProp.getPropType();
        if (this.m_pWidget.getType() == CGSWidget.WidgetType.eChartCombo) {
            object2 = (CGSPropChartCombo)this.m_pBaseProp.getProp(CGSEnums.PropType.ePropChartCombo);
            boolean bl = false;
            for (int i = 0; i < ((CGSPropChartCombo)object2).getChartCount(); ++i) {
                if (!(propType == CGSEnums.PropType.ePropComboAxisRight && this.m_pData.getAxisLocation(i) == 2 || propType == CGSEnums.PropType.ePropComboAxisLeft && this.m_pData.getAxisLocation(i) == 1 || propType == CGSEnums.PropType.ePropComboAxisRightBottom && this.m_pData.getAxisLocation(i) == 4) && (propType != CGSEnums.PropType.ePropComboAxisLeftBottom || this.m_pData.getAxisLocation(i) != 3)) continue;
                object = this.m_pWidget.getChartSubtype(i);
                if (!bl) {
                    bl = true;
                    object3 = object;
                    continue;
                }
                if (object3 == object) continue;
                object3 = CGSEnums.ChartSubType.eChartSubStacked;
                break;
            }
        }
        object2 = new StringBuilder("%v");
        StringBuilder stringBuilder = new StringBuilder("");
        StringBuilder stringBuilder2 = new StringBuilder("");
        object = new StringBuilder("-");
        StringBuilder stringBuilder3 = new StringBuilder("");
        StringBuilder stringBuilder4 = new StringBuilder("");
        StringBuilder stringBuilder5 = new StringBuilder("");
        boolean bl = this.setLabelPatterns(cGSPropFormatNumeric.getPattern(), cGSPropFormatNumeric.getPositivePrefix(), cGSPropFormatNumeric.getPositiveSuffix(), stringBuilder, stringBuilder2);
        boolean bl2 = this.setLabelPatterns(cGSPropFormatNumeric.getNegativePattern(), cGSPropFormatNumeric.getNegativePrefix(), cGSPropFormatNumeric.getNegativeSuffix(), (StringBuilder)object, stringBuilder3);
        if (!bl2) {
            bl2 = this.setLabelPatterns(cGSPropFormatNumeric.getPattern(), cGSPropFormatNumeric.getNegativePrefix(), cGSPropFormatNumeric.getNegativeSuffix(), new StringBuilder(""), stringBuilder3);
        }
        String string = cGSPropFormatNumeric.getNegativeSign();
        if (!bl2 && string.length() > 0) {
            if (cGSPropFormatNumeric.getTrailingNegativeSign()) {
                ((StringBuilder)object).replace(0, ((StringBuilder)object).length(), "");
                stringBuilder3.replace(0, stringBuilder3.length(), string);
            } else if (string.equalsIgnoreCase("()")) {
                ((StringBuilder)object).replace(0, ((StringBuilder)object).length(), string.substring(0, 1));
                stringBuilder3.replace(0, stringBuilder3.length(), string.substring(1));
            } else {
                ((StringBuilder)object).replace(0, ((StringBuilder)object).length(), string);
            }
        }
        if (cGSPropFormatNumeric.getMaximumDecimalPlaces() >= 0) {
            iNumericStyle.setLabelMaximumDecimalPlaces(cGSPropFormatNumeric.getMaximumDecimalPlaces());
        }
        if (cGSPropFormatNumeric.getMinimumDecimalPlaces() >= 0) {
            iNumericStyle.setLabelMinimumDecimalPlaces(cGSPropFormatNumeric.getMinimumDecimalPlaces());
            iNumericStyle.setLabelZeroFractions(AxisLabelZeroFractionsEnum.INCLUDE_ZEROS);
        }
        if (cGSPropFormatNumeric.getDecimalSeparator().length() > 0) {
            iNumericStyle.setLabelDecimalPoint(cGSPropFormatNumeric.getDecimalSeparator());
        } else {
            iNumericStyle.setLabelDecimalPoint(cGSFormatter.getDecimalSeparator());
        }
        if (cGSPropFormatNumeric.getFormatType() == CGSPropFormatNumericBase.FormatType.eFormatPercentage) {
            iNumericStyle.setLabelFormat(AxisLabelFormatEnum.AUTO_FORMAT_NO_EXPONENTS);
            double d = 100.0;
            if (cGSPropFormatNumeric.getPercentSymbol().compareTo("\u2030") == 0 || cGSPropFormatNumeric.getUsePermill()) {
                d *= 10.0;
            }
            iNumericStyle.setLabelScaleFactor(d *= Math.pow(10.0, -cGSPropFormatNumeric.getPercentScale()));
            String string2 = null;
            string2 = cGSPropFormatNumeric.getUsePermill() ? "\u2030" : "%";
            if (cGSPropFormatNumeric.getPercentSymbol().length() > 0) {
                string2 = cGSPropFormatNumeric.getPercentSymbol();
            }
            string2 = string2.replaceAll("%", "%%");
            if (!bl2) {
                stringBuilder3.insert(0, string2);
            }
            if (!bl) {
                stringBuilder2.insert(0, string2);
            }
        } else if (cGSPropFormatNumeric.getFormatType() == CGSPropFormatNumericBase.FormatType.eFormatCurrency) {
            String string3 = cGSFormatter.getCurrencySymbol();
            iNumericStyle.setLabelFormat(AxisLabelFormatEnum.AUTO_FORMAT_NO_EXPONENTS);
            iNumericStyle.setLabelScaleFactor(Math.pow(10.0, cGSPropFormatNumeric.getScale()));
            if (cGSFormatter.getUseTrailingCurrencySymbol()) {
                if (!bl2) {
                    stringBuilder3.insert(0, " " + string3);
                }
                if (!bl) {
                    stringBuilder2.insert(0, " " + string3);
                }
            } else {
                if (!bl2) {
                    ((StringBuilder)object).append(string3);
                }
                if (!bl) {
                    stringBuilder.append(string3);
                }
            }
        } else if (cGSPropFormatNumeric.getFormatType() == CGSPropFormatNumericBase.FormatType.eFormatScientific) {
            iNumericStyle.setLabelFormat(AxisLabelFormatEnum.EE_FORMAT);
            iNumericStyle.setLabelScaleFactor(Math.pow(10.0, cGSPropFormatNumeric.getScale()));
        } else {
            iNumericStyle.setLabelFormat(AxisLabelFormatEnum.AUTO_FORMAT_NO_EXPONENTS);
            iNumericStyle.setLabelScaleFactor(Math.pow(10.0, cGSPropFormatNumeric.getScale()));
        }
        stringBuilder5.append((CharSequence)object).append((CharSequence)object2).append((CharSequence)stringBuilder3);
        stringBuilder4.append((CharSequence)stringBuilder).append((CharSequence)object2).append((CharSequence)stringBuilder2);
        if (cGSPropFormatNumeric.getUseGrouping()) {
            if (cGSPropFormatNumeric.getGroupingSeparator().length() > 0) {
                iNumericStyle.setLabel3DigitSpacer(cGSPropFormatNumeric.getGroupingSeparator());
            } else {
                iNumericStyle.setLabel3DigitSpacer(cGSFormatter.getGroupingSeparator());
            }
        } else {
            iNumericStyle.setLabel3DigitSpacer("");
        }
        iNumericStyle.setLabelPositiveFormat(stringBuilder4.toString());
        iNumericStyle.setLabelNegativeFormat(stringBuilder5.toString());
    }

    private GRLegendItemIcon createIcon(int n, CGSEnums.MarkerShapeB markerShapeB, Color color, CGSPropChart.MaterialEffect materialEffect, CGSTypeFillEffect cGSTypeFillEffect, CGSTypeFillEffect cGSTypeFillEffect2, CGSEnums.LineStyleB lineStyleB, CGSTypeDouble cGSTypeDouble) {
        GRLegendItemIcon gRLegendItemIcon = new GRLegendItemIcon();
        gRLegendItemIcon.dataPointShapeFill = cGSTypeFillEffect;
        if (n == 1 && cGSTypeFillEffect2 != null) {
            gRLegendItemIcon.lineFill = cGSTypeFillEffect2;
            gRLegendItemIcon.lineStyleB = lineStyleB;
            gRLegendItemIcon.lineWeight = cGSTypeDouble;
        }
        gRLegendItemIcon.dataPointShapeB = markerShapeB;
        gRLegendItemIcon.dataPointShapeOutlineColor = color;
        gRLegendItemIcon.materialEffect = materialEffect;
        gRLegendItemIcon.doRotation = OVHelper.isGlyph3D(gRLegendItemIcon.dataPointShapeB);
        gRLegendItemIcon.iconType = n;
        return gRLegendItemIcon;
    }

    protected Double getCrossOverValue(double d, double d2) {
        double d3 = 0.0;
        if (d > 0.0) {
            d3 = d;
        } else if (d2 < 0.0) {
            d3 = d2;
        }
        return new Double(d3);
    }

    protected void populateViewport() {
    }

    protected void populateWorkbox() {
    }

    protected void postSceneTreeBuild() {
    }

    protected boolean is3DViewportRequired() {
        return true;
    }

    protected void setViewportTo3D() {
        this.m_viewportIs3D = true;
    }

    protected boolean getViewportTo3D() {
        return this.m_viewportIs3D;
    }

    protected void createViewport() {
        if (this.m_ovViewport == null) {
            this.m_ovViewport = new Viewport25D();
        } else {
            this.m_ovViewport.removeAllChildren();
            this.m_ovViewport.resetProperty(ManageableComponentSceneNodePropertyEnum.ALL);
        }
        this.m_ovViewport.setPerformDepthCheck(this.m_viewportIs3D);
        this.m_ovViewport.addComponentExceptionListener((ComponentExceptionListener)this);
        this.m_ovViewport.normalizeView();
        OVChart.setMaterialEffectLighting(this.m_pWidget.getMaterialEffect(), (com.avs.openviz3.layout.Viewport25D)this.m_ovViewport);
        if (this.m_pDrawContext.isClipping() && (this.m_pWidget.getType() == CGSWidget.WidgetType.eChartBubble || this.m_pWidget.getType() == CGSWidget.WidgetType.eChartScatter)) {
            this.m_ovViewport.setClippingEnabled(true);
        } else if (this.m_pWidget.getType() == CGSWidget.WidgetType.eChartCombo || this.m_pWidget.getType() == CGSWidget.WidgetType.eChartProgressive) {
            this.m_pWorkbox.setClippingEnabled(true);
        } else {
            this.m_ovViewport.setClippingEnabled(false);
        }
    }

    public static void setMaterialEffectLighting(CGSPropChart.MaterialEffect materialEffect, com.avs.openviz3.layout.Viewport25D viewport25D) {
        if (materialEffect != CGSPropChart.MaterialEffect.eMaterialNone) {
            ILight iLight = viewport25D.newLight(LightTypeEnum.DIRECTIONAL);
            iLight.setDirection(new PointFloat3(1.0f, 0.0f, 1.0f));
        }
    }

    protected boolean isVerticalOrientation() {
        return true;
    }

    protected boolean hasDepth() {
        return this.getDepth() > 0.0f;
    }

    protected float getDepth() {
        return 0.0f;
    }

    public void exceptionOccurred(ComponentExceptionEvent componentExceptionEvent) {
        this.m_pDrawContext.exceptionOccurred(componentExceptionEvent);
    }

    protected abstract Color getOutlineColor(int var1);

    static class ContinuousPaletteInfo {
        protected String m_measureName;
        protected Color[] m_colors;
        protected String[] m_labels;
        protected Double[] m_values;

        protected ContinuousPaletteInfo(String string, Color[] colorArray, String[] stringArray, Double[] doubleArray) {
            this.m_measureName = string;
            this.m_colors = colorArray;
            this.m_labels = stringArray;
            this.m_values = doubleArray;
        }
    }

    protected static enum ConditionalIconType {
        eBar,
        eArea,
        eLine,
        ePoint,
        eLineAndPoint;

    }
}

