/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.DrawContext;

import com.avs.openviz3.cognos.ImageMaker;
import com.avs.openviz3.cognos.RasterMapRenderer;
import com.avs.openviz3.cognos.SoftwareRenderer;
import com.avs.openviz3.fw.PointFloat2;
import com.avs.openviz3.fw.PointFloat3;
import com.avs.openviz3.fw.base.ComponentExceptionEvent;
import com.avs.openviz3.fw.base.ComponentExceptionListener;
import com.avs.openviz3.fw.base.ComponentSceneNode;
import com.avs.openviz3.fw.base.GroupSceneNode;
import com.avs.openviz3.fw.base.IAttributeSceneNode;
import com.avs.openviz3.fw.base.ISceneNode;
import com.avs.openviz3.fw.base.ISoftwareRendererLineAttributes;
import com.avs.openviz3.fw.base.ISurfaceAttributes;
import com.avs.openviz3.fw.base.ISurfaceFaceAttributeSceneNode;
import com.avs.openviz3.fw.base.ISurfaceFaceAttributes;
import com.avs.openviz3.fw.base.SurfaceTypeEnum;
import com.avs.openviz3.fw.field.CellTypeEnum;
import com.avs.openviz3.fw.field.DataTagEnum;
import com.avs.openviz3.fw.text.BaseTextDirectionEnum;
import com.avs.openviz3.geometry.FieldToTextureMap;
import com.avs.openviz3.io.ImageToField;
import com.avs.openviz3.io.UnstructuredFieldBuilder;
import com.avs.openviz3.viewer.CullFaceEnum;
import com.avs.openviz3.viewer.GenerateNormalsEnum;
import com.avs.openviz3.viewer.SuperSampleResolutionEnum;
import com.avs.openviz3.viewer.renderer.IRenderer;
import com.avs.openviz3.viewer.renderer.paint.IPixelBuffer;
import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.DrawContext.DCDrawContextOV;
import com.ibm.cgsBus.DrawContext.OVDevice;
import com.ibm.cgsBus.DrawContext.OVHelper;
import com.ibm.cgsBus.DrawContext.OVRasterMapRenderer;
import com.ibm.cgsBus.FrameWork.CGSWidget;
import com.ibm.cgsBus.Graphics.GRBufferedImage;
import com.ibm.cgsBus.Graphics.GRLegendItemIcon;
import com.ibm.cgsBus.Logging.CGSLogging;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeFillEffect;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class OVDeviceRaster
extends OVDevice
implements ComponentExceptionListener {
    protected static final double MIN_LINE_WIDTH = 1.0E-7;
    protected static final double RASTER_SINGLE_PIXEL_LINE_WEIGHT = 0.75;
    private DCDrawContextOV m_pDrawContext = null;
    private ImageMaker m_pImageMaker = null;
    private boolean m_isAntialiased = false;

    public OVDeviceRaster(DCDrawContextOV dCDrawContextOV, boolean bl) {
        this.m_pDrawContext = dCDrawContextOV;
        this.m_pImageMaker = new ImageMaker("OVDeviceRaster", "x67d-r3yv-l095-s6qt");
        this.setBaseTextDirection();
        this.m_pImageMaker.addComponentExceptionListener((ComponentExceptionListener)this);
        this.m_pImageMaker.setBackground(new Color(0, 0, 0, 0));
        this.m_pImageMaker.getSceneRoot().getSurfaceAttributes().setCullFace(CullFaceEnum.BACK);
        RasterMapRenderer rasterMapRenderer = new RasterMapRenderer();
        rasterMapRenderer.setImageMapQuality(7);
        rasterMapRenderer.setPixelBuffer((IPixelBuffer)new OVRasterMapRenderer());
        rasterMapRenderer.setDepthBuffer((IPixelBuffer)new OVRasterMapRenderer());
        rasterMapRenderer.setSupersampleResolution(SuperSampleResolutionEnum.TWO_BY_TWO);
        this.m_pImageMaker.setImageMapRenderer((IRenderer)rasterMapRenderer);
        SoftwareRenderer softwareRenderer = new SoftwareRenderer();
        softwareRenderer.setPixelBuffer((IPixelBuffer)new OVRasterMapRenderer());
        softwareRenderer.setDepthBuffer((IPixelBuffer)new OVRasterMapRenderer());
        softwareRenderer.setDownSamplePixelBuffer((IPixelBuffer)new OVRasterMapRenderer());
        if (bl) {
            this.m_isAntialiased = true;
            softwareRenderer.setSupersampleResolution(SuperSampleResolutionEnum.TWO_BY_TWO);
            softwareRenderer.setFilterSize(1);
        }
        softwareRenderer.setGamma(1.0);
        softwareRenderer.setSuperSampleMinLineWidth(1.0E-7);
        softwareRenderer.setBlendAgainstTransparentPixels(true);
        softwareRenderer.setFilterSize(1);
        this.m_pImageMaker.setRenderer((IRenderer)softwareRenderer);
        softwareRenderer = null;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_pImageMaker = null;
    }

    @Override
    public void reset() {
        if (this.m_rootNode != null) {
            this.m_pImageMaker.removeChild((ISceneNode)this.m_rootNode);
        }
        this.m_rootNode = null;
    }

    @Override
    public boolean isRaster() {
        return true;
    }

    @Override
    public boolean isSVG() {
        return false;
    }

    public boolean isAntialiased() {
        return this.m_isAntialiased;
    }

    @Override
    public void disableBackfaceCull() {
        this.m_pImageMaker.getSceneRoot().getSurfaceAttributes().setCullFace(CullFaceEnum.NONE);
    }

    @Override
    public void setSize(int n, int n2) {
        this.m_width = n;
        this.m_height = n2;
        this.m_pImageMaker.setSize(new Dimension(this.m_width, this.m_height));
    }

    @Override
    public void addChild(GroupSceneNode groupSceneNode) {
        CMHelper.CGS_ASSERT(this.m_rootNode == null, "ImageMaker already populated.");
        this.m_rootNode = groupSceneNode;
        this.m_sceneTreeMeasured = false;
        this.m_pImageMaker.addChild((ISceneNode)groupSceneNode);
    }

    @Override
    public void measureSceneTree() {
        if (this.m_sceneTreeMeasured) {
            return;
        }
        CGSLogging.logEnter("OVDeviceRaster::measureSceneTree");
        this.m_pImageMaker.measureSceneTree();
        CGSLogging.logExit("OVDeviceRaster::measureSceneTree");
        this.m_sceneTreeMeasured = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void applyFillEffect(CGSTypeFillEffect cGSTypeFillEffect, ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode, IAttributeSceneNode iAttributeSceneNode, Float f) {
        if (!cGSTypeFillEffect.isSimple(true)) {
            float f2;
            float f3;
            if (f != null) {
                f3 = f.floatValue();
                f2 = f.floatValue();
            } else {
                PointFloat2[] pointFloat2Array = this.getBoundingBox((ISceneNode)(iAttributeSceneNode == null ? iSurfaceFaceAttributeSceneNode : iAttributeSceneNode));
                if (pointFloat2Array == null) {
                    if (this.m_pDrawContext.getWidget().getType() != CGSWidget.WidgetType.eChartGauge) return;
                    f3 = this.m_width;
                    f2 = this.m_height;
                } else {
                    f3 = pointFloat2Array[1].getX() - pointFloat2Array[0].getX();
                    f2 = pointFloat2Array[1].getY() - pointFloat2Array[0].getY();
                }
            }
            BufferedImage bufferedImage = this.createFillEffectImage(cGSTypeFillEffect, this.m_pDrawContext, f3, f2);
            if (bufferedImage == null) {
                return;
            }
            ImageToField imageToField = new ImageToField();
            imageToField.addComponentExceptionListener((ComponentExceptionListener)this);
            imageToField.setImage((Image)bufferedImage);
            FieldToTextureMap fieldToTextureMap = new FieldToTextureMap();
            fieldToTextureMap.addComponentExceptionListener((ComponentExceptionListener)this);
            fieldToTextureMap.connectInputField(imageToField.getOutputField());
            iSurfaceFaceAttributeSceneNode.getSurfaceAttributes().setSurfaceColor(Color.WHITE);
            ISurfaceFaceAttributes iSurfaceFaceAttributes = iSurfaceFaceAttributeSceneNode.getSurfaceFaceAttributes();
            iSurfaceFaceAttributes.setSurfaceType(SurfaceTypeEnum.TEXTURE);
            iSurfaceFaceAttributes.getTextureAttributes().setTextureMap(fieldToTextureMap.getOutputField());
            fieldToTextureMap = null;
            imageToField.setImage(null);
            return;
        }
        super.applyFillEffect(cGSTypeFillEffect, iSurfaceFaceAttributeSceneNode, iAttributeSceneNode, null);
    }

    @Override
    public void applyFillEffectToUSFB(CGSTypeFillEffect cGSTypeFillEffect, UnstructuredFieldBuilder unstructuredFieldBuilder, Float f) {
        Object object;
        if (cGSTypeFillEffect.getType() == CGSEnums.FillType.eFillPattern) {
            super.applyFillEffectToUSFB(cGSTypeFillEffect, unstructuredFieldBuilder, f);
            return;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (f != null) {
            f2 = f.floatValue();
            f3 = f.floatValue();
        } else {
            object = this.getBoundingBox((ISceneNode)unstructuredFieldBuilder);
            if (object == null) {
                return;
            }
            f2 = object[1].getX() - object[0].getX();
            f3 = object[1].getY() - object[0].getY();
        }
        object = this.createFillEffectImage(cGSTypeFillEffect, this.m_pDrawContext, f2, f3);
        if (object == null) {
            return;
        }
        ImageToField imageToField = new ImageToField();
        imageToField.addComponentExceptionListener((ComponentExceptionListener)this);
        imageToField.setImage((Image)object);
        FieldToTextureMap fieldToTextureMap = new FieldToTextureMap();
        fieldToTextureMap.addComponentExceptionListener((ComponentExceptionListener)this);
        fieldToTextureMap.connectInputField(imageToField.getOutputField());
        ISurfaceAttributes iSurfaceAttributes = unstructuredFieldBuilder.getSurfaceAttributes();
        iSurfaceAttributes.setGenerateNormals(GenerateNormalsEnum.NONE);
        iSurfaceAttributes.setTextureMap(fieldToTextureMap.getOutputField());
        fieldToTextureMap = null;
        imageToField.setImage(null);
        imageToField = null;
        object = null;
    }

    @Override
    protected double getLineWidth(double d) {
        return Math.max(d, 0.75);
    }

    private PointFloat2[] getBoundingBox(ISceneNode iSceneNode) {
        this.measureSceneTree();
        return this.m_pImageMaker.getScreenCoordinateBoundingBox(iSceneNode);
    }

    public BufferedImage getImage() {
        CGSLogging.logEnter("OVDeviceRaster::getImage");
        int[] nArray = null;
        GRBufferedImage gRBufferedImage = new GRBufferedImage(this.m_width, this.m_height);
        IPixelBuffer iPixelBuffer = this.m_pImageMaker.getOutputPixelBuffer();
        if (iPixelBuffer instanceof OVRasterMapRenderer) {
            nArray = ((OVRasterMapRenderer)iPixelBuffer).getUnCompressedPixels();
        }
        gRBufferedImage.copyPixels(nArray);
        CGSLogging.logExit("OVDeviceRaster::getImage");
        return gRBufferedImage.getImage();
    }

    @Override
    public String getImageMap() {
        CGSLogging.logEnter("OVDeviceRaster::getImageMap");
        String string = this.m_pImageMaker.getImageMap();
        CGSLogging.logExit("OVDeviceRaster::getImageMap");
        return string;
    }

    public void exceptionOccurred(ComponentExceptionEvent componentExceptionEvent) {
        if (this.m_pDrawContext != null) {
            this.m_pDrawContext.exceptionOccurred(componentExceptionEvent);
        } else {
            OVHelper.outputAVSException(componentExceptionEvent);
        }
    }

    private void setBaseTextDirection() {
        CGSEnums.TextDirection textDirection = this.m_pDrawContext.getWidget().getCanvas().getTextDirection();
        if (textDirection != CGSEnums.TextDirection.eTextDirDefault) {
            if (textDirection == CGSEnums.TextDirection.eTextDirRtl) {
                this.m_pImageMaker.getSceneRoot().getTextAttributes().setBaseTextDirection(BaseTextDirectionEnum.RIGHT_TO_LEFT);
            } else if (textDirection == CGSEnums.TextDirection.eTextDirLtr) {
                this.m_pImageMaker.getSceneRoot().getTextAttributes().setBaseTextDirection(BaseTextDirectionEnum.LEFT_TO_RIGHT);
            } else if (textDirection == CGSEnums.TextDirection.eTextDirAuto) {
                this.m_pImageMaker.getSceneRoot().getTextAttributes().setBaseTextDirection(BaseTextDirectionEnum.AUTO_DETECT);
            }
        }
    }

    public boolean isGrayLegendIcon(GRLegendItemIcon gRLegendItemIcon) {
        return gRLegendItemIcon.iconType == 3 || gRLegendItemIcon.iconType == 4 || gRLegendItemIcon.iconType == 5;
    }

    public void addGlyph(GRLegendItemIcon gRLegendItemIcon, int n, Color color, ComponentSceneNode componentSceneNode, PointFloat3 pointFloat3) {
        UnstructuredFieldBuilder unstructuredFieldBuilder = this.getGlyph(gRLegendItemIcon.dataPointShapeB, new Float(n - 2), pointFloat3, gRLegendItemIcon.dataPointShapeFill, color, true, gRLegendItemIcon.materialEffect, gRLegendItemIcon.doRotation);
        if (unstructuredFieldBuilder != null) {
            componentSceneNode.addChild((ISceneNode)unstructuredFieldBuilder);
        }
    }

    public void addLineGlyph(GRLegendItemIcon gRLegendItemIcon, ComponentSceneNode componentSceneNode, int n, PointFloat3 pointFloat3, float f) {
        if (gRLegendItemIcon.lineStyleB == CGSEnums.LineStyleB.eLineSolidB) {
            OVDeviceRaster.addLine(-1.0f, 1.0f, gRLegendItemIcon, componentSceneNode, pointFloat3, f);
        } else if (gRLegendItemIcon.lineStyleB == CGSEnums.LineStyleB.eLineDashB) {
            OVDeviceRaster.addLine(-1.0f, -0.2f, gRLegendItemIcon, componentSceneNode, pointFloat3, f);
            OVDeviceRaster.addLine(0.2f, 1.0f, gRLegendItemIcon, componentSceneNode, pointFloat3, f);
        } else if (gRLegendItemIcon.lineStyleB == CGSEnums.LineStyleB.eLineDotB) {
            OVDeviceRaster.addLine(-0.8f, -0.7f, gRLegendItemIcon, componentSceneNode, pointFloat3, f);
            OVDeviceRaster.addLine(-0.3f, -0.2f, gRLegendItemIcon, componentSceneNode, pointFloat3, f);
            OVDeviceRaster.addLine(0.2f, 0.3f, gRLegendItemIcon, componentSceneNode, pointFloat3, f);
            OVDeviceRaster.addLine(0.7f, 0.8f, gRLegendItemIcon, componentSceneNode, pointFloat3, f);
        } else if (gRLegendItemIcon.lineStyleB == CGSEnums.LineStyleB.eLineDashDotB) {
            OVDeviceRaster.addLine(-1.0f, -0.5f, gRLegendItemIcon, componentSceneNode, pointFloat3, f);
            OVDeviceRaster.addLine(-0.1f, 0.1f, gRLegendItemIcon, componentSceneNode, pointFloat3, f);
            OVDeviceRaster.addLine(0.5f, 1.0f, gRLegendItemIcon, componentSceneNode, pointFloat3, f);
        } else {
            CMHelper.CGS_ASSERT(false, "Invalid line style.");
        }
        this.addGlyph(gRLegendItemIcon, n, gRLegendItemIcon.dataPointShapeOutlineColor, componentSceneNode, new PointFloat3(0.0f, 0.0f, 0.06f));
    }

    private static void addLine(float f, float f2, GRLegendItemIcon gRLegendItemIcon, ComponentSceneNode componentSceneNode, PointFloat3 pointFloat3, float f3) {
        Color color = gRLegendItemIcon.lineFill == null ? new Color(255, 0, 0, 255) : gRLegendItemIcon.lineFill.getSolidColor();
        UnstructuredFieldBuilder unstructuredFieldBuilder = new UnstructuredFieldBuilder();
        ISoftwareRendererLineAttributes iSoftwareRendererLineAttributes = (ISoftwareRendererLineAttributes)unstructuredFieldBuilder.getLineAttributes();
        iSoftwareRendererLineAttributes.setPreciseSuperSampledLines(true);
        iSoftwareRendererLineAttributes.setLineColor(color);
        double d = 0.75;
        if (gRLegendItemIcon.lineWeight != null && gRLegendItemIcon.lineWeight.getValue() > 0.0) {
            d = gRLegendItemIcon.lineWeight.getValue();
        }
        iSoftwareRendererLineAttributes.setLineWidth(d);
        iSoftwareRendererLineAttributes.setLinePatternIndex(0);
        float[] fArray = new float[]{pointFloat3.getX() + f * f3, pointFloat3.getY(), pointFloat3.getZ(), pointFloat3.getX() + f2 * f3, pointFloat3.getY(), pointFloat3.getZ()};
        unstructuredFieldBuilder.appendVerts((Object)fArray);
        unstructuredFieldBuilder.addCellSet(1, 0, CellTypeEnum.LINE);
        OVHelper.applyMaterialEffect((IAttributeSceneNode)unstructuredFieldBuilder, gRLegendItemIcon.materialEffect);
        componentSceneNode.addChild((ISceneNode)unstructuredFieldBuilder);
    }

    private static float[] getAreaChartIconCoords(PointFloat3 pointFloat3, float f) {
        float f2 = pointFloat3.getX();
        float f3 = f2 + f;
        float f4 = f2 - f;
        float f5 = pointFloat3.getY();
        float f6 = f5 + f;
        float f7 = f5 - f;
        float[] fArray = new float[]{f4, f7, 0.0f, f3, f7, 0.0f, f3, f6, 0.0f, f2, f5, 0.0f, f4, f6, 0.0f};
        return fArray;
    }

    private static float[] getBarChartIconCoords(PointFloat3 pointFloat3, float f) {
        float f2 = pointFloat3.getX();
        float f3 = f2 + f;
        float f4 = f2 - f;
        float f5 = pointFloat3.getY();
        float f6 = f5 + f;
        float f7 = f5 - f;
        float[] fArray = new float[]{f4, f7, 0.0f, f3, f7, 0.0f, f3, f6, 0.0f, f2, f6, 0.0f, f2, f5, 0.0f, f4, f5, 0.0f};
        return fArray;
    }

    private static float[] getLineChartIconCoords(PointFloat3 pointFloat3, float f) {
        float f2 = pointFloat3.getX();
        float f3 = pointFloat3.getY();
        float[] fArray = new float[]{f2 - 1.0f * f, f3 - 1.0f * f, 0.0f, f2 - 0.3f * f, f3 - 0.3f * f, 0.0f, f2 + 0.3f * f, f3 - 0.5f * f, 0.0f, f2 + 1.0f * f, f3 + 0.3f * f, 0.0f, f2 + 1.0f * f, f3 + 1.0f * f, 0.0f, f2 + 0.2f * f, f3 + 0.0f * f, 0.0f, f2 - 0.3f * f, f3 + 0.3f * f, 0.0f, f2 - 1.0f * f, f3 - 0.4f * f, 0.0f};
        return fArray;
    }

    public void addChartGlyph(GRLegendItemIcon gRLegendItemIcon, ComponentSceneNode componentSceneNode, PointFloat3 pointFloat3, float f) {
        UnstructuredFieldBuilder unstructuredFieldBuilder = new UnstructuredFieldBuilder();
        float[] fArray = null;
        int[] nArray = null;
        switch (gRLegendItemIcon.iconType) {
            case 3: {
                fArray = OVDeviceRaster.getAreaChartIconCoords(pointFloat3, f);
                nArray = new int[]{0, 1, 2, 3, 4};
                break;
            }
            case 4: {
                fArray = OVDeviceRaster.getBarChartIconCoords(pointFloat3, f);
                nArray = new int[]{0, 1, 2, 3, 4, 5};
                break;
            }
            case 5: {
                fArray = OVDeviceRaster.getLineChartIconCoords(pointFloat3, f);
                nArray = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
            }
        }
        unstructuredFieldBuilder.appendVerts(fArray);
        unstructuredFieldBuilder.addCellSetWithIndices(nArray, CellTypeEnum.NONCONVEX_POLYGON);
        this.applyFillEffectToUSFB(gRLegendItemIcon.dataPointShapeFill, unstructuredFieldBuilder, new Float(f * (float)this.m_height));
        OVHelper.applyMaterialEffect((IAttributeSceneNode)unstructuredFieldBuilder, gRLegendItemIcon.materialEffect);
        componentSceneNode.addChild((ISceneNode)unstructuredFieldBuilder);
        if (gRLegendItemIcon.dataPointShapeOutlineColor != null && gRLegendItemIcon.dataPointShapeOutlineColor.getAlpha() > 0) {
            UnstructuredFieldBuilder unstructuredFieldBuilder2 = new UnstructuredFieldBuilder();
            unstructuredFieldBuilder2.appendVerts((Object)fArray);
            unstructuredFieldBuilder2.addCellSet(nArray.length, 0, CellTypeEnum.LINE_STRIP);
            ISoftwareRendererLineAttributes iSoftwareRendererLineAttributes = (ISoftwareRendererLineAttributes)unstructuredFieldBuilder2.getLineAttributes();
            iSoftwareRendererLineAttributes.setPreciseSuperSampledLines(true);
            iSoftwareRendererLineAttributes.setLineColor(gRLegendItemIcon.dataPointShapeOutlineColor);
            iSoftwareRendererLineAttributes.setLineWidth(0.75);
            iSoftwareRendererLineAttributes.setLinePatternIndex(0);
            OVHelper.applyMaterialEffect((IAttributeSceneNode)unstructuredFieldBuilder2, gRLegendItemIcon.materialEffect);
            componentSceneNode.addChild((ISceneNode)unstructuredFieldBuilder2);
        }
    }

    public void addAreaGlyph(GRLegendItemIcon gRLegendItemIcon, ComponentSceneNode componentSceneNode, PointFloat3 pointFloat3, float f) {
        UnstructuredFieldBuilder unstructuredFieldBuilder = new UnstructuredFieldBuilder();
        float[] fArray = OVDeviceRaster.getAreaChartIconCoords(pointFloat3, f);
        unstructuredFieldBuilder.appendVerts((Object)fArray);
        int[] nArray = new int[]{0, 1, 2, 3, 4};
        unstructuredFieldBuilder.addCellSetWithIndices((Object)nArray, CellTypeEnum.NONCONVEX_POLYGON);
        PointFloat2[] pointFloat2Array = new PointFloat2[]{new PointFloat2(0.0f, 0.0f), new PointFloat2(1.0f, 0.0f), new PointFloat2(1.0f, 1.0f), new PointFloat2(0.5f, 0.5f), new PointFloat2(0.0f, 1.0f)};
        unstructuredFieldBuilder.addNodeDataArray(PointFloat2.class, (Object)pointFloat2Array, null, DataTagEnum.TEXTURE_INDEX);
        this.applyFillEffectToUSFB(gRLegendItemIcon.dataPointShapeFill, unstructuredFieldBuilder, new Float(f * (float)this.m_height));
        OVHelper.applyMaterialEffect((IAttributeSceneNode)unstructuredFieldBuilder, gRLegendItemIcon.materialEffect);
        componentSceneNode.addChild((ISceneNode)unstructuredFieldBuilder);
        if (gRLegendItemIcon.dataPointShapeOutlineColor != null && gRLegendItemIcon.dataPointShapeOutlineColor.getAlpha() > 0) {
            UnstructuredFieldBuilder unstructuredFieldBuilder2 = new UnstructuredFieldBuilder();
            unstructuredFieldBuilder2.appendVerts((Object)fArray);
            unstructuredFieldBuilder2.addCellSet(5, 0, CellTypeEnum.LINE_STRIP);
            ISoftwareRendererLineAttributes iSoftwareRendererLineAttributes = (ISoftwareRendererLineAttributes)unstructuredFieldBuilder2.getLineAttributes();
            iSoftwareRendererLineAttributes.setPreciseSuperSampledLines(true);
            iSoftwareRendererLineAttributes.setLineColor(gRLegendItemIcon.dataPointShapeOutlineColor);
            iSoftwareRendererLineAttributes.setLineWidth(0.75);
            iSoftwareRendererLineAttributes.setLinePatternIndex(0);
            OVHelper.applyMaterialEffect((IAttributeSceneNode)unstructuredFieldBuilder2, gRLegendItemIcon.materialEffect);
            componentSceneNode.addChild((ISceneNode)unstructuredFieldBuilder2);
        }
    }

    public static void writePNG(String string, BufferedImage bufferedImage) {
        try {
            File file = new File("C:\\" + string + ".png");
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Error writing " + string + ".png");
        }
    }
}

