/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.DrawContext;

import com.avs.openviz3.cognos.OpenVizRendererBridge;
import com.avs.openviz3.fw.PointFloat2;
import com.avs.openviz3.fw.base.ComponentExceptionEvent;
import com.avs.openviz3.fw.base.ComponentExceptionListener;
import com.avs.openviz3.fw.base.GroupSceneNode;
import com.avs.openviz3.fw.base.IAttributeSceneNode;
import com.avs.openviz3.fw.base.ISceneNode;
import com.avs.openviz3.fw.base.ISurfaceAttributes;
import com.avs.openviz3.fw.base.ISurfaceFaceAttributeSceneNode;
import com.avs.openviz3.fw.base.ISurfaceFaceAttributes;
import com.avs.openviz3.fw.base.SurfaceTypeEnum;
import com.avs.openviz3.geometry.FieldToTextureMap;
import com.avs.openviz3.glyphs.HorizontalBarGlyph;
import com.avs.openviz3.io.ImageToField;
import com.avs.openviz3.io.UnstructuredFieldBuilder;
import com.avs.openviz3.viewer.CullFaceEnum;
import com.avs.openviz3.viewer.GenerateNormalsEnum;
import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.DrawContext.DCDrawContextOV;
import com.ibm.cgsBus.DrawContext.OVDevice;
import com.ibm.cgsBus.DrawContext.OVHelper;
import com.ibm.cgsBus.DrawContext.OVVector;
import com.ibm.cgsBus.FrameWork.CGSWidget;
import com.ibm.cgsBus.Logging.CGSLogging;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeFillEffect;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class OVDeviceVector
extends OVDevice
implements ComponentExceptionListener {
    protected DCDrawContextOV m_pDrawContext = null;
    protected OpenVizRendererBridge m_pRenderBridge = null;
    protected String m_imageMap = null;
    protected boolean m_supportTranspency = true;
    protected boolean m_mirror = false;

    public OVDeviceVector(DCDrawContextOV dCDrawContextOV) {
        this.m_pDrawContext = dCDrawContextOV;
        this.m_pRenderBridge = new OpenVizRendererBridge();
        this.m_pRenderBridge.setUsesFractionalFontMetrics(true);
        this.m_pRenderBridge.setLicense("x67d-r3yv-l095-s6qt");
        if (this.m_pDrawContext != null) {
            this.m_mirror = this.m_pDrawContext.getWidget().isChartMirroringEnabled();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_pRenderBridge = null;
    }

    @Override
    public void reset() {
        if (this.m_rootNode != null) {
            this.m_pRenderBridge.removeChild((ISceneNode)this.m_rootNode);
        }
        this.m_rootNode = null;
    }

    @Override
    public boolean isRaster() {
        return false;
    }

    @Override
    public boolean isSVG() {
        return false;
    }

    @Override
    public void setSize(int n, int n2) {
        this.m_width = n;
        this.m_height = n2;
        this.m_pRenderBridge.setSize(new Dimension(this.m_width, this.m_height));
    }

    @Override
    public void addChild(GroupSceneNode groupSceneNode) {
        CMHelper.CGS_ASSERT(this.m_rootNode == null, "RenderBridge already populated.");
        this.m_rootNode = groupSceneNode;
        this.m_sceneTreeMeasured = false;
        groupSceneNode.getSurfaceAttributes().setCullFace(CullFaceEnum.BACK);
        this.m_pRenderBridge.addChild((ISceneNode)groupSceneNode);
    }

    @Override
    public void measureSceneTree() {
        if (this.m_sceneTreeMeasured) {
            return;
        }
        CGSLogging.logEnter("OVDeviceVector::measureSceneTree");
        this.m_pRenderBridge.measureSceneTree();
        CGSLogging.logExit("OVDeviceVector::measureSceneTree");
        this.m_sceneTreeMeasured = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void applyFillEffect(CGSTypeFillEffect cGSTypeFillEffect, ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode, IAttributeSceneNode iAttributeSceneNode, Float f) {
        if (cGSTypeFillEffect.getType() == CGSEnums.FillType.eFillImage && iSurfaceFaceAttributeSceneNode instanceof HorizontalBarGlyph) {
            float f2;
            float f3;
            if (f != null) {
                f3 = f.floatValue();
                f2 = f.floatValue();
            } else {
                PointFloat2[] pointFloat2Array = this.getBoundingBox((ISceneNode)(iAttributeSceneNode == null ? iSurfaceFaceAttributeSceneNode : iAttributeSceneNode));
                if (pointFloat2Array == null) {
                    if (this.m_pDrawContext.getWidget().getType() != CGSWidget.WidgetType.eChartGauge) return;
                    f3 = this.m_width;
                    f2 = this.m_height;
                } else {
                    f3 = pointFloat2Array[1].getX() - pointFloat2Array[0].getX();
                    f2 = pointFloat2Array[1].getY() - pointFloat2Array[0].getY();
                }
            }
            BufferedImage bufferedImage = this.createFillEffectImage(cGSTypeFillEffect, this.m_pDrawContext, f3, f2);
            if (bufferedImage == null) {
                return;
            }
            ImageToField imageToField = new ImageToField();
            imageToField.addComponentExceptionListener((ComponentExceptionListener)this);
            imageToField.setImage((Image)bufferedImage);
            FieldToTextureMap fieldToTextureMap = new FieldToTextureMap();
            fieldToTextureMap.addComponentExceptionListener((ComponentExceptionListener)this);
            fieldToTextureMap.connectInputField(imageToField.getOutputField());
            iSurfaceFaceAttributeSceneNode.getSurfaceAttributes().setSurfaceColor(Color.WHITE);
            ISurfaceFaceAttributes iSurfaceFaceAttributes = iSurfaceFaceAttributeSceneNode.getSurfaceFaceAttributes();
            iSurfaceFaceAttributes.setSurfaceType(SurfaceTypeEnum.TEXTURE);
            iSurfaceFaceAttributes.getTextureAttributes().setTextureMap(fieldToTextureMap.getOutputField());
            fieldToTextureMap = null;
            imageToField.setImage(null);
            return;
        }
        super.applyFillEffect(cGSTypeFillEffect, iSurfaceFaceAttributeSceneNode, iAttributeSceneNode, f);
    }

    @Override
    public void applyFillEffectToUSFB(CGSTypeFillEffect cGSTypeFillEffect, UnstructuredFieldBuilder unstructuredFieldBuilder, Float f) {
        Object object;
        if (cGSTypeFillEffect.getType() == CGSEnums.FillType.eFillPattern) {
            super.applyFillEffectToUSFB(cGSTypeFillEffect, unstructuredFieldBuilder, f);
            return;
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (f != null) {
            f2 = f.floatValue();
            f3 = f.floatValue();
        } else {
            object = this.getBoundingBox((ISceneNode)unstructuredFieldBuilder);
            if (object == null) {
                return;
            }
            f2 = object[1].getX() - object[0].getX();
            f3 = object[1].getY() - object[0].getY();
        }
        object = this.createFillEffectImage(cGSTypeFillEffect, this.m_pDrawContext, f2, f3);
        if (object == null) {
            return;
        }
        Image image = ((Image)object).getScaledInstance((int)Math.ceil(f2 * 72.0f / 96.0f), (int)Math.ceil(f3 * 72.0f / 96.0f), 0);
        ImageToField imageToField = new ImageToField();
        imageToField.addComponentExceptionListener((ComponentExceptionListener)this);
        imageToField.setImage(image);
        FieldToTextureMap fieldToTextureMap = new FieldToTextureMap();
        fieldToTextureMap.addComponentExceptionListener((ComponentExceptionListener)this);
        fieldToTextureMap.connectInputField(imageToField.getOutputField());
        ISurfaceAttributes iSurfaceAttributes = unstructuredFieldBuilder.getSurfaceAttributes();
        iSurfaceAttributes.setGenerateNormals(GenerateNormalsEnum.NONE);
        iSurfaceAttributes.setTextureMap(fieldToTextureMap.getOutputField());
        fieldToTextureMap = null;
        imageToField.setImage(null);
        imageToField = null;
        object = null;
    }

    @Override
    public void vectorTransparencyNotSupported() {
        this.m_supportTranspency = false;
    }

    @Override
    public double getOpacity(double d) {
        return this.m_supportTranspency || d == 0.0 ? d : 1.0;
    }

    private PointFloat2[] getBoundingBox(ISceneNode iSceneNode) {
        this.measureSceneTree();
        return this.m_pRenderBridge.getScreenCoordinateBoundingBox(iSceneNode);
    }

    public byte[] getVectorBlob() {
        OVVector oVVector = new OVVector(this.m_mirror);
        this.m_pRenderBridge.renderScene((Graphics2D)oVVector);
        byte[] byArray = oVVector.getVectorBlob();
        this.m_imageMap = oVVector.getImageMap();
        oVVector.destroy();
        return byArray;
    }

    @Override
    public String getImageMap() {
        return this.m_imageMap;
    }

    public void exceptionOccurred(ComponentExceptionEvent componentExceptionEvent) {
        if (this.m_pDrawContext != null) {
            this.m_pDrawContext.exceptionOccurred(componentExceptionEvent);
        } else {
            OVHelper.outputAVSException(componentExceptionEvent);
        }
    }
}

