/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.DrawContext;

import com.avs.openviz3.axis.AxisElementEndsEnum;
import com.avs.openviz3.axis.AxisElementStatusEnum;
import com.avs.openviz3.axis.AxisLabelFormatEnum;
import com.avs.openviz3.axis.AxisMajorTickMarkLayoutEnum;
import com.avs.openviz3.axis.AxisScaleResolutionEnum;
import com.avs.openviz3.chart.Annotation;
import com.avs.openviz3.dial.DialAxisDirectionEnum;
import com.avs.openviz3.dial.DialAxisFittingModeEnum;
import com.avs.openviz3.dial.DialAxisJustificationEnum;
import com.avs.openviz3.dial.DialAxisTextOrientationEnum;
import com.avs.openviz3.dial.DialBevelStyleEnum;
import com.avs.openviz3.dial.DialManipulator;
import com.avs.openviz3.dial.IDialAxis;
import com.avs.openviz3.dial.IDialFace;
import com.avs.openviz3.dial.IDialNeedle;
import com.avs.openviz3.dial.IDialNeedleCollection;
import com.avs.openviz3.dial.IDialPivotPoint;
import com.avs.openviz3.dial.axis.DialNumericAxis;
import com.avs.openviz3.dial.axis.IDialNumericAxis;
import com.avs.openviz3.dial.colorbar.LinearColorInterpolationEnum;
import com.avs.openviz3.dial.face.CircularDialFace;
import com.avs.openviz3.dial.face.DialFace;
import com.avs.openviz3.dial.face.DialFaceBorderWidthEnum;
import com.avs.openviz3.dial.face.DialFaceSector;
import com.avs.openviz3.dial.face.RoundedEdgeDialFace;
import com.avs.openviz3.dial.needle.DialNeedle;
import com.avs.openviz3.dial.needle.DialNeedleEndStyleEnum;
import com.avs.openviz3.dial.pivotpoint.CircularDialPivotPoint;
import com.avs.openviz3.filter.DataMapInfo;
import com.avs.openviz3.fw.LabelFilteringEnum;
import com.avs.openviz3.fw.PointFloat2;
import com.avs.openviz3.fw.base.ComponentExceptionListener;
import com.avs.openviz3.fw.base.IAttributeSceneNode;
import com.avs.openviz3.fw.base.IAxisMapSource;
import com.avs.openviz3.fw.base.IManageableComponentSceneNode;
import com.avs.openviz3.fw.base.ISceneNode;
import com.avs.openviz3.fw.base.ISurfaceFaceAttributeSceneNode;
import com.avs.openviz3.fw.text.BillboardTextSizeModeEnum;
import com.avs.openviz3.fw.text.FontStyleEnum;
import com.avs.openviz3.fw.text.FontWeightEnum;
import com.avs.openviz3.fw.text.TextHorizontalAlignmentEnum;
import com.avs.openviz3.fw.text.TextModeEnum;
import com.avs.openviz3.layout.LinearAxisMap;
import com.ibm.cgsBus.Common.CMAxisCalculator;
import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.DrawContext.DCDrawContextOV;
import com.ibm.cgsBus.DrawContext.OVChart;
import com.ibm.cgsBus.DrawContext.OVHelper;
import com.ibm.cgsBus.FrameWork.CGSProp;
import com.ibm.cgsBus.FrameWork.CGSWidget;
import com.ibm.cgsBus.Graphics.GRLegend;
import com.ibm.cgsBus.Graphics.GRLegendItemIcon;
import com.ibm.cgsBus.Properties.CGSPropAxisTitleB;
import com.ibm.cgsBus.Properties.CGSPropChartGauge;
import com.ibm.cgsBus.Properties.CGSPropFont;
import com.ibm.cgsBus.Properties.CGSPropGaugeDial;
import com.ibm.cgsBus.Properties.CGSPropGaugeNeedlesB;
import com.ibm.cgsBus.Properties.CGSPropGaugePivot;
import com.ibm.cgsBus.Properties.CGSPropGaugeRangeAxisB;
import com.ibm.cgsBus.Properties.CGSPropLine;
import com.ibm.cgsBus.Properties.CGSPropMajorGridLine;
import com.ibm.cgsBus.Properties.CGSPropMinorGridLine;
import com.ibm.cgsBus.Properties.CGSPropPaletteContinuousB;
import com.ibm.cgsBus.Properties.CGSPropPaletteDiscreteB;
import com.ibm.cgsBus.Properties.CGSPropTickLabel;
import com.ibm.cgsBus.Properties.CGSPropTitle;
import com.ibm.cgsBus.Properties.CGSPropWidgetChartGauge;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeFillEffect;
import java.awt.Color;

public class OVGaugeChart
extends OVChart
implements ComponentExceptionListener {
    private boolean m_useRoundedDialFace;
    private boolean m_showAnnotations;
    private Object[] m_needleValues;
    private Object[] m_needleLabels;
    private int[] m_dataSeriesIndex;
    private int[] m_dataColorByValueIndex;
    private int m_currentAxisIndex;
    private double m_needleHeightSum;
    private boolean m_noSeries = false;
    private int MAX_MAJOR_GRID_INTERVALS = 2000;
    private CGSPropChartGauge m_propChartGauge;
    private CGSPropGaugeDial m_propGaugeDial;
    private CGSPropGaugePivot m_propGaugePivot;
    private Annotation m_annotation;
    private DialManipulator m_dialManipulator;
    private DialNumericAxis[] m_axes;
    protected Object[] m_legendItems;

    public OVGaugeChart(DCDrawContextOV dCDrawContextOV) {
        super(dCDrawContextOV);
        this.init(dCDrawContextOV);
    }

    @Override
    protected void init(DCDrawContextOV dCDrawContextOV) {
        super.init(dCDrawContextOV);
        this.m_dialManipulator = new DialManipulator();
        this.m_dialManipulator.addComponentExceptionListener((ComponentExceptionListener)this);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_useRoundedDialFace = false;
        this.m_showAnnotations = false;
        this.m_needleValues = null;
        this.m_needleLabels = null;
        this.m_dataSeriesIndex = null;
        this.m_dataColorByValueIndex = null;
        this.m_currentAxisIndex = 0;
        this.m_needleHeightSum = 0.0;
        this.m_propChartGauge = null;
        this.m_propGaugeDial = null;
        this.m_propGaugePivot = null;
        this.m_annotation = null;
        this.m_dialManipulator = null;
        this.m_axes = null;
        this.m_legendItems = null;
        this.m_noSeries = false;
    }

    @Override
    public void applyProperties() {
        super.applyProperties();
        this.setViewportTo3D();
        this.getProperties();
        this.addChartData();
        this.getProperties();
        this.createChart();
        this.populateLegend();
        this.applyChartProperties();
    }

    private void addChartData() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = -1;
        Object[] objectArray = this.m_pData.getGridColumns();
        int n6 = this.m_pData.getSeriesCount(0);
        this.m_needleValues = new Object[n6];
        this.m_dataSeriesIndex = new int[n6];
        this.m_dataColorByValueIndex = new int[n6];
        int n7 = 0;
        int n8 = 0;
        for (n4 = 0; n4 < this.m_pData.getGridColumnCount(); ++n4) {
            n3 = this.m_pData.getGridColumnType(n4);
            if (n3 == 4) {
                if (n5 > -1) {
                    this.m_needleLabels = (Object[])objectArray[n5];
                }
                this.m_needleValues[n7] = (double[])objectArray[n4];
                this.m_dataSeriesIndex[n7] = n4;
                ++n7;
                continue;
            }
            if (n3 == 10) {
                this.m_dataColorByValueIndex[n8] = n4;
                ++n8;
                continue;
            }
            if (n3 != 1) continue;
            this.m_legendItems = (Object[])this.m_pData.getGridColumns()[n4];
            n5 = n4;
        }
        if (n7 == 1 && this.m_legendItems == null) {
            this.m_legendItems = new Object[1];
            this.m_legendItems[0] = this.m_pData.getAxisTitle(0);
            this.m_noSeries = true;
        }
        n4 = this.m_dataSeriesIndex.length > 0 ? ((double[])objectArray[this.m_dataSeriesIndex[0]]).length : 0;
        for (n3 = 0; n3 < this.m_dataSeriesIndex.length; ++n3) {
            n2 = this.m_dataSeriesIndex[n3];
            for (n = 0; n < n4; ++n) {
                double d = ((double[])objectArray[n2])[n];
                String string = this.m_pWidget.getDataValueAsString(n, n2, d, CGSWidget.DataTableId.eDataTableDefault);
                this.m_pData.addFormattedValueToCell(n, n2, string);
            }
        }
        for (n3 = 0; n3 < this.m_dataColorByValueIndex.length; ++n3) {
            n2 = this.m_dataColorByValueIndex[n3];
            n = this.m_dataSeriesIndex[n3];
            for (int i = 0; i < n4; ++i) {
                int n9 = this.m_pData.getTableColumnIndex(i, n2);
                if (n9 < 0 || n9 >= this.m_pData.getOriginalColumns().size()) continue;
                double d = ((double[])objectArray[n2])[i];
                String string = this.m_pWidget.getDataValueAsString(i, n2, d, CGSWidget.DataTableId.eDataTableDefault);
                this.m_pData.addFormattedValueToCell(i, n, n9, string);
            }
        }
    }

    protected void getProperties() {
        this.m_propChartGauge = (CGSPropChartGauge)this.getChart();
        this.m_propGaugeDial = (CGSPropGaugeDial)this.m_propChartGauge.getProp(CGSEnums.PropType.ePropGaugeDial);
        this.m_propGaugePivot = (CGSPropGaugePivot)this.m_propChartGauge.getProp(CGSEnums.PropType.ePropGaugePivot);
    }

    public void createChart() {
        double d;
        double d2;
        RoundedEdgeDialFace roundedEdgeDialFace;
        if (this.m_propChartGauge.getStartAngle() != 0.0 || this.m_propChartGauge.getEndAngle() != 360.0) {
            this.m_useRoundedDialFace = true;
        }
        if (this.m_useRoundedDialFace) {
            roundedEdgeDialFace = new RoundedEdgeDialFace();
            roundedEdgeDialFace.addComponentExceptionListener((ComponentExceptionListener)this);
            double d3 = this.m_propChartGauge.getStartAngle() % 360.0;
            d2 = this.m_propChartGauge.getEndAngle() % 360.0;
            d = d3 - d2;
            roundedEdgeDialFace.setDialStartAngle(d3);
            roundedEdgeDialFace.setDialEndAngle(d2);
            if (d <= -270.0 || d <= 90.0 && d >= 0.0) {
                roundedEdgeDialFace.setPivotPointRadius(0.0);
            } else {
                roundedEdgeDialFace.setPivotPointRadius(this.getAdjustedValue(this.m_propChartGauge.getPivotPointRadius()));
            }
            this.setSurfaceFaceFillEffect((ISurfaceFaceAttributeSceneNode)roundedEdgeDialFace.getDialBackground(), false);
            this.setDialFaceBorderProperites(roundedEdgeDialFace);
            this.m_dialManipulator.setDialFace((IDialFace)roundedEdgeDialFace);
        } else {
            roundedEdgeDialFace = new DialFaceSector();
            roundedEdgeDialFace.addComponentExceptionListener((ComponentExceptionListener)this);
            CircularDialFace circularDialFace = new CircularDialFace();
            circularDialFace.addComponentExceptionListener((ComponentExceptionListener)this);
            this.setDialFaceBorderProperties(circularDialFace);
            this.setSurfaceFaceFillEffect((ISurfaceFaceAttributeSceneNode)roundedEdgeDialFace, false);
            circularDialFace.getDialSectors().addSector((DialFace.DialFaceSector)roundedEdgeDialFace);
            this.m_dialManipulator.setDialFace((IDialFace)circularDialFace);
        }
        int n = ((CGSPropWidgetChartGauge)this.m_pBaseProp).getGaugeRangeAxisBCount();
        this.m_axes = new DialNumericAxis[n];
        for (int i = 0; i < n; ++i) {
            double d4;
            double d5;
            double d6;
            CGSPropGaugeRangeAxisB cGSPropGaugeRangeAxisB = ((CGSPropWidgetChartGauge)this.m_pBaseProp).getGaugeRangeAxisB(i);
            d2 = -1.0;
            d = 1.0;
            if (this.m_needleValues.length > i) {
                double[] dArray = this.calculateAxis(cGSPropGaugeRangeAxisB, (double[])this.m_needleValues[i]);
                d2 = dArray[0];
                d = dArray[1];
            }
            if ((d6 = cGSPropGaugeRangeAxisB.getManualIntervalValue()) > 0.0 && d6 < d && (d5 = (d - d2) % d6) > 0.0 && (d4 = Math.ceil((d - d2) / d6)) > 0.0) {
                d = d2 + d6 * d4;
            }
            LinearAxisMap linearAxisMap = new LinearAxisMap();
            linearAxisMap.addComponentExceptionListener((ComponentExceptionListener)this);
            linearAxisMap.setStartValue((Object)d2);
            linearAxisMap.setEndValue((Object)d);
            this.m_axes[i] = new DialNumericAxis();
            this.m_axes[i].addComponentExceptionListener((ComponentExceptionListener)this);
            this.setAxisProperties(cGSPropGaugeRangeAxisB, this.m_axes[i], this.m_dialManipulator, linearAxisMap);
            this.setAxisTitleProperties(this.m_axes[i], cGSPropGaugeRangeAxisB, i);
            this.setAxisFontProperties(this.m_axes[i], cGSPropGaugeRangeAxisB);
            this.setAxisAxleProperties(this.m_axes[i], cGSPropGaugeRangeAxisB);
            this.setAxisTickMarkProperties(this.m_axes[i], cGSPropGaugeRangeAxisB, d2, d);
            this.setAxisColorBarProperties(this.m_axes[i], cGSPropGaugeRangeAxisB, d2, d);
            this.m_dialManipulator.getDialAxes().addDialAxis((IDialAxis)this.m_axes[i]);
            if (this.m_needleValues.length <= i) continue;
            this.addNeedlesToAxis(cGSPropGaugeRangeAxisB, this.m_axes[i], (double[])this.m_needleValues[i], this.m_needleLabels, i);
        }
        this.setPivotPointProperties(this.m_dialManipulator);
    }

    private void addNeedlesToAxis(CGSPropGaugeRangeAxisB cGSPropGaugeRangeAxisB, DialNumericAxis dialNumericAxis, double[] dArray, Object[] objectArray, int n) {
        if (this.m_showAnnotations) {
            this.m_annotation = new Annotation();
            this.m_annotation.addComponentExceptionListener((ComponentExceptionListener)this);
            this.m_annotation.getTextAttributes().setTextHorizontalAlignment(TextHorizontalAlignmentEnum.CENTER);
        }
        double d = 1.4;
        double d2 = Math.PI / 180;
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                DialNeedle dialNeedle = this.addDialNeedle(dArray, i, dialNumericAxis, cGSPropGaugeRangeAxisB, n);
                if (!this.m_showAnnotations) continue;
                double d3 = dialNeedle.getAngle() * d2;
                this.m_annotation.newText("Product: " + objectArray[i] + "<br/>Value: " + dArray[i], d * Math.cos(d3), d * Math.sin(d3), 0.0);
            }
        }
    }

    private void setAxisProperties(CGSPropGaugeRangeAxisB cGSPropGaugeRangeAxisB, DialNumericAxis dialNumericAxis, DialManipulator dialManipulator, LinearAxisMap linearAxisMap) {
        double d;
        dialNumericAxis.connectInputValueAxisMap((IAxisMapSource)linearAxisMap.getOutputAxisMap());
        dialNumericAxis.getNumericStyle().setLabelFormat(AxisLabelFormatEnum.AUTO_FORMAT_NO_EXPONENTS);
        dialNumericAxis.setInnerRadius(Double.valueOf(this.getAdjustedValue(cGSPropGaugeRangeAxisB.getGaugeAxisInnerRadius())));
        dialNumericAxis.setOuterRadius(Double.valueOf(this.getAdjustedValue(cGSPropGaugeRangeAxisB.getGaugeAxisOuterRadius())));
        this.applyAxisLabelFormattingProperties((CGSProp)cGSPropGaugeRangeAxisB, (IDialNumericAxis)dialNumericAxis);
        double d2 = 0.0;
        double d3 = cGSPropGaugeRangeAxisB.getGaugeAxisStartAngle();
        if (d3 > 360.0) {
            d3 %= 360.0;
        }
        if ((d = cGSPropGaugeRangeAxisB.getGaugeAxisEndAngle()) > 360.0) {
            d %= 360.0;
        }
        if (cGSPropGaugeRangeAxisB.getGaugeAxisDirection() == CGSPropGaugeRangeAxisB.GaugeAxisDirectionB.eGaugeAxisDirectionClockwise) {
            dialNumericAxis.setAxisDirection(DialAxisDirectionEnum.CLOCKWISE);
            d2 = d3 - d;
            if (d2 == 0.0) {
                d3 -= 0.01;
            }
            dialNumericAxis.setStartAngle(Double.valueOf(d));
            dialNumericAxis.setEndAngle(Double.valueOf(d3));
        } else if (cGSPropGaugeRangeAxisB.getGaugeAxisDirection() == CGSPropGaugeRangeAxisB.GaugeAxisDirectionB.eGaugeAxisDirectionCounterClockwise) {
            dialNumericAxis.setAxisDirection(DialAxisDirectionEnum.COUNTERCLOCKWISE);
            d2 = d - d3;
            if (d2 == 0.0) {
                d -= 0.01;
            }
            dialNumericAxis.setStartAngle(Double.valueOf(d3));
            dialNumericAxis.setEndAngle(Double.valueOf(d));
        } else {
            CMHelper.CGS_ASSERT(false, "Invalid axis direction.");
        }
        if (d2 == 0.0) {
            dialNumericAxis.getLabels().setEnds(AxisElementEndsEnum.SUPPRESS_FIRST);
        }
        dialNumericAxis.setAxisJustification(this.getTextJustification(cGSPropGaugeRangeAxisB.getGaugeAxisJustification()));
        dialNumericAxis.getText().setJustification(this.getTextJustification(cGSPropGaugeRangeAxisB.getGaugeAxisTitleJustification()));
        dialNumericAxis.setLabelTextOrientation(this.getTextOrientation(cGSPropGaugeRangeAxisB.getGaugeAxisTextOrientation()));
        dialNumericAxis.setTitleTextOrientation(this.getTextOrientation(cGSPropGaugeRangeAxisB.getGaugeAxisTitleOrientation()));
        dialNumericAxis.setAxisFittingMode(DialAxisFittingModeEnum.ALL_EXCEPT_UNIT_AND_TITLE);
    }

    private DialAxisJustificationEnum getTextJustification(CGSPropGaugeRangeAxisB.GaugeAxisJustificationB gaugeAxisJustificationB) {
        DialAxisJustificationEnum dialAxisJustificationEnum = DialAxisJustificationEnum.INSIDE;
        if (gaugeAxisJustificationB == CGSPropGaugeRangeAxisB.GaugeAxisJustificationB.eGaugeAxisJustificationInside) {
            dialAxisJustificationEnum = DialAxisJustificationEnum.INSIDE;
        } else if (gaugeAxisJustificationB == CGSPropGaugeRangeAxisB.GaugeAxisJustificationB.eGaugeAxisJustificationOutside) {
            dialAxisJustificationEnum = DialAxisJustificationEnum.OUTSIDE;
        } else {
            CMHelper.CGS_ASSERT(false, "Invalid axis text justification.");
        }
        return dialAxisJustificationEnum;
    }

    private DialAxisTextOrientationEnum getTextOrientation(CGSPropGaugeRangeAxisB.GaugeAxisTextOrientationB gaugeAxisTextOrientationB) {
        DialAxisTextOrientationEnum dialAxisTextOrientationEnum = DialAxisTextOrientationEnum.UPRIGHT;
        if (gaugeAxisTextOrientationB == CGSPropGaugeRangeAxisB.GaugeAxisTextOrientationB.eGaugeAxisTextOrientationPerpendicularInwardB) {
            dialAxisTextOrientationEnum = DialAxisTextOrientationEnum.PERPENDICULAR_INWARD;
        } else if (gaugeAxisTextOrientationB == CGSPropGaugeRangeAxisB.GaugeAxisTextOrientationB.eGaugeAxisTextOrientationPerpendicularOutwardB) {
            dialAxisTextOrientationEnum = DialAxisTextOrientationEnum.PERPENDICULAR_OUTWARD;
        } else if (gaugeAxisTextOrientationB == CGSPropGaugeRangeAxisB.GaugeAxisTextOrientationB.eGaugeAxisTextOrientationTangentialClockwiseB) {
            dialAxisTextOrientationEnum = DialAxisTextOrientationEnum.TANGENTIAL_CLOCKWISE;
        } else if (gaugeAxisTextOrientationB == CGSPropGaugeRangeAxisB.GaugeAxisTextOrientationB.eGaugeAxisTextOrientationTangentialCounterClockwiseB) {
            dialAxisTextOrientationEnum = DialAxisTextOrientationEnum.TANGENTIAL_COUNTERCLOCKWISE;
        } else if (gaugeAxisTextOrientationB == CGSPropGaugeRangeAxisB.GaugeAxisTextOrientationB.eGaugeAxisTextOrientationUprightB) {
            dialAxisTextOrientationEnum = DialAxisTextOrientationEnum.UPRIGHT;
        } else {
            CMHelper.CGS_ASSERT(false, "Invalid axis text orientation.");
        }
        return dialAxisTextOrientationEnum;
    }

    public void applyChartProperties() {
        super.applyProperties();
    }

    private void setAxisColorBarProperties(DialNumericAxis dialNumericAxis, CGSPropGaugeRangeAxisB cGSPropGaugeRangeAxisB, double d, double d2) {
        CGSPropPaletteContinuousB cGSPropPaletteContinuousB = (CGSPropPaletteContinuousB)cGSPropGaugeRangeAxisB.getProp(CGSEnums.PropType.ePropPaletteContinuousB);
        int n = cGSPropPaletteContinuousB.getPaletteContinuousItemBCount();
        double[] dArray = new double[n];
        Color[] colorArray = new Color[100];
        CGSTypeFillEffect cGSTypeFillEffect = new CGSTypeFillEffect();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Color color = cGSPropPaletteContinuousB.getPaletteContinuousItemB(i % n).getColor();
                dArray[i] = cGSPropPaletteContinuousB.getPaletteContinuousItemB(i % n).getValue();
                cGSTypeFillEffect.addGradient(color, dArray[i]);
                if (i <= 0) continue;
                CMHelper.CGS_ASSERT(dArray[i] >= dArray[i - 1], "Palette entries must be in ascending order");
            }
            double d3 = 0.0;
            for (int i = 0; i < 100; ++i) {
                colorArray[i] = cGSTypeFillEffect.getGradientColor(d3);
                d3 += 0.01;
            }
            double d4 = dArray[0] / 100.0 * (d2 - d) + d;
            double d5 = dArray[n - 1] / 100.0 * (d2 - d) + d;
            dialNumericAxis.getDialColorBar().setStartValue((Object)d4);
            dialNumericAxis.getDialColorBar().setEndValue((Object)d5);
            dialNumericAxis.getDialColorBar().setLinearColorInterpolation(LinearColorInterpolationEnum.RGB);
            dialNumericAxis.getDialColorBar().setPaletteColors(colorArray);
        }
    }

    private void setAxisAxleProperties(DialNumericAxis dialNumericAxis, CGSPropGaugeRangeAxisB cGSPropGaugeRangeAxisB) {
        CGSPropLine cGSPropLine = (CGSPropLine)cGSPropGaugeRangeAxisB.getProp(CGSEnums.PropType.ePropAxisLine);
        if (cGSPropLine.getVisible()) {
            dialNumericAxis.getAxle().setElement(AxisElementStatusEnum.INCLUDE);
            dialNumericAxis.getAxle().setWidth(cGSPropLine.getWeight());
            dialNumericAxis.getAxle().setColor(cGSPropLine.getColor());
            dialNumericAxis.getAxle().setStyle(cGSPropLine.getStyleB().ordinal());
        } else {
            dialNumericAxis.getAxle().setElement(AxisElementStatusEnum.EXCLUDE);
        }
    }

    private void setAxisTickMarkProperties(DialNumericAxis dialNumericAxis, CGSPropGaugeRangeAxisB cGSPropGaugeRangeAxisB, double d, double d2) {
        CGSPropMajorGridLine cGSPropMajorGridLine = (CGSPropMajorGridLine)cGSPropGaugeRangeAxisB.getProp(CGSEnums.PropType.ePropMajorGridLine);
        CGSPropMinorGridLine cGSPropMinorGridLine = (CGSPropMinorGridLine)cGSPropGaugeRangeAxisB.getProp(CGSEnums.PropType.ePropMinorGridLine);
        if (cGSPropMajorGridLine.getVisible()) {
            double d3;
            double d4 = cGSPropGaugeRangeAxisB.getManualIntervalValue();
            double d5 = d4 = d4 < (d3 = d2 - d) ? d4 : d3;
            if (cGSPropGaugeRangeAxisB.getUseManualInterval() && d4 > 0.0) {
                if (d3 / d4 > (double)this.MAX_MAJOR_GRID_INTERVALS) {
                    d4 = d2 / (double)this.MAX_MAJOR_GRID_INTERVALS;
                }
                dialNumericAxis.getLinearStyle().setMajorTickMarkStep(d4);
                dialNumericAxis.getLinearStyle().setMajorTickMarkLayout(AxisMajorTickMarkLayoutEnum.START_LIMIT_END_LIMIT);
                dialNumericAxis.setScaleResolution(AxisScaleResolutionEnum.COARSE);
            }
            dialNumericAxis.getMajorTickMarks().setElement(AxisElementStatusEnum.INCLUDE);
            dialNumericAxis.getMajorTickMarks().setColor(cGSPropMajorGridLine.getColor());
            dialNumericAxis.getMajorTickMarks().setWidth(cGSPropMajorGridLine.getWeight());
            dialNumericAxis.getMajorTickMarks().setLength(this.getAdjustedValue(cGSPropMajorGridLine.getLength()));
            dialNumericAxis.getMajorTickMarks().setStyle(cGSPropMajorGridLine.getStyleB().ordinal());
        } else {
            dialNumericAxis.getMajorTickMarks().setElement(AxisElementStatusEnum.EXCLUDE);
        }
        if (cGSPropMinorGridLine.getVisible()) {
            dialNumericAxis.getMinorTickMarks().setElement(AxisElementStatusEnum.INCLUDE);
            dialNumericAxis.getMinorTickMarks().setColor(cGSPropMinorGridLine.getColor());
            dialNumericAxis.getMinorTickMarks().setWidth(cGSPropMinorGridLine.getWeight());
            dialNumericAxis.getMinorTickMarks().setLength(this.getAdjustedValue(cGSPropMinorGridLine.getLength()));
            dialNumericAxis.getMinorTickMarks().setFrequency(cGSPropMinorGridLine.getNumberOfLines());
            dialNumericAxis.getMinorTickMarks().setStyle(cGSPropMinorGridLine.getStyleB().ordinal());
        }
    }

    private void setSurfaceFaceFillEffect(ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode, boolean bl) {
        iSurfaceFaceAttributeSceneNode.getSurfaceAttributes().setSurfaceLighting(false);
        if (bl || this.m_propGaugeDial.getFillEffect().getType() == CGSEnums.FillType.eFillPattern && this.m_propGaugeDial.getFillEffect().getPatternType() == CGSEnums.PatternType.ePatternNone) {
            CGSTypeFillEffect cGSTypeFillEffect = new CGSTypeFillEffect();
            cGSTypeFillEffect.setSolidColor(new Color(255, 255, 255, 0));
            this.applyFillEffect(cGSTypeFillEffect, iSurfaceFaceAttributeSceneNode);
        } else {
            this.applyFillEffect(this.m_propGaugeDial.getFillEffect(), iSurfaceFaceAttributeSceneNode);
        }
    }

    private void setDialFaceBorderProperites(RoundedEdgeDialFace roundedEdgeDialFace) {
        roundedEdgeDialFace.getDialBorder().setVisible(this.m_propGaugeDial.getShowBorder());
        roundedEdgeDialFace.getSurfaceAttributes().setSurfaceColor(this.m_propGaugeDial.getBorderColor());
        double d = this.getAdjustedValue(this.m_propGaugeDial.getBorderHeight(), 0.0, 0.5);
        roundedEdgeDialFace.getDialBorder().setHeight(d);
        roundedEdgeDialFace.getDialBorder().setBevelRadius(this.getAdjustedValue(this.m_propGaugeDial.getBevelRadius(), 0.0, d));
        switch (this.m_propGaugeDial.getBorderWidthB()) {
            case eBorderWidthDeepB: {
                roundedEdgeDialFace.getDialBorder().setWidth(DialFaceBorderWidthEnum.DEEP);
                break;
            }
            case eBorderWidthLineB: {
                roundedEdgeDialFace.getDialBorder().setWidth(DialFaceBorderWidthEnum.LINE);
                break;
            }
            case eBorderWidthShallowB: {
                roundedEdgeDialFace.getDialBorder().setWidth(DialFaceBorderWidthEnum.SHALLOW);
                break;
            }
            default: {
                CMHelper.CGS_ASSERT(false, "Invalid border width.");
            }
        }
        switch (this.m_propGaugeDial.getBevelStyle()) {
            case eBevelStyleConcave: {
                roundedEdgeDialFace.getDialBorder().setBevelStyle(DialBevelStyleEnum.CONCAVE);
                break;
            }
            case eBevelStyleConvex: {
                roundedEdgeDialFace.getDialBorder().setBevelStyle(DialBevelStyleEnum.CONVEX);
                break;
            }
            case eBevelStyleFlat: {
                roundedEdgeDialFace.getDialBorder().setBevelStyle(DialBevelStyleEnum.FLAT);
                break;
            }
            case eBevelStyleRound: {
                roundedEdgeDialFace.getDialBorder().setBevelStyle(DialBevelStyleEnum.ROUND);
                break;
            }
            default: {
                CMHelper.CGS_ASSERT(false, "Invalid bevel type.");
            }
        }
    }

    private void setDialFaceBorderProperties(CircularDialFace circularDialFace) {
        circularDialFace.getDialBorder().setVisible(this.m_propGaugeDial.getShowBorder());
        circularDialFace.getSurfaceAttributes().setSurfaceColor(this.m_propGaugeDial.getBorderColor());
        double d = this.getAdjustedValue(this.m_propGaugeDial.getBorderHeight(), 0.0, 0.5);
        circularDialFace.getDialBorder().setHeight(d);
        circularDialFace.getDialBorder().setBevelRadius(this.getAdjustedValue(this.m_propGaugeDial.getBevelRadius(), 0.0, d));
        switch (this.m_propGaugeDial.getBorderWidthB()) {
            case eBorderWidthDeepB: {
                circularDialFace.getDialBorder().setWidth(DialFaceBorderWidthEnum.DEEP);
                break;
            }
            case eBorderWidthLineB: {
                circularDialFace.getDialBorder().setWidth(DialFaceBorderWidthEnum.LINE);
                break;
            }
            case eBorderWidthShallowB: {
                circularDialFace.getDialBorder().setWidth(DialFaceBorderWidthEnum.SHALLOW);
                break;
            }
            default: {
                CMHelper.CGS_ASSERT(false, "Invalid border width.");
            }
        }
        switch (this.m_propGaugeDial.getBevelStyle()) {
            case eBevelStyleConcave: {
                circularDialFace.getDialBorder().setBevelStyle(DialBevelStyleEnum.CONCAVE);
                break;
            }
            case eBevelStyleConvex: {
                circularDialFace.getDialBorder().setBevelStyle(DialBevelStyleEnum.CONVEX);
                break;
            }
            case eBevelStyleFlat: {
                circularDialFace.getDialBorder().setBevelStyle(DialBevelStyleEnum.FLAT);
                break;
            }
            case eBevelStyleRound: {
                circularDialFace.getDialBorder().setBevelStyle(DialBevelStyleEnum.ROUND);
                break;
            }
            default: {
                CMHelper.CGS_ASSERT(false, "Invalid bevel type.");
            }
        }
    }

    private void setAxisFontProperties(DialNumericAxis dialNumericAxis, CGSPropGaugeRangeAxisB cGSPropGaugeRangeAxisB) {
        CGSPropTickLabel cGSPropTickLabel = (CGSPropTickLabel)cGSPropGaugeRangeAxisB.getProp(CGSEnums.PropType.ePropTickLabelNumeric);
        CGSPropFont cGSPropFont = (CGSPropFont)cGSPropTickLabel.getProp(CGSEnums.PropType.ePropFont);
        if (!this.m_pDrawContext.getOutputDevice().isRaster() && !this.m_pDrawContext.getOutputDevice().isSVG()) {
            dialNumericAxis.getTextAttributes().setTextMode(TextModeEnum.BILLBOARD);
            dialNumericAxis.getTextAttributes().setBillboardTextSizeMode(BillboardTextSizeModeEnum.TEXT_SCALE);
        }
        dialNumericAxis.getLabels().setFiltering(LabelFilteringEnum.ALL);
        dialNumericAxis.getLabels().setTextColor(cGSPropFont.getColor());
        dialNumericAxis.getLabels().setFontFamily(cGSPropFont.getFaceName());
        dialNumericAxis.setMinimumFontSize(0.05);
        dialNumericAxis.setMaximumFontSize(0.2);
        if (!cGSPropFont.getAutoSize() && !this.m_pDrawContext.forceAutoFontSize()) {
            dialNumericAxis.getLabels().setSize(cGSPropFont.getSize() / 100.0);
        }
        if (cGSPropFont.getStyle() == CGSPropFont.Style.eStyleBold) {
            dialNumericAxis.getLabels().setFontWeight(FontWeightEnum.BOLD);
        } else if (cGSPropFont.getStyle() == CGSPropFont.Style.eStyleItalic) {
            dialNumericAxis.getLabels().setFontStyle(FontStyleEnum.ITALIC);
        } else if (cGSPropFont.getStyle() == CGSPropFont.Style.eStyleBoldItalic) {
            dialNumericAxis.getLabels().setFontWeight(FontWeightEnum.BOLD);
            dialNumericAxis.getLabels().setFontStyle(FontStyleEnum.ITALIC);
        }
        if (!cGSPropTickLabel.getVisible()) {
            dialNumericAxis.getLabels().setElement(AxisElementStatusEnum.EXCLUDE);
        }
    }

    private void setAxisTitleProperties(DialNumericAxis dialNumericAxis, CGSPropGaugeRangeAxisB cGSPropGaugeRangeAxisB, int n) {
        CGSPropTitle cGSPropTitle = (CGSPropTitle)cGSPropGaugeRangeAxisB.getProp(CGSEnums.PropType.ePropTitle);
        CGSPropFont cGSPropFont = (CGSPropFont)cGSPropTitle.getProp(CGSEnums.PropType.ePropFont);
        if (!cGSPropTitle.getVisible()) {
            return;
        }
        dialNumericAxis.getText().setTextColor(cGSPropFont.getColor());
        dialNumericAxis.getText().setFontFamily(cGSPropFont.getFaceName());
        dialNumericAxis.setMinimumFontSize(0.05);
        dialNumericAxis.setMaximumFontSize(0.2);
        if (!cGSPropFont.getAutoSize() && !this.m_pDrawContext.forceAutoFontSize()) {
            dialNumericAxis.getText().setSize(cGSPropFont.getSize() / 100.0);
        }
        if (cGSPropFont.getStyle() == CGSPropFont.Style.eStyleBold) {
            dialNumericAxis.getText().setFontWeight(FontWeightEnum.BOLD);
        } else if (cGSPropFont.getStyle() == CGSPropFont.Style.eStyleItalic) {
            dialNumericAxis.getText().setFontStyle(FontStyleEnum.ITALIC);
        } else if (cGSPropFont.getStyle() == CGSPropFont.Style.eStyleBoldItalic) {
            dialNumericAxis.getText().setFontWeight(FontWeightEnum.BOLD);
            dialNumericAxis.getText().setFontStyle(FontStyleEnum.ITALIC);
        }
        CGSPropAxisTitleB cGSPropAxisTitleB = (CGSPropAxisTitleB)this.m_pWidget.getBaseProp().findProp(CGSEnums.PropType.ePropAxisTitleB);
        String string = cGSPropAxisTitleB.getLabel();
        CGSPropFont cGSPropFont2 = (CGSPropFont)cGSPropAxisTitleB.findProp(CGSEnums.PropType.ePropFont);
        cGSPropFont2.copy(cGSPropFont);
        dialNumericAxis.getText().setImageMapTemplate("[" + CGSEnums.DetArea.eDetNumericAxisTitle.getValue() + " " + CGSWidget.DataType.eRange.getValue() + " " + -3 + " " + string + "]");
    }

    private DialNeedle addDialNeedle(double[] dArray, int n, DialNumericAxis dialNumericAxis, CGSPropGaugeRangeAxisB cGSPropGaugeRangeAxisB, int n2) {
        CGSPropGaugeNeedlesB cGSPropGaugeNeedlesB = (CGSPropGaugeNeedlesB)cGSPropGaugeRangeAxisB.getProp(CGSEnums.PropType.ePropGaugeNeedlesB);
        DialNeedle dialNeedle = null;
        if (!Double.isNaN(dArray[n])) {
            dialNeedle = new DialNeedle();
            dialNeedle.addComponentExceptionListener((ComponentExceptionListener)this);
            double d = this.getAdjustedValue(cGSPropGaugeNeedlesB.getNeedleHeight(), 0.0, 0.05);
            this.m_needleHeightSum += d;
            dialNeedle.setNeedleHeight(d);
            dialNeedle.setNeedleHeadLengthScale(this.getAdjustedValue(cGSPropGaugeNeedlesB.getNeedleHeadLength()));
            dialNeedle.setNeedleHeadWidthScale(this.getAdjustedValue(cGSPropGaugeNeedlesB.getNeedleHeadWidth()));
            dialNeedle.setNeedlePivotPointWidthScale(Double.valueOf(this.getAdjustedValue(cGSPropGaugeNeedlesB.getNeedlePivotWidth())));
            dialNeedle.setNeedleTailWidthScale(this.getAdjustedValue(cGSPropGaugeNeedlesB.getNeedleTailWidth()));
            dialNeedle.setNeedleTailLengthScale(this.getAdjustedValue(cGSPropGaugeNeedlesB.getNeedleTailLength()));
            dialNeedle.setBevelRadius(this.getAdjustedValue(cGSPropGaugeNeedlesB.getNeedleBevelRadius(), 0.0, d));
            if (cGSPropGaugeNeedlesB.getNeedleHeadStyle() == CGSPropGaugeNeedlesB.NeedleStyleB.eNeedleStyleFlat) {
                dialNeedle.setNeedleHeadEndStyle(DialNeedleEndStyleEnum.FLAT);
            } else if (cGSPropGaugeNeedlesB.getNeedleHeadStyle() == CGSPropGaugeNeedlesB.NeedleStyleB.eNeedleStyleRound) {
                dialNeedle.setNeedleHeadEndStyle(DialNeedleEndStyleEnum.ROUND);
            } else if (cGSPropGaugeNeedlesB.getNeedleHeadStyle() == CGSPropGaugeNeedlesB.NeedleStyleB.eNeedleStyleTriangular) {
                dialNeedle.setNeedleHeadEndStyle(DialNeedleEndStyleEnum.TRIANGULAR);
            } else {
                CMHelper.CGS_ASSERT(false, "Invalid needle head style.");
            }
            if (cGSPropGaugeNeedlesB.getNeedleTailStyle() == CGSPropGaugeNeedlesB.NeedleStyleB.eNeedleStyleFlat) {
                dialNeedle.setNeedleTailEndStyle(DialNeedleEndStyleEnum.FLAT);
            } else if (cGSPropGaugeNeedlesB.getNeedleTailStyle() == CGSPropGaugeNeedlesB.NeedleStyleB.eNeedleStyleRound) {
                dialNeedle.setNeedleTailEndStyle(DialNeedleEndStyleEnum.ROUND);
            } else if (cGSPropGaugeNeedlesB.getNeedleTailStyle() == CGSPropGaugeNeedlesB.NeedleStyleB.eNeedleStyleTriangular) {
                dialNeedle.setNeedleTailEndStyle(DialNeedleEndStyleEnum.TRIANGULAR);
            } else {
                CMHelper.CGS_ASSERT(false, "Invalid needle tail style.");
            }
            if (cGSPropGaugeNeedlesB.getNeedleBevelStyle() == CGSPropGaugeNeedlesB.BevelStyleB.eBevelStyleConcaveB) {
                dialNeedle.setBevelStyle(DialBevelStyleEnum.CONCAVE);
            } else if (cGSPropGaugeNeedlesB.getNeedleBevelStyle() == CGSPropGaugeNeedlesB.BevelStyleB.eBevelStyleConvexB) {
                dialNeedle.setBevelStyle(DialBevelStyleEnum.CONVEX);
            } else if (cGSPropGaugeNeedlesB.getNeedleBevelStyle() == CGSPropGaugeNeedlesB.BevelStyleB.eBevelStyleFlatB) {
                dialNeedle.setBevelStyle(DialBevelStyleEnum.FLAT);
            } else if (cGSPropGaugeNeedlesB.getNeedleBevelStyle() == CGSPropGaugeNeedlesB.BevelStyleB.eBevelStyleRoundB) {
                dialNeedle.setBevelStyle(DialBevelStyleEnum.ROUND);
            } else {
                CMHelper.CGS_ASSERT(false, "Invalid needle bevel style.");
            }
            dialNeedle.setShowBorder(this.m_propChartGauge.getShowOutline());
            this.applyOutline(dialNeedle.getLineAttributes(), this.m_propChartGauge.getOutlineColor());
            dialNeedle.setValue((Object)new Double(dArray[n]));
            dialNumericAxis.getNeedles().addDialNeedle((IDialNeedle)dialNeedle);
            if (this.m_pWidget.isDetectionAreaRequired(CGSEnums.DetArea.eDetChartElement, 0)) {
                dialNeedle.getSceneNodeAttributes().setImageMapArea("[" + CGSEnums.DetArea.eDetChartElement.getValue() + " " + CGSWidget.DataType.eCategory.getValue() + " " + n2 + " " + n + " 0]");
            }
            OVHelper.applyMaterialEffect((IAttributeSceneNode)dialNeedle, this.m_propChartGauge.getMaterialEffect());
            return dialNeedle;
        }
        return dialNeedle;
    }

    private void setPivotPointProperties(DialManipulator dialManipulator) {
        CircularDialPivotPoint circularDialPivotPoint = new CircularDialPivotPoint();
        circularDialPivotPoint.addComponentExceptionListener((ComponentExceptionListener)this);
        circularDialPivotPoint.getSurfaceAttributes().setSurfaceColor(this.m_propGaugePivot.getColour());
        circularDialPivotPoint.setPivotPointRadius(this.getAdjustedValue(this.m_propGaugePivot.getRadius()));
        circularDialPivotPoint.setVisible(this.m_propGaugePivot.getVisible());
        double d = this.getAdjustedValue(this.m_propGaugePivot.getHeight(), this.m_needleHeightSum + 0.1, 1.0);
        circularDialPivotPoint.setPivotPointHeight(d);
        double d2 = this.getAdjustedValue(this.m_propGaugePivot.getBevelRadius(), 0.0, d);
        if (this.m_propGaugePivot.getBevelStyle() == CGSPropGaugePivot.BevelStyleB.eBevelStyleConvexB) {
            d2 /= 2.0;
        }
        circularDialPivotPoint.setBevelRadius(d2);
        switch (this.m_propGaugePivot.getBevelStyle()) {
            case eBevelStyleConcaveB: {
                circularDialPivotPoint.setBevelStyle(DialBevelStyleEnum.CONVEX);
                break;
            }
            case eBevelStyleConvexB: {
                circularDialPivotPoint.setBevelStyle(DialBevelStyleEnum.CONCAVE);
                break;
            }
            case eBevelStyleFlatB: {
                circularDialPivotPoint.setBevelStyle(DialBevelStyleEnum.ROUND);
                break;
            }
            case eBevelStyleRoundB: {
                circularDialPivotPoint.setBevelStyle(DialBevelStyleEnum.FLAT);
                break;
            }
            default: {
                CMHelper.CGS_ASSERT(false, "Invalid bevel style.");
            }
        }
        dialManipulator.setDialPivotPoint((IDialPivotPoint)circularDialPivotPoint);
    }

    private double[] calculateAxis(CGSPropGaugeRangeAxisB cGSPropGaugeRangeAxisB, double[] dArray) {
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        double[] dArray2 = null;
        if (dArray == null) {
            d = -1.0;
            d2 = 1.0;
        } else {
            double d3 = Double.MAX_VALUE;
            double d4 = Double.MIN_VALUE;
            for (int i = 0; i < dArray.length; ++i) {
                if (Double.isNaN(dArray[i])) continue;
                d3 = Math.min(d3, dArray[i]);
                d4 = Math.max(d4, dArray[i]);
            }
            if (cGSPropGaugeRangeAxisB.getIncludeZero() && d3 > 0.0) {
                d3 = 0.0;
            }
            if (cGSPropGaugeRangeAxisB.getIncludeZero() && d4 < 0.0) {
                d4 = 0.0;
            }
            dArray2 = CMAxisCalculator.calculateNumericAxisScale(d3, d4, 5);
            d2 = cGSPropGaugeRangeAxisB.getUseManualMax() ? cGSPropGaugeRangeAxisB.getManualMaxValue() : dArray2[dArray2.length - 1];
            d = cGSPropGaugeRangeAxisB.getUseManualMin() ? cGSPropGaugeRangeAxisB.getManualMinValue() : dArray2[0];
        }
        double[] dArray3 = new double[]{d, d2};
        return dArray3;
    }

    @Override
    protected void populateViewport() {
        if (this.m_dialManipulator == null) {
            return;
        }
        this.createViewport();
        this.m_ovViewport.setObliqueProjectionVector(new PointFloat2(0.0f, 0.0f));
        this.m_ovViewport.setMaintainAspectRatio(true);
        this.m_dialManipulator.setParent((ISceneNode)this.m_ovViewport);
        if (this.m_showAnnotations) {
            this.m_ovViewport.addChild((ISceneNode)this.m_annotation);
        }
        this.m_pDrawContext.getContainer().setCenter((IManageableComponentSceneNode)this.m_ovViewport);
    }

    protected void applyPaletteToNeedles() {
        int n = this.m_axes.length;
        for (int i = 0; i < n; ++i) {
            this.m_currentAxisIndex = i;
            if (i >= this.m_dataSeriesIndex.length) continue;
            Double[] doubleArray = null;
            DataMapInfo dataMapInfo = null;
            CGSTypeFillEffect cGSTypeFillEffect = null;
            boolean bl = this.useContinuousPalette();
            if (bl) {
                doubleArray = new Double[1];
                dataMapInfo = new DataMapInfo();
                dataMapInfo.addComponentExceptionListener((ComponentExceptionListener)this);
                dataMapInfo.connectInputDataMap(this.getContinuousColorMap(0));
                cGSTypeFillEffect = new CGSTypeFillEffect();
            }
            IDialNeedleCollection iDialNeedleCollection = this.m_axes[i].getNeedles();
            int n2 = iDialNeedleCollection.getNumOfNeedles();
            for (int j = 0; j < n2; ++j) {
                int n3;
                IDialNeedle iDialNeedle = iDialNeedleCollection.getDialNeedle(j);
                if (!(iDialNeedle instanceof ISurfaceFaceAttributeSceneNode)) continue;
                ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode = (ISurfaceFaceAttributeSceneNode)iDialNeedle;
                if (bl) {
                    n3 = this.m_dataColorByValueIndex[this.m_currentAxisIndex];
                    double[] dArray = (double[])this.m_pData.getGridColumns()[n3];
                    doubleArray[0] = dArray[j];
                    Color[] colorArray = (Color[])dataMapInfo.mapValue((Object)doubleArray);
                    cGSTypeFillEffect.setSolidColor(colorArray[0]);
                    this.applyFillEffect(cGSTypeFillEffect, iSurfaceFaceAttributeSceneNode, iDialNeedle.getInActivePart());
                    continue;
                }
                n3 = this.getNeedleGridIndex(i, j);
                this.applyPalette(n3, i, 0, iSurfaceFaceAttributeSceneNode, iDialNeedle.getInActivePart(), null);
            }
        }
    }

    private int getNeedleGridIndex(int n, int n2) {
        double[] dArray = (double[])this.m_needleValues[n];
        int n3 = -1;
        for (int i = 0; i < dArray.length; ++i) {
            if (!Double.isNaN(dArray[i])) {
                ++n3;
            }
            if (n3 != n2) continue;
            return i;
        }
        CMHelper.CGS_ASSERT(false, "invalid needle index");
        return 0;
    }

    @Override
    protected int getPaletteIndex(int n, int n2, int n3) {
        return n2;
    }

    @Override
    protected boolean useContinuousPalette() {
        CGSPropGaugeRangeAxisB cGSPropGaugeRangeAxisB = ((CGSPropWidgetChartGauge)this.m_pBaseProp).getGaugeRangeAxisB(this.m_currentAxisIndex);
        CGSPropGaugeNeedlesB cGSPropGaugeNeedlesB = (CGSPropGaugeNeedlesB)cGSPropGaugeRangeAxisB.getProp(CGSEnums.PropType.ePropGaugeNeedlesB);
        CGSPropPaletteContinuousB cGSPropPaletteContinuousB = (CGSPropPaletteContinuousB)cGSPropGaugeNeedlesB.getProp(CGSEnums.PropType.ePropPaletteContinuousB);
        return cGSPropPaletteContinuousB == null ? false : cGSPropPaletteContinuousB.getPaletteContinuousItemBCount() != 0;
    }

    @Override
    protected CGSPropPaletteDiscreteB getDiscretePalette() {
        CGSPropGaugeRangeAxisB cGSPropGaugeRangeAxisB = ((CGSPropWidgetChartGauge)this.m_pBaseProp).getGaugeRangeAxisB(this.m_currentAxisIndex);
        CGSPropGaugeNeedlesB cGSPropGaugeNeedlesB = (CGSPropGaugeNeedlesB)cGSPropGaugeRangeAxisB.getProp(CGSEnums.PropType.ePropGaugeNeedlesB);
        return (CGSPropPaletteDiscreteB)cGSPropGaugeNeedlesB.getProp(CGSEnums.PropType.ePropPaletteDiscreteB);
    }

    @Override
    protected CGSPropPaletteContinuousB getContinuousPalette() {
        CGSPropGaugeRangeAxisB cGSPropGaugeRangeAxisB = ((CGSPropWidgetChartGauge)this.m_pBaseProp).getGaugeRangeAxisB(this.m_currentAxisIndex);
        CGSPropGaugeNeedlesB cGSPropGaugeNeedlesB = (CGSPropGaugeNeedlesB)cGSPropGaugeRangeAxisB.getProp(CGSEnums.PropType.ePropGaugeNeedlesB);
        return (CGSPropPaletteContinuousB)cGSPropGaugeNeedlesB.getProp(CGSEnums.PropType.ePropPaletteContinuousB);
    }

    @Override
    public double getColorByValueDataMin(int n) {
        double d = Double.NaN;
        double d2 = Double.NaN;
        int n2 = this.m_dataColorByValueIndex[this.m_currentAxisIndex];
        double[] dArray = (double[])this.m_pData.getGridColumns()[n2];
        for (int i = 0; i < dArray.length; ++i) {
            d2 = dArray[i];
            if (Double.isNaN(d2)) continue;
            d = Double.isNaN(d) ? d2 : Math.min(d, d2);
        }
        return d;
    }

    @Override
    public double getColorByValueDataMax(int n) {
        double d = Double.NaN;
        double d2 = Double.NaN;
        int n2 = this.m_dataColorByValueIndex[this.m_currentAxisIndex];
        double[] dArray = (double[])this.m_pData.getGridColumns()[n2];
        for (int i = 0; i < dArray.length; ++i) {
            d2 = dArray[i];
            if (Double.isNaN(d2)) continue;
            d = Double.isNaN(d) ? d2 : Math.max(d, d2);
        }
        return d;
    }

    protected void populateLegend() {
        GRLegend gRLegend = this.m_pDrawContext.getLegend();
        if (gRLegend == null) {
            return;
        }
        int n = this.m_legendItems != null ? this.m_legendItems.length : 0;
        int n2 = this.m_pData.getSeriesCount(0);
        CGSWidget.DataType dataType = this.m_noSeries ? CGSWidget.DataType.eMeasure : CGSWidget.DataType.eSeries;
        int n3 = this.m_axes.length;
        for (int i = 0; i < n3; ++i) {
            this.m_currentAxisIndex = i;
            if (i >= this.m_dataSeriesIndex.length) continue;
            CGSPropGaugeRangeAxisB cGSPropGaugeRangeAxisB = ((CGSPropWidgetChartGauge)this.m_pBaseProp).getGaugeRangeAxisB(i);
            CGSPropTitle cGSPropTitle = (CGSPropTitle)cGSPropGaugeRangeAxisB.getProp(CGSEnums.PropType.ePropTitle);
            String string = cGSPropTitle.getLabel();
            if (this.useContinuousPalette()) {
                this.addContinuousLegendEntry(0, string, i);
                continue;
            }
            if (n2 > 1 && !string.equals("")) {
                gRLegend.addSubtitleItem(string);
            }
            double[] dArray = (double[])this.m_needleValues[i];
            for (int j = 0; j < n; ++j) {
                int n4;
                if (Double.isNaN(dArray[j])) continue;
                for (n4 = 0; n4 < this.m_pData.getRowCount() && (this.m_pData.getRow(n4).getCategoryIndex() != j || this.m_pData.getRow(n4).getSeriesIndex() != i); ++n4) {
                }
                GRLegendItemIcon gRLegendItemIcon = new GRLegendItemIcon();
                gRLegendItemIcon.dataPointShapeFill = this.getFillEffect(j, CGSEnums.PropType.ePropPaletteDiscreteB, true);
                gRLegendItemIcon.dataPointShapeB = CGSEnums.MarkerShapeB.eMarkerSquareB;
                gRLegendItemIcon.dataPointShapeOutlineColor = this.getOutlineColor(0);
                gRLegendItemIcon.materialEffect = this.m_propChartGauge.getMaterialEffect();
                boolean bl = this.m_pWidget.isDetectionAreaRequired(CGSEnums.DetArea.eDetLegendLabel, 0);
                gRLegend.addChartItem((String)this.m_legendItems[j], dataType, gRLegendItemIcon, n4, bl, i);
            }
        }
    }

    protected void addContinuousLegendEntry(int n, String string, int n2) {
        OVChart.ContinuousPaletteInfo continuousPaletteInfo = this.getContinuousPaletteInfo(n);
        Color[] colorArray = continuousPaletteInfo.m_colors;
        String[] stringArray = continuousPaletteInfo.m_labels;
        GRLegend gRLegend = this.m_pDrawContext.getLegend();
        if (gRLegend != null) {
            String string2 = this.m_pData.getColorByValueMeasure(n);
            String string3 = string.equals("") ? string2 : string + ", " + string2;
            gRLegend.addContinuousPaletteItem(string3, colorArray, stringArray, this.getOutlineColor(0), n2, null);
        }
    }

    @Override
    protected void postSceneTreeBuild() {
        super.postSceneTreeBuild();
        this.applyPaletteToNeedles();
    }

    private double getAdjustedValue(double d) {
        return this.getAdjustedValue(d, 0.0, 1.0);
    }

    private double getAdjustedValue(double d, double d2, double d3) {
        double d4 = d / 100.0 * (d3 - d2) + d2;
        d4 = Math.max(d4, d2);
        d4 = Math.min(d4, d3);
        return d4;
    }

    @Override
    protected Color getOutlineColor(int n) {
        return this.m_propChartGauge.getShowOutline() ? this.m_propChartGauge.getOutlineColor() : null;
    }
}

