/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.DrawContext;

import com.avs.openviz3.cognos.OpenVizGraphics2D;
import com.avs.openviz3.fw.PointFloat3;
import com.avs.openviz3.viewer.renderer.paint.HatchPaint;
import com.avs.openviz3.viewer.renderer.paint.SurfaceAttribute;
import com.ibm.cgsBus.Common.CMByteBuffer;
import com.ibm.cgsBus.Graphics.GRBufferedImage;
import com.ibm.cgsBus.Graphics.GRDeviceVector;
import com.ibm.cgsBus.Graphics.GRHelper;
import com.ibm.cgsBus.Graphics.GRPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.AttributedCharacterIterator;
import java.text.NumberFormat;
import java.util.Map;
import java.util.Vector;

public class OVVector
extends Graphics2D
implements OpenVizGraphics2D {
    protected int m_opCodeCount = 0;
    protected String m_tagText = null;
    protected Font m_font = null;
    protected Color m_color = Color.BLACK;
    protected FontRenderContext m_fontContext = new FontRenderContext(null, true, true);
    protected AffineTransform m_transform = new AffineTransform();
    protected RenderingHints m_hints = new RenderingHints(null);
    protected GRDeviceVector m_vectorDevice = new GRDeviceVector();
    protected StringBuilder m_imageMap = new StringBuilder();
    protected boolean m_mirror = false;

    public OVVector(boolean bl) {
        this.m_mirror = bl;
    }

    @Override
    public void dispose() {
    }

    public void destroy() {
    }

    public byte[] getVectorBlob() {
        return this.m_vectorDevice.getVectorBlob();
    }

    protected Point transform(Point point) {
        Point point2 = new Point(0, 0);
        this.m_transform.transform(point, point2);
        return point2;
    }

    protected void opCodeDump(String string) {
        ++this.m_opCodeCount;
    }

    protected void addDetectionArea(CMByteBuffer cMByteBuffer) {
        if (this.m_tagText != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(cMByteBuffer.str());
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int n = cMByteBuffer.pcount() / 16;
            this.m_imageMap.append("<AREA " + this.m_tagText + " shape=\"poly\" coords=\"");
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMaximumFractionDigits(0);
            numberFormat.setGroupingUsed(false);
            for (int i = 0; i < n; ++i) {
                double d = byteBuffer.getDouble();
                double d2 = byteBuffer.getDouble();
                if (Double.isNaN(d)) {
                    d = 0.0;
                }
                if (Double.isNaN(d2)) {
                    d2 = 0.0;
                }
                if (i != 0) {
                    this.m_imageMap.append(",");
                }
                this.m_imageMap.append(numberFormat.format(d) + "," + numberFormat.format(d2));
            }
            this.m_imageMap.append("\">\n");
        }
    }

    public String getImageMap() {
        return this.m_imageMap.toString();
    }

    public void setTag(String string) {
        this.m_tagText = string;
    }

    public void fillTexture(Shape shape, PointFloat3[] pointFloat3Array, SurfaceAttribute.TextureMap textureMap) {
        boolean bl = false;
        for (int i = 0; i < pointFloat3Array.length; ++i) {
            if (pointFloat3Array[i].getX() != 0.0f || pointFloat3Array[i].getY() != 0.0f) continue;
            bl = true;
        }
        if (bl) {
            double d = Double.NaN;
            double d2 = Double.NaN;
            double d3 = Double.NaN;
            double d4 = Double.NaN;
            PathIterator pathIterator = shape.getPathIterator(null);
            double[] dArray = new double[6];
            while (!pathIterator.isDone()) {
                int n = pathIterator.currentSegment(dArray);
                switch (n) {
                    case 0: 
                    case 1: {
                        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
                        this.m_transform.transform(new Point2D.Double(dArray[0], dArray[1]), double_);
                        double d5 = double_.x;
                        double d6 = double_.y;
                        if (Double.isNaN(d) || d5 < d) {
                            d = d5;
                        }
                        if (Double.isNaN(d2) || d5 > d2) {
                            d2 = d5;
                        }
                        if (Double.isNaN(d3) || d6 < d3) {
                            d3 = d6;
                        }
                        if (!Double.isNaN(d4) && !(d6 > d4)) break;
                        d4 = d6;
                        break;
                    }
                }
                pathIterator.next();
            }
            GRBufferedImage gRBufferedImage = new GRBufferedImage(textureMap._width, textureMap._height);
            gRBufferedImage.setPixels(textureMap._pixels);
            if (this.m_mirror) {
                GRHelper.mirrorBufferedImage(gRBufferedImage.getImage());
            }
            this.m_vectorDevice.drawImage(gRBufferedImage.getImage(), d, d3, false);
        }
    }

    public void fillShaded(Shape shape, Color[] colorArray) {
        int n = 0;
        for (n = 0; n < colorArray.length; ++n) {
            if (colorArray[n].getAlpha() != 0) continue;
            return;
        }
        Vector<CMByteBuffer> vector = this.getPoints(shape, true);
        this.opCodeDump("DRAW_CPV_TRIANGLE");
        this.m_vectorDevice.drawCPVTriangle(colorArray, vector.elementAt(0).str());
        this.addDetectionArea(vector.elementAt(0));
    }

    @Override
    public void setStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            float[] fArray = basicStroke.getDashArray();
            double[] dArray = null;
            double d = 0.0;
            if (fArray != null) {
                int n = fArray.length;
                dArray = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray[i] = fArray[i];
                }
                d = basicStroke.getDashPhase();
            }
            this.opCodeDump("SET_STROKE");
            this.m_vectorDevice.setStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), basicStroke.getLineJoin(), dArray, d);
        }
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint instanceof HatchPaint) {
            HatchPaint hatchPaint = (HatchPaint)paint;
            int n = hatchPaint.getHatch();
            this.opCodeDump("SET_PAINT");
            this.m_vectorDevice.setColor(hatchPaint.getColor());
            this.m_vectorDevice.setPaint(n);
        } else if (paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            this.setColor(gradientPaint.getColor1());
        } else {
            this.setColor(null);
        }
    }

    protected Vector<CMByteBuffer> getPoints(Shape shape, boolean bl) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        CMByteBuffer cMByteBuffer = new CMByteBuffer();
        Vector<CMByteBuffer> vector = new Vector<CMByteBuffer>();
        PathIterator pathIterator = shape.getPathIterator(null);
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            int n2 = 0;
            switch (n) {
                case 0: {
                    n2 = 1;
                    break;
                }
                case 1: {
                    n2 = 1;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    break;
                }
            }
            if (n == 0 && cMByteBuffer.pcount() != 0) {
                vector.add(cMByteBuffer);
                cMByteBuffer = new CMByteBuffer();
            }
            for (int i = 0; i < n2; ++i) {
                Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
                this.m_transform.transform(new Point2D.Double(dArray[i * 2], dArray[i * 2 + 1]), double_);
                if (cMByteBuffer.pcount() == 0) {
                    d = double_.x;
                    d3 = double_.y;
                }
                cMByteBuffer.appendDouble(double_.x);
                cMByteBuffer.appendDouble(double_.y);
                d2 = double_.x;
                d4 = double_.y;
            }
            if (n == 4) {
                if (!(bl || d2 == d && d4 == d3)) {
                    cMByteBuffer.appendDouble(d);
                    cMByteBuffer.appendDouble(d3);
                }
                vector.add(cMByteBuffer);
                cMByteBuffer = new CMByteBuffer();
            }
            pathIterator.next();
        }
        if (cMByteBuffer.pcount() != 0) {
            vector.add(cMByteBuffer);
        }
        return vector;
    }

    protected void handleShape(Shape shape, boolean bl) {
        if (this.m_color.getAlpha() == 0) {
            return;
        }
        Vector<CMByteBuffer> vector = this.getPoints(shape, bl);
        for (int i = 0; i < vector.size(); ++i) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            int n;
            Object object;
            CMByteBuffer cMByteBuffer = vector.elementAt(i);
            this.opCodeDump(bl ? "FILL_POLYGON" : "DRAW_LINE");
            if (bl && cMByteBuffer.pcount() / 16 == 3 && this.m_color.getAlpha() != 255) {
                object = new Color[]{this.m_color, this.m_color, this.m_color};
                this.m_vectorDevice.drawCPVTriangle((Color[])object, cMByteBuffer.str());
            } else {
                this.m_vectorDevice.polyOpCode(bl, cMByteBuffer.str());
            }
            if (bl) {
                this.addDetectionArea(cMByteBuffer);
                continue;
            }
            if (this.m_tagText == null) continue;
            object = ByteBuffer.wrap(cMByteBuffer.str());
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            int n2 = cMByteBuffer.pcount() / 16;
            GRPoint[] gRPointArray = new GRPoint[n2];
            for (int j = 0; j < n2; ++j) {
                double d9 = ((ByteBuffer)object).getDouble();
                double d10 = ((ByteBuffer)object).getDouble();
                gRPointArray[j] = new GRPoint(d9, d10);
            }
            CMByteBuffer cMByteBuffer2 = new CMByteBuffer();
            for (n = 0; n < n2 - 1; ++n) {
                d8 = gRPointArray[n + 1].x;
                d7 = gRPointArray[n].x;
                d6 = d8 - d7;
                d5 = gRPointArray[n + 1].y;
                d4 = gRPointArray[n].y;
                d3 = d5 - d4;
                d2 = Math.sqrt(d6 * d6 + d3 * d3);
                if (d2 == 0.0) continue;
                d = 1.0 / d2;
                cMByteBuffer2.appendDouble(d7 + d3 * d);
                cMByteBuffer2.appendDouble(d4 - d6 * d);
                cMByteBuffer2.appendDouble(d8 + d3 * d);
                cMByteBuffer2.appendDouble(d5 - d6 * d);
            }
            for (n = n2 - 1; n > 0; --n) {
                d8 = gRPointArray[n - 1].x;
                d7 = gRPointArray[n].x;
                d6 = d8 - d7;
                d5 = gRPointArray[n - 1].y;
                d4 = gRPointArray[n].y;
                d3 = d5 - d4;
                d2 = Math.sqrt(d6 * d6 + d3 * d3);
                if (d2 == 0.0) continue;
                d = 1.0 / d2;
                cMByteBuffer2.appendDouble(d7 + d3 * d);
                cMByteBuffer2.appendDouble(d4 - d6 * d);
                cMByteBuffer2.appendDouble(d8 + d3 * d);
                cMByteBuffer2.appendDouble(d5 - d6 * d);
            }
            this.addDetectionArea(cMByteBuffer2);
        }
    }

    @Override
    public void fill(Shape shape) {
        this.handleShape(shape, true);
    }

    @Override
    public void draw(Shape shape) {
        this.handleShape(shape, false);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.m_transform = (AffineTransform)affineTransform.clone();
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.m_transform.clone();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.m_fontContext;
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (object == null) {
            this.m_hints.clear();
        } else {
            this.m_hints.put(key, object);
        }
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.m_hints;
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
    }

    @Override
    public void setColor(Color color) {
        this.opCodeDump("SET_COLOR");
        this.m_color = color == null ? new Color(0, 0, 0, 0) : color;
        this.m_vectorDevice.setPaint(-1);
        this.m_vectorDevice.setColor(this.m_color);
    }

    @Override
    public void setFont(Font font) {
        this.m_font = font;
        String string = this.m_font.getName();
        boolean bl = this.m_font.isBold();
        double d = this.m_font.getSize2D();
        boolean bl2 = this.m_font.isItalic();
        boolean bl3 = false;
        boolean bl4 = false;
        bl3 = this.m_font.getAttributes().get(TextAttribute.STRIKETHROUGH) == TextAttribute.STRIKETHROUGH_ON;
        boolean bl5 = bl4 = this.m_font.getAttributes().get(TextAttribute.UNDERLINE) == TextAttribute.UNDERLINE_ON;
        if (font.getFontName().indexOf(".") != -1) {
            string = "Andale WT";
        }
        this.opCodeDump("SET_FONT");
        this.m_vectorDevice.setFont(string, d, bl, bl2, bl3, bl4);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.opCodeDump("FILL_POLYGON");
        this.m_vectorDevice.fillRect(n, n2, n3 - 1, n4 - 1);
        CMByteBuffer cMByteBuffer = new CMByteBuffer();
        cMByteBuffer.appendDouble(n);
        cMByteBuffer.appendDouble(n2);
        cMByteBuffer.appendDouble(n + n3 - 1);
        cMByteBuffer.appendDouble(n2);
        cMByteBuffer.appendDouble(n + n3 - 1);
        cMByteBuffer.appendDouble(n2 + n4 - 1);
        cMByteBuffer.appendDouble(n);
        cMByteBuffer.appendDouble(n2 + n4 - 1);
        this.addDetectionArea(cMByteBuffer);
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        CMByteBuffer cMByteBuffer = new CMByteBuffer();
        for (int i = 0; i < n; ++i) {
            cMByteBuffer.appendDouble(nArray[i]);
            cMByteBuffer.appendDouble(nArray2[i]);
        }
        this.opCodeDump("FILL_POLYGON");
        this.m_vectorDevice.polyOpCode(true, cMByteBuffer.str());
        this.addDetectionArea(cMByteBuffer);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
    }

    @Override
    public void drawString(String string, float f, float f2) {
        this.drawString(string, (int)((double)f + 0.5), (int)((double)f2 + 0.5));
    }

    @Override
    public void drawString(String string, int n, int n2) {
        Point[] pointArray;
        Rectangle2D rectangle2D = this.m_font.getStringBounds(string, this.m_fontContext);
        Point point = this.transform(new Point(n, (int)((double)n2 - rectangle2D.getHeight())));
        Point point2 = this.transform(new Point(0, 0));
        Point point3 = this.transform(new Point(100, 0));
        double d = point3.x - point2.x;
        double d2 = -(point3.y - point2.y);
        double d3 = Math.atan2(d2, d) * 180.0 / Math.PI;
        this.opCodeDump("DRAW_STRING");
        this.m_vectorDevice.drawString(point.x, point.y, d3, string);
        pointArray = new Point[]{new Point(n, n2), new Point(GRHelper.GR_ROUND((double)n + rectangle2D.getWidth()), n2), new Point(pointArray[1].x, GRHelper.GR_ROUND((double)n2 - rectangle2D.getHeight())), new Point(pointArray[0].x, pointArray[2].y)};
        CMByteBuffer cMByteBuffer = new CMByteBuffer();
        for (int i = 0; i < 4; ++i) {
            Point point4 = this.transform(pointArray[i]);
            cMByteBuffer.appendDouble(point4.x);
            cMByteBuffer.appendDouble(point4.y);
        }
        this.addDetectionArea(cMByteBuffer);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return false;
    }

    @Override
    public Rectangle getClipBounds() {
        return null;
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.m_transform.concatenate(affineTransform);
    }

    public void nullop() {
    }

    @Override
    public Stroke getStroke() {
        this.nullop();
        return null;
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        this.nullop();
        return false;
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        this.nullop();
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.nullop();
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.nullop();
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.nullop();
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        this.nullop();
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.nullop();
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        this.nullop();
        return false;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        this.nullop();
        return null;
    }

    @Override
    public void setComposite(Composite composite) {
        this.nullop();
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        this.nullop();
        return null;
    }

    public void setRenderingHints(Map map) {
        this.nullop();
    }

    public void addRenderingHints(Map map) {
        this.nullop();
    }

    @Override
    public void translate(int n, int n2) {
        this.nullop();
    }

    @Override
    public void translate(double d, double d2) {
        this.nullop();
    }

    @Override
    public void rotate(double d) {
        this.nullop();
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.nullop();
    }

    @Override
    public void scale(double d, double d2) {
        this.nullop();
    }

    @Override
    public void shear(double d, double d2) {
        this.nullop();
    }

    @Override
    public Paint getPaint() {
        this.nullop();
        return null;
    }

    @Override
    public Composite getComposite() {
        this.nullop();
        return null;
    }

    @Override
    public void setBackground(Color color) {
        this.nullop();
    }

    @Override
    public Color getBackground() {
        this.nullop();
        return null;
    }

    @Override
    public void clip(Shape shape) {
        this.nullop();
    }

    @Override
    public Graphics create() {
        this.nullop();
        return null;
    }

    @Override
    public Color getColor() {
        this.nullop();
        return null;
    }

    @Override
    public void setPaintMode() {
        this.nullop();
    }

    @Override
    public void setXORMode(Color color) {
        this.nullop();
    }

    @Override
    public Font getFont() {
        this.nullop();
        return null;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        this.nullop();
        return null;
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.nullop();
    }

    @Override
    public Shape getClip() {
        this.nullop();
        return null;
    }

    @Override
    public void setClip(Shape shape) {
        this.nullop();
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.nullop();
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        this.nullop();
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.nullop();
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.nullop();
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.nullop();
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.nullop();
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.nullop();
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.nullop();
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.nullop();
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.nullop();
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.nullop();
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.nullop();
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        this.nullop();
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        this.nullop();
        return false;
    }
}

