/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.DrawContext;

import com.ibm.cgsBus.Common.CMByteBuffer;
import com.ibm.cgsBus.FrameWork.CGSVectorInterface;
import com.ibm.cgsBus.FrameWork.CGSVectorTriangle;
import com.ibm.cgsBus.Graphics.GRBufferedImage;
import com.ibm.cgsBus.Graphics.GRHelper;
import com.ibm.cgsBus.Types.CGSTypeFillEffect;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.Vector;

public class OVVectorInterface
implements CGSVectorInterface {
    private boolean m_verbose = false;
    private CMByteBuffer m_pText = null;
    private BufferedImage m_pImage = null;
    private int[] m_xPts = new int[10000];
    private int[] m_yPts = new int[10000];
    private int m_countPts = 0;
    private float m_lineWidth = 0.0f;
    private int m_lineCap = 0;
    private int m_lineJoin = 0;
    private float[] m_lineDash = null;
    private float m_lineDashPhase = 0.0f;

    public OVVectorInterface(int n, int n2) {
        this.m_pText = new CMByteBuffer();
        this.m_pText.appendRawString("Width: " + n + " Height: " + n2 + "\n");
        this.m_pImage = new BufferedImage(n, n2, 2);
        GRHelper.initBufferedImage(this.m_pImage, 0xFFFFFF);
    }

    public CMByteBuffer getText() {
        return this.m_pText;
    }

    public BufferedImage getImage() {
        return this.m_pImage;
    }

    @Override
    public void pathStartNew() {
        this.m_pText.appendRawString("pathStartNew()\n");
        this.m_countPts = 0;
        this.m_lineWidth = 0.0f;
        this.m_lineCap = 0;
        this.m_lineJoin = 0;
        this.m_lineDash = null;
        this.m_lineDashPhase = 0.0f;
    }

    @Override
    public void pathSetLineStyle(double d, int n, int n2) {
        if (this.m_verbose) {
            this.m_pText.appendRawString("   pathSetLineStyle(" + this.formatDouble(d) + "," + n + "," + n2 + ")\n");
        } else {
            this.m_pText.appendRawString("   pathSetLineStyle(...)\n");
        }
        this.m_lineWidth = (float)d;
        switch (n) {
            case 1: {
                this.m_lineCap = 1;
                break;
            }
            case 2: {
                this.m_lineCap = 2;
                break;
            }
            default: {
                this.m_lineCap = 0;
            }
        }
        switch (n2) {
            case 1: {
                this.m_lineJoin = 1;
                break;
            }
            case 2: {
                this.m_lineJoin = 2;
                break;
            }
            default: {
                this.m_lineJoin = 0;
            }
        }
    }

    @Override
    public void pathSetLineDashPattern(double d, int n, double[] dArray) {
        if (this.m_verbose) {
            this.m_pText.appendRawString("   pathSetLineDashPattern(" + d + ")\n");
        } else {
            this.m_pText.appendRawString("   pathSetLineDashPattern(...)\n");
        }
        this.m_lineDash = new float[n];
        for (int i = 0; i < n; ++i) {
            this.m_lineDash[i] = (float)dArray[i];
        }
        this.m_lineDashPhase = (float)d;
    }

    @Override
    public void pathMoveTo(double d, double d2) {
        if (this.m_verbose) {
            this.m_pText.appendRawString("   pathMoveTo(" + this.formatDouble(d) + "," + this.formatDouble(d2) + ")\n");
        } else {
            this.m_pText.appendRawString("   pathMoveTo(...)\n");
        }
        this.m_xPts[this.m_countPts] = (int)Math.round(d);
        this.m_yPts[this.m_countPts] = (int)Math.round(d2);
        ++this.m_countPts;
    }

    @Override
    public void pathLineTo(double d, double d2) {
        if (this.m_verbose) {
            this.m_pText.appendRawString("   pathLineTo(" + this.formatDouble(d) + "," + this.formatDouble(d2) + ")\n");
        } else {
            this.m_pText.appendRawString("   pathLineTo(...)\n");
        }
        this.m_xPts[this.m_countPts] = (int)Math.round(d);
        this.m_yPts[this.m_countPts] = (int)Math.round(d2);
        ++this.m_countPts;
    }

    @Override
    public void pathCloseSubpath() {
        this.m_pText.appendRawString("   pathCloseSubpath()\n");
        this.m_xPts[this.m_countPts] = this.m_xPts[0];
        this.m_yPts[this.m_countPts] = this.m_yPts[0];
        ++this.m_countPts;
    }

    @Override
    public void pathFinishAndPaint(Color color, CGSTypeFillEffect cGSTypeFillEffect) {
        this.m_pText.appendRawString("pathFinishAndPaint(...)\n");
        Graphics2D graphics2D = (Graphics2D)this.m_pImage.getGraphics();
        if (cGSTypeFillEffect == null) {
            BasicStroke basicStroke = new BasicStroke(this.m_lineWidth, this.m_lineCap, this.m_lineJoin, 1.0f, this.m_lineDash, this.m_lineDashPhase);
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(color);
            graphics2D.drawPolyline(this.m_xPts, this.m_yPts, this.m_countPts);
        } else {
            graphics2D.setColor(cGSTypeFillEffect.getSolidColor());
            graphics2D.fillPolygon(this.m_xPts, this.m_yPts, this.m_countPts);
        }
    }

    @Override
    public void setFont(String string, double d, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.m_pText.appendRawString("setFont(" + string + "," + this.formatDouble(d) + ",...)\n");
    }

    @Override
    public void drawString(String string, double d, double d2, double d3) {
        this.m_pText.appendRawString("drawString(\"" + string + "\"," + this.formatDouble(d) + "," + this.formatDouble(d2) + "," + this.formatDouble(d3) + ")\n");
    }

    @Override
    public void drawStringBox(String string, double d, double d2, double d3, double d4, int n) {
        this.m_pText.appendRawString("drawStringBox(\"" + string + "\",...)\n");
    }

    @Override
    public void drawImage(double d, double d2, int n, int n2, int[] nArray) {
        int n3;
        this.m_pText.appendRawString("drawImage(" + d + "," + d2 + "," + n + "," + n2 + ")\n");
        GRBufferedImage gRBufferedImage = new GRBufferedImage(n, n2);
        for (n3 = 0; n3 < n2; ++n3) {
            for (int i = 0; i < n; ++i) {
                gRBufferedImage.setRGB(i, n3, nArray[n3 * n + i]);
            }
        }
        n3 = (int)((double)(this.m_pImage.getHeight() - 1) - d2);
        GRHelper.pasteBufferedImage(this.m_pImage, gRBufferedImage.getImage(), (int)d, n3);
    }

    @Override
    public void drawShadedTriangle(Vector<CGSVectorTriangle> vector) {
        this.m_pText.appendRawString("drawShadedTriangle(" + vector.size() + ")\n");
        int n = vector.size();
        if (n == 0) {
            return;
        }
        GRBufferedImage gRBufferedImage = new GRBufferedImage(this.m_pImage.getWidth(), this.m_pImage.getHeight());
        boolean bl = true;
        int n2 = -1;
        for (int i = 0; i != n; ++i) {
            double[][] dArray = vector.elementAt((int)i).points;
            Color[] colorArray = vector.elementAt((int)i).colors;
            if (bl) {
                n2 = colorArray[0].getAlpha();
                bl = false;
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (int j = 0; j < 3; ++j) {
                if (this.m_verbose) {
                    if (j == 0) {
                        this.m_pText.appendRawString("  " + i + ":");
                    }
                    this.m_pText.appendRawString(" " + this.formatDouble(dArray[j][0]) + "," + this.formatDouble(dArray[j][1]));
                    if (j == 2) {
                        this.m_pText.appendRawString("\n");
                    }
                }
                n3 += colorArray[j].getRed();
                n4 += colorArray[j].getGreen();
                n5 += colorArray[j].getBlue();
                n6 += colorArray[j].getAlpha();
            }
            Color color = new Color(n3 / 3, n4 / 3, n5 / 3, n6 / 3);
            gRBufferedImage.fillPolygon(dArray, color);
            if (i != n - 1 && colorArray[0].getAlpha() == n2) continue;
            if (this.m_verbose) {
                this.m_pText.appendRawString("  draw");
                if (i == n - 1) {
                    this.m_pText.appendRawString(" - flush\n");
                } else {
                    this.m_pText.appendRawString(" - " + colorArray[0].getAlpha() + " != " + n2 + "\n");
                }
            }
            GRHelper.pasteBufferedImage(this.m_pImage, gRBufferedImage.getImage(), 0, 0);
            GRHelper.initBufferedImage(gRBufferedImage.getImage(), 0xFFFFFF);
            bl = true;
        }
    }

    private String formatDouble(double d) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        return numberFormat.format(d);
    }
}

