/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.FrameWork;

import com.ibm.cgsBus.Common.CMByteBuffer;
import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.FrameWork.CGSCanvasRef;
import com.ibm.cgsBus.FrameWork.CGSDetectArea;
import com.ibm.cgsBus.FrameWork.CGSProp;
import com.ibm.cgsBus.FrameWork.CGSRaster;
import com.ibm.cgsBus.FrameWork.CGSUCJ;
import com.ibm.cgsBus.FrameWork.CGSVector;
import com.ibm.cgsBus.FrameWork.CGSWidget;
import com.ibm.cgsBus.Graphics.GRContainer;
import com.ibm.cgsBus.Graphics.GRDevice;
import com.ibm.cgsBus.Graphics.GRDeviceRaster;
import com.ibm.cgsBus.Graphics.GRDeviceVector;
import com.ibm.cgsBus.Logging.CGSLogging;
import com.ibm.cgsBus.Properties.CGSPropCanvas;
import com.ibm.cgsBus.Properties.CGSPropContainer;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeBox;
import com.ibm.cgsBus.Types.CGSTypeFillEffect;
import com.ibm.cgsBus.Types.CGSTypeSize;
import com.ibm.cgsBus.Widgets.CGSWidgetChartBubble;
import com.ibm.cgsBus.Widgets.CGSWidgetChartCombo;
import com.ibm.cgsBus.Widgets.CGSWidgetChartCombo3D;
import com.ibm.cgsBus.Widgets.CGSWidgetChartGauge;
import com.ibm.cgsBus.Widgets.CGSWidgetChartHistory;
import com.ibm.cgsBus.Widgets.CGSWidgetChartMap;
import com.ibm.cgsBus.Widgets.CGSWidgetChartMarimekko;
import com.ibm.cgsBus.Widgets.CGSWidgetChartPareto;
import com.ibm.cgsBus.Widgets.CGSWidgetChartPie;
import com.ibm.cgsBus.Widgets.CGSWidgetChartPolar;
import com.ibm.cgsBus.Widgets.CGSWidgetChartProgressive;
import com.ibm.cgsBus.Widgets.CGSWidgetChartRadar;
import com.ibm.cgsBus.Widgets.CGSWidgetChartScatter;
import com.ibm.cgsBus.Widgets.CGSWidgetChartScatter3D;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class CGSCanvas
implements CGSCanvasRef {
    private String m_id = null;
    private CGSPropCanvas m_pBaseProp = new CGSPropCanvas();
    private Vector<CGSWidget> m_widgets = new Vector();
    private boolean m_ldxAsRaster = true;
    private boolean m_ldxAsSVG = false;
    private Color m_backgroundBlendingColor = null;
    private boolean m_appliedMirroring = false;

    public CGSCanvas(String string) {
    }

    public void removeReference() {
    }

    public void setId(String string) {
        this.m_id = string;
    }

    public String getId() {
        return this.m_id;
    }

    @Override
    public CGSProp getBaseProp() {
        return this.m_pBaseProp;
    }

    public CGSWidget createWidget(CGSWidget.WidgetType widgetType) {
        return this.createWidget(widgetType, null);
    }

    protected CGSWidget createWidget(CGSWidget.WidgetType widgetType, String string) {
        CGSWidget cGSWidget = null;
        if (widgetType == CGSWidget.WidgetType.eChartBubble || string != null && string.compareTo("cgsPropWidgetChartBubble") == 0) {
            cGSWidget = new CGSWidgetChartBubble(this, this.m_widgets.size());
        } else if (widgetType == CGSWidget.WidgetType.eChartCombo || string != null && string.compareTo("cgsPropWidgetChartCombo") == 0) {
            cGSWidget = new CGSWidgetChartCombo(this, this.m_widgets.size());
        } else if (widgetType == CGSWidget.WidgetType.eChartCombo3D || string != null && string.compareTo("cgsPropWidgetChartCombo3D") == 0) {
            cGSWidget = new CGSWidgetChartCombo3D(this, this.m_widgets.size());
        } else if (widgetType == CGSWidget.WidgetType.eChartGauge || string != null && string.compareTo("cgsPropWidgetChartGauge") == 0) {
            cGSWidget = new CGSWidgetChartGauge(this, this.m_widgets.size());
        } else if (widgetType == CGSWidget.WidgetType.eChartHistory || string != null && string.compareTo("cgsPropWidgetChartMetrics") == 0) {
            cGSWidget = new CGSWidgetChartHistory(this, this.m_widgets.size());
        } else if (widgetType == CGSWidget.WidgetType.eChartMap || string != null && string.compareTo("cgsPropWidgetChartMap") == 0) {
            cGSWidget = new CGSWidgetChartMap(this, this.m_widgets.size());
        } else if (widgetType == CGSWidget.WidgetType.eChartMarimekko || string != null && string.compareTo("cgsPropWidgetChartMarimekko") == 0) {
            cGSWidget = new CGSWidgetChartMarimekko(this, this.m_widgets.size());
        } else if (widgetType == CGSWidget.WidgetType.eChartPareto || string != null && string.compareTo("cgsPropWidgetChartPareto") == 0) {
            cGSWidget = new CGSWidgetChartPareto(this, this.m_widgets.size());
        } else if (widgetType == CGSWidget.WidgetType.eChartPie || string != null && string.compareTo("cgsPropWidgetChartPie") == 0) {
            cGSWidget = new CGSWidgetChartPie(this, this.m_widgets.size());
        } else if (widgetType == CGSWidget.WidgetType.eChartPolar || string != null && string.compareTo("cgsPropWidgetChartPolar") == 0) {
            cGSWidget = new CGSWidgetChartPolar(this, this.m_widgets.size());
        } else if (widgetType == CGSWidget.WidgetType.eChartProgressive || string != null && string.compareTo("cgsPropWidgetChartProgressive") == 0) {
            cGSWidget = new CGSWidgetChartProgressive(this, this.m_widgets.size());
        } else if (widgetType == CGSWidget.WidgetType.eChartRadar || string != null && string.compareTo("cgsPropWidgetChartRadar") == 0) {
            cGSWidget = new CGSWidgetChartRadar(this, this.m_widgets.size());
        } else if (widgetType == CGSWidget.WidgetType.eChartScatter || string != null && string.compareTo("cgsPropWidgetChartScatter") == 0) {
            cGSWidget = new CGSWidgetChartScatter(this, this.m_widgets.size());
        } else if (widgetType == CGSWidget.WidgetType.eChartScatter3D || string != null && string.compareTo("cgsPropWidgetChartScatter3D") == 0) {
            cGSWidget = new CGSWidgetChartScatter3D(this, this.m_widgets.size());
        }
        if (cGSWidget != null) {
            this.m_widgets.addElement(cGSWidget);
        }
        return cGSWidget;
    }

    public int getWidgetCount() {
        return this.m_widgets.size();
    }

    public CGSWidget getWidget(int n) {
        return this.m_widgets.elementAt(n);
    }

    public int getWidgetIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.m_widgets.size(); ++i) {
            if (!string.equals(this.m_widgets.get(i).getId())) continue;
            n = i;
        }
        CMHelper.CGS_ASSERT(n >= 0, "Widget index not found");
        return n;
    }

    public boolean loadFromLDX(String string) throws Exception {
        Object object;
        Object object2;
        CGSLogging.logEnter("CGSCanvas::loadFromLDX");
        Document document = null;
        Element element = null;
        try {
            document = DocumentHelper.parseText((String)string);
            element = document.getRootElement();
        }
        catch (DocumentException documentException) {
            CGSLogging.logError("Unable to create DOM from LDX: " + documentException.getMessage());
            CGSLogging.logError("LDX=" + string);
            CGSLogging.logExit("CGSCanvas::loadFromLDX");
            throw documentException;
        }
        try {
            this.parseLDXHeader(element);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CGSLogging.logError("Unable to create DOM from LDX: " + illegalArgumentException.getMessage());
            CGSLogging.logError("LDX=" + element.toString());
            CGSLogging.logExit("CGSCanvas::loadFromLDX");
        }
        Element element2 = element.element("details");
        List list = element2.elements("cgsWidget");
        for (int i = 0; i < list.size(); ++i) {
            object2 = (Element)list.get(i);
            Element element3 = object2.element("cgsProperties");
            object = ((Element)element3.elements().get(0)).getName();
            CGSWidget cGSWidget = this.createWidget(null, (String)object);
            if (cGSWidget == null) {
                CGSLogging.logExit("CGSCanvas::loadFromLDX");
                return false;
            }
            cGSWidget.loadFromLDX((Element)object2, (String)object);
        }
        Element element4 = element2.element("cgsPropCanvas");
        this.m_pBaseProp.loadLDX(element4);
        if (this.m_backgroundBlendingColor != null) {
            object2 = (CGSPropContainer)this.m_pBaseProp.getProp(CGSEnums.PropType.ePropContainer);
            for (int i = 0; i < ((CGSPropContainer)object2).getFillEffectCount(); ++i) {
                object = ((CGSPropContainer)object2).getFillEffect(i);
                ((CGSTypeFillEffect)object).setForcedBlendingColor(this.m_backgroundBlendingColor);
            }
        }
        CGSLogging.logExit("CGSCanvas::loadFromLDX");
        return true;
    }

    private void parseLDXHeader(Element element) throws IllegalArgumentException {
        block7: {
            try {
                Element element2 = element.element("drawType");
                if (element2.getText().equalsIgnoreCase("vector")) {
                    this.m_ldxAsRaster = false;
                    this.m_ldxAsSVG = false;
                } else if (element2.getText().equalsIgnoreCase("SVG")) {
                    this.m_ldxAsSVG = true;
                    this.m_ldxAsRaster = false;
                }
                Element element3 = element.element("backgroundBlendingColor");
                if (element3 == null) break block7;
                String string = element3.element("red").getText();
                String string2 = element3.element("green").getText();
                String string3 = element3.element("blue").getText();
                this.m_backgroundBlendingColor = new Color((int)(Double.parseDouble(string) * 255.0), (int)(Double.parseDouble(string2) * 255.0), (int)(Double.parseDouble(string3) * 255.0));
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException(nullPointerException);
            }
        }
    }

    public CGSRaster drawAsRaster() {
        CGSLogging.logEnter("CGSCanvas::drawAsRaster");
        if (this.isChartMirroringEnabled()) {
            this.applyMirroring();
        }
        CGSTypeSize cGSTypeSize = this.m_pBaseProp.getSize();
        GRDeviceRaster gRDeviceRaster = new GRDeviceRaster(this.m_pBaseProp.getDPI(), cGSTypeSize.m_width, cGSTypeSize.m_height);
        this.drawBackground(gRDeviceRaster);
        for (int i = 0; i < this.m_widgets.size(); ++i) {
            CGSWidget cGSWidget = this.getWidget(i);
            CGSTypeBox cGSTypeBox = cGSWidget.getLocation();
            if (cGSTypeBox.m_right < 0 || cGSTypeBox.m_top < 0 || cGSTypeBox.m_left >= cGSTypeSize.m_width || cGSTypeBox.m_bottom >= cGSTypeSize.m_height) continue;
            cGSWidget.drawAsRaster();
            BufferedImage bufferedImage = cGSWidget.outputRasterWidget();
            int n = cGSTypeBox.m_top >= cGSTypeSize.m_height ? cGSTypeSize.m_height - 1 : cGSTypeBox.m_top;
            n = cGSTypeSize.m_height - 1 - n;
            int n2 = cGSTypeBox.m_left < 0 ? 0 : cGSTypeBox.m_left;
            gRDeviceRaster.pasteImage(bufferedImage, n2, n);
        }
        CGSRaster cGSRaster = new CGSRaster(gRDeviceRaster.getImage());
        cGSRaster.setDetectAreas(this.getDetectionAreas());
        CGSLogging.logExit("CGSCanvas::drawAsRaster");
        return cGSRaster;
    }

    public String drawAsSVG() {
        CGSLogging.logEnter("CGSCanvas::drawAsSVG");
        String string = null;
        Document document = null;
        if (this.isChartMirroringEnabled()) {
            this.applyMirroring();
        }
        CGSTypeSize cGSTypeSize = this.m_pBaseProp.getSize();
        GRDeviceRaster gRDeviceRaster = new GRDeviceRaster(this.m_pBaseProp.getDPI(), cGSTypeSize.m_width, cGSTypeSize.m_height);
        this.drawBackground(gRDeviceRaster);
        for (int i = 0; i < this.m_widgets.size(); ++i) {
            CGSWidget cGSWidget = this.getWidget(i);
            CGSTypeBox cGSTypeBox = cGSWidget.getLocation();
            if (cGSTypeBox.m_right < 0 || cGSTypeBox.m_top < 0 || cGSTypeBox.m_left >= cGSTypeSize.m_width || cGSTypeBox.m_bottom >= cGSTypeSize.m_height) continue;
            int n = cGSTypeBox.m_top >= cGSTypeSize.m_height ? cGSTypeSize.m_height - 1 : cGSTypeBox.m_top;
            n = cGSTypeSize.m_height - 1 - n;
            int n2 = cGSTypeBox.m_left < 0 ? 0 : cGSTypeBox.m_left;
            cGSWidget.m_widgetSVG = string;
            cGSWidget.m_docSVG = document;
            cGSWidget.m_leftSVG = n2;
            cGSWidget.m_topSVG = n;
            cGSWidget.m_widthSVG = cGSTypeSize.m_width;
            cGSWidget.m_heightSVG = cGSTypeSize.m_height;
            cGSWidget.drawAsSVG();
            string = cGSWidget.m_widgetSVG;
            document = cGSWidget.m_docSVG;
        }
        CGSLogging.logExit("CGSCanvas::drawAsSVG");
        return string;
    }

    private Vector<CGSDetectArea> getDetectionAreas() {
        Vector<CGSDetectArea> vector = new Vector<CGSDetectArea>();
        for (int i = 0; i < this.m_widgets.size(); ++i) {
            vector.addAll(this.getWidget(i).getDetectionAreas());
        }
        CGSDetectArea cGSDetectArea = new CGSDetectArea(CGSEnums.DetArea.eDetNone, CGSWidget.DataType.eCategory, 0, null, 0, 0, CGSWidget.DataTableId.eDataTableDefault, 0, null);
        Collections.sort(vector, cGSDetectArea);
        return vector;
    }

    public CGSVector drawAsVector() {
        CGSLogging.logEnter("CGSCanvas::drawAsVector");
        if (this.isChartMirroringEnabled()) {
            this.applyMirroring();
        }
        CGSTypeSize cGSTypeSize = this.m_pBaseProp.getSize();
        CMByteBuffer cMByteBuffer = new CMByteBuffer();
        cMByteBuffer.appendRawString("vec");
        cMByteBuffer.appendInt(0);
        GRDeviceVector gRDeviceVector = new GRDeviceVector();
        this.drawBackground(gRDeviceVector);
        cMByteBuffer.appendBytes(gRDeviceVector.getVectorBlob());
        for (int i = 0; i < this.m_widgets.size(); ++i) {
            CGSWidget cGSWidget = this.getWidget(i);
            CGSTypeBox cGSTypeBox = cGSWidget.getLocation();
            if (cGSTypeBox.m_right < 0 || cGSTypeBox.m_top < 0 || cGSTypeBox.m_left >= cGSTypeSize.m_width || cGSTypeBox.m_bottom >= cGSTypeSize.m_height) continue;
            cGSWidget.drawAsVector();
            byte[] byArray = cGSWidget.outputVectorWidget();
            cMByteBuffer.appendBytes(byArray);
        }
        cMByteBuffer.appendInt(99);
        CGSLogging.logExit("CGSCanvas::drawAsVector");
        return new CGSVector(cMByteBuffer, gRDeviceVector.fromPixels(cGSTypeSize.m_width), gRDeviceVector.fromPixels(cGSTypeSize.m_height));
    }

    public static void addIndent(CMByteBuffer cMByteBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            cMByteBuffer.appendRawString("  ");
        }
    }

    public CGSUCJ drawAsUCJ() {
        CGSTypeSize cGSTypeSize = this.m_pBaseProp.getSize();
        int n = this.m_widgets.size();
        CMByteBuffer cMByteBuffer = new CMByteBuffer();
        cMByteBuffer.appendRawString("{\n");
        CGSCanvas.addIndent(cMByteBuffer, 1);
        cMByteBuffer.appendRawString("\"data\": [\n");
        if (n == 0) {
            CGSWidget.saveEmptyUCJData(cMByteBuffer, 2);
        } else {
            this.m_widgets.elementAt(0).saveUCJData(cMByteBuffer, 2);
        }
        CGSCanvas.addIndent(cMByteBuffer, 1);
        cMByteBuffer.appendRawString("],\n");
        CGSCanvas.addIndent(cMByteBuffer, 1);
        cMByteBuffer.appendRawString("\"grammar\": [\n");
        if (n == 0) {
            CGSWidget.saveEmptyUCJGrammar(cMByteBuffer, 2);
        } else {
            this.m_widgets.elementAt(0).saveUCJGrammar(cMByteBuffer, 2);
        }
        CGSCanvas.addIndent(cMByteBuffer, 1);
        cMByteBuffer.appendRawString("],\n");
        CGSCanvas.addIndent(cMByteBuffer, 1);
        cMByteBuffer.appendRawString("\"style\": {\n");
        CGSCanvas.addIndent(cMByteBuffer, 2);
        cMByteBuffer.appendRawString("\"fill\": {\n");
        CGSCanvas.addIndent(cMByteBuffer, 3);
        cMByteBuffer.appendRawString("\"type\": \"linear\",\n");
        CGSCanvas.addIndent(cMByteBuffer, 3);
        cMByteBuffer.appendRawString("\"colors\": [\n");
        CGSCanvas.addIndent(cMByteBuffer, 4);
        cMByteBuffer.appendRawString("{\n");
        CGSCanvas.addIndent(cMByteBuffer, 5);
        cMByteBuffer.appendRawString("\"color\": { \"r\": 255, \"g\": 0, \"b\": 0 },\n");
        CGSCanvas.addIndent(cMByteBuffer, 5);
        cMByteBuffer.appendRawString("\"offset\": 0.0\n");
        CGSCanvas.addIndent(cMByteBuffer, 4);
        cMByteBuffer.appendRawString("},\n");
        CGSCanvas.addIndent(cMByteBuffer, 4);
        cMByteBuffer.appendRawString("{\n");
        CGSCanvas.addIndent(cMByteBuffer, 5);
        cMByteBuffer.appendRawString("\"color\": { \"r\": 0, \"g\": 255, \"b\": 255 },\n");
        CGSCanvas.addIndent(cMByteBuffer, 5);
        cMByteBuffer.appendRawString("\"offset\": 1.0\n");
        CGSCanvas.addIndent(cMByteBuffer, 4);
        cMByteBuffer.appendRawString("}\n");
        CGSCanvas.addIndent(cMByteBuffer, 3);
        cMByteBuffer.appendRawString("]\n");
        CGSCanvas.addIndent(cMByteBuffer, 2);
        cMByteBuffer.appendRawString("}\n");
        CGSCanvas.addIndent(cMByteBuffer, 1);
        cMByteBuffer.appendRawString("},\n");
        CGSCanvas.addIndent(cMByteBuffer, 1);
        cMByteBuffer.appendRawString("\"size\": {\n");
        CGSCanvas.addIndent(cMByteBuffer, 2);
        cMByteBuffer.appendRawString("\"height\": " + cGSTypeSize.m_height + ",\n");
        CGSCanvas.addIndent(cMByteBuffer, 2);
        cMByteBuffer.appendRawString("\"width\": " + cGSTypeSize.m_width + "\n");
        CGSCanvas.addIndent(cMByteBuffer, 1);
        cMByteBuffer.appendRawString("}\n");
        cMByteBuffer.appendRawString("}\n");
        return new CGSUCJ(cMByteBuffer);
    }

    private void drawBackground(GRDevice gRDevice) {
        CGSTypeSize cGSTypeSize = this.m_pBaseProp.getSize();
        CGSPropContainer cGSPropContainer = (CGSPropContainer)this.m_pBaseProp.getProp(CGSEnums.PropType.ePropContainer);
        double d = gRDevice.fromPixels(0.0);
        double d2 = gRDevice.fromPixels(0.0);
        double d3 = gRDevice.fromPixels(cGSTypeSize.getWidth() - 1);
        double d4 = gRDevice.fromPixels(cGSTypeSize.getHeight() - 1);
        GRContainer gRContainer = new GRContainer(cGSPropContainer);
        gRContainer.draw(gRDevice, d, d4, d3, d2, this.isChartMirroringEnabled());
    }

    public byte[] drawAsBytes(String string) throws InterruptedException {
        int n;
        Object[] objectArray;
        Object object;
        int n2;
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            n2 = this.loadFromLDX(string);
            if (n2 == 0) {
                throw new RuntimeException("Failed to parse LDX.");
            }
            if (this.m_ldxAsRaster) {
                object = this.drawAsRaster();
                if (object == null || ((CGSRaster)object).getBuffer() == null || ((CGSRaster)object).getBuffer().length == 0) {
                    throw new RuntimeException("Failed to render image.");
                }
                byArray = ((CGSRaster)object).getBuffer();
                byArray2 = this.encodeDetectionAreas();
            } else if (this.m_ldxAsSVG) {
                object = this.drawAsSVG();
                if (object == null || ((String)object).isEmpty()) {
                    throw new RuntimeException("Failed to render image.");
                }
                byArray = ((String)object).getBytes();
            } else {
                object = this.drawAsVector();
                if (object == null || ((CGSVector)object).getBuffer() == null || ((CGSVector)object).getBuffer().pcount() == 0) {
                    throw new RuntimeException("Failed to render vector.");
                }
                byArray = ((CGSVector)object).getBuffer().str();
                byArray2 = this.encodeDetectionAreas();
            }
        }
        catch (Throwable throwable) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Error: " + throwable.getMessage() + " : " + throwable.getCause() + "\n");
            objectArray = throwable.getStackTrace();
            for (int i = 0; i < objectArray.length; ++i) {
                ((StringBuilder)object).append("at " + objectArray[i].getClassName() + "(" + objectArray[i].getFileName() + ":" + objectArray[i].getLineNumber() + ")\n");
            }
            try {
                byte[] byArray3 = ((StringBuilder)object).toString().getBytes("UTF-8");
                byArray = new byte[byArray3.length + 1];
                for (n = 0; n < byArray3.length; ++n) {
                    byArray[n] = byArray3[n];
                }
                byArray[byArray3.length] = 0;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        n2 = byArray.length;
        if (byArray2 != null) {
            n2 += byArray2.length;
        }
        object = ByteBuffer.allocate(n2);
        ((ByteBuffer)object).put(byArray);
        if (byArray2 != null) {
            ((ByteBuffer)object).put(byArray2);
        }
        objectArray = ((ByteBuffer)object).array();
        int n3 = 0;
        for (n = 7; n < n2; ++n) {
            n3 = n3 + objectArray[n] + 128 & 0xFFFF;
        }
        if (!(this.m_ldxAsSVG || objectArray[0] == 69 && objectArray[1] == 114 && objectArray[2] == 114)) {
            objectArray[3] = (StackTraceElement)((byte)(n3 & 0xFF));
            objectArray[4] = (StackTraceElement)((byte)((n3 & 0xFF00) >> 8));
            objectArray[5] = (StackTraceElement)((byte)((n3 & 0xFF0000) >> 16));
            objectArray[6] = (StackTraceElement)((byte)((n3 & 0xFF000000) >> 24));
        }
        return objectArray;
    }

    private byte[] encodeDetectionAreas() {
        int n;
        CMByteBuffer cMByteBuffer = new CMByteBuffer();
        int n2 = this.getWidgetCount();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 += this.getWidget(n).getDetectionAreas().size();
        }
        cMByteBuffer.appendInt(n3);
        Vector<CGSDetectArea> vector = this.getDetectionAreas();
        for (n = 0; n < vector.size(); ++n) {
            CGSDetectArea cGSDetectArea = vector.get(n);
            cMByteBuffer.appendBytes(cGSDetectArea.encode());
        }
        return cMByteBuffer.str();
    }

    @Override
    public boolean isChartMirroringEnabled() {
        return this.m_pBaseProp.getChartMirroring();
    }

    @Override
    public CGSEnums.TextDirection getTextDirection() {
        return this.m_pBaseProp.getTextDirection();
    }

    private void applyMirroring() {
        if (this.m_appliedMirroring) {
            return;
        }
        for (int i = 0; i < this.getWidgetCount(); ++i) {
            this.updatePropertyForMirroring(this.getWidget(i).getBaseProp());
        }
        this.updatePropertyForMirroring(this.getBaseProp());
        this.m_appliedMirroring = true;
    }

    private void updatePropertyForMirroring(CGSProp cGSProp) {
        cGSProp.mirror();
        for (int i = 0; i < cGSProp.getPropCount(); ++i) {
            this.updatePropertyForMirroring(cGSProp.getPropByIndex(i));
        }
    }
}

