/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.FrameWork;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.FrameWork.CGSCanvasRef;
import com.ibm.cgsBus.FrameWork.CGSDataColumn;
import com.ibm.cgsBus.FrameWork.CGSDataItem;
import com.ibm.cgsBus.FrameWork.CGSDataRow;
import com.ibm.cgsBus.FrameWork.CGSIDataFactory;
import com.ibm.cgsBus.FrameWork.CGSWidget;
import com.ibm.cgsBus.FrameWork.CGSWidgetRef;
import com.ibm.cgsBus.Properties.CGSPropCanvas;
import com.ibm.cgsBus.Properties.CGSPropChartCombo;
import com.ibm.cgsBus.Properties.CGSPropChartPie;
import com.ibm.cgsBus.Properties.CGSPropChartProgressive;
import com.ibm.cgsBus.Properties.CGSPropComboElem;
import com.ibm.cgsBus.Properties.CGSPropLegend;
import com.ibm.cgsBus.Properties.CGSPropLegendBase;
import com.ibm.cgsBus.Properties.CGSPropLegendItem;
import com.ibm.cgsBus.Types.CGSEnums;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;

public class CGSData {
    public static final int eGridCategory_X = 0;
    public static final int eGridCategory_X_Nest = 1;
    public static final int eGridCategory_Y = 2;
    public static final int eGridCategory_Y_Nest = 3;
    public static final int eGridSeries = 4;
    public static final int eGridRowIndex = 5;
    public static final int eGridCategoryNIndices = 6;
    public static final int eGridShowDataValues = 7;
    public static final int eGridParetoShowDataValues = 7;
    public static final int eGridParetoSortOrder = 8;
    public static final int eGridPiePercentages = 9;
    public static final int eGridSeriesColorByValue = 10;
    public static final int eGridPieExplodeDistances = 11;
    public static final int eGridLineColorPercent = 12;
    public static final int eGridGlyphSize = 14;
    public static final int eGridSeriesName = 15;
    public static final int eGridMMSeriesIndex = 16;
    public static final int eGridMMCategoryIndex = 17;
    public static final int eAxisX = 0;
    public static final int eAxisY = 1;
    public static final int eAxisTopLeft = 1;
    public static final int eAxisTopRight = 2;
    public static final int eAxisBottomLeft = 3;
    public static final int eAxisBottomRight = 4;
    public static final int eAxisZ = 5;
    public static final int CGS_DEFAULT_FORMAT_INDEX = -1;
    public static final int CGS_ERROR_FORMAT_INDEX = -2;
    protected CGSCanvasRef m_pCanvas = null;
    protected CGSWidgetRef m_pWidget = null;
    protected Vector<CGSDataColumn> m_columns = new Vector();
    protected Vector<CGSDataRow> m_rows = new Vector();
    protected Hashtable<String, Integer> m_rowsIndex = new Hashtable();
    protected int m_categoryCount = 0;
    protected int[] m_seriesCount = null;
    protected int m_numGroupedRows = 0;
    protected boolean m_gridSet = false;
    protected Object[] m_gridColumns = null;
    protected Class<?>[] m_gridTypes = null;
    protected Object[] m_gridNulls = null;
    protected int[] m_gridColEleIndex = null;
    protected int[] m_gridColTypes = null;
    protected String[] m_gridColTitles = null;
    protected String[] m_gridColSeriesName = null;
    protected String[] m_gridColMeasureName = null;
    protected int[] m_gridColSeriesIndex = null;
    protected boolean m_gridColumnsAmpersandEncodingFixed = false;
    protected CellInfo[][] m_gridCellInfo = null;
    protected int[] m_targetAxis = null;
    protected HashMap<Integer, String> m_axisTitles = null;
    protected int m_paletteCol = -1;
    protected int m_pieExplodeCol = -1;
    protected String m_legendTitle = null;
    protected int[] m_firstMeasureCol = null;
    protected int[] m_categoriesFirstRowIndex = null;
    protected Vector<Integer> m_gridSeriesIndices = null;
    protected int[] m_gaugeOriginalMeasureCol = null;
    protected int[] m_gaugeOriginalColorByValueCol = null;

    public CGSData(CGSCanvasRef cGSCanvasRef, CGSWidgetRef cGSWidgetRef) {
        this.m_pCanvas = cGSCanvasRef;
        this.m_pWidget = cGSWidgetRef;
    }

    public int getGridColumnCount() {
        this.prepareData();
        return this.m_gridColumns == null ? 0 : this.m_gridColumns.length;
    }

    public int getGridColumnType(int n) {
        this.prepareData();
        return this.m_gridColTypes[n];
    }

    public int getGridColumnElementIndex(int n) {
        this.prepareData();
        return this.m_gridColEleIndex[n];
    }

    public int getGridColumnSeriesIndex(int n) {
        this.prepareData();
        return this.m_gridColSeriesIndex[n];
    }

    public String getGridColumnTitle(int n) {
        this.prepareData();
        return this.m_gridColTitles[n];
    }

    public String getGridSeriesName(int n) {
        this.prepareData();
        return this.m_gridColSeriesName[n];
    }

    public String getGridMeasureName(int n) {
        this.prepareData();
        return this.m_gridColMeasureName[n];
    }

    public Object[] getGridColumns() {
        this.prepareData();
        return this.m_gridColumns;
    }

    public Class<?>[] getGridTypes() {
        this.prepareData();
        return this.m_gridTypes;
    }

    public Object[] getGridNulls() {
        this.prepareData();
        return this.m_gridNulls;
    }

    public int getGridSeriesCount(int n) {
        this.prepareData();
        int n2 = 0;
        int n3 = this.getGridColumnCount();
        for (int i = 0; i < n3; ++i) {
            if (this.m_gridColEleIndex[i] != n || this.m_gridColTypes[i] != 4) continue;
            ++n2;
        }
        return n2;
    }

    public CellInfo getGridCellInfo(int n) {
        CellInfo cellInfo = null;
        boolean bl = false;
        int n2 = this.m_gridCellInfo[0].length;
        int n3 = this.m_gridCellInfo.length;
        for (int i = 0; i < n3 && !bl; ++i) {
            for (int j = 0; j < n2 && !bl; ++j) {
                if (this.m_gridCellInfo[i][j].rowIndex < 0 || this.getRow(this.m_gridCellInfo[i][j].rowIndex).getRowIndex() != n) continue;
                cellInfo = new CellInfo();
                cellInfo.colIndex = j;
                cellInfo.rowIndex = i;
                bl = true;
            }
        }
        return cellInfo;
    }

    public int getTableColumnIndex(int n, int n2) {
        if (this.m_pWidget.getType() == CGSWidget.WidgetType.eChartGauge) {
            CMHelper.CGS_ASSERT(this.m_gaugeOriginalMeasureCol != null, "Original gauge measure column not specified");
            int n3 = this.getTableRowIndex(n, n2);
            int n4 = this.m_gridCellInfo[n][n2].colIndex;
            if (n3 == -1 || this.m_rows.get(n3).getRowIndex() == -1) {
                return -1;
            }
            if (this.m_columns.get((int)n4).m_type == CGSWidget.DataType.eMeasure) {
                return this.m_gaugeOriginalMeasureCol[this.m_rows.get(n3).getRowIndex()];
            }
            if (this.m_columns.get((int)n4).m_type == CGSWidget.DataType.eMeasureColorByValue) {
                return this.m_gaugeOriginalColorByValueCol[this.m_rows.get(n3).getRowIndex()];
            }
            return -1;
        }
        return this.m_gridCellInfo[n][n2].colIndex;
    }

    public int getTableRowIndex(int n, int n2) {
        return this.m_gridCellInfo[n][n2].rowIndex;
    }

    public boolean getIsGroupedData(int n, int n2) {
        return this.m_gridCellInfo[n][n2].isGroupedData;
    }

    public void setIsGroupedData(int n, int n2, boolean bl) {
        this.m_gridCellInfo[n][n2].isGroupedData = bl;
    }

    public void addFormattedValueToCell(int n, int n2, int n3, String string) {
        this.m_gridCellInfo[n][n2].addFormattedValue(n3, string);
    }

    public void addFormattedValueToCell(int n, int n2, String string) {
        int n3 = this.getTableColumnIndex(n, n2);
        this.addFormattedValueToCell(n, n2, n3, string);
    }

    public HashMap<Integer, String> getFormattedValues(int n, int n2) {
        return this.m_gridCellInfo[n][n2].formattedValues;
    }

    public int getAxisLocation(int n) {
        this.prepareData();
        if (this.m_targetAxis == null) {
            return 1;
        }
        return this.m_targetAxis[n];
    }

    public String getAxisTitle(int n) {
        this.prepareData();
        if (this.m_axisTitles == null) {
            return "";
        }
        return this.m_axisTitles.get(n);
    }

    public int getGridRowIndexColumn() {
        int n = 0;
        int n2 = this.getGridColumnCount();
        for (n = 0; n < n2 && this.m_gridColTypes[n] != 5; ++n) {
        }
        CMHelper.CGS_ASSERT(n != n2, "Grid Row Index column not found");
        return n;
    }

    public int getGridUniqueLeafIndexColumn() {
        int n = 0;
        int n2 = this.getGridColumnCount();
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            if (this.m_gridColTypes[n] != 6) continue;
            n3 = n;
        }
        return n3;
    }

    public boolean isNestedData() {
        int n = 0;
        int n2 = this.getGridColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (this.getGridColumnType(i) != 1) continue;
            ++n;
        }
        return n > 1;
    }

    public int getColumnByType(int n, int n2) {
        int n3 = -1;
        int n4 = this.m_gridColSeriesIndex[n2];
        int n5 = this.m_gridColEleIndex[n2];
        int n6 = this.getGridColumnCount();
        for (int i = 0; i < n6; ++i) {
            if (this.m_gridColTypes[i] != n || this.m_gridColEleIndex[i] != n5 || this.m_gridColSeriesIndex[i] != n4) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    public int getShowDataValueColumn(int n) {
        return this.getColumnByType(7, n);
    }

    public int getLineColorPercentColumn(int n) {
        return this.getColumnByType(12, n);
    }

    public int getColorByValueColumn(int n) {
        return this.getColumnByType(10, n);
    }

    public String getColorByValueMeasure(int n) {
        Vector<Integer> vector = this.getColumnIndices(CGSWidget.DataType.eMeasureColorByValue, n);
        return vector.size() == 0 ? "" : this.getColumn((int)vector.elementAt((int)0).intValue()).m_name;
    }

    public double getColorByValueValue(int n, int n2, int n3) {
        double d = Double.NaN;
        int n4 = this.getGridColumnCount();
        for (int i = 0; i < n4; ++i) {
            if (this.m_gridColTypes[i] != 10 || this.m_gridColEleIndex[i] != n || this.m_gridColSeriesIndex[i] != n2) continue;
            double[] dArray = (double[])this.m_gridColumns[i];
            d = dArray[n3];
            break;
        }
        return d;
    }

    public double getColorByValueDataMin(int n) {
        double d = Double.NaN;
        int n2 = this.getGridColumnCount();
        for (int i = 0; i < n2; ++i) {
            double d2;
            if (this.m_gridColTypes[i] != 10 || this.m_gridColEleIndex[i] != n || Double.isNaN(d2 = this.getGridColumnDataMin(i))) continue;
            d = !Double.isNaN(d) ? Math.min(d, d2) : d2;
        }
        return d;
    }

    public double getColorByValueDataMax(int n) {
        double d = Double.NaN;
        int n2 = this.getGridColumnCount();
        for (int i = 0; i < n2; ++i) {
            double d2;
            if (this.m_gridColTypes[i] != 10 || this.m_gridColEleIndex[i] != n || Double.isNaN(d2 = this.getGridColumnDataMax(i))) continue;
            d = !Double.isNaN(d) ? Math.max(d, d2) : d2;
        }
        return d;
    }

    public double getGridColumnDataMin(int n) {
        double d = Double.NaN;
        double d2 = 0.0;
        double[] dArray = (double[])this.m_gridColumns[n];
        for (int i = 0; i < dArray.length; ++i) {
            d2 = dArray[i];
            if (Double.isNaN(d2)) continue;
            d = Double.isNaN(d) ? d2 : Math.min(d, d2);
        }
        return d;
    }

    public double getGridColumnDataMax(int n) {
        double d = Double.NaN;
        double d2 = 0.0;
        double[] dArray = (double[])this.m_gridColumns[n];
        for (int i = 0; i < dArray.length; ++i) {
            d2 = dArray[i];
            if (Double.isNaN(d2)) continue;
            d = Double.isNaN(d) ? d2 : Math.max(d, d2);
        }
        return d;
    }

    public int setColumn(CGSDataColumn cGSDataColumn, int n) {
        int n2 = this.m_columns.size();
        if (n2 == n) {
            this.m_columns.addElement(cGSDataColumn);
        } else if (n2 < n) {
            for (int i = this.m_columns.size(); i < n; ++i) {
                this.m_columns.addElement(null);
            }
            this.m_columns.addElement(cGSDataColumn);
        } else {
            this.m_columns.setElementAt(cGSDataColumn, n);
        }
        return n;
    }

    public int appendRow(CGSDataRow cGSDataRow) {
        this.m_rows.addElement(cGSDataRow);
        return this.m_rows.size() - 1;
    }

    private void appendDummyCategoryColumn() {
        CGSDataColumn cGSDataColumn = new CGSDataColumn();
        cGSDataColumn.m_type = CGSWidget.DataType.eCategory;
        cGSDataColumn.m_name = "";
        cGSDataColumn.m_string_list.add("");
        this.m_columns.addElement(cGSDataColumn);
        int n = this.m_rows.size();
        for (int i = 0; i < n; ++i) {
            CGSDataRow cGSDataRow = this.m_rows.elementAt(i);
            cGSDataRow.appendDummyCategoryItem();
        }
    }

    public int getRowCount() {
        return this.m_rows.size();
    }

    public CGSDataRow getRow(int n) {
        CMHelper.CGS_ASSERT(n >= 0 && n < this.getRowCount(), "Invalid row index " + n);
        return this.m_rows.elementAt(n);
    }

    public int getRow(int n, int n2, int n3) {
        Integer n4 = this.m_rowsIndex.get(this.createKey(n, n3, n2));
        return n4 != null ? n4 : -1;
    }

    public int getCategoryCount(int n) {
        this.prepareData();
        return this.m_categoryCount;
    }

    public int getSeriesCount(int n) {
        this.prepareData();
        return this.m_seriesCount[n];
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.m_columns.size());
        for (CGSDataColumn object : this.m_columns) {
            object.save(dataOutputStream);
        }
        dataOutputStream.writeInt(this.m_rows.size());
        for (CGSDataRow cGSDataRow : this.m_rows) {
            cGSDataRow.save(dataOutputStream);
        }
    }

    public void restore(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        this.m_columns.setSize(n);
        for (int i = 0; i < n; ++i) {
            CGSDataColumn cGSDataColumn = new CGSDataColumn();
            cGSDataColumn.restore(dataInputStream);
            this.m_columns.set(i, cGSDataColumn);
        }
        CGSIDataFactory cGSIDataFactory = this.m_pWidget.getDataFactory();
        int n2 = dataInputStream.readInt();
        this.m_rows.setSize(n2);
        for (int i = 0; i < n2; ++i) {
            CGSDataRow cGSDataRow = cGSIDataFactory.createDataRow(n);
            cGSDataRow.restore(dataInputStream);
            this.m_rows.set(i, cGSDataRow);
        }
    }

    public int getColumnCount() {
        return this.m_columns.size();
    }

    public CGSDataColumn getColumn(int n) {
        return this.m_columns.elementAt(n);
    }

    public int getCategoryColumnCount() {
        return this.getColumnTypeCount(CGSWidget.DataType.eCategory, 0);
    }

    public int getSeriesColumnCount(int n) {
        return this.getColumnTypeCount(CGSWidget.DataType.eSeries, n);
    }

    public int getMeasureColumnCount(int n) {
        return this.getColumnTypeCount(CGSWidget.DataType.eMeasure, n);
    }

    public Vector<Integer> getMeasureColumnIndices(int n) {
        return this.getColumnIndices(CGSWidget.DataType.eMeasure, n);
    }

    public int getPaletteColumnCount(int n) {
        return this.getColumnTypeCount(CGSWidget.DataType.ePaletteElem, n);
    }

    protected int getColumnTypeCount(CGSWidget.DataType dataType, int n) {
        return this.getColumnIndices(dataType, n).size();
    }

    protected Vector<Integer> getColumnIndices(CGSWidget.DataType dataType, int n) {
        Vector<Integer> vector = new Vector<Integer>();
        CGSDataColumn cGSDataColumn = null;
        int n2 = this.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            cGSDataColumn = this.getColumn(i);
            if (cGSDataColumn.m_type != dataType || cGSDataColumn.m_elementIndex != n) continue;
            vector.addElement(i);
        }
        return vector;
    }

    public void fixGridColumnAmpersandEncoding() {
        int n = this.getGridColumnCount();
        if (n > 0 && !this.m_gridColumnsAmpersandEncodingFixed) {
            Object[] objectArray = this.getGridColumns();
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] == null || objectArray[i].getClass() != Object[].class && objectArray[i].getClass() != String[].class) continue;
                this.fixGridColumnAmpersandEncoding(i);
            }
            this.m_gridColumnsAmpersandEncodingFixed = true;
        }
    }

    public void fixGridColumnAmpersandEncoding(int n) {
        if (n >= 0) {
            Object[] objectArray = this.getGridColumns();
            for (int i = 0; i < ((Object[])objectArray[n]).length; ++i) {
                if (((Object[])objectArray[n])[i] == null) continue;
                ((Object[])objectArray[n])[i] = ((Object[])objectArray[n])[i].toString().replaceAll("&", "&amp;");
                ((Object[])objectArray[n])[i] = ((Object[])objectArray[n])[i].toString().replaceAll("<", "&lt;");
                ((Object[])objectArray[n])[i] = ((Object[])objectArray[n])[i].toString().replaceAll(">", "&gt;");
            }
        }
    }

    public String getDefaultLegendTitle() {
        this.prepareData();
        return this.m_legendTitle;
    }

    protected void initializeGrid(int n, int n2) {
        this.m_gridColumns = new Object[n2];
        this.m_gridTypes = new Class[n2];
        this.m_gridNulls = new Object[n2];
        this.m_gridColTypes = new int[n2];
        this.m_gridColEleIndex = new int[n2];
        this.m_gridColTitles = new String[n2];
        this.m_gridColSeriesName = new String[n2];
        this.m_gridColMeasureName = new String[n2];
        this.m_gridColSeriesIndex = new int[n2];
        this.m_gridCellInfo = new CellInfo[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.m_gridCellInfo[i][j] = new CellInfo();
            }
        }
    }

    public void prepareData() {
        int n;
        int n2;
        int n3;
        int n4;
        String string;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Object object;
        Object object2;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        if (this.m_gridSet) {
            return;
        }
        this.m_gridSet = true;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string2 = "";
        boolean bl7 = this.m_pWidget.isMultiMeasure();
        boolean bl8 = this.m_pWidget.isDataPointShapeByCategory();
        CGSWidget.DataType dataType = CGSWidget.DataType.eSeries;
        CGSWidget.DataType dataType2 = CGSWidget.DataType.eCategory;
        int n16 = 1;
        block0 : switch (this.m_pWidget.getType()) {
            case eChartPie: {
                bl = true;
                bl3 = true;
                dataType = CGSWidget.DataType.eCategory;
                dataType2 = CGSWidget.DataType.eSeries;
                break;
            }
            case eChartGauge: {
                this.flattenGaugeData();
                dataType = CGSWidget.DataType.eCategory;
                dataType2 = CGSWidget.DataType.eSeries;
                break;
            }
            case eChartCombo: {
                bl = true;
                bl2 = true;
                n15 = 0;
                for (int i = 0; i < this.m_columns.size(); ++i) {
                    CGSDataColumn cGSDataColumn = this.m_columns.elementAt(i);
                    if (cGSDataColumn.m_type != CGSWidget.DataType.eCategory) continue;
                    n15 = 1;
                }
                if (n15 == 0) {
                    this.appendDummyCategoryColumn();
                }
                CGSPropChartCombo cGSPropChartCombo = (CGSPropChartCombo)this.m_pWidget.getBaseProp().getProp(CGSEnums.PropType.ePropChartCombo);
                n16 = cGSPropChartCombo.getChartCount();
                for (n14 = 0; n14 < n16; ++n14) {
                    CGSPropComboElem cGSPropComboElem = cGSPropChartCombo.getChart(n14);
                    if (cGSPropComboElem.getPropType() != CGSEnums.PropType.ePropComboElemLine) continue;
                    bl5 = true;
                    break block0;
                }
                break;
            }
            case eChartProgressive: {
                bl = true;
                bl2 = true;
                CGSPropChartProgressive cGSPropChartProgressive = (CGSPropChartProgressive)this.m_pWidget.getBaseProp().getProp(CGSEnums.PropType.ePropChartProgressive);
                if (this.m_pWidget.isCategoriesReversed()) {
                    cGSPropChartProgressive.setShowTotalBar(true);
                }
                if (!cGSPropChartProgressive.getShowTotalBar()) break;
                bl4 = true;
                string2 = cGSPropChartProgressive.getTotalBarLabel();
                break;
            }
            case eChartPareto: {
                bl6 = true;
                break;
            }
        }
        n15 = 0;
        int n17 = 0;
        n14 = this.m_rows.size();
        int n18 = this.m_columns.size();
        int n19 = 0;
        CGSDataRow cGSDataRow = null;
        CGSDataColumn cGSDataColumn = null;
        boolean bl9 = true;
        boolean bl10 = true;
        int n20 = 0;
        this.m_gridSeriesIndices = new Vector();
        String string3 = ((CGSPropCanvas)this.m_pCanvas.getBaseProp()).getSeparator();
        CGSPropLegendBase cGSPropLegendBase = (CGSPropLegendBase)this.m_pWidget.getBaseProp().getProp(CGSEnums.PropType.ePropLegend);
        if (cGSPropLegendBase == null) {
            cGSPropLegendBase = (CGSPropLegendBase)this.m_pWidget.getBaseProp().getProp(CGSEnums.PropType.ePropMapLegend);
        }
        CGSPropLegendItem cGSPropLegendItem = (CGSPropLegendItem)cGSPropLegendBase.getProp(CGSEnums.PropType.ePropLegendItem);
        String string4 = cGSPropLegendItem.getSeparator();
        Vector<String> vector = this.getSeriesNames();
        if (bl8) {
            for (n17 = 0; n17 < n18; ++n17) {
                cGSDataColumn = this.m_columns.elementAt(n17);
                if (cGSDataColumn.m_type != CGSWidget.DataType.eCategory) continue;
                n13 = 0;
                for (n12 = 0; n12 < vector.size(); ++n12) {
                    if (vector.elementAt(n12).compareTo(cGSDataColumn.m_name) != 0) continue;
                    n13 = 1;
                    break;
                }
                if (n13 != 0 || cGSDataColumn.m_name == null) continue;
                vector.addElement(cGSDataColumn.m_name);
            }
        }
        this.m_legendTitle = this.buildTitle(vector);
        n13 = -1;
        for (n17 = 0; n17 < n18; ++n17) {
            cGSDataColumn = this.m_columns.elementAt(n17);
            if (cGSDataColumn.m_type == CGSWidget.DataType.eMeasure) {
                if (cGSDataColumn.m_elementIndex <= n13) continue;
                n13 = cGSDataColumn.m_elementIndex;
                continue;
            }
            if (cGSDataColumn.m_type == dataType2) {
                bl9 = false;
                ++n20;
                continue;
            }
            if (cGSDataColumn.m_type == dataType) {
                bl10 = false;
                continue;
            }
            if (cGSDataColumn.m_type == CGSWidget.DataType.ePaletteElem) {
                this.m_paletteCol = n17;
                continue;
            }
            if (cGSDataColumn.m_type != CGSWidget.DataType.ePieExplodeDistance) continue;
            this.m_pieExplodeCol = n17;
        }
        n12 = n13 + 1;
        if (n12 == 0) {
            return;
        }
        this.m_firstMeasureCol = new int[n12];
        for (n11 = 0; n11 < n12; ++n11) {
            this.m_firstMeasureCol[n11] = -1;
        }
        this.m_axisTitles = new HashMap();
        this.m_targetAxis = new int[n12];
        n11 = 0;
        while (n11 < n12) {
            this.m_targetAxis[n11++] = 1;
        }
        n11 = 0;
        int n21 = 0;
        for (n17 = 0; n17 < n18; ++n17) {
            int n22;
            cGSDataColumn = this.m_columns.elementAt(n17);
            n10 = -1;
            if (this.m_gaugeOriginalMeasureCol != null) {
                for (n22 = 0; n22 < this.m_gaugeOriginalMeasureCol.length; ++n22) {
                    if (this.m_gaugeOriginalMeasureCol[n22] != n17) continue;
                    n10 = n17;
                    cGSDataColumn = this.m_columns.elementAt(n17);
                }
            }
            if (cGSDataColumn.m_type != CGSWidget.DataType.eMeasure && n10 <= -1) continue;
            if (this.m_firstMeasureCol.length > cGSDataColumn.m_elementIndex && this.m_targetAxis.length > cGSDataColumn.m_elementIndex) {
                if (this.m_firstMeasureCol[cGSDataColumn.m_elementIndex] == -1) {
                    this.m_firstMeasureCol[cGSDataColumn.m_elementIndex] = n17;
                }
                this.m_targetAxis[cGSDataColumn.m_elementIndex] = cGSDataColumn.m_targetAxis;
            }
            if (bl7) {
                switch (n11) {
                    case 0: {
                        this.m_axisTitles.put(0, cGSDataColumn.m_name);
                        break;
                    }
                    case 1: {
                        this.m_axisTitles.put(1, cGSDataColumn.m_name);
                        break;
                    }
                    case 2: {
                        this.m_axisTitles.put(5, cGSDataColumn.m_name);
                        break;
                    }
                }
                ++n11;
                continue;
            }
            n22 = cGSDataColumn.m_targetAxis;
            if (n10 >= 0) {
                n22 = n21++;
            }
            if ((object2 = this.m_axisTitles.get(n22)) != null && (cGSDataColumn.m_name == null || ((String)object2).indexOf(cGSDataColumn.m_name) != -1)) continue;
            object = new StringBuilder();
            if (object2 != null) {
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append(string3);
            }
            ((StringBuilder)object).append(cGSDataColumn.m_name);
            this.m_axisTitles.put(n22, ((StringBuilder)object).toString());
        }
        block21: for (n15 = 0; n15 < n14; ++n15) {
            cGSDataRow = this.m_rows.elementAt(n15);
            cGSDataRow.setCategoryIndex(n15);
            cGSDataRow.setSeriesIndex(0);
            if (n16 == 1) {
                cGSDataRow.setElementIndex(0);
                continue;
            }
            cGSDataRow.setElementIndex(-1);
            for (n17 = 0; n17 < n18; ++n17) {
                cGSDataColumn = this.m_columns.elementAt(n17);
                if (cGSDataColumn.m_type == CGSWidget.DataType.eSeries && cGSDataRow.getAt((int)n17).m_index != -1) {
                    cGSDataRow.setElementIndex(cGSDataColumn.m_elementIndex);
                    continue block21;
                }
                if (cGSDataColumn.m_type != CGSWidget.DataType.eMeasure || Double.isNaN(cGSDataRow.getAt((int)n17).m_value)) continue;
                cGSDataRow.setElementIndex(cGSDataColumn.m_elementIndex);
                continue block21;
            }
        }
        this.m_seriesCount = new int[n12];
        n10 = 0;
        while (n10 < n12) {
            this.m_seriesCount[n10++] = 0;
        }
        n10 = 0;
        for (n17 = 0; n17 < n18; ++n17) {
            cGSDataColumn = this.m_columns.elementAt(n17);
            if (cGSDataColumn.m_type != CGSWidget.DataType.eXMatrix && cGSDataColumn.m_type != CGSWidget.DataType.eYMatrix) continue;
            n10 = 1;
            break;
        }
        ArrayList[] arrayListArray = new ArrayList[n12];
        object2 = n10 != 0 ? null : new ArrayList[n12];
        for (n19 = 0; n19 < n12; ++n19) {
            arrayListArray[n19] = new ArrayList();
            if (n10 != 0) continue;
            object2[n19] = new ArrayList();
        }
        for (n19 = 0; n19 < n12; ++n19) {
            for (n15 = 0; n15 < n14; ++n15) {
                cGSDataRow = this.m_rows.elementAt(n15);
                if (cGSDataRow.getElementIndex() != n19) continue;
                object = new StringBuilder();
                StringBuilder stringBuilder = n10 == 0 ? new StringBuilder() : null;
                for (n17 = 0; n17 < n18; ++n17) {
                    cGSDataColumn = this.m_columns.elementAt(n17);
                    if (cGSDataColumn.m_type != dataType || cGSDataColumn.m_elementIndex != n19 || (n9 = cGSDataRow.getAt((int)n17).m_index) == -1) continue;
                    if (((StringBuilder)object).length() != 0) {
                        ((StringBuilder)object).append(string4);
                        if (n10 == 0) {
                            stringBuilder.append(string4);
                        }
                    }
                    ((StringBuilder)object).append(cGSDataColumn.m_string_list.elementAt(n9));
                    if (n10 != 0) continue;
                    stringBuilder.append(n9);
                }
                n9 = 1;
                if (n10 == 0) {
                    n9 = ((ArrayList)object2[n19]).indexOf(stringBuilder.toString());
                    if (n9 == -1) {
                        ((ArrayList)object2[n19]).add(stringBuilder.toString());
                        arrayListArray[n19].add(((StringBuilder)object).toString());
                        n9 = arrayListArray[n19].size() - 1;
                    }
                } else {
                    n9 = arrayListArray[n19].indexOf(((StringBuilder)object).toString());
                    if (n9 == -1) {
                        arrayListArray[n19].add(((StringBuilder)object).toString());
                        n9 = arrayListArray[n19].size() - 1;
                    }
                }
                cGSDataRow.setSeriesIndex(n9);
                this.m_seriesCount[n19] = Math.max(this.m_seriesCount[n19], n9 + 1);
            }
        }
        object = new int[n18];
        for (n8 = 0; n8 < n18; ++n8) {
            object[n8] = -1;
        }
        n8 = 0;
        n9 = bl7 ? 0 : 1;
        for (n19 = 0; n19 < n12; ++n19) {
            for (n17 = 0; n17 < n18; ++n17) {
                cGSDataColumn = this.m_columns.elementAt(n17);
                if (cGSDataColumn.m_type != CGSWidget.DataType.eMeasure || cGSDataColumn.m_elementIndex != n19) continue;
                if (bl7) {
                    object[n17] = n9;
                    ++n9;
                } else {
                    object[n17] = n8;
                }
                n8 += arrayListArray[n19].size();
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList[] arrayListArray2 = null;
        ArrayList[] arrayListArray3 = null;
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = null;
        if (n20 != 0) {
            StringBuilder stringBuilder2 = new StringBuilder();
            StringBuilder stringBuilder3 = new StringBuilder();
            String[] stringArray2 = new String[n20];
            int[] nArray = new int[n20];
            arrayListArray2 = new ArrayList[n20];
            arrayListArray3 = new ArrayList[n20];
            stringArray = new String[n20];
            for (n7 = 0; n7 < n20; ++n7) {
                arrayListArray2[n7] = new ArrayList();
                arrayListArray3[n7] = new ArrayList();
                stringArray2[n7] = null;
                nArray[n7] = -1;
                stringArray[n7] = null;
            }
            n7 = 0;
            for (n17 = 0; n17 < n18; ++n17) {
                cGSDataColumn = this.m_columns.elementAt(n17);
                if (cGSDataColumn.m_type != dataType2) continue;
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(string3);
                }
                stringBuilder.append(cGSDataColumn.m_name);
                stringArray[n7] = cGSDataColumn.m_name;
                ++n7;
            }
            for (n15 = 0; n15 < n14; ++n15) {
                cGSDataRow = this.m_rows.elementAt(n15);
                stringBuilder3.setLength(0);
                stringBuilder2.setLength(0);
                for (n6 = 0; n6 < n20; ++n6) {
                    stringArray2[n6] = null;
                    nArray[n6] = -1;
                }
                n7 = 0;
                n6 = -1;
                n5 = 0;
                for (n17 = 0; n17 < n18; ++n17) {
                    cGSDataColumn = this.m_columns.elementAt(n17);
                    if (cGSDataColumn.m_type != dataType2) continue;
                    n6 = cGSDataRow.getAt((int)n17).m_index;
                    if (n6 != -1) {
                        string = string3;
                        if (dataType2 == CGSWidget.DataType.eSeries) {
                            string = string4;
                        }
                        if (stringBuilder3.length() != 0) {
                            stringBuilder3.append(string);
                            stringBuilder2.append(string);
                        }
                        stringBuilder3.append(cGSDataColumn.m_string_list.elementAt(n6));
                        stringBuilder2.append(n6);
                        stringArray2[n7] = cGSDataColumn.m_string_list.elementAt(n6);
                        nArray[n7] = n6;
                        n5 = 1;
                    } else {
                        stringArray2[n7] = "";
                        n5 = 1;
                    }
                    ++n7;
                }
                if (n5 != 0) {
                    string = n6 + "_" + stringBuilder2.toString();
                    n4 = arrayList2.indexOf(string);
                    if (n4 == -1) {
                        arrayList2.add(string);
                        arrayList.add(stringBuilder3.toString());
                        n4 = arrayList.size() - 1;
                        for (int i = 0; i < n20; ++i) {
                            arrayListArray2[i].add(stringArray2[i]);
                            arrayListArray3[i].add(nArray[i]);
                        }
                    }
                    cGSDataRow.setCategoryIndex(n4);
                    this.m_categoryCount = Math.max(this.m_categoryCount, n4 + 1);
                    continue;
                }
                cGSDataRow.setCategoryIndex(bl10 ? n15 : 0);
                this.m_categoryCount = Math.max(this.m_categoryCount, bl10 ? n15 + 1 : 1);
            }
        } else {
            for (n15 = 0; n15 < n14; ++n15) {
                cGSDataRow = this.m_rows.elementAt(n15);
                cGSDataRow.setCategoryIndex(bl10 ? n15 : 0);
            }
        }
        int n23 = arrayList.size();
        if (bl4 && n23 > 0) {
            ++n23;
            arrayList.add(string2);
            for (int i = 0; i < n20; ++i) {
                arrayListArray2[i].add(i == n20 - 1 ? string2 : "");
                arrayListArray3[i].add(n23 * n20);
            }
        } else {
            bl4 = false;
        }
        if (n23 > 0) {
            int n24;
            this.m_categoriesFirstRowIndex = new int[n23];
            for (n24 = 0; n24 < n23; ++n24) {
                this.m_categoriesFirstRowIndex[n24] = -1;
            }
            for (n15 = 0; n15 < n14; ++n15) {
                cGSDataRow = this.m_rows.elementAt(n15);
                n19 = cGSDataRow.getElementIndex();
                n24 = cGSDataRow.getCategoryIndex();
                if (this.m_categoriesFirstRowIndex.length <= n24 || this.m_categoriesFirstRowIndex[n24] != -1) continue;
                if (n10 == 0) {
                    this.m_categoriesFirstRowIndex[n24] = n15;
                    continue;
                }
                if (cGSDataRow.getRowIndex() == -1) continue;
                this.m_categoriesFirstRowIndex[n24] = cGSDataRow.getRowIndex();
            }
        }
        if (n23 == 0) {
            if (bl10) {
                n23 = n14;
            } else if (bl9) {
                n23 = 1;
            }
            if (n23 == 0) {
                return;
            }
        }
        if (bl9) {
            bl2 = false;
        }
        int n25 = n20 != 0 ? 1 + n20 : 0;
        int n26 = 0;
        if (bl) {
            ++n26;
        }
        if (bl2) {
            n26 += n20;
        }
        if (bl3) {
            ++n26;
        }
        if (bl6) {
            n26 += 2;
        }
        CMHelper.CGS_ASSERT(n8 % n9 == 0, "Unexpected grid series count in calculations.");
        int n27 = n8 / n9;
        n7 = bl5 ? 3 : 2;
        n6 = n25 + n7 * n8 + n27 + n26;
        this.initializeGrid(n23, n6);
        n5 = 0;
        if (n25 != 0) {
            this.m_gridColumns[0] = arrayList.toArray();
            this.m_gridTypes[0] = String.class;
            this.m_gridNulls[0] = null;
            this.m_gridColTypes[0] = 0;
            this.m_gridColEleIndex[0] = 0;
            this.m_gridColTitles[0] = stringBuilder.toString();
            this.m_gridColSeriesIndex[0] = -1;
            string = this.m_axisTitles.get(0);
            if (!(bl7 || string != null && string.length() != 0)) {
                this.m_axisTitles.put(0, this.m_gridColTitles[0]);
            }
            for (n4 = 0; n4 < n20; ++n4) {
                this.m_gridColumns[1 + n4] = arrayListArray2[n4].toArray();
                this.m_gridTypes[1 + n4] = String.class;
                this.m_gridNulls[1 + n4] = null;
                this.m_gridColTypes[1 + n4] = 1;
                this.m_gridColEleIndex[1 + n4] = 0;
                this.m_gridColTitles[1 + n4] = stringArray[n4];
                this.m_gridColSeriesIndex[1 + n4] = -1;
            }
        }
        for (n3 = 0; n3 < n8; ++n3) {
            double[] dArray = new double[n23];
            int n28 = 0;
            while (n28 < n23) {
                dArray[n28++] = Double.NaN;
            }
            n5 = n25 + n3;
            this.m_gridColumns[n5] = dArray;
            this.m_gridTypes[n5] = Double.TYPE;
            this.m_gridNulls[n5] = new Double(Double.NaN);
            this.m_gridColTypes[n5] = 4;
            this.m_gridColEleIndex[n5] = 0;
            this.m_gridColTitles[n5] = null;
            this.m_gridColSeriesIndex[n5] = -1;
            this.m_gridSeriesIndices.add(n5);
            String[] stringArray3 = new String[n23];
            int n29 = 0;
            while (n29 < n23) {
                stringArray3[n29++] = "";
            }
            n5 = n25 + n8 + n3;
            this.m_gridColumns[n5] = stringArray3;
            this.m_gridTypes[n5] = String.class;
            this.m_gridNulls[n5] = "";
            this.m_gridColTypes[n5] = 7;
            this.m_gridColEleIndex[n5] = 0;
            this.m_gridColTitles[n5] = null;
            this.m_gridColSeriesIndex[n5] = -1;
            if (!bl5) continue;
            double[] dArray2 = new double[n23];
            n2 = 0;
            while (n2 < n23) {
                dArray2[n2++] = Double.NaN;
            }
            n5 = n25 + 2 * n8 + n3;
            this.m_gridColumns[n5] = dArray2;
            this.m_gridTypes[n5] = Double.TYPE;
            this.m_gridNulls[n5] = new Double(Double.NaN);
            this.m_gridColTypes[n5] = 12;
            this.m_gridColEleIndex[n5] = 0;
            this.m_gridColTitles[n5] = "<eGridLineColorPercent>";
            this.m_gridColSeriesIndex[n5] = -1;
        }
        for (n3 = 0; n3 < n27; ++n3) {
            double[] dArray = new double[n23];
            int n30 = 0;
            while (n30 < n23) {
                dArray[n30++] = Double.NaN;
            }
            n5 = n25 + n7 * n8 + n3;
            this.m_gridColumns[n5] = dArray;
            this.m_gridTypes[n5] = Double.TYPE;
            this.m_gridNulls[n5] = new Double(Double.NaN);
            this.m_gridColTypes[n5] = 10;
            this.m_gridColEleIndex[n5] = 0;
            this.m_gridColTitles[n5] = null;
            this.m_gridColSeriesIndex[n5] = -1;
        }
        n3 = 0;
        if (bl) {
            int[] nArray = new int[n23];
            int n31 = 0;
            while (n31 < n23) {
                nArray[n31] = n31++;
            }
            n5 = n25 + n7 * n8 + n27;
            this.m_gridColumns[n5] = nArray;
            this.m_gridTypes[n5] = Integer.TYPE;
            this.m_gridNulls[n5] = new Integer(Integer.MIN_VALUE);
            this.m_gridColTypes[n5] = 5;
            this.m_gridColEleIndex[n5] = -1;
            this.m_gridColTitles[n5] = "<eGridRowIndex>";
            this.m_gridColSeriesIndex[n5] = -1;
            ++n3;
        }
        if (bl2) {
            for (int i = 0; i < arrayListArray2.length; ++i) {
                n5 = n25 + n7 * n8 + n27 + n3;
                ArrayList arrayList3 = arrayListArray3[i];
                int[] nArray = new int[arrayList3.size()];
                if (i == 0) {
                    for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                        nArray[n2] = (Integer)arrayList3.get(n2);
                    }
                } else {
                    nArray[0] = n = 0;
                    for (int j = 1; j < arrayList3.size(); ++j) {
                        for (n2 = 0; n2 <= i && ((Integer)arrayListArray3[n2].get(j)).equals(arrayListArray3[n2].get(j - 1)); ++n2) {
                        }
                        nArray[j] = n2 > i ? n : ++n;
                    }
                }
                this.m_gridColumns[n5] = nArray;
                this.m_gridTypes[n5] = Integer.TYPE;
                this.m_gridNulls[n5] = new Integer(Integer.MIN_VALUE);
                this.m_gridColTypes[n5] = 6;
                this.m_gridColEleIndex[n5] = -1;
                this.m_gridColTitles[n5] = "<eGridCategoryNIndices>";
                this.m_gridColSeriesIndex[n5] = -1;
                ++n3;
            }
        }
        double d = 0.0;
        for (n15 = 0; n15 < n14; ++n15) {
            cGSDataRow = this.m_rows.elementAt(n15);
            n19 = cGSDataRow.getElementIndex();
            int n32 = cGSDataRow.getCategoryIndex();
            n2 = cGSDataRow.getSeriesIndex();
            if (n19 == -1 || n32 == -1 || n2 == -1) continue;
            for (n17 = 0; n17 < n18; ++n17) {
                double[] dArray;
                cGSDataColumn = this.m_columns.elementAt(n17);
                if (cGSDataColumn.m_type == CGSWidget.DataType.eMeasure && cGSDataColumn.m_elementIndex == n19 && object[n17] != -1) {
                    n = n25 + object[n17] + n9 * n2;
                    dArray = (double[])this.m_gridColumns[n];
                    double d2 = cGSDataRow.getAt((int)n17).m_value;
                    if (Double.isNaN(dArray[n32])) {
                        dArray[n32] = d2;
                        this.m_gridColEleIndex[n] = n19;
                        this.m_gridColSeriesIndex[n] = n2;
                        this.m_gridCellInfo[n32][n].rowIndex = n15;
                        this.m_gridCellInfo[n32][n].colIndex = n17;
                        this.m_gridColEleIndex[n += n8] = n19;
                        this.m_gridColSeriesIndex[n] = n2;
                        if (!Double.isNaN(d2)) {
                            d += d2;
                        }
                        if (bl5) {
                            this.m_gridColEleIndex[n += n8] = n19;
                            this.m_gridColSeriesIndex[n] = n2;
                        }
                    }
                }
                if (cGSDataColumn.m_type != CGSWidget.DataType.eMeasureColorByValue || cGSDataColumn.m_elementIndex != n19) continue;
                n = n25 + n7 * n8 + n2;
                dArray = (double[])this.m_gridColumns[n];
                dArray[n32] = cGSDataRow.getAt((int)n17).m_value;
                this.m_gridColEleIndex[n] = n19;
                this.m_gridColSeriesIndex[n] = n2;
                this.m_gridCellInfo[n32][n].rowIndex = n15;
                this.m_gridCellInfo[n32][n].colIndex = n17;
            }
        }
        if (bl4) {
            int n33 = n25;
            double[] dArray = (double[])this.m_gridColumns[n33];
            dArray[n23 - 1] = -d;
            String[] stringArray4 = (String[])this.m_gridColumns[n33 + n8];
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            stringArray4[n23 - 1] = numberFormat.format(d);
            for (n17 = 0; n17 < n18; ++n17) {
                cGSDataColumn = this.m_columns.elementAt(n17);
                if (cGSDataColumn.m_type == CGSWidget.DataType.eMeasure) break;
            }
            this.m_gridCellInfo[n23 - 1][n33].rowIndex = -1;
            this.m_gridCellInfo[n23 - 1][n33].colIndex = n17;
        }
        if (bl3) {
            double[] dArray = (double[])this.m_gridColumns[n25];
            String[] stringArray5 = new String[dArray.length];
            if (bl2) {
                ++n3;
            }
            n5 = n25 + n7 * n8 + n27 + n3;
            this.m_gridColumns[n5] = stringArray5;
            this.m_gridTypes[n5] = String.class;
            this.m_gridNulls[n5] = null;
            this.m_gridColTypes[n5] = 9;
            this.m_gridColEleIndex[n5] = -1;
            this.m_gridColTitles[n5] = "<eGridPiePercentages>";
            this.m_gridColSeriesIndex[n5] = -1;
            ++n3;
        }
        if (bl6) {
            n5 = n25 + n7 * n8 + n27 + n3;
            int n34 = 1;
            for (int i = 0; i < this.m_seriesCount.length; ++i) {
                n34 += this.m_seriesCount[i];
            }
            double[] dArray = new double[n23];
            this.m_gridColumns[n5] = dArray;
            this.m_gridTypes[n5] = Double.TYPE;
            this.m_gridNulls[n5] = new Double(Double.NaN);
            this.m_gridColTypes[n5] = 4;
            this.m_gridColEleIndex[n5] = 0;
            this.m_gridColTitles[n5] = "Total";
            this.m_gridColSeriesIndex[n5] = n34;
            this.m_gridColSeriesName[n5] = "Total";
            if (n8 > 0) {
                for (int i = 0; i < n23; ++i) {
                    this.m_gridCellInfo[i][n5].rowIndex = this.m_gridCellInfo[i][n25].rowIndex;
                    this.m_gridCellInfo[i][n5].colIndex = this.m_gridCellInfo[i][n25].colIndex;
                }
            }
            this.m_gridSeriesIndices.add(new Integer(n5));
            this.m_gridColumns[++n5] = new String[n23];
            for (int i = 0; i < n23; ++i) {
                ((String[])this.m_gridColumns[n5])[i] = "Total Label";
            }
            this.m_gridTypes[n5] = String.class;
            this.m_gridNulls[n5] = null;
            this.m_gridColTypes[n5] = 7;
            this.m_gridColEleIndex[n5] = 0;
            this.m_gridColTitles[n5] = "Total";
            this.m_gridColSeriesIndex[n5] = n34;
            n3 += 2;
        }
        for (n19 = 0; n19 < n12; ++n19) {
            for (n17 = 0; n17 < n18; ++n17) {
                cGSDataColumn = this.m_columns.elementAt(n17);
                if (cGSDataColumn.m_type != CGSWidget.DataType.eMeasure && cGSDataColumn.m_type != CGSWidget.DataType.eMeasureColorByValue || cGSDataColumn.m_elementIndex != n19) continue;
                for (int i = 0; i < arrayListArray[n19].size(); ++i) {
                    String string5 = (String)arrayListArray[n19].get(i);
                    String string6 = string5.length() == 0 ? cGSDataColumn.m_name : cGSDataColumn.m_name + string4 + string5;
                    int n35 = 0;
                    n35 = cGSDataColumn.m_type == CGSWidget.DataType.eMeasure ? n25 + object[n17] + n9 * i : n25 + n7 * n8 + i;
                    this.m_gridColTitles[n35] = string6;
                    this.m_gridColSeriesName[n35] = string5;
                    this.m_gridColMeasureName[n35] = cGSDataColumn.m_name;
                }
            }
        }
        if (this.m_pWidget.isCategoriesReversed() || this.isPieClockwise()) {
            this.reverseData(n6);
        }
        for (n15 = 0; n15 < n14; ++n15) {
            cGSDataRow = this.m_rows.elementAt(n15);
            this.m_rowsIndex.put(this.createKey(cGSDataRow.getElementIndex(), cGSDataRow.getCategoryIndex(), cGSDataRow.getSeriesIndex()), n15);
        }
    }

    private String createKey(int n, int n2, int n3) {
        return Integer.toString(n) + '#' + Integer.toString(n3) + '#' + Integer.toString(n2);
    }

    protected void reverseData(int n) {
        int n2 = 0;
        if (this.m_pWidget.getType() == CGSWidget.WidgetType.eChartPareto) {
            return;
        }
        if (this.m_pWidget.getType() == CGSWidget.WidgetType.eChartProgressive) {
            for (n2 = 0; n2 < n && this.getGridColumnType(n2) != 4; ++n2) {
            }
            double[] dArray = (double[])this.m_gridColumns[n2];
            int n3 = 0;
            while (n3 < dArray.length) {
                dArray[n3] = -dArray[n3++];
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (this.m_gridTypes[n2] == String.class) {
                CMHelper.reverseArrayObject((Object[])this.m_gridColumns[n2]);
                continue;
            }
            if (this.m_gridTypes[n2] == Double.TYPE) {
                CMHelper.reverseArrayDouble((double[])this.m_gridColumns[n2]);
                continue;
            }
            if (this.m_gridTypes[n2] == Integer.TYPE) {
                CMHelper.reverseArrayInt((int[])this.m_gridColumns[n2]);
                continue;
            }
            System.out.print("(" + n2 + ")" + "<unknown type>");
        }
    }

    protected boolean isPieClockwise() {
        if (this.m_pWidget.getType() != CGSWidget.WidgetType.eChartPie) {
            return false;
        }
        CGSPropChartPie cGSPropChartPie = (CGSPropChartPie)this.m_pWidget.getBaseProp().getProp(CGSEnums.PropType.ePropChartPie);
        return cGSPropChartPie.getShowClockwise();
    }

    private String buildTitle(Vector<String> vector) {
        String string = ((CGSPropCanvas)this.m_pCanvas.getBaseProp()).getSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < vector.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(vector.elementAt(i));
        }
        return stringBuilder.toString();
    }

    private Vector<String> getSeriesNames() {
        int n = this.m_columns.size();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            CGSDataColumn cGSDataColumn = this.m_columns.elementAt(i);
            if (cGSDataColumn.m_type != CGSWidget.DataType.eSeries) continue;
            boolean bl = false;
            for (int j = 0; j < vector.size(); ++j) {
                if (cGSDataColumn.m_name == null || vector.elementAt(j).compareTo(cGSDataColumn.m_name) != 0) continue;
                bl = true;
                break;
            }
            if (bl || cGSDataColumn.m_name == null) continue;
            vector.addElement(cGSDataColumn.m_name);
        }
        return vector;
    }

    public void setRowIndices() {
        for (int i = 0; i < this.m_rows.size(); ++i) {
            this.m_rows.get(i).setRowIndex(i);
        }
    }

    public int[] getGaugeOriginalMeasureCols() {
        return this.m_gaugeOriginalMeasureCol;
    }

    public void setGaugeOriginalMeasureCols(int[] nArray) {
        this.m_gaugeOriginalMeasureCol = nArray;
    }

    public int[] getGaugeOriginalColorByValueCols() {
        return this.m_gaugeOriginalColorByValueCol;
    }

    public void setGaugeOriginalColorByValueCols(int[] nArray) {
        this.m_gaugeOriginalColorByValueCol = nArray;
    }

    private void flattenGaugeData() {
        CGSDataColumn cGSDataColumn;
        int n;
        if (this.m_gaugeOriginalMeasureCol != null) {
            return;
        }
        int n2 = this.m_rows.size();
        int n3 = this.m_columns.size();
        if (n2 == 0) {
            return;
        }
        int n4 = -1;
        int n5 = -1;
        Vector<String> vector = new Vector<String>();
        this.m_gaugeOriginalMeasureCol = new int[n2];
        this.m_gaugeOriginalColorByValueCol = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.m_gaugeOriginalMeasureCol[i] = -1;
            this.m_gaugeOriginalColorByValueCol[i] = -1;
            double d = Double.NaN;
            String string = "";
            CGSDataRow cGSDataRow = this.m_rows.elementAt(i);
            for (n = 0; n < n3; ++n) {
                cGSDataColumn = this.m_columns.elementAt(n);
                CGSPropLegend cGSPropLegend = (CGSPropLegend)this.m_pWidget.getBaseProp().getProp(CGSEnums.PropType.ePropLegend);
                CGSPropLegendItem cGSPropLegendItem = (CGSPropLegendItem)cGSPropLegend.getProp(CGSEnums.PropType.ePropLegendItem);
                String string2 = cGSPropLegendItem.getSeparator();
                if (cGSDataColumn.m_type == CGSWidget.DataType.eSeries) {
                    if (n5 == -1) {
                        n5 = n;
                    }
                    if (cGSDataRow.getAt((int)n).m_index == -1) continue;
                    if (!string.equals("")) {
                        string = string + string2;
                    }
                    string = string + cGSDataColumn.m_string_list.elementAt(cGSDataRow.getAt((int)n).m_index);
                    continue;
                }
                if (cGSDataColumn.m_type == CGSWidget.DataType.eMeasure) {
                    double d2;
                    if (n4 == -1) {
                        n4 = n;
                    }
                    if (Double.isNaN(d2 = cGSDataRow.getAt((int)n).m_value)) continue;
                    d = d2;
                    this.m_gaugeOriginalMeasureCol[i] = n;
                    continue;
                }
                if (cGSDataColumn.m_type != CGSWidget.DataType.eMeasureColorByValue) continue;
                this.m_gaugeOriginalColorByValueCol[i] = n;
            }
            if (!vector.contains(string)) {
                vector.add(string);
            }
            int n6 = vector.indexOf(string);
            if (n4 > -1) {
                cGSDataRow.getAt((int)n4).m_value = d;
            }
            if (n5 <= -1) continue;
            cGSDataRow.getAt((int)n5).m_index = n6;
        }
        if (n5 > -1) {
            cGSDataColumn = this.m_columns.elementAt(n5);
            cGSDataColumn.m_string_list = vector;
            cGSDataColumn.m_name = this.buildTitle(this.getSeriesNames());
        }
        for (n = 0; n < n3; ++n) {
            cGSDataColumn = this.m_columns.elementAt(n);
            if (cGSDataColumn.m_type == CGSWidget.DataType.eSeries) {
                if (n == n5) continue;
                cGSDataColumn.m_type = CGSWidget.DataType.eIgnore;
                continue;
            }
            if (cGSDataColumn.m_type != CGSWidget.DataType.eMeasure || n == n4) continue;
            cGSDataColumn.m_type = CGSWidget.DataType.eIgnore;
        }
    }

    public void dumpOriginalData() {
        System.out.println("------------------------");
        System.out.println("Raw table data");
        int n = this.m_rows.size();
        int n2 = this.m_columns.size();
        for (int i = 0; i < n; ++i) {
            CGSDataRow cGSDataRow = this.m_rows.elementAt(i);
            System.out.print("e" + cGSDataRow.getElementIndex() + " ");
            for (int j = 0; j < n2; ++j) {
                CGSDataColumn cGSDataColumn = this.m_columns.elementAt(j);
                if (cGSDataColumn.m_type == CGSWidget.DataType.eCategory) {
                    System.out.print("c" + cGSDataRow.getAt((int)j).m_index);
                    if (cGSDataRow.getAt((int)j).m_index != -1) {
                        System.out.print(" [" + cGSDataColumn.m_string_list.elementAt(cGSDataRow.getAt((int)j).m_index) + "]");
                    }
                } else if (cGSDataColumn.m_type == CGSWidget.DataType.eSeries) {
                    System.out.print("s" + cGSDataRow.getAt((int)j).m_index);
                    if (cGSDataRow.getAt((int)j).m_index != -1) {
                        System.out.print(" [" + cGSDataColumn.m_string_list.elementAt(cGSDataRow.getAt((int)j).m_index) + "]");
                    }
                } else if (cGSDataColumn.m_type == CGSWidget.DataType.eXMatrix) {
                    System.out.print("x" + cGSDataRow.getAt((int)j).m_index);
                    if (cGSDataRow.getAt((int)j).m_index != -1) {
                        System.out.print(" [" + cGSDataColumn.m_string_list.elementAt(cGSDataRow.getAt((int)j).m_index) + "]");
                    }
                } else if (cGSDataColumn.m_type == CGSWidget.DataType.eYMatrix) {
                    System.out.print("y" + cGSDataRow.getAt((int)j).m_index);
                    if (cGSDataRow.getAt((int)j).m_index != -1) {
                        System.out.print(" [" + cGSDataColumn.m_string_list.elementAt(cGSDataRow.getAt((int)j).m_index) + "]");
                    }
                } else if (cGSDataColumn.m_type == CGSWidget.DataType.eMeasure || cGSDataColumn.m_type == CGSWidget.DataType.eMeasureColorByValue) {
                    System.out.print(cGSDataRow.getAt((int)j).m_value + "[" + cGSDataRow.getAt((int)j).m_index + "]");
                } else if (cGSDataColumn.m_type == CGSWidget.DataType.eMeasureShowValue) {
                    System.out.print("\"" + cGSDataRow.getAt((int)j).m_value + "\"");
                } else if (cGSDataColumn.m_type == CGSWidget.DataType.ePaletteElem) {
                    System.out.print("[" + cGSDataRow.getAt((int)j).m_index + "]");
                } else if (cGSDataColumn.m_type == CGSWidget.DataType.ePieExplodeDistance) {
                    System.out.print(cGSDataRow.getAt((int)j).m_index);
                }
                System.out.print(" ");
            }
            System.out.println(cGSDataRow.getRowIndex() + "");
        }
        System.out.println("------------------------");
    }

    public void dumpOriginalDataToCSV(String string) {
        try {
            Object object;
            int n;
            FileWriter fileWriter = new FileWriter(string, false);
            int n2 = this.m_rows.size();
            int n3 = this.m_columns.size();
            boolean bl = false;
            for (n = 0; n < n3; ++n) {
                object = this.m_columns.elementAt(n);
                String string2 = null;
                switch (((CGSDataColumn)object).m_type) {
                    case eCategory: {
                        string2 = "Cat" + n;
                        break;
                    }
                    case eSeries: {
                        string2 = "Ser" + n;
                        break;
                    }
                    case eXMatrix: {
                        string2 = "XMat" + n;
                        break;
                    }
                    case eYMatrix: {
                        string2 = "YMat" + n;
                        break;
                    }
                    case eMeasure: {
                        string2 = "Meas" + n;
                        break;
                    }
                    case eMeasureColorByValue: {
                        string2 = "MCBV" + n;
                        break;
                    }
                    case eMeasureShowValue: {
                        string2 = "MShow" + n;
                        break;
                    }
                    case ePaletteElem: {
                        string2 = "Pal" + n;
                        break;
                    }
                    case ePieExplodeDistance: {
                        string2 = "Pie" + n;
                        break;
                    }
                    default: {
                        string2 = null;
                    }
                }
                if (string2 == null) continue;
                if (bl) {
                    fileWriter.write(",");
                }
                fileWriter.write(string2);
                bl = true;
            }
            fileWriter.write("\r\n");
            for (n = 0; n < n2; ++n) {
                object = this.m_rows.elementAt(n);
                bl = false;
                for (int i = 0; i < n3; ++i) {
                    CGSDataColumn cGSDataColumn = this.m_columns.elementAt(i);
                    String string3 = null;
                    switch (cGSDataColumn.m_type) {
                        case eCategory: 
                        case eSeries: 
                        case eXMatrix: 
                        case eYMatrix: {
                            string3 = ((CGSDataRow)object).getAt((int)i).m_index == -1 ? "" : ((CGSDataRow)object).getAt((int)i).m_index + "_" + cGSDataColumn.m_string_list.elementAt(((CGSDataRow)object).getAt((int)i).m_index);
                            break;
                        }
                        case eMeasure: 
                        case eMeasureColorByValue: 
                        case eMeasureShowValue: {
                            string3 = Double.isNaN(((CGSDataRow)object).getAt((int)i).m_value) ? "" : Double.toString(((CGSDataRow)object).getAt((int)i).m_value);
                            break;
                        }
                        case ePaletteElem: 
                        case ePieExplodeDistance: {
                            string3 = Integer.toString(((CGSDataRow)object).getAt((int)i).m_index);
                            break;
                        }
                        default: {
                            string3 = null;
                        }
                    }
                    if (string3 == null) continue;
                    if (bl) {
                        fileWriter.write(",");
                    }
                    fileWriter.write(string3);
                    bl = true;
                }
                fileWriter.write("\r\n");
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void dumpData(int n, int n2) {
        int n3;
        System.out.println("------------------------");
        System.out.println("Grid Data");
        System.out.println("X: " + this.getAxisTitle(0));
        System.out.println("Y top left: " + this.getAxisTitle(1));
        System.out.println("Y top right: " + this.getAxisTitle(2));
        System.out.println("Y bottom left: " + this.getAxisTitle(3));
        System.out.println("Y bottom right: " + this.getAxisTitle(4));
        System.out.println("Z: " + this.getAxisTitle(5));
        System.out.print("Column Titles:\t");
        for (n3 = 0; n3 < n2; ++n3) {
            System.out.print("(" + n3 + ")" + "'" + this.m_gridColTitles[n3] + "' ");
        }
        System.out.println("");
        System.out.print("Series Names:\t");
        for (n3 = 0; n3 < n2; ++n3) {
            System.out.print("(" + n3 + ")" + "'" + this.m_gridColSeriesName[n3] + "' ");
        }
        System.out.println("");
        System.out.print("Measure Names:\t");
        for (n3 = 0; n3 < n2; ++n3) {
            System.out.print("(" + n3 + ")" + "'" + this.m_gridColMeasureName[n3] + "' ");
        }
        System.out.println("");
        System.out.print("Element Indices:");
        for (n3 = 0; n3 < n2; ++n3) {
            System.out.print("(" + n3 + ")" + this.m_gridColEleIndex[n3] + " ");
        }
        System.out.println("");
        System.out.print("Series Index:\t");
        for (n3 = 0; n3 < n2; ++n3) {
            System.out.print("(" + n3 + ")" + this.m_gridColSeriesIndex[n3] + " ");
        }
        System.out.println("");
        System.out.print("Column Type:\t");
        for (n3 = 0; n3 < n2; ++n3) {
            System.out.print("(" + n3 + ")" + this.m_gridColTypes[n3] + " ");
        }
        System.out.println("");
        for (int i = 0; i < n; ++i) {
            System.out.print("Row:" + i + "\t\t");
            for (n3 = 0; n3 < n2; ++n3) {
                Object[] objectArray;
                if (this.m_gridTypes[n3] == String.class) {
                    objectArray = (Object[])this.m_gridColumns[n3];
                    System.out.print("(" + n3 + ")" + "'" + objectArray[i] + "'");
                } else if (this.m_gridTypes[n3] == Double.TYPE) {
                    objectArray = (double[])this.m_gridColumns[n3];
                    System.out.print("(" + n3 + ")" + (double)objectArray[i]);
                } else if (this.m_gridTypes[n3] == Integer.TYPE) {
                    objectArray = (int[])this.m_gridColumns[n3];
                    System.out.print("(" + n3 + ")" + (int)objectArray[i]);
                } else {
                    System.out.print("(" + n3 + ")" + "<unknown type>");
                }
                if (this.m_gridCellInfo[i][n3].rowIndex != -1) {
                    System.out.print("[" + this.m_gridCellInfo[i][n3].rowIndex + "," + this.m_gridCellInfo[i][n3].colIndex + "]");
                }
                System.out.print(" ");
            }
            System.out.println("");
        }
        System.out.println("------------------------");
    }

    public int getCellValueId(int n, int n2) {
        if (n < 0 || n >= this.m_rows.size()) {
            return -1;
        }
        CGSDataRow cGSDataRow = this.m_rows.elementAt(n);
        CGSDataItem cGSDataItem = cGSDataRow.getAt(n2);
        return cGSDataItem.m_index;
    }

    public int getFirstMeasureCol(int n) {
        if (this.m_firstMeasureCol == null) {
            return -1;
        }
        return this.m_firstMeasureCol[n];
    }

    public int getCategoryIndex(String string, int n) {
        int n2 = this.getCategoryColumnCount();
        boolean bl = n2 == n || n == 0;
        CGSPropCanvas cGSPropCanvas = (CGSPropCanvas)this.m_pCanvas.getBaseProp();
        String string2 = string + cGSPropCanvas.getSeparator();
        int n3 = string2.length();
        int n4 = this.getGridRowIndexColumn();
        int[] nArray = (int[])this.m_gridColumns[n4];
        for (int i = 0; i < this.m_gridTypes.length; ++i) {
            if (this.m_gridColTypes[i] != 0) continue;
            Object[] objectArray = (Object[])this.m_gridColumns[i];
            for (int j = 0; j < objectArray.length; ++j) {
                String string3 = (String)objectArray[j];
                if (!(string3.length() > n3 && !bl ? string2.equals(string3.substring(0, n3)) : string.equals(objectArray[j]))) continue;
                return nArray[j];
            }
        }
        return -1;
    }

    public int getCategoriesFirstRowIndex(int n) {
        return this.m_categoriesFirstRowIndex[n];
    }

    public boolean isNaN(int n, int n2, int n3) {
        int n4 = 0;
        double d = 0.0;
        boolean bl = false;
        for (int i = 0; i < this.m_gridColEleIndex.length; ++i) {
            if (this.m_gridColEleIndex[i] != n || this.m_gridColTypes[i] != 4) continue;
            if (n3 == n4) {
                d = ((double[])this.m_gridColumns[i])[n2];
                bl = true;
                break;
            }
            ++n4;
        }
        if (!bl) {
            throw new Error("invalid row specified");
        }
        return Double.isNaN(d);
    }

    public boolean hasPaletteColumn() {
        return this.m_paletteCol != -1;
    }

    public int getPaletteIndex(int n) {
        CMHelper.CGS_ASSERT(this.m_paletteCol != -1, "No palette column");
        return this.getRow((int)n).getAt((int)this.m_paletteCol).m_index;
    }

    public boolean hasPieExplodeColumn() {
        return this.m_pieExplodeCol != -1;
    }

    private int getPieExplodeIndex(int n) {
        CMHelper.CGS_ASSERT(this.m_pieExplodeCol != -1, "No pie explode column");
        return this.getRow((int)n).getAt((int)this.m_pieExplodeCol).m_index;
    }

    public int getPieExplodeValue(int n) {
        int n2 = 0;
        if (!this.hasPieExplodeColumn()) {
            return n2;
        }
        n2 = this.getPieExplodeIndex(n);
        n2 = Math.max(n2, 0);
        n2 = Math.min(n2, 100);
        return n2;
    }

    public int getGridSeriesIndex(int n) {
        CMHelper.CGS_ASSERT(n >= 0 && n < this.m_gridSeriesIndices.size(), "Invalid series index");
        return this.m_gridSeriesIndices.get(n);
    }

    public Vector<CGSDataColumn> getOriginalColumns() {
        return this.m_columns;
    }

    public Vector<CGSDataRow> getOriginalRows() {
        return this.m_rows;
    }

    public void setNumGroupedRows(int n) {
        this.m_numGroupedRows = n;
    }

    public int getNumGroupedRows() {
        return this.m_numGroupedRows;
    }

    public static class CellInfo {
        int rowIndex = -1;
        int colIndex = -1;
        boolean isGroupedData = false;
        HashMap<Integer, String> formattedValues = new HashMap();

        protected void addFormattedValue(int n, String string) {
            this.formattedValues.put(n, string);
        }
    }
}

