/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Graphics;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.Graphics.GRBufferedImage;
import com.ibm.cgsBus.Graphics.GRDevice;
import com.ibm.cgsBus.Graphics.GRDeviceVector;
import com.ibm.cgsBus.Graphics.GRHelper;
import com.ibm.cgsBus.Graphics.GRPoint;
import com.ibm.cgsBus.Graphics.GRPointList;
import com.ibm.cgsBus.Graphics.GRPolygonPointList;
import com.ibm.cgsBus.Properties.CGSPropContainer;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeFillEffect;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class GRContainer {
    private Pixel m_getPixelColor = new Pixel();
    private Pixel m_getImageFillColor = new Pixel();
    private static double VERY_DARK = 0.47;
    private static double DARK = 0.72;
    private static double LIGHT = 1.04;
    private static double VERY_LIGHT = 1.35;
    private GRDevice m_pDevice = null;
    private int m_width = 0;
    private int m_height = 0;
    private double m_outlineWidth = 0.0;
    private double m_shadowOffset = 0.0;
    private double m_roundRectRadius = 0.0;
    private CGSEnums.Blur m_shadowBlurPixels = CGSEnums.Blur.eBlurNone;
    private double m_shadowBlur = 0.0;
    private CGSEnums.HTMLOutlineStyle m_outlineType;
    private Color m_outlineColor;
    private boolean m_outlineVisible;
    private double m_outlineWidthPixels;
    private boolean m_outlineDashStyle;
    private boolean m_outlineAlphaIndependent;
    private Vector<CGSTypeFillEffect> m_fillEffects;
    private boolean m_shadowVisible;
    private Color m_shadowColor;
    private double m_shadowOffsetPixels;
    private boolean m_shadowAlphaIndependent;
    private double m_roundRectRadiusPixels;
    private GRPolygonPointList m_pPoints = null;
    private boolean m_drawingShadow = false;
    private boolean m_drawingOutline = false;
    private GRBufferedImage m_pRGBABase = null;
    private GRBufferedImage m_pRGBAWorking = null;
    private boolean m_outlineUseLightSource = false;
    private Color m_outlineLightSourceColor = Color.BLACK;
    private boolean m_drawCleanupEdge = false;
    private boolean m_drawingCleanupEdge = false;
    private GRBufferedImage m_pRGBAImage = null;
    private boolean m_drawVectorOutline = false;
    private boolean m_drawingVectorOutline = false;
    private double m_xVectorOffset = 0.0;
    private double m_yVectorOffset = 0.0;
    private boolean m_showShadowLayer = true;
    private boolean m_showShapeLayer = true;
    private boolean m_showOutlineLayer = true;
    private boolean m_mirror = false;
    private Intersect m_intersect = new Intersect();

    public GRContainer(CGSPropContainer cGSPropContainer) {
        this.m_outlineType = cGSPropContainer.getOutlineStyle();
        this.m_outlineColor = cGSPropContainer.getOutlineColor();
        this.m_outlineVisible = cGSPropContainer.getShowOutline();
        this.m_outlineWidthPixels = cGSPropContainer.getOutlineThickness();
        this.m_outlineDashStyle = this.m_outlineType == CGSEnums.HTMLOutlineStyle.eHTMLOutlineDot || this.m_outlineType == CGSEnums.HTMLOutlineStyle.eHTMLOutlineDash || this.m_outlineType.ordinal() >= CGSEnums.HTMLOutlineStyle.eBorderLineDash.ordinal();
        this.m_outlineAlphaIndependent = cGSPropContainer.getOutlineIndependent();
        this.m_fillEffects = cGSPropContainer.getFillEffectList();
        this.m_shadowVisible = cGSPropContainer.getShowShadow();
        this.m_shadowColor = cGSPropContainer.getShadowColor();
        this.m_shadowOffsetPixels = cGSPropContainer.getShadowSize();
        this.m_shadowBlurPixels = cGSPropContainer.getShadowBlur();
        this.m_shadowAlphaIndependent = cGSPropContainer.getShadowIndependent();
        this.m_roundRectRadiusPixels = cGSPropContainer.getCornerRadius();
    }

    public void draw(GRDevice gRDevice, double d, double d2, double d3, double d4, boolean bl) {
        CMHelper.CGS_ASSERT(gRDevice != null, "NULL pDevice");
        this.m_pDevice = gRDevice;
        this.m_outlineWidth = this.m_pDevice.fromPixels(this.m_outlineWidthPixels);
        this.m_shadowOffset = this.m_pDevice.fromPixels(this.m_shadowOffsetPixels);
        this.m_shadowBlur = this.m_pDevice.fromPixels(this.m_shadowBlurPixels.ordinal());
        if (this.m_shadowBlur > this.m_shadowOffset) {
            this.m_shadowBlur = this.m_shadowOffset;
        }
        this.m_roundRectRadius = this.m_pDevice.fromPixels(this.m_roundRectRadiusPixels);
        this.m_drawVectorOutline = false;
        this.m_mirror = bl;
        this.m_width = GRHelper.GR_ROUND(d3 - d + 1.0);
        this.m_height = GRHelper.GR_ROUND(d2 - d4 + 1.0);
        this.calcRoundedRect(this.m_pDevice.isRaster() || this.m_pDevice.isSVG());
        if (this.m_pPoints == null || this.m_pPoints.size() == 0) {
            return;
        }
        this.m_pRGBABase = new GRBufferedImage(this.m_width, this.m_height);
        this.draw();
        if (!GRHelper.isEmptyBufferedImage(this.m_pRGBABase.getImage())) {
            GRHelper.flipBufferedImage(this.m_pRGBABase.getImage());
            this.m_pDevice.drawImage(this.m_pRGBABase.getImage(), d, d2, true);
        }
        if (this.m_drawVectorOutline) {
            this.m_drawingVectorOutline = true;
            this.m_xVectorOffset = d + 0.5;
            this.m_yVectorOffset = d4 + 0.5;
            this.drawOutlineLayer();
            this.m_drawingVectorOutline = false;
            this.m_xVectorOffset = 0.0;
            this.m_yVectorOffset = 0.0;
        }
        this.m_pRGBABase = null;
        this.m_pPoints = null;
    }

    private void draw() {
        boolean bl;
        boolean bl2;
        if (this.m_outlineVisible && this.m_outlineWidthPixels < 1.0) {
            this.m_outlineVisible = false;
        }
        this.createImage();
        if (!this.m_pDevice.isRaster() && !this.m_pDevice.isSVG() && this.m_outlineVisible && (this.m_outlineWidthPixels >= 2.0 || this.m_outlineDashStyle || this.m_pRGBAImage == null)) {
            this.m_drawVectorOutline = true;
        }
        this.m_drawCleanupEdge = false;
        if (this.m_pRGBAImage != null && (this.m_outlineVisible && this.m_outlineDashStyle || !this.m_outlineVisible)) {
            this.m_drawCleanupEdge = true;
        }
        GRHelper.initBufferedImage(this.m_pRGBABase.getImage(), 0xFFFFFF);
        this.m_pRGBAWorking = null;
        boolean bl3 = this.m_showShadowLayer && this.m_shadowVisible && GRHelper.getAlpha(this.m_shadowColor.getRGB()) != 0;
        boolean bl4 = this.m_showShapeLayer && this.m_pRGBAImage != null;
        boolean bl5 = this.m_showOutlineLayer && this.m_outlineVisible && !this.m_drawVectorOutline;
        boolean bl6 = bl2 = this.m_outlineAlphaIndependent && this.m_shadowAlphaIndependent && this.m_outlineVisible;
        if (bl3) {
            this.m_pRGBAWorking = this.m_pRGBABase;
            this.m_drawingShadow = true;
            GRHelper.initBufferedImage(this.m_pRGBAWorking.getImage(), 0xFFFFFF);
            if (this.m_mirror) {
                this.offsetForMirror();
            }
            this.offsetForShadow(true);
            this.drawPolyLayer();
            this.m_drawingOutline = true;
            if (this.m_outlineVisible && !bl2) {
                this.drawOutlineLayer();
            }
            this.addImageAlphaEffects();
            if (this.m_outlineVisible && bl2) {
                this.drawOutlineLayer();
            }
            this.addShadowAlphaEffects();
            this.m_drawingOutline = false;
            this.offsetForShadow(false);
            this.m_drawingShadow = false;
            GRHelper.blurBufferedImage(this.m_pRGBAWorking.getImage(), GRHelper.GR_ROUND(this.m_shadowBlur));
            this.m_pRGBAWorking = null;
        }
        if (bl4) {
            bl = false;
            if (bl3) {
                bl = true;
                this.m_pRGBAWorking = new GRBufferedImage(this.m_width, this.m_height);
            } else {
                this.m_pRGBAWorking = this.m_pRGBABase;
            }
            GRHelper.initBufferedImage(this.m_pRGBAWorking.getImage(), 0xFFFFFF);
            boolean bl7 = this.m_drawCleanupEdge;
            if (!this.m_pDevice.isRaster() && !this.m_pDevice.isSVG()) {
                this.m_drawCleanupEdge = true;
            }
            this.drawPolyLayer();
            this.m_drawCleanupEdge = bl7;
            this.addImageAlphaEffects();
            if (bl) {
                GRHelper.combineBufferedImage(this.m_pRGBABase.getImage(), this.m_pRGBAWorking.getImage(), false);
            } else {
                this.m_pRGBAWorking = null;
            }
        }
        if (bl5) {
            bl = false;
            if (bl3 || bl4) {
                bl = true;
                if (this.m_pRGBAWorking == null) {
                    this.m_pRGBAWorking = new GRBufferedImage(this.m_width, this.m_height);
                }
            } else {
                this.m_pRGBAWorking = this.m_pRGBABase;
            }
            this.m_drawingOutline = true;
            GRHelper.initBufferedImage(this.m_pRGBAWorking.getImage(), 0xFFFFFF);
            this.drawOutlineLayer();
            if (!this.m_outlineAlphaIndependent) {
                this.addImageAlphaEffects();
            }
            this.m_drawingOutline = false;
            if (bl) {
                GRHelper.combineBufferedImage(this.m_pRGBABase.getImage(), this.m_pRGBAWorking.getImage(), true);
            } else {
                this.m_pRGBAWorking = null;
            }
        }
        this.m_pRGBAWorking = null;
        this.m_pRGBAImage = null;
    }

    private void offsetForShadow(boolean bl) {
        double d = bl ? this.m_shadowOffset - this.m_shadowBlur : -(this.m_shadowOffset - this.m_shadowBlur);
        for (int i = 0; i < this.m_pPoints.size(); ++i) {
            this.m_pPoints.offset(i, this.m_mirror ? -d : d, -d);
        }
    }

    private void offsetForMirror() {
        double d = this.m_mirror ? this.m_shadowOffset : 0.0;
        for (int i = 0; i < this.m_pPoints.size(); ++i) {
            this.m_pPoints.offset(i, d, 0.0);
        }
    }

    private void drawPolyLayer() {
        this.fillPolygon();
        if (this.m_drawCleanupEdge) {
            this.m_drawingCleanupEdge = true;
            GRPointList gRPointList = new GRPointList(4);
            for (int i = 0; i < this.m_pPoints.size(); ++i) {
                int n = i;
                int n2 = (i + 1) % this.m_pPoints.size();
                double d = this.m_pPoints.xOuter(n) - this.m_pPoints.xInner(n);
                double d2 = this.m_pPoints.yOuter(n) - this.m_pPoints.yInner(n);
                double d3 = this.m_pPoints.xOuter(n2) - this.m_pPoints.xInner(n2);
                double d4 = this.m_pPoints.yOuter(n2) - this.m_pPoints.yInner(n2);
                double d5 = Math.sqrt(d * d + d2 * d2);
                double d6 = Math.sqrt(d3 * d3 + d4 * d4);
                gRPointList.setPoint(0, this.m_pPoints.xInner(n), this.m_pPoints.yInner(n));
                gRPointList.setPoint(1, this.m_pPoints.xInner(n2), this.m_pPoints.yInner(n2));
                gRPointList.setPoint(2, gRPointList.x(1) + d3 / d6, gRPointList.y(1) + d4 / d6);
                gRPointList.setPoint(3, gRPointList.x(0) + d / d5, gRPointList.y(0) + d2 / d5);
                this.fillLinePoly(gRPointList);
            }
            this.m_drawingCleanupEdge = false;
        }
    }

    private void fillPolygon() {
        if (this.m_pRGBAImage == null) {
            return;
        }
        double d = this.m_pPoints.yInner(0);
        double d2 = this.m_pPoints.yInner(0);
        int n = 0;
        for (n = 1; n < this.m_pPoints.size(); ++n) {
            if (this.m_pPoints.yInner(n) < d) {
                d = this.m_pPoints.yInner(n);
            }
            if (!(this.m_pPoints.yInner(n) > d2)) continue;
            d2 = this.m_pPoints.yInner(n);
        }
        int n2 = GRHelper.GR_ROUND(d);
        int n3 = GRHelper.GR_ROUND(d2);
        GRPoint gRPoint = new GRPoint();
        GRPoint gRPoint2 = new GRPoint();
        GRPoint gRPoint3 = new GRPoint();
        for (int i = n2; i <= n3; ++i) {
            double d3 = (double)i - 0.5;
            double d4 = (double)i + 0.5;
            double d5 = 0.0;
            double d6 = 0.0;
            boolean bl = false;
            for (n = 0; n < this.m_pPoints.size(); ++n) {
                gRPoint = this.m_pPoints.inner(n, gRPoint);
                if (Math.min(this.m_pPoints.yInner(n), this.m_pPoints.yInner((n + 1) % this.m_pPoints.size())) >= d3 && Math.max(this.m_pPoints.yInner(n), this.m_pPoints.yInner((n + 1) % this.m_pPoints.size())) <= d4) {
                    if (!bl) {
                        bl = true;
                        d5 = d6 = gRPoint.x;
                    } else {
                        if (gRPoint.x < d5) {
                            d5 = gRPoint.x;
                        }
                        if (gRPoint.x > d6) {
                            d6 = gRPoint.x;
                        }
                    }
                }
                gRPoint2 = this.m_pPoints.inner(n, gRPoint2);
                gRPoint3 = this.m_pPoints.inner((n + 1) % this.m_pPoints.size(), gRPoint3);
                Intersect intersect = this.yIntersect(d3, gRPoint2, gRPoint3);
                if (intersect.isIntersect) {
                    gRPoint = intersect.intersectPt;
                    if (!bl) {
                        bl = true;
                        d5 = d6 = gRPoint.x;
                    } else {
                        if (gRPoint.x < d5) {
                            d5 = gRPoint.x;
                        }
                        if (gRPoint.x > d6) {
                            d6 = gRPoint.x;
                        }
                    }
                }
                intersect = this.yIntersect(d4, gRPoint2, gRPoint3);
                if (!intersect.isIntersect) continue;
                gRPoint = intersect.intersectPt;
                if (!bl) {
                    bl = true;
                    d5 = d6 = gRPoint.x;
                    continue;
                }
                if (gRPoint.x < d5) {
                    d5 = gRPoint.x;
                }
                if (!(gRPoint.x > d6)) continue;
                d6 = gRPoint.x;
            }
            if (!bl) continue;
            int n4 = GRHelper.GR_ROUND(d5);
            int n5 = GRHelper.GR_ROUND(d6);
            for (int j = n4; j <= n5; ++j) {
                this.fillPixel(j, i, 255);
            }
        }
    }

    private void drawOutlineLayer() {
        if (this.m_outlineType == CGSEnums.HTMLOutlineStyle.eHTMLOutlineGroove || this.m_outlineType == CGSEnums.HTMLOutlineStyle.eHTMLOutlineRidge || this.m_outlineType == CGSEnums.HTMLOutlineStyle.eHTMLOutlineInset || this.m_outlineType == CGSEnums.HTMLOutlineStyle.eHTMLOutlineOutset) {
            int n;
            int n2;
            int n3;
            int n4;
            if (this.m_outlineType == CGSEnums.HTMLOutlineStyle.eHTMLOutlineGroove) {
                n4 = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), VERY_DARK);
                n3 = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), VERY_LIGHT);
                n2 = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), VERY_LIGHT);
                n = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), VERY_DARK);
            } else if (this.m_outlineType == CGSEnums.HTMLOutlineStyle.eHTMLOutlineRidge) {
                n4 = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), LIGHT);
                n3 = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), DARK);
                n2 = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), DARK);
                n = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), LIGHT);
            } else if (this.m_outlineType == CGSEnums.HTMLOutlineStyle.eHTMLOutlineInset) {
                n4 = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), DARK);
                n3 = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), VERY_LIGHT);
                n2 = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), VERY_DARK);
                n = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), LIGHT);
            } else {
                n4 = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), LIGHT);
                n3 = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), VERY_DARK);
                n2 = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), VERY_LIGHT);
                n = GRHelper.adjustIntensity(this.m_outlineColor.getRGB(), DARK);
            }
            this.drawLightSourceOutline(n4, n3, true);
            this.drawLightSourceOutline(n2, n, false);
        } else if (this.m_outlineType == CGSEnums.HTMLOutlineStyle.eHTMLOutlineDouble) {
            GRPointList gRPointList = new GRPointList(4);
            for (int i = 0; i < this.m_pPoints.size(); ++i) {
                int n = i;
                int n5 = (i + 1) % this.m_pPoints.size();
                double d = this.m_pPoints.xOuter(n) - this.m_pPoints.xInner(n);
                double d2 = this.m_pPoints.yOuter(n) - this.m_pPoints.yInner(n);
                double d3 = this.m_pPoints.xOuter(n5) - this.m_pPoints.xInner(n5);
                double d4 = this.m_pPoints.yOuter(n5) - this.m_pPoints.yInner(n5);
                gRPointList.setPoint(0, this.m_pPoints.xOuter(n) - d / 3.0, this.m_pPoints.yOuter(n) - d2 / 3.0);
                gRPointList.setPoint(1, this.m_pPoints.xOuter(n5) - d3 / 3.0, this.m_pPoints.yOuter(n5) - d4 / 3.0);
                gRPointList.setPoint(2, this.m_pPoints.xOuter(n5), this.m_pPoints.yOuter(n5));
                gRPointList.setPoint(3, this.m_pPoints.xOuter(n), this.m_pPoints.yOuter(n));
                this.fillLinePoly(gRPointList);
                gRPointList.setPoint(0, this.m_pPoints.xInner(n) + d / 3.0, this.m_pPoints.yInner(n) + d2 / 3.0);
                gRPointList.setPoint(1, this.m_pPoints.xInner(n5) + d3 / 3.0, this.m_pPoints.yInner(n5) + d4 / 3.0);
                gRPointList.setPoint(2, this.m_pPoints.xInner(n5), this.m_pPoints.yInner(n5));
                gRPointList.setPoint(3, this.m_pPoints.xInner(n), this.m_pPoints.yInner(n));
                this.fillLinePoly(gRPointList);
            }
        } else if (this.m_outlineType == CGSEnums.HTMLOutlineStyle.eHTMLOutlineSolid) {
            GRPointList gRPointList = new GRPointList(4);
            for (int i = 0; i < this.m_pPoints.size(); ++i) {
                gRPointList.setPoint(0, this.m_pPoints.xOuter(i), this.m_pPoints.yOuter(i));
                gRPointList.setPoint(1, this.m_pPoints.xOuter((i + 1) % this.m_pPoints.size()), this.m_pPoints.yOuter((i + 1) % this.m_pPoints.size()));
                gRPointList.setPoint(2, this.m_pPoints.xInner((i + 1) % this.m_pPoints.size()), this.m_pPoints.yInner((i + 1) % this.m_pPoints.size()));
                gRPointList.setPoint(3, this.m_pPoints.xInner(i), this.m_pPoints.yInner(i));
                this.fillLinePoly(gRPointList);
            }
        } else if (this.m_outlineDashStyle) {
            double d;
            class LinePattern {
                CGSEnums.HTMLOutlineStyle style;
                int dashCount;
                int[] pattern;

                LinePattern(CGSEnums.HTMLOutlineStyle hTMLOutlineStyle, int n, int[] nArray) {
                    this.style = hTMLOutlineStyle;
                    this.dashCount = n;
                    this.pattern = nArray;
                }
            }
            LinePattern[] linePatternArray = new LinePattern[]{new LinePattern(CGSEnums.HTMLOutlineStyle.eHTMLOutlineDot, 1, new int[]{1, 1, 0, 0, 0, 0, 0, 0}), new LinePattern(CGSEnums.HTMLOutlineStyle.eHTMLOutlineDash, 1, new int[]{2, 1, 0, 0, 0, 0, 0, 0}), new LinePattern(CGSEnums.HTMLOutlineStyle.eBorderLineDash, 1, new int[]{5, 3, 0, 0, 0, 0, 0, 0}), new LinePattern(CGSEnums.HTMLOutlineStyle.eBorderLineDot, 1, new int[]{1, 1, 0, 0, 0, 0, 0, 0}), new LinePattern(CGSEnums.HTMLOutlineStyle.eBorderLineDotDash, 2, new int[]{5, 2, 2, 2, 0, 0, 0, 0}), new LinePattern(CGSEnums.HTMLOutlineStyle.eBorderLineDashDotDot, 3, new int[]{5, 2, 2, 2, 2, 2, 0, 0}), new LinePattern(CGSEnums.HTMLOutlineStyle.eBorderLineMediumDash, 1, new int[]{9, 2, 0, 0, 0, 0, 0, 0}), new LinePattern(CGSEnums.HTMLOutlineStyle.eBorderLineShortDash, 1, new int[]{2, 3, 0, 0, 0, 0, 0, 0}), new LinePattern(CGSEnums.HTMLOutlineStyle.eBorderLineLongDash, 1, new int[]{8, 4, 0, 0, 0, 0, 0, 0}), new LinePattern(CGSEnums.HTMLOutlineStyle.eBorderLineLongDot, 1, new int[]{5, 5, 0, 0, 0, 0, 0, 0}), new LinePattern(CGSEnums.HTMLOutlineStyle.eBorderLineDotDotDot, 3, new int[]{1, 1, 1, 1, 1, 4, 0, 0}), new LinePattern(CGSEnums.HTMLOutlineStyle.eBorderLineDashDashDot, 3, new int[]{5, 2, 5, 2, 1, 2, 0, 0}), new LinePattern(CGSEnums.HTMLOutlineStyle.eBorderLineDashDashDotDot, 4, new int[]{5, 2, 5, 2, 1, 2, 1, 2}), new LinePattern(CGSEnums.HTMLOutlineStyle.eBorderLineLongDashDot, 2, new int[]{5, 3, 3, 3, 0, 0, 0, 0}), new LinePattern(CGSEnums.HTMLOutlineStyle.eBorderLineLongDashDotDot, 3, new int[]{5, 3, 3, 3, 3, 3, 0, 0}), new LinePattern(CGSEnums.HTMLOutlineStyle.eBorderLineLongDashDashDot, 3, new int[]{5, 3, 5, 3, 3, 3, 0, 0}), new LinePattern(CGSEnums.HTMLOutlineStyle.eBorderLineLongDashDashDotDot, 4, new int[]{5, 3, 5, 3, 3, 3, 3, 3})};
            int n = -1;
            boolean bl = false;
            if (this.m_outlineType == CGSEnums.HTMLOutlineStyle.eHTMLOutlineDot) {
                bl = true;
                n = 0;
            } else {
                for (n = 0; n < linePatternArray.length && linePatternArray[n].style != this.m_outlineType; ++n) {
                }
            }
            int n6 = 24;
            if (this.m_pDevice.isRaster() || this.m_pDevice.isSVG() || this.m_drawingShadow) {
                if (this.m_outlineWidth < 8.0) {
                    n6 = 8;
                } else if (this.m_outlineWidth < 12.0) {
                    n6 = 12;
                } else if (this.m_outlineWidth < 18.0) {
                    n6 = 20;
                }
            }
            GRPointList gRPointList = new GRPointList(Math.max(this.m_pPoints.size() * 2 + 4, n6));
            double[] dArray = new double[this.m_pPoints.size()];
            double d5 = 0.0;
            int n7 = 0;
            for (n7 = 0; n7 < this.m_pPoints.size(); ++n7) {
                int n8 = n7;
                int n9 = (n7 + 1) % this.m_pPoints.size();
                d = this.m_pPoints.xMid(n9) - this.m_pPoints.xMid(n8);
                double d6 = this.m_pPoints.yMid(n9) - this.m_pPoints.yMid(n8);
                dArray[n7] = Math.sqrt(d * d + d6 * d6);
                d5 += dArray[n7];
            }
            double d7 = 0.0;
            d = 0.0;
            for (n7 = 0; n7 < linePatternArray[n].dashCount; ++n7) {
                d7 += (double)linePatternArray[n].pattern[n7 * 2];
                d7 += (double)linePatternArray[n].pattern[n7 * 2 + 1];
                d += (double)linePatternArray[n].pattern[n7 * 2];
                if (n7 == linePatternArray[n].dashCount - 1) continue;
                d += (double)linePatternArray[n].pattern[n7 * 2 + 1];
            }
            d7 *= this.m_outlineWidth;
            d *= this.m_outlineWidth;
            int n10 = 1;
            if (this.m_pPoints.isDashStop(0)) {
                n10 = 0;
                for (n7 = 0; n7 < this.m_pPoints.size(); ++n7) {
                    if (!this.m_pPoints.isDashStop(n7)) continue;
                    ++n10;
                }
            }
            for (int i = 0; i < n10; ++i) {
                int n11;
                double d8 = d5;
                int n12 = 0;
                if (n10 != 1) {
                    d8 = 0.0;
                    n11 = 0;
                    for (n7 = 0; n7 < this.m_pPoints.size(); ++n7) {
                        if (this.m_pPoints.isDashStop(n7)) {
                            if (i == n11) {
                                n12 = n7;
                            }
                            ++n11;
                        }
                        if (i != n11 - 1) continue;
                        d8 += dArray[n7];
                    }
                }
                if ((n11 = (int)(d8 / d7)) == 0) {
                    n11 = 1;
                }
                double d9 = (d8 - (double)n11 * d) / (double)n11;
                int n13 = n11 * linePatternArray[n].dashCount;
                if (!bl) {
                    ++n13;
                }
                double d10 = 0.0;
                double d11 = 0.0;
                n7 = 0;
                for (int j = 0; j < n13 && n12 < this.m_pPoints.size(); ++j) {
                    double d12;
                    double d13;
                    int n14;
                    int n15 = 0;
                    double d14 = 0.0;
                    if (bl) {
                        d14 = this.m_outlineWidth;
                    } else if (j == 0 || j == n13 - 1) {
                        d14 = (double)linePatternArray[n].pattern[0] * this.m_outlineWidth / 2.0;
                    } else {
                        n15 = linePatternArray[n].dashCount - 1 - (j - 1) % linePatternArray[n].dashCount;
                        d14 = (double)linePatternArray[n].pattern[n15 *= 2] * this.m_outlineWidth;
                    }
                    int n16 = n12;
                    double d15 = d10 - d11;
                    while (d11 + dArray[n12 % this.m_pPoints.size()] < d10 + d14) {
                        d11 += dArray[n12 % this.m_pPoints.size()];
                        ++n12;
                    }
                    int n17 = n12;
                    double d16 = d10 + d14 - d11;
                    if (bl) {
                        if (Math.abs(d14 - d) < 1.0E-7) {
                            int n18 = n16 % this.m_pPoints.size();
                            for (n14 = 0; n14 < n6; ++n14) {
                                d13 = this.m_pPoints.xMid(n18) + d15 / dArray[n18] * (this.m_pPoints.xMid((n18 + 1) % this.m_pPoints.size()) - this.m_pPoints.xMid(n18));
                                d12 = this.m_pPoints.yMid(n18) + d15 / dArray[n18] * (this.m_pPoints.yMid((n18 + 1) % this.m_pPoints.size()) - this.m_pPoints.yMid(n18));
                                gRPointList.setPoint(n14, d13 + this.m_outlineWidth / 2.0 * GRHelper.cosValue(n14 * 360 / n6), d12 + this.m_outlineWidth / 2.0 * GRHelper.sinValue(n14 * 360 / n6));
                            }
                            gRPointList.setSize(n6);
                            this.fillLinePoly(gRPointList);
                        }
                    } else {
                        int n19 = n16 % this.m_pPoints.size();
                        n14 = (n16 + 1) % this.m_pPoints.size();
                        d13 = this.m_pPoints.xOuter(n19) + d15 / dArray[n19] * (this.m_pPoints.xOuter(n14) - this.m_pPoints.xOuter(n19));
                        d12 = this.m_pPoints.yOuter(n19) + d15 / dArray[n19] * (this.m_pPoints.yOuter(n14) - this.m_pPoints.yOuter(n19));
                        double d17 = this.m_pPoints.xInner(n19) + d15 / dArray[n19] * (this.m_pPoints.xInner(n14) - this.m_pPoints.xInner(n19));
                        double d18 = this.m_pPoints.yInner(n19) + d15 / dArray[n19] * (this.m_pPoints.yInner(n14) - this.m_pPoints.yInner(n19));
                        n19 = n17 % this.m_pPoints.size();
                        n14 = (n17 + 1) % this.m_pPoints.size();
                        double d19 = this.m_pPoints.xOuter(n19) + d16 / dArray[n19] * (this.m_pPoints.xOuter(n14) - this.m_pPoints.xOuter(n19));
                        double d20 = this.m_pPoints.yOuter(n19) + d16 / dArray[n19] * (this.m_pPoints.yOuter(n14) - this.m_pPoints.yOuter(n19));
                        double d21 = this.m_pPoints.xInner(n19) + d16 / dArray[n19] * (this.m_pPoints.xInner(n14) - this.m_pPoints.xInner(n19));
                        double d22 = this.m_pPoints.yInner(n19) + d16 / dArray[n19] * (this.m_pPoints.yInner(n14) - this.m_pPoints.yInner(n19));
                        int n20 = 0;
                        int n21 = 0;
                        gRPointList.setPoint(0, d17, d18);
                        ++n21;
                        for (n20 = n16 + 1; n20 <= n17; ++n20) {
                            gRPointList.setPoint(n21, this.m_pPoints.xInner(n20 % this.m_pPoints.size()), this.m_pPoints.yInner(n20 % this.m_pPoints.size()));
                            ++n21;
                        }
                        gRPointList.setPoint(n21, d21, d22);
                        gRPointList.setPoint(++n21, d19, d20);
                        ++n21;
                        for (n20 = n17; n20 >= n16 + 1; --n20) {
                            gRPointList.setPoint(n21, this.m_pPoints.xOuter(n20 % this.m_pPoints.size()), this.m_pPoints.yOuter(n20 % this.m_pPoints.size()));
                            ++n21;
                        }
                        gRPointList.setPoint(n21, d13, d12);
                        gRPointList.setSize(++n21);
                        this.fillLinePoly(gRPointList);
                    }
                    double d23 = n15 == 0 ? d9 : (double)linePatternArray[n].pattern[n15 - 1] * this.m_outlineWidth;
                    d10 += d14 + d23;
                    while (d11 + dArray[n12 % this.m_pPoints.size()] < d10) {
                        d11 += dArray[n12 % this.m_pPoints.size()];
                        ++n12;
                    }
                }
            }
            gRPointList = null;
            dArray = null;
        }
    }

    private void drawLightSourceOutline(int n, int n2, boolean bl) {
        this.m_outlineUseLightSource = true;
        int n3 = GRHelper.getRed(n);
        int n4 = GRHelper.getGreen(n);
        int n5 = GRHelper.getBlue(n);
        int n6 = GRHelper.getRed(n2);
        int n7 = GRHelper.getGreen(n2);
        int n8 = GRHelper.getBlue(n2);
        GRPointList gRPointList = new GRPointList(4);
        for (int i = 0; i < this.m_pPoints.size(); ++i) {
            int n9 = i;
            int n10 = (i + 1) % this.m_pPoints.size();
            double d = this.m_pPoints.xMid(n10) - this.m_pPoints.xMid(n9);
            double d2 = this.m_pPoints.yMid(n10) - this.m_pPoints.yMid(n9);
            double d3 = Math.atan2(d2, d) * 57.29577951308232;
            d3 -= 45.0;
            while (d3 < 0.0) {
                d3 += 360.0;
            }
            double d4 = d3 <= 180.0 ? d3 / 180.0 : 1.0 - (d3 - 180.0) / 180.0;
            int n11 = (int)((double)n3 * d4 + (double)n6 * (1.0 - d4));
            int n12 = (int)((double)n4 * d4 + (double)n7 * (1.0 - d4));
            int n13 = (int)((double)n5 * d4 + (double)n8 * (1.0 - d4));
            this.m_outlineLightSourceColor = new Color(n11, n12, n13);
            gRPointList.setPoint(0, this.m_pPoints.xMid(n9), this.m_pPoints.yMid(n9));
            gRPointList.setPoint(1, this.m_pPoints.xMid(n10), this.m_pPoints.yMid(n10));
            if (bl) {
                gRPointList.setPoint(2, this.m_pPoints.xOuter(n10), this.m_pPoints.yOuter(n10));
                gRPointList.setPoint(3, this.m_pPoints.xOuter(n9), this.m_pPoints.yOuter(n9));
            } else {
                gRPointList.setPoint(2, this.m_pPoints.xInner(n10), this.m_pPoints.yInner(n10));
                gRPointList.setPoint(3, this.m_pPoints.xInner(n9), this.m_pPoints.yInner(n9));
            }
            this.fillLinePoly(gRPointList);
        }
        this.m_outlineUseLightSource = false;
    }

    private void addShadowAlphaEffects() {
        for (int i = 0; i < this.m_height; ++i) {
            for (int j = 0; j < this.m_width; ++j) {
                int n = this.m_pRGBAWorking.getRGB(j, i);
                int n2 = GRHelper.getAlpha(n);
                if (n2 != 0) {
                    int n3 = n2;
                    int n4 = this.m_shadowColor.getAlpha();
                    n2 = n3 = n3 * n4 / 255;
                }
                this.m_pRGBAWorking.setRGB(j, i, GRHelper.updateAlpha(n2, n));
            }
        }
    }

    private void addImageAlphaEffects() {
        if (this.m_pRGBAImage != null) {
            int n = 0;
            if (this.m_drawingShadow) {
                n = GRHelper.GR_ROUND(this.m_shadowOffset);
            }
            int n2 = this.m_width;
            int n3 = this.m_height;
            int n4 = 0;
            if (this.m_shadowVisible) {
                n4 = GRHelper.GR_ROUND(this.m_shadowOffset);
                n2 -= n4;
                n3 -= n4;
            }
            for (int i = 0; i < this.m_height; ++i) {
                for (int j = 0; j < this.m_width; ++j) {
                    boolean bl;
                    int n5 = this.m_pRGBAWorking.getRGB(j, i);
                    int n6 = GRHelper.getAlpha(n5);
                    boolean bl2 = this.m_mirror ? j + n < this.m_width : j - n >= 0;
                    boolean bl3 = bl = i + n < this.m_height;
                    if (n6 != 0 && bl2 && bl) {
                        int n7 = i - n4;
                        int n8 = this.m_mirror ? j - n4 : j;
                        n7 += n;
                        n8 += this.m_mirror ? n : -n;
                        int n9 = this.m_pRGBAImage.getRGB(n8 = Math.min(n2 - 1, Math.max(0, n8)), n7 = Math.min(n3 - 1, Math.max(0, n7)));
                        int n10 = GRHelper.getAlpha(n9);
                        if ((n6 -= 255 - n10) < 0) {
                            n6 = 0;
                        }
                    }
                    this.m_pRGBAWorking.setRGB(j, i, GRHelper.updateAlpha(n6, n5));
                }
            }
        }
    }

    private Pixel getPixelColor(int n, int n2) {
        this.m_getPixelColor.ignore = false;
        if (this.m_drawingShadow) {
            if (!this.m_drawingOutline) {
                Pixel pixel = this.getImageFillColor(GRHelper.GR_ROUND(this.m_mirror ? (double)n + this.m_shadowOffset : (double)n - this.m_shadowOffset), GRHelper.GR_ROUND((double)n2 + this.m_shadowOffset));
                this.m_getPixelColor.ignore = pixel.ignore;
            }
            this.m_getPixelColor.rgba = this.m_shadowColor.getRGB();
            return this.m_getPixelColor;
        }
        if (this.m_drawingOutline) {
            if (this.m_outlineUseLightSource) {
                this.m_getPixelColor.rgba = this.m_outlineLightSourceColor.getRGB();
                return this.m_getPixelColor;
            }
            if (!this.m_drawingCleanupEdge) {
                this.m_getPixelColor.rgba = this.m_outlineColor.getRGB();
                return this.m_getPixelColor;
            }
        }
        return this.getImageFillColor(n, n2);
    }

    private void createImage() {
        int n = 0;
        boolean bl = false;
        for (n = 0; n < this.m_fillEffects.size() && !bl; ++n) {
            CGSTypeFillEffect cGSTypeFillEffect = this.m_fillEffects.elementAt(n);
            if (cGSTypeFillEffect.isEmpty()) continue;
            bl = true;
        }
        if (!bl) {
            return;
        }
        int n2 = this.m_width;
        int n3 = this.m_height;
        if (this.m_shadowVisible) {
            n2 -= GRHelper.GR_ROUND(this.m_shadowOffset);
            n3 -= GRHelper.GR_ROUND(this.m_shadowOffset);
        }
        this.m_pRGBAImage = new GRBufferedImage(n2, n3);
        GRHelper.initBufferedImage(this.m_pRGBAImage.getImage(), 0xFFFFFF);
        for (n = 0; n < this.m_fillEffects.size(); ++n) {
            CGSTypeFillEffect cGSTypeFillEffect = this.m_fillEffects.elementAt(n);
            if (cGSTypeFillEffect.isEmpty()) continue;
            BufferedImage bufferedImage = cGSTypeFillEffect.createImage(this.m_pDevice, n2, n3, this.m_mirror, false);
            GRHelper.combineBufferedImage(this.m_pRGBAImage.getImage(), bufferedImage, true);
        }
        GRHelper.flipBufferedImage(this.m_pRGBAImage.getImage());
    }

    private Pixel getImageFillColor(int n, int n2) {
        int n3;
        if (this.m_pRGBAImage == null) {
            this.m_getImageFillColor.ignore = true;
            this.m_getImageFillColor.rgba = Color.WHITE.getRGB();
            return this.m_getImageFillColor;
        }
        int n4 = this.m_width;
        int n5 = this.m_height;
        if (this.m_shadowVisible) {
            n4 -= GRHelper.GR_ROUND(this.m_shadowOffset);
            n5 -= GRHelper.GR_ROUND(this.m_shadowOffset);
        }
        if (this.m_shadowVisible) {
            n2 -= GRHelper.GR_ROUND(this.m_shadowOffset);
            if (this.m_mirror) {
                n -= GRHelper.GR_ROUND(this.m_shadowOffset);
            }
        }
        this.m_getImageFillColor.ignore = GRHelper.getAlpha(n3 = this.m_pRGBAImage.getRGB(n = Math.min(n4 - 1, Math.max(0, n)), n2 = Math.min(n5 - 1, Math.max(0, n2)))) == 0;
        this.m_getImageFillColor.rgba = n3;
        return this.m_getImageFillColor;
    }

    private void fillLinePoly(GRPointList gRPointList) {
        int n = 0;
        if (this.m_drawingVectorOutline) {
            GRPointList gRPointList2 = new GRPointList(28);
            for (n = 0; n < gRPointList.size(); ++n) {
                gRPointList2.setPoint(n, gRPointList.x(n) + this.m_xVectorOffset, gRPointList.y(n) + this.m_yVectorOffset);
            }
            Color color = this.m_outlineUseLightSource ? this.m_outlineLightSourceColor : this.m_outlineColor;
            gRPointList2.setSize(gRPointList.size());
            ((GRDeviceVector)this.m_pDevice).fillPolygon(color, gRPointList2);
            return;
        }
        double d = gRPointList.y(0);
        double d2 = gRPointList.y(0);
        for (n = 1; n < gRPointList.size(); ++n) {
            if (gRPointList.y(n) < d) {
                d = gRPointList.y(n);
            }
            if (!(gRPointList.y(n) > d2)) continue;
            d2 = gRPointList.y(n);
        }
        int n2 = GRHelper.GR_ROUND(d);
        int n3 = GRHelper.GR_ROUND(d2);
        GRPointList gRPointList3 = new GRPointList(28);
        for (int i = n2; i <= n3; ++i) {
            double d3;
            double d4;
            double d5 = (double)i - 0.5;
            double d6 = (double)i + 0.5;
            int n4 = 0;
            for (n = 0; n < gRPointList.size(); ++n) {
                if (gRPointList.y(n) >= d5 && gRPointList.y(n) <= d6) {
                    gRPointList3.setPoint(n4++, gRPointList.x(n), gRPointList.y(n));
                }
                d4 = d5;
                d3 = d6;
                if (gRPointList.y(n) > gRPointList.y((n + 1) % gRPointList.size())) {
                    d4 = d6;
                    d3 = d5;
                }
                Intersect intersect = this.yIntersect(d4, gRPointList.pt(n), gRPointList.pt((n + 1) % gRPointList.size()));
                if (intersect.isIntersect) {
                    gRPointList3.setPoint(n4++, intersect.intersectPt);
                }
                intersect = this.yIntersect(d3, gRPointList.pt(n), gRPointList.pt((n + 1) % gRPointList.size()));
                if (!intersect.isIntersect) continue;
                gRPointList3.setPoint(n4++, intersect.intersectPt);
            }
            gRPointList3.setSize(n4);
            d4 = gRPointList3.x(0);
            d3 = gRPointList3.x(0);
            for (n = 0; n < n4; ++n) {
                if (gRPointList3.x(n) < d4) {
                    d4 = gRPointList3.x(n);
                }
                if (!(gRPointList3.x(n) > d3)) continue;
                d3 = gRPointList3.x(n);
            }
            int n5 = GRHelper.GR_ROUND(d4);
            int n6 = GRHelper.GR_ROUND(d3);
            GRPointList gRPointList4 = new GRPointList(28);
            for (int j = n5; j <= n6; ++j) {
                double d7;
                double d8 = (double)j - 0.5;
                double d9 = (double)j + 0.5;
                int n7 = 0;
                for (n = 0; n < n4; ++n) {
                    if (gRPointList3.x(n) >= d8 && gRPointList3.x(n) <= d9) {
                        gRPointList4.setPoint(n7++, gRPointList3.x(n), gRPointList3.y(n));
                    }
                    d7 = d8;
                    double d10 = d9;
                    if (gRPointList3.x(n) > gRPointList3.x((n + 1) % n4)) {
                        d7 = d9;
                        d10 = d8;
                    }
                    Intersect intersect = this.xIntersect(d7, gRPointList3.pt(n), gRPointList3.pt((n + 1) % n4));
                    if (intersect.isIntersect) {
                        gRPointList4.setPoint(n7++, intersect.intersectPt);
                    }
                    intersect = this.xIntersect(d10, gRPointList3.pt(n), gRPointList3.pt((n + 1) % n4));
                    if (!intersect.isIntersect) continue;
                    gRPointList4.setPoint(n7++, intersect.intersectPt);
                }
                gRPointList4.setSize(n7);
                d7 = this.polyArea(gRPointList4);
                int n8 = (int)(d7 * 255.0);
                this.fillPixel(j, i, n8);
            }
        }
    }

    private void fillPixel(int n, int n2, int n3) {
        if (n < 0 || n >= this.m_width || n2 < 0 || n2 >= this.m_height || n3 == 0) {
            return;
        }
        GRBufferedImage gRBufferedImage = this.m_pRGBAWorking;
        Pixel pixel = this.getPixelColor(n, n2);
        if (pixel.ignore) {
            return;
        }
        int n4 = pixel.rgba;
        n4 = GRHelper.updateAlpha(n3, n4);
        int n5 = gRBufferedImage.getRGB(n, n2);
        if (n3 == 255 || GRHelper.getAlpha(n5) == 0) {
            gRBufferedImage.setRGB(n, n2, n4);
        } else {
            int n6 = GRHelper.addPixels(n5, n4);
            gRBufferedImage.setRGB(n, n2, n6);
        }
    }

    private void calcRoundedRect(boolean bl) {
        double d;
        double d2 = this.m_width;
        if (this.m_shadowVisible) {
            d2 -= this.m_shadowOffset;
        }
        double d3 = this.m_height;
        if (this.m_shadowVisible) {
            d3 -= this.m_shadowOffset;
        }
        double d4 = Math.max(1.0, this.m_outlineWidth);
        if (!this.m_outlineVisible) {
            d4 = 1.0;
        }
        if ((d = this.m_roundRectRadius) > d3 / 2.0 - d4) {
            d = d3 / 2.0 - d4;
        }
        if (d > d2 / 2.0 - d4) {
            d = d2 / 2.0 - d4;
        }
        double d5 = d + d4 / 2.0;
        double d6 = d3 - d - d4 / 2.0;
        double d7 = d2 - d - d4 / 2.0;
        double d8 = d + d4 / 2.0;
        d5 -= 0.5;
        d6 -= 0.5;
        d7 -= 0.5;
        d8 -= 0.5;
        if (this.m_shadowVisible) {
            d6 += this.m_shadowOffset;
            d8 += this.m_shadowOffset;
        }
        GRPoint gRPoint = new GRPoint();
        GRPoint gRPoint2 = new GRPoint();
        GRPoint gRPoint3 = new GRPoint();
        if (d == 0.0) {
            this.m_pPoints = new GRPolygonPointList(12);
            gRPoint.x = d7;
            gRPoint.y = d6;
            gRPoint3.x = d7 + d4 / 2.0;
            gRPoint3.y = d6 + d4 / 2.0;
            gRPoint2.x = d7 - d4 / 2.0;
            gRPoint2.y = d6 - d4 / 2.0;
            this.m_pPoints.setPoint(0, gRPoint2, gRPoint, gRPoint3, true);
            gRPoint.x = d7 - d4 / 2.0;
            gRPoint.y = d6;
            gRPoint3.x = d7 - d4 / 2.0;
            gRPoint3.y = d6 + d4 / 2.0;
            gRPoint2.x = d7 - d4 / 2.0;
            gRPoint2.y = d6 - d4 / 2.0;
            this.m_pPoints.setPoint(1, gRPoint2, gRPoint, gRPoint3, false);
            gRPoint.x = d5 + d4 / 2.0;
            gRPoint.y = d6;
            gRPoint3.x = d5 + d4 / 2.0;
            gRPoint3.y = d6 + d4 / 2.0;
            gRPoint2.x = d5 + d4 / 2.0;
            gRPoint2.y = d6 - d4 / 2.0;
            this.m_pPoints.setPoint(2, gRPoint2, gRPoint, gRPoint3, false);
            gRPoint.x = d5;
            gRPoint.y = d6;
            gRPoint3.x = d5 - d4 / 2.0;
            gRPoint3.y = d6 + d4 / 2.0;
            gRPoint2.x = d5 + d4 / 2.0;
            gRPoint2.y = d6 - d4 / 2.0;
            this.m_pPoints.setPoint(3, gRPoint2, gRPoint, gRPoint3, true);
            gRPoint.x = d5;
            gRPoint.y = d6 - d4 / 2.0;
            gRPoint3.x = d5 - d4 / 2.0;
            gRPoint3.y = d6 - d4 / 2.0;
            gRPoint2.x = d5 + d4 / 2.0;
            gRPoint2.y = d6 - d4 / 2.0;
            this.m_pPoints.setPoint(4, gRPoint2, gRPoint, gRPoint3, false);
            gRPoint.x = d5;
            gRPoint.y = d8 + d4 / 2.0;
            gRPoint3.x = d5 - d4 / 2.0;
            gRPoint3.y = d8 + d4 / 2.0;
            gRPoint2.x = d5 + d4 / 2.0;
            gRPoint2.y = d8 + d4 / 2.0;
            this.m_pPoints.setPoint(5, gRPoint2, gRPoint, gRPoint3, false);
            gRPoint.x = d5;
            gRPoint.y = d8;
            gRPoint3.x = d5 - d4 / 2.0;
            gRPoint3.y = d8 - d4 / 2.0;
            gRPoint2.x = d5 + d4 / 2.0;
            gRPoint2.y = d8 + d4 / 2.0;
            this.m_pPoints.setPoint(6, gRPoint2, gRPoint, gRPoint3, true);
            gRPoint.x = d5 + d4 / 2.0;
            gRPoint.y = d8;
            gRPoint3.x = d5 + d4 / 2.0;
            gRPoint3.y = d8 - d4 / 2.0;
            gRPoint2.x = d5 + d4 / 2.0;
            gRPoint2.y = d8 + d4 / 2.0;
            this.m_pPoints.setPoint(7, gRPoint2, gRPoint, gRPoint3, false);
            gRPoint.x = d7 - d4 / 2.0;
            gRPoint.y = d8;
            gRPoint3.x = d7 - d4 / 2.0;
            gRPoint3.y = d8 - d4 / 2.0;
            gRPoint2.x = d7 - d4 / 2.0;
            gRPoint2.y = d8 + d4 / 2.0;
            this.m_pPoints.setPoint(8, gRPoint2, gRPoint, gRPoint3, false);
            gRPoint.x = d7;
            gRPoint.y = d8;
            gRPoint3.x = d7 + d4 / 2.0;
            gRPoint3.y = d8 - d4 / 2.0;
            gRPoint2.x = d7 - d4 / 2.0;
            gRPoint2.y = d8 + d4 / 2.0;
            this.m_pPoints.setPoint(9, gRPoint2, gRPoint, gRPoint3, true);
            gRPoint.x = d7;
            gRPoint.y = d8 + d4 / 2.0;
            gRPoint3.x = d7 + d4 / 2.0;
            gRPoint3.y = d8 + d4 / 2.0;
            gRPoint2.x = d7 - d4 / 2.0;
            gRPoint2.y = d8 + d4 / 2.0;
            this.m_pPoints.setPoint(10, gRPoint2, gRPoint, gRPoint3, false);
            gRPoint.x = d7;
            gRPoint.y = d6 - d4 / 2.0;
            gRPoint3.x = d7 + d4 / 2.0;
            gRPoint3.y = d6 - d4 / 2.0;
            gRPoint2.x = d7 - d4 / 2.0;
            gRPoint2.y = d6 - d4 / 2.0;
            this.m_pPoints.setPoint(11, gRPoint2, gRPoint, gRPoint3, false);
        } else {
            double d9;
            double d10;
            int n = d <= 15.0 && bl ? 15 : 5;
            int n2 = 360 / n + 4;
            if (d < d4 / 2.0) {
                n2 += 8;
            }
            this.m_pPoints = new GRPolygonPointList(n2);
            int n3 = 0;
            double d11 = d + d4 / 2.0;
            double d12 = d - d4 / 2.0;
            int n4 = 0;
            for (n3 = 45; n3 <= 90; n3 += n) {
                d10 = GRHelper.cosValue(n3);
                d9 = GRHelper.sinValue(n3);
                gRPoint.x = d7 + d * d10;
                gRPoint.y = d6 + d * d9;
                gRPoint3.x = d7 + d11 * d10;
                gRPoint3.y = d6 + d11 * d9;
                if (d12 <= 0.0) {
                    d10 = 1.0;
                    d9 = 1.0;
                }
                gRPoint2.x = d7 + d12 * d10;
                gRPoint2.y = d6 + d12 * d9;
                this.m_pPoints.setPoint(n4, gRPoint2, gRPoint, gRPoint3, n3 == 45);
                ++n4;
                if (n3 != 90 || !(d < d4 / 2.0)) continue;
                gRPoint.x = d7 + d - d4 / 2.0;
                gRPoint.y = d6 + d;
                gRPoint3.x = d7 + d - d4 / 2.0;
                gRPoint3.y = d6 + d + d4 / 2.0;
                gRPoint2.x = d7 + d - d4 / 2.0;
                gRPoint2.y = d6 + d - d4 / 2.0;
                this.m_pPoints.setPoint(n4, gRPoint2, gRPoint, gRPoint3, false);
                ++n4;
            }
            for (n3 = 90; n3 <= 180; n3 += n) {
                if (n3 == 90 && d < d4 / 2.0) {
                    gRPoint.x = d5 - d + d4 / 2.0;
                    gRPoint.y = d6 + d;
                    gRPoint3.x = d5 - d + d4 / 2.0;
                    gRPoint3.y = d6 + d + d4 / 2.0;
                    gRPoint2.x = d5 - d + d4 / 2.0;
                    gRPoint2.y = d6 + d - d4 / 2.0;
                    this.m_pPoints.setPoint(n4, gRPoint2, gRPoint, gRPoint3, false);
                    ++n4;
                }
                d10 = GRHelper.cosValue(n3);
                d9 = GRHelper.sinValue(n3);
                gRPoint.x = d5 + d * d10;
                gRPoint.y = d6 + d * d9;
                gRPoint3.x = d5 + d11 * d10;
                gRPoint3.y = d6 + d11 * d9;
                if (d12 <= 0.0) {
                    d10 = -1.0;
                    d9 = 1.0;
                }
                gRPoint2.x = d5 + d12 * d10;
                gRPoint2.y = d6 + d12 * d9;
                this.m_pPoints.setPoint(n4, gRPoint2, gRPoint, gRPoint3, n3 == 135);
                ++n4;
                if (n3 != 180 || !(d < d4 / 2.0)) continue;
                gRPoint.x = d5 - d;
                gRPoint.y = d6 + d - d4 / 2.0;
                gRPoint3.x = d5 - d - d4 / 2.0;
                gRPoint3.y = d6 + d - d4 / 2.0;
                gRPoint2.x = d5 - d + d4 / 2.0;
                gRPoint2.y = d6 + d - d4 / 2.0;
                this.m_pPoints.setPoint(n4, gRPoint2, gRPoint, gRPoint3, false);
                ++n4;
            }
            for (n3 = 180; n3 <= 270; n3 += n) {
                if (n3 == 180 && d < d4 / 2.0) {
                    gRPoint.x = d5 - d;
                    gRPoint.y = d8 - d + d4 / 2.0;
                    gRPoint3.x = d5 - d - d4 / 2.0;
                    gRPoint3.y = d8 - d + d4 / 2.0;
                    gRPoint2.x = d5 - d + d4 / 2.0;
                    gRPoint2.y = d8 - d + d4 / 2.0;
                    this.m_pPoints.setPoint(n4, gRPoint2, gRPoint, gRPoint3, false);
                    ++n4;
                }
                d10 = GRHelper.cosValue(n3);
                d9 = GRHelper.sinValue(n3);
                gRPoint.x = d5 + d * d10;
                gRPoint.y = d8 + d * d9;
                gRPoint3.x = d5 + d11 * d10;
                gRPoint3.y = d8 + d11 * d9;
                if (d12 <= 0.0) {
                    d10 = -1.0;
                    d9 = -1.0;
                }
                gRPoint2.x = d5 + d12 * d10;
                gRPoint2.y = d8 + d12 * d9;
                this.m_pPoints.setPoint(n4, gRPoint2, gRPoint, gRPoint3, n3 == 225);
                ++n4;
                if (n3 != 270 || !(d < d4 / 2.0)) continue;
                gRPoint.x = d5 - d + d4 / 2.0;
                gRPoint.y = d8 - d;
                gRPoint3.x = d5 - d + d4 / 2.0;
                gRPoint3.y = d8 - d - d4 / 2.0;
                gRPoint2.x = d5 - d + d4 / 2.0;
                gRPoint2.y = d8 - d + d4 / 2.0;
                this.m_pPoints.setPoint(n4, gRPoint2, gRPoint, gRPoint3, false);
                ++n4;
            }
            for (n3 = 270; n3 <= 360; n3 += n) {
                if (n3 == 270 && d < d4 / 2.0) {
                    gRPoint.x = d7 + d - d4 / 2.0;
                    gRPoint.y = d8 - d;
                    gRPoint3.x = d7 + d - d4 / 2.0;
                    gRPoint3.y = d8 - d - d4 / 2.0;
                    gRPoint2.x = d7 + d - d4 / 2.0;
                    gRPoint2.y = d8 - d + d4 / 2.0;
                    this.m_pPoints.setPoint(n4, gRPoint2, gRPoint, gRPoint3, false);
                    ++n4;
                }
                d10 = GRHelper.cosValue(n3);
                d9 = GRHelper.sinValue(n3);
                gRPoint.x = d7 + d * d10;
                gRPoint.y = d8 + d * d9;
                gRPoint3.x = d7 + d11 * d10;
                gRPoint3.y = d8 + d11 * d9;
                if (d12 <= 0.0) {
                    d10 = 1.0;
                    d9 = -1.0;
                }
                gRPoint2.x = d7 + d12 * d10;
                gRPoint2.y = d8 + d12 * d9;
                this.m_pPoints.setPoint(n4, gRPoint2, gRPoint, gRPoint3, n3 == 315);
                ++n4;
                if (n3 != 360 || !(d < d4 / 2.0)) continue;
                gRPoint.x = d7 + d;
                gRPoint.y = d8 - d + d4 / 2.0;
                gRPoint3.x = d7 + d + d4 / 2.0;
                gRPoint3.y = d8 - d + d4 / 2.0;
                gRPoint2.x = d7 + d - d4 / 2.0;
                gRPoint2.y = d8 - d + d4 / 2.0;
                this.m_pPoints.setPoint(n4, gRPoint2, gRPoint, gRPoint3, false);
                ++n4;
            }
            for (n3 = 0; n3 < 45; n3 += n) {
                if (n3 == 0 && d < d4 / 2.0) {
                    gRPoint.x = d7 + d;
                    gRPoint.y = d6 + d - d4 / 2.0;
                    gRPoint3.x = d7 + d + d4 / 2.0;
                    gRPoint3.y = d6 + d - d4 / 2.0;
                    gRPoint2.x = d7 + d - d4 / 2.0;
                    gRPoint2.y = d6 + d - d4 / 2.0;
                    this.m_pPoints.setPoint(n4, gRPoint2, gRPoint, gRPoint3, false);
                    ++n4;
                }
                d10 = GRHelper.cosValue(n3);
                d9 = GRHelper.sinValue(n3);
                gRPoint.x = d7 + d * d10;
                gRPoint.y = d6 + d * d9;
                gRPoint3.x = d7 + d11 * d10;
                gRPoint3.y = d6 + d11 * d9;
                if (d12 <= 0.0) {
                    d10 = 1.0;
                    d9 = 1.0;
                }
                gRPoint2.x = d7 + d12 * d10;
                gRPoint2.y = d6 + d12 * d9;
                this.m_pPoints.setPoint(n4, gRPoint2, gRPoint, gRPoint3, false);
                ++n4;
            }
        }
    }

    private Intersect yIntersect(double d, GRPoint gRPoint, GRPoint gRPoint2) {
        this.m_intersect.isIntersect = false;
        if (Math.min(gRPoint.y, gRPoint2.y) >= d || Math.max(gRPoint.y, gRPoint2.y) <= d) {
            return this.m_intersect;
        }
        double d2 = (d - gRPoint.y) / (gRPoint2.y - gRPoint.y);
        this.m_intersect.isIntersect = true;
        this.m_intersect.intersectPt.x = gRPoint.x + d2 * (gRPoint2.x - gRPoint.x);
        this.m_intersect.intersectPt.y = d;
        return this.m_intersect;
    }

    private Intersect xIntersect(double d, GRPoint gRPoint, GRPoint gRPoint2) {
        this.m_intersect.isIntersect = false;
        if (Math.min(gRPoint.x, gRPoint2.x) >= d || Math.max(gRPoint.x, gRPoint2.x) <= d) {
            return this.m_intersect;
        }
        double d2 = (d - gRPoint.x) / (gRPoint2.x - gRPoint.x);
        this.m_intersect.isIntersect = true;
        this.m_intersect.intersectPt.x = d;
        this.m_intersect.intersectPt.y = gRPoint.y + d2 * (gRPoint2.y - gRPoint.y);
        return this.m_intersect;
    }

    private double polyArea(GRPointList gRPointList) {
        double d = 0.0;
        for (int i = 0; i < gRPointList.size(); ++i) {
            int n = (i + 1) % gRPointList.size();
            d += gRPointList.x(i) * gRPointList.y(n) - gRPointList.x(n) * gRPointList.y(i);
        }
        return Math.abs(d /= 2.0);
    }

    class Intersect {
        public boolean isIntersect = false;
        public GRPoint intersectPt = new GRPoint();
    }

    class Pixel {
        public int rgba;
        public boolean ignore;

        Pixel() {
        }
    }
}

