/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Graphics;

import com.ibm.cgsBus.Graphics.GRHelper;
import java.awt.image.BufferedImage;

public abstract class GRDevice {
    protected int m_width = 0;
    protected int m_height = 0;
    protected int m_dpi = 96;
    protected double m_scaleFactor = 1.0;

    public GRDevice(int n, int n2, int n3, double d) {
        this.m_dpi = n == 0 ? 96 : this.m_dpi;
        this.m_width = GRHelper.GR_ROUND((double)n2 * d);
        this.m_height = GRHelper.GR_ROUND((double)n3 * d);
        this.m_scaleFactor = d;
    }

    public abstract boolean isRaster();

    public abstract boolean isSVG();

    public abstract void drawImage(BufferedImage var1, double var2, double var4, boolean var6);

    public void pasteImage(BufferedImage bufferedImage, int n, int n2) {
        int n3 = this.m_height - 1 - n2;
        this.drawImage(bufferedImage, n, n3, true);
    }

    public double getScaleFactor() {
        return this.m_scaleFactor;
    }

    public double fromPoints(double d) {
        return d * (double)this.m_dpi * this.m_scaleFactor / 72.0;
    }

    public double fromPixels(double d) {
        return d * this.m_scaleFactor;
    }

    public double toPixels(double d) {
        return d / this.m_scaleFactor;
    }
}

