/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Graphics;

import com.ibm.cgsBus.Common.CMByteBuffer;
import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.FrameWork.CGSVectorInterface;
import com.ibm.cgsBus.FrameWork.CGSVectorTriangle;
import com.ibm.cgsBus.Graphics.GRDevice;
import com.ibm.cgsBus.Graphics.GRHelper;
import com.ibm.cgsBus.Graphics.GRPointList;
import com.ibm.cgsBus.Properties.CGSPropFont;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeFillEffect;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Stack;
import java.util.Vector;

public class GRDeviceVector
extends GRDevice {
    private static final int SET_COLOR = 0;
    private static final int SET_FONT = 1;
    private static final int SET_STROKE = 2;
    private static final int SET_PAINT = 3;
    private static final int FILL_POLYGON = 4;
    private static final int DRAW_LINE = 5;
    private static final int DRAW_STRING = 6;
    private static final int DRAW_IMAGE = 7;
    private static final int PUSH_OFFSET = 8;
    private static final int POP_OFFSET = 9;
    private static final int DRAW_STRING_BOX = 10;
    private static final int DRAW_CPV_TRIANGLE = 11;
    public static final int END_OF_VECTOR_STREAM = 99;
    private CMByteBuffer m_vectorBlob = new CMByteBuffer();
    private Color m_color = null;
    private String m_fontFacename = null;
    private double m_fontSize = 0.0;
    private boolean m_fontBold = false;
    private boolean m_fontItalic = false;
    private boolean m_fontStrikeThru = false;
    private boolean m_fontUnderline = false;
    private boolean m_strokeSet = false;
    private double m_strokeLineWidth = 0.0;
    private int m_strokeEndCap = 0;
    private int m_strokeLineJoin = 0;
    private double[] m_strokeDashes = null;
    private double m_strokeDashPhase = 0.0;
    private int m_paintHatchCode = -1;

    public GRDeviceVector() {
        super(0, 0, 0, 0.75);
    }

    public GRDeviceVector(int n, int n2, int n3) {
        super(n, n2, n3, 0.75);
    }

    @Override
    public boolean isRaster() {
        return false;
    }

    @Override
    public boolean isSVG() {
        return false;
    }

    public byte[] getVectorBlob() {
        byte[] byArray = this.m_vectorBlob.str();
        return byArray == null ? new byte[]{} : byArray;
    }

    public void pasteVectorBlob(byte[] byArray, double d, double d2) {
        this.pushOffset(d, d2);
        this.m_vectorBlob.appendBytes(byArray);
        this.popOffset();
    }

    public void drawText(CGSPropFont cGSPropFont, double d, double d2, String string) {
        this.setColor(cGSPropFont.getColor());
        this.setFont(cGSPropFont);
        this.drawString(d, d2, 0.0, string);
    }

    public void setColor(Color color) {
        this.m_color = color;
    }

    private void setColor() {
        if (this.m_color != null) {
            this.m_vectorBlob.appendInt(0);
            this.m_vectorBlob.appendInt(this.m_color.getRGB());
        }
    }

    public void setFont(String string, double d, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.m_fontFacename = string;
        this.m_fontSize = d;
        this.m_fontBold = bl;
        this.m_fontItalic = bl2;
        this.m_fontStrikeThru = bl3;
        this.m_fontUnderline = bl4;
    }

    public void setFont(CGSPropFont cGSPropFont) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        switch (cGSPropFont.getStyle()) {
            case eStyleBold: {
                bl = true;
                break;
            }
            case eStyleItalic: {
                bl2 = true;
                break;
            }
            case eStyleBoldItalic: {
                bl = true;
                bl2 = true;
                break;
            }
        }
        switch (cGSPropFont.getEffect()) {
            case eEffectStrikeThrough: {
                bl3 = true;
                break;
            }
            case eEffectUnderline: {
                bl4 = true;
                break;
            }
            case eEffectUnderlineStrikeThrough: {
                bl3 = true;
                bl4 = true;
                break;
            }
        }
        this.setFont(cGSPropFont.getFaceName(), cGSPropFont.getSize(), bl, bl2, bl3, bl4);
    }

    private void setFont() {
        if (this.m_fontFacename != null) {
            this.m_vectorBlob.appendInt(1);
            this.m_vectorBlob.appendString(this.m_fontFacename);
            this.m_vectorBlob.appendDouble(this.m_fontSize);
            this.m_vectorBlob.appendInt(this.m_fontBold ? 1 : 0);
            this.m_vectorBlob.appendInt(this.m_fontItalic ? 1 : 0);
            this.m_vectorBlob.appendInt(this.m_fontStrikeThru ? 1 : 0);
            this.m_vectorBlob.appendInt(this.m_fontUnderline ? 1 : 0);
        }
    }

    public void setStroke(double d, int n, int n2, double[] dArray, double d2) {
        this.m_strokeSet = true;
        this.m_strokeLineWidth = d;
        this.m_strokeEndCap = n;
        this.m_strokeLineJoin = n2;
        this.m_strokeDashes = dArray;
        this.m_strokeDashPhase = d2;
    }

    private void setStroke() {
        if (this.m_strokeSet) {
            this.m_vectorBlob.appendInt(2);
            this.m_vectorBlob.appendDouble(this.m_strokeLineWidth);
            this.m_vectorBlob.appendInt(this.m_strokeEndCap);
            this.m_vectorBlob.appendInt(this.m_strokeLineJoin);
            if (this.m_strokeDashes == null) {
                this.m_vectorBlob.appendInt(0);
            } else {
                this.m_vectorBlob.appendInt(this.m_strokeDashes.length);
                for (int i = 0; i < this.m_strokeDashes.length; ++i) {
                    this.m_vectorBlob.appendDouble(this.m_strokeDashes[i]);
                }
                this.m_vectorBlob.appendDouble(this.m_strokeDashPhase);
            }
        }
    }

    public void setPaint(int n) {
        this.m_paintHatchCode = n;
    }

    private void setPaint() {
        if (this.m_paintHatchCode != -1) {
            this.m_vectorBlob.appendInt(3);
            this.m_vectorBlob.appendInt(this.m_paintHatchCode);
        }
    }

    public void drawString(double d, double d2, double d3, String string) {
        this.setColor();
        this.setFont();
        this.m_vectorBlob.appendInt(6);
        this.m_vectorBlob.appendDouble(d);
        this.m_vectorBlob.appendDouble(d2);
        this.m_vectorBlob.appendDouble(d3);
        this.m_vectorBlob.appendString(string);
    }

    public void drawString(double d, double d2, double d3, double d4, CGSPropFont.HorAlign horAlign, String string) {
        this.setColor();
        this.setFont();
        this.m_vectorBlob.appendInt(10);
        this.m_vectorBlob.appendDouble(d);
        this.m_vectorBlob.appendDouble(d2);
        this.m_vectorBlob.appendDouble(d3);
        this.m_vectorBlob.appendDouble(d4);
        this.m_vectorBlob.appendInt(horAlign.ordinal());
        this.m_vectorBlob.appendString(string);
    }

    public void fillRect(double d, double d2, double d3, double d4) {
        this.setColor();
        this.setPaint();
        this.m_vectorBlob.appendInt(4);
        this.m_vectorBlob.appendInt(4);
        this.m_vectorBlob.appendDouble(d);
        this.m_vectorBlob.appendDouble(d2);
        this.m_vectorBlob.appendDouble(d + d3);
        this.m_vectorBlob.appendDouble(d2);
        this.m_vectorBlob.appendDouble(d + d3);
        this.m_vectorBlob.appendDouble(d2 + d4);
        this.m_vectorBlob.appendDouble(d);
        this.m_vectorBlob.appendDouble(d2 + d4);
    }

    public void fillPolygon(Color color, GRPointList gRPointList) {
        this.m_vectorBlob.appendInt(0);
        this.m_vectorBlob.appendInt(color.getRGB());
        this.m_vectorBlob.appendInt(4);
        this.m_vectorBlob.appendInt(gRPointList.size());
        for (int i = 0; i < gRPointList.size(); ++i) {
            this.m_vectorBlob.appendDouble(gRPointList.x(i));
            this.m_vectorBlob.appendDouble((double)this.m_height - gRPointList.y(i));
        }
    }

    public void polyOpCode(boolean bl, byte[] byArray) {
        this.setColor();
        if (bl) {
            this.setPaint();
        } else {
            this.setStroke();
        }
        this.m_vectorBlob.appendInt(bl ? 4 : 5);
        this.m_vectorBlob.appendInt(byArray.length / 16);
        this.m_vectorBlob.appendBytes(byArray);
    }

    public void drawCPVTriangle(Color[] colorArray, byte[] byArray) {
        if (colorArray.length != 3 || byArray.length != 48) {
            return;
        }
        this.m_vectorBlob.appendInt(11);
        for (int i = 0; i < 3; ++i) {
            this.m_vectorBlob.appendInt(colorArray[i].getRGB());
        }
        this.m_vectorBlob.appendBytes(byArray);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, double d, double d2, boolean bl) {
        this.m_vectorBlob.appendInt(7);
        this.m_vectorBlob.appendDouble(d);
        this.m_vectorBlob.appendDouble(d2);
        this.m_vectorBlob.appendInt(bl ? 1 : 0);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        this.m_vectorBlob.appendInt(n);
        this.m_vectorBlob.appendInt(n2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = bufferedImage.getRGB(j, i);
                this.m_vectorBlob.appendInt(n3);
            }
        }
    }

    public void pushOffset(double d, double d2) {
        this.m_vectorBlob.appendInt(8);
        this.m_vectorBlob.appendDouble(d);
        this.m_vectorBlob.appendDouble(d2);
    }

    public void popOffset() {
        this.m_vectorBlob.appendInt(9);
    }

    public static void decodeBuffer(CGSVectorInterface cGSVectorInterface, CMByteBuffer cMByteBuffer, double d, double d2) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(cMByteBuffer.str());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        Color color = null;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        int n2 = -1;
        double[] dArray = new double[100];
        double d5 = 0.0;
        int n3 = 0;
        int n4 = 0;
        CGSTypeFillEffect cGSTypeFillEffect = new CGSTypeFillEffect();
        Stack<Double> stack = new Stack<Double>();
        Stack<Double> stack2 = new Stack<Double>();
        double d6 = 0.0;
        double d7 = 0.0;
        Vector<CGSVectorTriangle> vector = new Vector<CGSVectorTriangle>();
        byteBuffer.get();
        byteBuffer.get();
        byteBuffer.get();
        byteBuffer.getInt();
        int n5 = -1;
        block29: while (byteBuffer.remaining() != 0) {
            Object object;
            int n6 = n5;
            n5 = byteBuffer.getInt();
            if (n5 == 99) break;
            if (n5 == 11) {
                int n7;
                object = new CGSVectorTriangle();
                for (n7 = 0; n7 < 3; ++n7) {
                    int n8 = byteBuffer.getInt();
                    ((CGSVectorTriangle)object).colors[n7] = new Color(GRHelper.getRed(n8), GRHelper.getGreen(n8), GRHelper.getBlue(n8), GRHelper.getAlpha(n8));
                }
                for (n7 = 0; n7 < 3; ++n7) {
                    ((CGSVectorTriangle)object).points[n7][0] = byteBuffer.getDouble() + d6;
                    ((CGSVectorTriangle)object).points[n7][1] = byteBuffer.getDouble() + d7;
                }
                vector.addElement((CGSVectorTriangle)object);
                continue;
            }
            if (vector.size() != 0) {
                cGSVectorInterface.drawShadedTriangle(vector);
                vector.clear();
            }
            switch (n5) {
                case 0: {
                    int n9 = byteBuffer.getInt();
                    color = n9 == 0 ? null : new Color(n9);
                    n2 = -1;
                    continue block29;
                }
                case 1: {
                    object = GRDeviceVector.decodeString(byteBuffer);
                    d3 = byteBuffer.getDouble();
                    boolean bl = byteBuffer.getInt() != 0;
                    boolean bl2 = byteBuffer.getInt() != 0;
                    boolean bl3 = byteBuffer.getInt() != 0;
                    boolean bl4 = byteBuffer.getInt() != 0;
                    cGSVectorInterface.setFont((String)object, d3, bl, bl2, bl3, bl4);
                    continue block29;
                }
                case 2: {
                    d4 = byteBuffer.getDouble();
                    int n10 = byteBuffer.getInt();
                    int n11 = byteBuffer.getInt();
                    int n12 = byteBuffer.getInt();
                    n = 0;
                    d5 = 0.0;
                    if (n12 != 0) {
                        CMHelper.CGS_ASSERT(n12 < 100, "Line Pattern is too complex");
                        for (int i = 0; i < n12; ++i) {
                            dArray[i] = byteBuffer.getDouble();
                        }
                        if (n12 > 1) {
                            n = n12;
                        }
                        d5 = byteBuffer.getDouble();
                    }
                    switch (n10) {
                        case 1: {
                            n3 = 1;
                            break;
                        }
                        case 2: {
                            n3 = 2;
                            break;
                        }
                        default: {
                            n3 = 0;
                        }
                    }
                    switch (n11) {
                        case 1: {
                            n4 = 1;
                            continue block29;
                        }
                        case 2: {
                            n4 = 2;
                            continue block29;
                        }
                    }
                    n4 = 0;
                    continue block29;
                }
                case 3: {
                    n2 = byteBuffer.getInt();
                    continue block29;
                }
                case 4: {
                    int n13;
                    int n14 = byteBuffer.getInt();
                    if (color == null) {
                        int n15 = n14 * 8 * 2;
                        int n16 = byteBuffer.position();
                        byteBuffer.position(n16 + n15);
                        continue block29;
                    }
                    cGSVectorInterface.pathStartNew();
                    cGSVectorInterface.pathSetLineStyle(0.0, n3, n4);
                    double d8 = byteBuffer.getDouble();
                    double d9 = byteBuffer.getDouble();
                    cGSVectorInterface.pathMoveTo(d8 + d6, d9 + d7);
                    for (n13 = 1; n13 < n14; ++n13) {
                        d8 = byteBuffer.getDouble();
                        d9 = byteBuffer.getDouble();
                        cGSVectorInterface.pathLineTo(d8 + d6, d9 + d7);
                    }
                    cGSVectorInterface.pathCloseSubpath();
                    if (n2 == -1) {
                        cGSTypeFillEffect.setSolidColor(color);
                    } else {
                        cGSTypeFillEffect.setType(CGSEnums.FillType.eFillPattern);
                        cGSTypeFillEffect.setPatternTransparent(true);
                        cGSTypeFillEffect.setPatternForeColor(color);
                        color = null;
                        switch (n2) {
                            case 1: {
                                cGSTypeFillEffect.setPatternType(CGSEnums.PatternType.ePatternForwardDiagonal);
                                break;
                            }
                            case 2: {
                                cGSTypeFillEffect.setPatternType(CGSEnums.PatternType.ePatternCross);
                                break;
                            }
                            case 3: {
                                cGSTypeFillEffect.setPatternType(CGSEnums.PatternType.ePatternDiagonalCross);
                                break;
                            }
                            case 4: {
                                cGSTypeFillEffect.setPatternType(CGSEnums.PatternType.ePatternBackwardDiagonal);
                                break;
                            }
                            case 5: {
                                cGSTypeFillEffect.setPatternType(CGSEnums.PatternType.ePatternHorizontal);
                                break;
                            }
                            case 6: {
                                cGSTypeFillEffect.setPatternType(CGSEnums.PatternType.ePatternVertical);
                                break;
                            }
                            default: {
                                cGSTypeFillEffect.setPatternType(CGSEnums.PatternType.ePatternSolid);
                            }
                        }
                    }
                    cGSVectorInterface.pathFinishAndPaint(color, cGSTypeFillEffect);
                    continue block29;
                }
                case 5: {
                    int n13;
                    int n17 = byteBuffer.getInt();
                    cGSVectorInterface.pathStartNew();
                    if (n != 0) {
                        cGSVectorInterface.pathSetLineDashPattern(d5, n, dArray);
                    }
                    cGSVectorInterface.pathSetLineStyle(d4, n3, n4);
                    double d10 = byteBuffer.getDouble();
                    double d11 = byteBuffer.getDouble();
                    cGSVectorInterface.pathMoveTo(d10 + d6, d11 + d7);
                    for (n13 = 1; n13 < n17; ++n13) {
                        d10 = byteBuffer.getDouble();
                        d11 = byteBuffer.getDouble();
                        cGSVectorInterface.pathLineTo(d10 + d6, d11 + d7);
                    }
                    cGSVectorInterface.pathFinishAndPaint(color, null);
                    continue block29;
                }
                case 6: {
                    double d12 = byteBuffer.getDouble();
                    double d13 = byteBuffer.getDouble();
                    double d14 = byteBuffer.getDouble();
                    String string = GRDeviceVector.decodeString(byteBuffer);
                    cGSVectorInterface.drawString(string, d12 + d6, d13 + d7, d14);
                    continue block29;
                }
                case 7: {
                    int n18;
                    double d15 = byteBuffer.getDouble();
                    double d16 = byteBuffer.getDouble();
                    boolean bl = byteBuffer.getInt() != 0;
                    int n13 = byteBuffer.getInt();
                    int n19 = byteBuffer.getInt();
                    int[] nArray = new int[n13 * n19];
                    for (n18 = 0; n18 < n19; ++n18) {
                        for (int i = 0; i < n13; ++i) {
                            nArray[n18 * n13 + i] = byteBuffer.getInt();
                        }
                    }
                    if (bl) {
                        cGSVectorInterface.drawImage(d15 + d6, d16 + d7, n13, n19, nArray);
                        continue block29;
                    }
                    double d17 = d2 - 1.0 - (d16 + d7);
                    cGSVectorInterface.drawImage(d15 + d6, d17, n13, n19, nArray);
                    continue block29;
                }
                case 8: {
                    double d18 = byteBuffer.getDouble();
                    double d19 = byteBuffer.getDouble();
                    stack.push(d18);
                    stack2.push(d19);
                    d6 += d18;
                    d7 += d19;
                    continue block29;
                }
                case 9: {
                    d6 -= ((Double)stack.pop()).doubleValue();
                    d7 -= ((Double)stack2.pop()).doubleValue();
                    continue block29;
                }
                case 10: {
                    double d20 = byteBuffer.getDouble();
                    double d21 = byteBuffer.getDouble();
                    double d22 = byteBuffer.getDouble();
                    double d23 = byteBuffer.getDouble();
                    int n18 = byteBuffer.getInt();
                    if (n18 < 0 || n18 > 2) {
                        n18 = 1;
                    }
                    String string = GRDeviceVector.decodeString(byteBuffer);
                    cGSVectorInterface.drawStringBox(string, d20 + d6, d21 + d7, d22, d23, n18);
                    continue block29;
                }
            }
            CMHelper.CGS_ASSERT(false, "Unknown vector opcode " + n5 + " last was " + n6);
        }
    }

    private static String decodeString(ByteBuffer byteBuffer) {
        try {
            int n = byteBuffer.getInt();
            byte[] byArray = new byte[n];
            byteBuffer.get(byArray);
            byteBuffer.get();
            String string = new String(byArray, "UTF-8");
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

