/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Graphics;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.Graphics.GRBufferedImage;
import com.ibm.cgsBus.Logging.CGSLogging;
import com.ibm.cgsBus.Properties.CGSPropFont;
import com.ibm.cgsBus.Properties.CGSPropPaletteContinuousB;
import com.ibm.cgsBus.Properties.CGSPropPaletteContinuousItemB;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class GRHelper {
    public static final double GR_RAD2DEG = 57.29577951308232;
    public static final int GR_MAX_LINE_PTS = 14;
    public static final int GR_MAX_SCAN_PTS = 28;
    public static final int GR_MAX_PIXEL_PTS = 28;
    private static List<String> s_fontNames = new ArrayList<String>();
    private static final double[] s_cosTable = new double[360];
    private static final double[] s_sinTable = new double[360];

    public static int getAlpha(int n) {
        return n >> 24 & 0xFF;
    }

    public static int getRed(int n) {
        return n >> 16 & 0xFF;
    }

    public static int getGreen(int n) {
        return n >> 8 & 0xFF;
    }

    public static int getBlue(int n) {
        return n & 0xFF;
    }

    public static int RGB(int n, int n2, int n3, int n4) {
        return (n & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF;
    }

    public static int updateAlpha(int n, int n2) {
        return GRHelper.RGB(n, GRHelper.getRed(n2), GRHelper.getGreen(n2), GRHelper.getBlue(n2));
    }

    public static int addPixels(int n, int n2) {
        int n3 = GRHelper.getAlpha(n);
        int n4 = GRHelper.getRed(n);
        int n5 = GRHelper.getGreen(n);
        int n6 = GRHelper.getBlue(n);
        int n7 = GRHelper.getAlpha(n2);
        int n8 = GRHelper.getRed(n2);
        int n9 = GRHelper.getGreen(n2);
        int n10 = GRHelper.getBlue(n2);
        int n11 = n7;
        int n12 = Math.min(n3, 255 - n11);
        if (n11 + n12 == 0) {
            return n;
        }
        int n13 = (n8 * n11 + n4 * n12) / (n11 + n12);
        int n14 = (n9 * n11 + n5 * n12) / (n11 + n12);
        int n15 = (n10 * n11 + n6 * n12) / (n11 + n12);
        int n16 = n11 + n12;
        return GRHelper.RGB(n16, n13, n14, n15);
    }

    public static int blendPixels(int n, int n2) {
        int n3 = GRHelper.getAlpha(n2);
        if (n3 == 0) {
            return n;
        }
        int n4 = GRHelper.getRed(n2);
        int n5 = GRHelper.getGreen(n2);
        int n6 = GRHelper.getBlue(n2);
        int n7 = GRHelper.getAlpha(n);
        if (n7 == 0) {
            return n2;
        }
        int n8 = GRHelper.getRed(n);
        int n9 = GRHelper.getGreen(n);
        int n10 = GRHelper.getBlue(n);
        double d = (double)n3 / 255.0;
        double d2 = (double)n7 / 255.0;
        double d3 = d + d2 * (1.0 - d);
        int n11 = (int)Math.round(((double)n4 * d + (double)n8 * d2 * (1.0 - d)) / d3);
        int n12 = (int)Math.round(((double)n5 * d + (double)n9 * d2 * (1.0 - d)) / d3);
        int n13 = (int)Math.round(((double)n6 * d + (double)n10 * d2 * (1.0 - d)) / d3);
        int n14 = (int)Math.round(d3 * 255.0);
        return GRHelper.RGB(n14, n11, n12, n13);
    }

    public static int mergePixels(int n, int n2) {
        int n3 = GRHelper.getAlpha(n);
        int n4 = GRHelper.getAlpha(n2);
        n = GRHelper.blendPixels(n, n2);
        return GRHelper.updateAlpha(Math.max(n3, n4), n);
    }

    public static Color calcContinuousColor(CGSPropPaletteContinuousB cGSPropPaletteContinuousB, double d, double d2, double d3) {
        Vector<CGSPropPaletteContinuousItemB> vector = cGSPropPaletteContinuousB.getPaletteContinuousItemBList();
        if (vector.size() == 0) {
            return Color.RED;
        }
        boolean bl = cGSPropPaletteContinuousB.getPercentDataMode();
        if (bl) {
            if (d3 <= d2) {
                return vector.elementAt(0).getColor();
            }
            d = (d - d2) * 100.0 / (d3 - d2);
        }
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i).getValue() > d)) continue;
            n = i;
            break;
        }
        if (n == 0) {
            return vector.elementAt(0).getColor();
        }
        if (n == -1) {
            return vector.elementAt(vector.size() - 1).getColor();
        }
        double d4 = (d - vector.elementAt(n - 1).getValue()) / (vector.elementAt(n).getValue() - vector.elementAt(n - 1).getValue());
        Color color = vector.elementAt(n - 1).getColor();
        int n2 = color.getAlpha();
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        Color color2 = vector.elementAt(n).getColor();
        int n6 = color2.getAlpha();
        int n7 = color2.getRed();
        int n8 = color2.getGreen();
        int n9 = color2.getBlue();
        int n10 = (int)((double)n2 * (1.0 - d4) + (double)n6 * d4 + 0.5);
        int n11 = (int)((double)n3 * (1.0 - d4) + (double)n7 * d4 + 0.5);
        int n12 = (int)((double)n4 * (1.0 - d4) + (double)n8 * d4 + 0.5);
        int n13 = (int)((double)n5 * (1.0 - d4) + (double)n9 * d4 + 0.5);
        return new Color(n11, n12, n13, n10);
    }

    public static int adjustIntensity(int n, double d) {
        int n2 = GRHelper.getRed(n);
        int n3 = GRHelper.getGreen(n);
        int n4 = GRHelper.getBlue(n);
        double d2 = d - 1.0;
        if (d2 > 0.0) {
            n2 += (int)((double)(255 - n2) * d2 + 0.5);
            n3 += (int)((double)(255 - n3) * d2 + 0.5);
            n4 += (int)((double)(255 - n4) * d2 + 0.5);
            return GRHelper.RGB(255, Math.min(n2, 255), Math.min(n3, 255), Math.min(n4, 255));
        }
        n2 += (int)((double)n2 * d2 + 0.5);
        n3 += (int)((double)n3 * d2 + 0.5);
        n4 += (int)((double)n4 * d2 + 0.5);
        return GRHelper.RGB(255, Math.max(n2, 0), Math.max(n3, 0), Math.max(n4, 0));
    }

    public static double cosValue(int n) {
        while (n < 0) {
            n += 360;
        }
        while (n >= 360) {
            n -= 360;
        }
        return s_cosTable[n];
    }

    public static double sinValue(int n) {
        while (n < 0) {
            n += 360;
        }
        while (n >= 360) {
            n -= 360;
        }
        return s_sinTable[n];
    }

    public static int GR_ROUND(double d) {
        return (int)(d + 0.5);
    }

    public static void initBufferedImage(BufferedImage bufferedImage, int n) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        int n2 = writableRaster.getWidth() * writableRaster.getHeight();
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
        }
    }

    public static boolean isEmptyBufferedImage(BufferedImage bufferedImage) {
        boolean bl = true;
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        int n = writableRaster.getWidth() * writableRaster.getHeight();
        for (int i = 0; i < n && bl; ++i) {
            if (GRHelper.getAlpha(nArray[i]) == 0) continue;
            bl = false;
        }
        return bl;
    }

    public static void copyBufferedImage(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        int[] nArray2 = ((DataBufferInt)writableRaster2.getDataBuffer()).getData();
        int n = writableRaster.getWidth() * writableRaster.getHeight();
        for (int i = 0; i < n; ++i) {
            nArray[i] = nArray2[i];
        }
    }

    public static void combineBufferedImage(BufferedImage bufferedImage, BufferedImage bufferedImage2, boolean bl) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        int[] nArray2 = ((DataBufferInt)writableRaster2.getDataBuffer()).getData();
        int n = writableRaster.getWidth();
        int n2 = writableRaster2.getHeight();
        CMHelper.CGS_ASSERT(n == writableRaster2.getWidth() && n2 == writableRaster2.getHeight(), "Images must be the same size.");
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = nArray[i * n + j];
                int n4 = nArray2[i * n + j];
                int n5 = 0;
                n5 = bl ? GRHelper.blendPixels(n3, n4) : GRHelper.mergePixels(n3, n4);
                nArray[i * n + j] = n5;
            }
        }
    }

    public static void pasteBufferedImage(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        int[] nArray2 = ((DataBufferInt)writableRaster2.getDataBuffer()).getData();
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = bufferedImage2.getWidth();
        int n6 = bufferedImage2.getHeight();
        int n7 = n + n5 >= n3 ? n3 - n : n5;
        int n8 = n2 + n6 >= n4 ? n4 - n2 : n6;
        for (int i = 0; i < n8; ++i) {
            if (n2 + i < 0) continue;
            for (int j = 0; j < n7; ++j) {
                if (n + j < 0) continue;
                int n9 = (n2 + i) * n3 + (n + j);
                int n10 = nArray[n9];
                int n11 = nArray2[i * n5 + j];
                nArray[n9] = GRHelper.blendPixels(n10, n11);
            }
        }
    }

    public static BufferedImage rotateBufferedImage90(BufferedImage bufferedImage, boolean bl) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        GRBufferedImage gRBufferedImage = new GRBufferedImage(n2, n);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = nArray[i * n + j];
                int n4 = bl ? n2 - i - 1 : i;
                int n5 = bl ? j : n - j - 1;
                gRBufferedImage.setRGB(n4, n5, n3);
            }
        }
        return gRBufferedImage.getImage();
    }

    public static void flipBufferedImage(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        for (int i = 0; i < n2 / 2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = nArray[i * n + j];
                nArray[i * n + j] = nArray[(n2 - 1 - i) * n + j];
                nArray[(n2 - 1 - i) * n + j] = n3;
            }
        }
    }

    public static void mirrorBufferedImage(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n / 2; ++j) {
                int n3 = nArray[i * n + j];
                nArray[i * n + j] = nArray[i * n + n - 1 - j];
                nArray[i * n + n - 1 - j] = n3;
            }
        }
    }

    public static void blurBufferedImage(BufferedImage bufferedImage, int n) {
        int n2;
        int n3;
        if (n == 0) {
            return;
        }
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n4, n5, 2);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int[] nArray2 = ((DataBufferInt)writableRaster2.getDataBuffer()).getData();
        int n6 = n;
        int n7 = (n * 2 + 1) * (n * 2 + 1);
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                for (int i = -n6; i <= n6; ++i) {
                    int n12 = n3 + i;
                    if (n12 < 0 || n12 >= n5) continue;
                    for (int j = -n6; j <= n6; ++j) {
                        int n13 = n2 + j;
                        if (n13 < 0 || n13 >= n4) continue;
                        int n14 = nArray[n12 * n4 + n13];
                        n8 += GRHelper.getRed(n14);
                        n9 += GRHelper.getGreen(n14);
                        n10 += GRHelper.getBlue(n14);
                        n11 += GRHelper.getAlpha(n14);
                    }
                }
                nArray2[n3 * n4 + n2] = GRHelper.RGB(n11 /= n7, n8 /= n7, n9 /= n7, n10 /= n7);
            }
        }
        n3 = n4 * n5;
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = nArray2[n2];
        }
    }

    public static String getDisplayableFontName(CGSPropFont cGSPropFont, String string) {
        String string2 = cGSPropFont.getFaceName();
        int n = 0;
        int n2 = GRHelper.GR_ROUND(cGSPropFont.getSize() * 96.0 / 72.0);
        Font font = new Font(string2, n, n2);
        boolean bl = true;
        if (string != null) {
            int n3 = string.length();
            int n4 = GRHelper.getFontDisplayCount(font, string);
            if (n4 != n3) {
                bl = false;
                for (int i = 0; i < cGSPropFont.getAlternateFaceNameCount(); ++i) {
                    font = new Font(cGSPropFont.getAlternateFaceName(i), n, n2);
                    int n5 = GRHelper.getFontDisplayCount(font, string);
                    if (n5 <= n4) continue;
                    string2 = cGSPropFont.getAlternateFaceName(i);
                    n4 = n5;
                    if (n4 == n3) break;
                }
            }
        }
        if (!bl) {
            CGSLogging.logInfo("Font " + cGSPropFont.getFaceName() + " can't be used for " + string + ", selecting font " + string2);
        }
        return string2;
    }

    private static int getFontDisplayCount(Font font, String string) {
        int n = 0;
        int n2 = string.length();
        String string2 = font.getName();
        if (!s_fontNames.contains(string2)) {
            CGSLogging.logInfo("Font " + string2 + " not found.");
        }
        for (int i = 0; i < n2; ++i) {
            if (!font.canDisplay(string.charAt(i))) continue;
            ++n;
        }
        return n;
    }

    public static Font getFont(CGSPropFont cGSPropFont, String string) {
        int n = 0;
        switch (cGSPropFont.getStyle()) {
            case eStyleBold: {
                n = 1;
                break;
            }
            case eStyleItalic: {
                n = 2;
                break;
            }
            case eStyleBoldItalic: {
                n = 3;
                break;
            }
        }
        String string2 = GRHelper.getDisplayableFontName(cGSPropFont, string);
        return new Font(string2, n, GRHelper.GR_ROUND(cGSPropFont.getSize() * 96.0 / 72.0));
    }

    public static void setJavaFontNames() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        CGSLogging.logInfo("  List of supported Java Fonts");
        for (Font font : fontArray) {
            String string = font.getName();
            CGSLogging.logInfo(string);
            s_fontNames.add(string);
        }
        CGSLogging.logInfo("  End of List of supported Java Fonts");
    }

    static {
        for (int i = 0; i < 360; ++i) {
            GRHelper.s_cosTable[i] = Math.cos((double)i / 57.29577951308232);
            GRHelper.s_sinTable[i] = Math.sin((double)i / 57.29577951308232);
        }
    }
}

