/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Graphics;

import com.ibm.cgsBus.DrawContext.DCDrawContextOVRef;
import com.ibm.cgsBus.FrameWork.CGSDetectArea;
import com.ibm.cgsBus.FrameWork.CGSDetectAreaExtents;
import com.ibm.cgsBus.FrameWork.CGSWidget;
import com.ibm.cgsBus.FrameWork.CGSWidgetRef;
import com.ibm.cgsBus.Graphics.GRContainer;
import com.ibm.cgsBus.Graphics.GRDevice;
import com.ibm.cgsBus.Graphics.GRDeviceVector;
import com.ibm.cgsBus.Graphics.GRHelper;
import com.ibm.cgsBus.Graphics.GRLegendItemIcon;
import com.ibm.cgsBus.Graphics.GRText;
import com.ibm.cgsBus.Properties.CGSPropChart;
import com.ibm.cgsBus.Properties.CGSPropConstrainedPositionB;
import com.ibm.cgsBus.Properties.CGSPropContainer;
import com.ibm.cgsBus.Properties.CGSPropFont;
import com.ibm.cgsBus.Properties.CGSPropLegend;
import com.ibm.cgsBus.Properties.CGSPropLegendBase;
import com.ibm.cgsBus.Properties.CGSPropLegendItem;
import com.ibm.cgsBus.Properties.CGSPropTitle;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeFillEffect;
import com.ibm.cgsBus.Types.CGSTypeSize;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class GRLegend {
    private static final int TITLE = 0;
    private static final int SEPARATOR = 1;
    private static final int COLOR_BY_VALUE = 2;
    private static final int SIMPLE = 3;
    private static final int SUBTITLE = 4;
    private static final int NO_SUBTYPE = 10;
    private static final int CHART = 11;
    private static final int CONDITIONAL = 13;
    private static final int WATERLINE = 14;
    private static final int REGRESSION_LINE = 15;
    private static final int MARKER = 16;
    private static final int FILL_RECTANGLE = 17;
    private static final int SHAPE = 18;
    private static final int ICON_LEFT_GAP = 1;
    private static final int ICON_SIZE = 15;
    private static final int ICON_RIGHT_GAP = 3;
    private static final int SEPARATOR_SIZE = 10;
    private static final double MIN_FONT_SIZE = 6.0;
    private static final double MAX_PERCENT_SIZE = 0.4;
    private CGSWidgetRef m_parent = null;
    private CGSPropLegend m_propLegend = null;
    private DCDrawContextOVRef m_pDrawContext = null;
    private double m_parentWidth = 0.0;
    private double m_parentHeight = 0.0;
    private Vector<LegendItem> m_items = new Vector();
    private boolean m_doLayout = true;
    private boolean m_isVertical = false;
    private double m_calcWidth = 0.0;
    private double m_calcHeight = 0.0;
    private CGSTypeSize m_legendSize = new CGSTypeSize();
    private double m_internalWidth = 0.0;
    private double m_internalItemWidth = 0.0;
    private boolean m_allItemsShown = true;
    private double m_truncatorHeight = 0.0;
    private double m_autoScale = 1.0;
    private int m_iconSize = 15;
    private boolean m_mirrorLegend = false;
    private Vector<CGSDetectArea> m_pDetAreas = new Vector();
    private Vector<CGSDetectAreaExtents> m_pDetAreasExtents = new Vector();

    public GRLegend(CGSWidgetRef cGSWidgetRef, CGSPropLegend cGSPropLegend, DCDrawContextOVRef dCDrawContextOVRef) {
        this.m_parent = cGSWidgetRef;
        this.m_propLegend = cGSPropLegend;
        this.m_pDrawContext = dCDrawContextOVRef;
        this.m_mirrorLegend = cGSWidgetRef.getCanvas().isChartMirroringEnabled();
    }

    public void setParentSize(double d, double d2) {
        this.m_parentWidth = d;
        this.m_parentHeight = d2;
    }

    public void setTitle(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return;
        }
        LegendItem legendItem = new LegendItem();
        legendItem.type = 0;
        legendItem.text = string;
        if (this.m_items.size() != 0 && this.m_items.elementAt((int)0).type == 0) {
            this.m_items.removeElementAt(0);
        }
        legendItem.genDetArea = bl;
        this.m_items.insertElementAt(legendItem, 0);
    }

    public void addSubtitleItem(String string) {
        LegendItem legendItem = new LegendItem();
        legendItem.type = 4;
        legendItem.text = string == null ? "" : string;
        this.m_items.addElement(legendItem);
    }

    public void addChartItem(String string, GRLegendItemIcon gRLegendItemIcon) {
        this.addChartItem(string, gRLegendItemIcon, -1, false);
    }

    public void addChartItem(String string, GRLegendItemIcon gRLegendItemIcon, int n, boolean bl) {
        this.addChartItem(string, CGSWidget.DataType.eSeries, gRLegendItemIcon, n, bl, 0);
    }

    public void addChartItem(String string, CGSWidget.DataType dataType, GRLegendItemIcon gRLegendItemIcon, int n, boolean bl, int n2) {
        this.addSimpleItem(11, dataType, string, gRLegendItemIcon, n, bl, n2);
    }

    public void addConditionalItem(String string, GRLegendItemIcon gRLegendItemIcon) {
        this.addSimpleItem(13, string, gRLegendItemIcon);
    }

    public void addShapeItem(String string, GRLegendItemIcon gRLegendItemIcon) {
        this.addSimpleItem(18, string, gRLegendItemIcon);
    }

    public void addShapeItem(String string, GRLegendItemIcon gRLegendItemIcon, int n, boolean bl) {
        this.addSimpleItem(18, CGSWidget.DataType.eCategory, string, gRLegendItemIcon, n, bl, 0);
    }

    public void addWaterlineItem(String string, GRLegendItemIcon gRLegendItemIcon) {
        this.addSimpleItem(14, string, gRLegendItemIcon);
    }

    public void addRegressionLineItem(String string, GRLegendItemIcon gRLegendItemIcon) {
        this.addSimpleItem(15, string, gRLegendItemIcon);
    }

    public void addMarkerItem(String string, GRLegendItemIcon gRLegendItemIcon) {
        this.addSimpleItem(16, string, gRLegendItemIcon);
    }

    public void addFillRectangleItem(String string, GRLegendItemIcon gRLegendItemIcon) {
        this.addSimpleItem(17, string, gRLegendItemIcon);
    }

    private void addSimpleItem(int n, String string, GRLegendItemIcon gRLegendItemIcon) {
        this.addSimpleItem(n, CGSWidget.DataType.eSeries, string, gRLegendItemIcon, -1, false, 0);
    }

    private void addSimpleItem(int n, CGSWidget.DataType dataType, String string, GRLegendItemIcon gRLegendItemIcon, int n2, boolean bl, int n3) {
        LegendItem legendItem = new LegendItem();
        legendItem.type = 3;
        legendItem.subtype = n;
        legendItem.datatype = dataType;
        legendItem.text = string == null ? "" : string;
        legendItem.icon = gRLegendItemIcon != null ? new GRLegendItemIcon(gRLegendItemIcon) : null;
        legendItem.genDetArea = bl;
        legendItem.row = n2;
        legendItem.axisIndex = n3;
        this.m_items.addElement(legendItem);
    }

    public void addContinuousPaletteItem(String string, Color[] colorArray, String[] stringArray, Color color, CGSPropChart.MaterialEffect materialEffect) {
        this.addContinuousPaletteItem(string, colorArray, stringArray, color, 0, materialEffect);
    }

    public void addContinuousPaletteItem(String string, Color[] colorArray, String[] stringArray, Color color, int n, CGSPropChart.MaterialEffect materialEffect) {
        this.addSubtitleItem(string);
        for (int i = 0; i < colorArray.length; ++i) {
            GRLegendItemIcon gRLegendItemIcon = new GRLegendItemIcon();
            gRLegendItemIcon.dataPointShapeB = CGSEnums.MarkerShapeB.eMarkerSquareB;
            CGSTypeFillEffect cGSTypeFillEffect = new CGSTypeFillEffect();
            cGSTypeFillEffect.setSolidColor(colorArray[i]);
            gRLegendItemIcon.dataPointShapeFill = cGSTypeFillEffect;
            gRLegendItemIcon.dataPointShapeOutlineColor = color;
            if (materialEffect != null) {
                gRLegendItemIcon.materialEffect = materialEffect;
            }
            this.addChartItem(stringArray[i], gRLegendItemIcon);
        }
        LegendItem legendItem = new LegendItem();
        legendItem = new LegendItem();
        legendItem.type = 2;
        legendItem.text = string == null ? "" : string;
        legendItem.colors = colorArray;
        legendItem.values = stringArray;
        legendItem.axisIndex = n;
        this.m_items.addElement(legendItem);
    }

    public CGSTypeSize getLegendSize() {
        this.layoutLegend();
        this.m_legendSize.m_width = GRHelper.GR_ROUND(this.m_calcWidth);
        this.m_legendSize.m_height = GRHelper.GR_ROUND(this.m_calcHeight);
        return this.m_legendSize;
    }

    private void layoutLegendItems() {
        boolean bl = !this.m_propLegend.getAllowTruncation();
        int n = this.m_propLegend.getMaxCharacters();
        String string = this.m_propLegend.getTruncationText();
        CGSPropFont cGSPropFont = new CGSPropFont();
        cGSPropFont.copyAttributes(this.m_propLegend.getProp(CGSEnums.PropType.ePropTitle).getProp(CGSEnums.PropType.ePropFont));
        CGSPropFont cGSPropFont2 = new CGSPropFont();
        cGSPropFont2.copyAttributes(this.m_propLegend.getProp(CGSEnums.PropType.ePropLegendItem).getProp(CGSEnums.PropType.ePropFont));
        cGSPropFont.setSize(cGSPropFont.getSize() * this.m_autoScale);
        cGSPropFont2.setSize(cGSPropFont2.getSize() * this.m_autoScale);
        this.m_iconSize = 15;
        GRText gRText = new GRText("X", cGSPropFont2);
        int n2 = gRText.getHeight();
        if (n2 < this.m_iconSize) {
            this.m_iconSize = n2;
        }
        for (int i = 0; i < this.m_items.size(); ++i) {
            LegendItem legendItem = this.m_items.elementAt(i);
            switch (legendItem.type) {
                case 0: {
                    Object object = (CGSPropTitle)this.m_propLegend.getProp(CGSEnums.PropType.ePropTitle);
                    String string2 = legendItem.text;
                    if (bl && string2.length() > n) {
                        string2 = string2.substring(0, n) + string;
                    }
                    legendItem.pText = new GRText(string2, cGSPropFont);
                    legendItem.width = legendItem.pText.getWidth();
                    legendItem.height = legendItem.pText.getHeight();
                    legendItem.truncWidth = legendItem.width;
                    legendItem.show = ((CGSPropTitle)object).getVisible();
                    break;
                }
                case 3: 
                case 4: {
                    Object object = legendItem.text;
                    if (bl && ((String)object).length() > n) {
                        object = ((String)object).substring(0, n) + string;
                    }
                    legendItem.pText = new GRText((String)object, cGSPropFont2);
                    legendItem.width = legendItem.pText.getWidth();
                    legendItem.height = legendItem.pText.getHeight();
                    legendItem.width += this.m_iconSize + 1 + 3;
                    if (legendItem.height < this.m_iconSize + 2) {
                        legendItem.height = this.m_iconSize + 2;
                    }
                    legendItem.truncWidth = legendItem.width;
                    legendItem.show = true;
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    legendItem.height = 10;
                    legendItem.show = true;
                    break;
                }
            }
            if (legendItem.pText == null) continue;
            legendItem.pText.setTextDirection(this.m_parent.getCanvas().getTextDirection());
        }
    }

    private void layoutLegend() {
        double d;
        double d2;
        if (!this.m_doLayout) {
            return;
        }
        this.m_calcWidth = 0.0;
        this.m_calcHeight = 0.0;
        this.m_doLayout = false;
        if (!this.m_propLegend.getVisible() || this.m_items.size() == 0) {
            return;
        }
        this.organizeItems();
        double d3 = 0.0;
        double d4 = 0.0;
        CGSPropContainer cGSPropContainer = (CGSPropContainer)this.m_propLegend.getProp(CGSEnums.PropType.ePropContainer);
        if (cGSPropContainer.getShowShadow()) {
            d2 = cGSPropContainer.getShadowSize();
            if (d2 > (d = 0.05 * Math.min(this.m_parentWidth, this.m_parentHeight))) {
                cGSPropContainer.setShadowSize(d);
            }
            d3 += cGSPropContainer.getShadowSize();
            d4 += cGSPropContainer.getShadowSize();
        }
        if (cGSPropContainer.getShowOutline()) {
            double d5;
            double d6;
            d2 = cGSPropContainer.getOutlineThickness();
            if (d2 > (d = 0.05 * Math.min(this.m_parentWidth, this.m_parentHeight))) {
                cGSPropContainer.setOutlineThickness(d);
            }
            d3 += 2.0 * cGSPropContainer.getOutlineThickness();
            d4 += 2.0 * cGSPropContainer.getOutlineThickness();
            double d7 = cGSPropContainer.getCornerRadius();
            if (d7 > (d6 = 0.1 * Math.min(this.m_parentWidth, this.m_parentHeight))) {
                cGSPropContainer.setCornerRadius(d6);
            }
            if ((d5 = d7 - d2 / 2.0) > 0.0) {
                d3 += d5 * 2.0;
            }
        }
        switch (this.m_propLegend.getPositionB()) {
            case eTopB: 
            case eBottomB: {
                this.m_isVertical = false;
                break;
            }
            default: {
                this.m_isVertical = true;
            }
        }
        this.m_autoScale = 1.0;
        this.layoutLegendItems();
        CGSPropLegendItem cGSPropLegendItem = (CGSPropLegendItem)this.m_propLegend.getProp(CGSEnums.PropType.ePropLegendItem);
        CGSPropFont cGSPropFont = (CGSPropFont)cGSPropLegendItem.getProp(CGSEnums.PropType.ePropFont);
        CGSPropFont cGSPropFont2 = new CGSPropFont();
        cGSPropFont2.copyAttributes(cGSPropFont);
        cGSPropFont2.setHorAlignment(CGSPropFont.HorAlign.eHorAlignCenter);
        String string = this.m_propLegend.getTruncationText();
        GRText gRText = new GRText("...", cGSPropFont2);
        double d8 = (double)gRText.getHeight() / 2.0;
        double d9 = gRText.getHeight();
        double d10 = gRText.getWidth();
        double d11 = 0.0;
        this.m_internalItemWidth = 0.0;
        this.m_internalWidth = 0.0;
        if (this.m_isVertical) {
            LegendItem legendItem;
            int n;
            double d12 = this.m_propLegend.getWidth();
            CGSPropConstrainedPositionB cGSPropConstrainedPositionB = (CGSPropConstrainedPositionB)this.m_propLegend.getProp(CGSEnums.PropType.ePropConstrainedPositionB);
            CGSPropConstrainedPositionB.VerticalPosition verticalPosition = cGSPropConstrainedPositionB.getVerticalPosition();
            if (this.m_propLegend.getPositionB() == CGSPropLegendBase.LegendPositionB.eContrainedPositionB && (verticalPosition == CGSPropConstrainedPositionB.VerticalPosition.eVerticalBottom || verticalPosition == CGSPropConstrainedPositionB.VerticalPosition.eVerticalTop)) {
                d12 = this.m_parentWidth - (double)cGSPropConstrainedPositionB.getHorizontalOffset();
            } else if (d12 == 0.0 || d12 > 0.4 * this.m_parentWidth) {
                d12 = 0.4 * this.m_parentWidth;
            } else if (d12 < d3 + (double)this.m_iconSize + 1.0 + 1.0) {
                d12 = d3 + (double)this.m_iconSize + 1.0 + 1.0;
            }
            double d13 = this.m_propLegend.getHeight();
            if (d13 == 0.0 || d13 > this.m_parentHeight) {
                d13 = this.m_parentHeight;
            } else if (d13 < d4) {
                d13 = d4;
            }
            if (cGSPropLegendItem.getFontAutoSizing()) {
                double d14;
                double d15 = 0.0;
                double d16 = 0.0;
                for (int i = 0; i < this.m_items.size(); ++i) {
                    LegendItem legendItem2 = this.m_items.elementAt(i);
                    d15 += (double)legendItem2.height;
                    if (!((double)legendItem2.width > d16)) continue;
                    d16 = legendItem2.width;
                }
                double d17 = d13 / d15;
                double d18 = (d12 - (double)this.m_iconSize - 1.0 - 1.0) / d16;
                double d19 = Math.min(d18, d17) * 0.9;
                CGSPropTitle cGSPropTitle = (CGSPropTitle)this.m_propLegend.getProp(CGSEnums.PropType.ePropTitle);
                CGSPropFont cGSPropFont3 = (CGSPropFont)cGSPropTitle.getProp(CGSEnums.PropType.ePropFont);
                CGSPropFont cGSPropFont4 = (CGSPropFont)this.m_propLegend.getProp(CGSEnums.PropType.ePropLegendItem).getProp(CGSEnums.PropType.ePropFont);
                double d20 = d14 = cGSPropTitle.getVisible() ? Math.min(cGSPropFont3.getSize(), cGSPropFont4.getSize()) : cGSPropFont4.getSize();
                if (d14 * d19 < 6.0) {
                    d19 = 6.0 / d14;
                }
                if (d19 < 1.0) {
                    this.m_autoScale = d19;
                    this.layoutLegendItems();
                }
            }
            for (n = 0; n < this.m_items.size(); ++n) {
                legendItem = this.m_items.elementAt(n);
                if (!this.m_allItemsShown) {
                    legendItem.show = false;
                }
                if (!legendItem.show) continue;
                if (d11 + (double)legendItem.height + d4 > d13) {
                    this.m_allItemsShown = false;
                    legendItem.show = false;
                    if (d11 + d8 + d4 <= d13) {
                        this.m_truncatorHeight = Math.min(d9, d13 - d11 - d4);
                        d11 += this.m_truncatorHeight;
                        if (!(d10 > this.m_internalItemWidth)) continue;
                        this.m_internalItemWidth = d10;
                        continue;
                    }
                    if (!(d8 + d4 <= d13)) continue;
                    --n;
                    while (n >= 0 && d11 + d8 + d4 > d13) {
                        legendItem = this.m_items.elementAt(n);
                        legendItem.show = false;
                        d11 -= (double)legendItem.height;
                        --n;
                    }
                    this.m_truncatorHeight = Math.min(d9, d13 - d11 - d4);
                    d11 += this.m_truncatorHeight;
                    if (!(d10 > this.m_internalItemWidth)) continue;
                    this.m_internalItemWidth = d10;
                    continue;
                }
                d11 += (double)legendItem.height;
                if (!((double)legendItem.width > this.m_internalItemWidth)) continue;
                this.m_internalItemWidth = legendItem.width;
            }
            if (this.m_internalItemWidth + d3 > d12) {
                this.m_internalItemWidth = d12 - d3;
                for (n = 0; n < this.m_items.size(); ++n) {
                    legendItem = this.m_items.elementAt(n);
                    if (!legendItem.show || !((double)legendItem.truncWidth > this.m_internalItemWidth)) continue;
                    int n2 = legendItem.truncWidth = GRHelper.GR_ROUND(this.m_internalItemWidth);
                    if (legendItem.type == 3) {
                        n2 -= this.m_iconSize + 1 + 3;
                    }
                    legendItem.pText.resetSinglelineLabel(legendItem.text, n2, string);
                }
            }
            this.m_internalWidth = this.m_internalItemWidth;
            if (this.m_propLegend.getWidth() != 0 && this.m_internalWidth + d3 < d12) {
                this.m_internalItemWidth = this.m_internalWidth = d12 - d3;
            }
            if (this.m_propLegend.getHeight() != 0) {
                d11 = d13 - d4;
            }
        } else {
            double d21 = this.m_propLegend.getWidth();
            if (d21 == 0.0 || d21 > this.m_parentWidth) {
                d21 = this.m_parentWidth;
            } else if (d21 < d3 + (double)(3 * (this.m_iconSize + 1 + 3))) {
                d21 = d3 + (double)(3 * (this.m_iconSize + 1 + 3));
            }
            double d22 = this.m_propLegend.getHeight();
            if (d22 == 0.0 || d22 > 0.4 * this.m_parentHeight) {
                d22 = 0.4 * this.m_parentHeight;
            } else if (d22 < d4) {
                d22 = d4;
            }
            int n = 0;
            block13: for (int i = 0; i < this.m_items.size(); ++i) {
                LegendItem legendItem = this.m_items.elementAt(i);
                if (!legendItem.show) continue;
                switch (legendItem.type) {
                    case 0: {
                        this.m_internalWidth = legendItem.width;
                        continue block13;
                    }
                    case 3: 
                    case 4: {
                        if ((double)legendItem.width > this.m_internalItemWidth) {
                            this.m_internalItemWidth = legendItem.width;
                        }
                        ++n;
                        continue block13;
                    }
                    case 2: {
                        this.m_allItemsShown = false;
                        legendItem.show = false;
                        continue block13;
                    }
                    case 1: {
                        legendItem.show = false;
                        continue block13;
                    }
                }
            }
            double d23 = (d21 - d3) / (double)Math.min(3, Math.max(n, 1));
            int n3 = 0;
            if (this.m_internalItemWidth < d23) {
                n3 = (int)((d21 - d3) / this.m_internalItemWidth);
                if (n3 > n) {
                    n3 = n;
                }
                if (this.m_internalWidth < (double)n3 * this.m_internalItemWidth) {
                    this.m_internalWidth = (double)n3 * this.m_internalItemWidth;
                } else {
                    if (this.m_internalWidth > d21 - d3) {
                        this.m_internalWidth = d21 - d3;
                    }
                    this.m_internalItemWidth = this.m_internalWidth / (double)n3;
                }
            } else {
                this.m_internalItemWidth = d23;
                this.m_internalWidth = d21 - d3;
                n3 = 3;
            }
            n = 0;
            block14: for (int i = 0; i < this.m_items.size(); ++i) {
                int n4;
                LegendItem legendItem = this.m_items.elementAt(i);
                if (!this.m_allItemsShown) {
                    legendItem.show = false;
                }
                if (!legendItem.show) continue;
                legendItem.truncWidth = n4 = legendItem.type == 0 ? GRHelper.GR_ROUND(this.m_internalWidth) : GRHelper.GR_ROUND(this.m_internalItemWidth);
                if (legendItem.type == 3) {
                    n4 -= this.m_iconSize + 1 + 3;
                }
                legendItem.pText.resetSinglelineLabel(legendItem.text, n4, string);
                if (legendItem.type == 0 || n % n3 == 0) {
                    if (d11 + (double)legendItem.height > d22 - d4) {
                        legendItem.show = false;
                        this.m_allItemsShown = false;
                        if (d11 + d8 + d4 <= d22) {
                            this.m_truncatorHeight = Math.min(d9, d22 - d11 - d4);
                            d11 += this.m_truncatorHeight;
                            continue;
                        }
                        if (!(d8 + d4 <= d22)) continue;
                        --i;
                        while (i >= 0) {
                            legendItem = this.m_items.elementAt(i);
                            legendItem.show = false;
                            if (legendItem.type != 0) {
                                --n;
                            }
                            if (legendItem.type == 0 || n % n3 == 0) {
                                if ((d11 -= (double)legendItem.height) + d8 + d4 <= d22) {
                                    this.m_truncatorHeight = Math.min(d9, d22 - d11 - d4);
                                    d11 += this.m_truncatorHeight;
                                    continue block14;
                                }
                            } else if (legendItem.type != 0 && n % n3 == n3 - 1 && d11 - (double)legendItem.height + d8 + d4 <= d22) {
                                this.m_truncatorHeight = Math.max((double)legendItem.height, d8);
                                continue block14;
                            }
                            --i;
                        }
                        continue;
                    }
                    d11 += (double)legendItem.height;
                    if (legendItem.type == 0) continue;
                    ++n;
                    continue;
                }
                ++n;
            }
            if (this.m_propLegend.getWidth() != 0 && this.m_internalWidth + d3 < d21) {
                this.m_internalWidth = d21 - d3;
                this.m_internalItemWidth = this.m_internalWidth / (double)n3;
            }
            if (this.m_propLegend.getHeight() != 0) {
                d11 = d22 - d4;
            }
        }
        this.m_calcWidth = this.m_internalWidth + d3;
        this.m_calcHeight = d11 + d4;
    }

    private void organizeItems() {
        Collections.sort(this.m_items);
        this.addSeparatorsToItems();
    }

    private void addSeparatorsToItems() {
        Vector<LegendItem> vector = new Vector<LegendItem>(this.m_items);
        this.m_items.clear();
        int n = 0;
        int n2 = 10;
        int n3 = 1;
        for (int i = 0; i < vector.size(); ++i) {
            LegendItem legendItem = vector.elementAt(i);
            if (legendItem.type == 4) {
                this.addSeparatorToItems();
                this.m_items.add(legendItem);
            } else if (legendItem.type == 3 && n3 == 3 && legendItem.subtype != n2) {
                this.addSeparatorToItems();
                this.m_items.add(legendItem);
            } else if (legendItem.type == 3 && n3 == 3 && legendItem.axisIndex != n) {
                this.addSeparatorToItems();
                this.m_items.add(legendItem);
            } else if (legendItem.type == 3 && n3 == 2) {
                this.addSeparatorToItems();
                this.m_items.add(legendItem);
            } else {
                this.m_items.add(legendItem);
            }
            n = legendItem.axisIndex;
            n2 = legendItem.subtype;
            n3 = legendItem.type;
        }
    }

    private void addSeparatorToItems() {
        if (this.m_items.size() == 0) {
            return;
        }
        LegendItem legendItem = this.m_items.lastElement();
        if (legendItem.type != 1) {
            LegendItem legendItem2 = new LegendItem();
            legendItem2.type = 1;
            this.m_items.add(legendItem2);
        }
    }

    public void appendShowValue(String string, String string2, String string3) {
        for (int i = 0; i < this.m_items.size(); ++i) {
            LegendItem legendItem = this.m_items.elementAt(i);
            if (legendItem.type != 3 || string == null || legendItem.text.compareTo(string) != 0) continue;
            legendItem.text = legendItem.text + string3 + " " + string2;
            return;
        }
    }

    public void draw(GRDevice gRDevice, double d, double d2) {
        double d3;
        double d4;
        double d5;
        this.layoutLegend();
        if (this.m_calcWidth == 0.0 || this.m_calcHeight == 0.0) {
            return;
        }
        this.m_pDetAreas.clear();
        this.m_pDetAreasExtents.clear();
        CGSPropLegendItem cGSPropLegendItem = (CGSPropLegendItem)this.m_propLegend.getProp(CGSEnums.PropType.ePropLegendItem);
        CGSPropFont cGSPropFont = (CGSPropFont)cGSPropLegendItem.getProp(CGSEnums.PropType.ePropFont);
        CGSPropFont cGSPropFont2 = new CGSPropFont();
        cGSPropFont2.copyAttributes(cGSPropFont);
        cGSPropFont2.setHorAlignment(CGSPropFont.HorAlign.eHorAlignCenter);
        GRText gRText = new GRText("...", cGSPropFont2);
        double d6 = gRText.getHeight();
        CGSPropContainer cGSPropContainer = (CGSPropContainer)this.m_propLegend.getProp(CGSEnums.PropType.ePropContainer);
        double d7 = d;
        double d8 = d2;
        double d9 = d7 + gRDevice.fromPixels(this.m_calcWidth);
        double d10 = d8 - gRDevice.fromPixels(this.m_calcHeight);
        GRContainer gRContainer = new GRContainer(cGSPropContainer);
        gRContainer.draw(gRDevice, d7, d8, d9, d10, this.m_mirrorLegend);
        double d11 = d7;
        double d12 = d8;
        double d13 = d9;
        if (this.m_mirrorLegend && cGSPropContainer.getShowShadow()) {
            d5 = gRDevice.fromPixels(cGSPropContainer.getShadowSize());
            d11 += d5;
        }
        if (cGSPropContainer.getShowOutline()) {
            d5 = gRDevice.fromPixels(cGSPropContainer.getOutlineThickness());
            d4 = gRDevice.fromPixels(cGSPropContainer.getCornerRadius());
            d3 = d4 - d5 / 2.0;
            if (d3 > 0.0) {
                d11 += d3;
                d13 -= d3;
            }
            d11 += d5;
            d12 -= d5;
            d13 -= d5;
            if (gRDevice.isSVG()) {
                this.m_parent.addSVGOutline(GRHelper.GR_ROUND(d11) + this.m_parent.getLocation().m_left, GRHelper.GR_ROUND((double)gRDevice.m_height - d12), GRHelper.GR_ROUND(this.m_calcWidth), GRHelper.GR_ROUND(this.m_calcHeight), d5, d3);
            }
        }
        if (this.m_isVertical) {
            for (int i = 0; i < this.m_items.size(); ++i) {
                LegendItem legendItem = this.m_items.elementAt(i);
                if (!legendItem.show) continue;
                if (legendItem.pText != null) {
                    int n;
                    int n2;
                    d5 = d11;
                    d3 = this.m_internalItemWidth;
                    CGSEnums.DetArea detArea = CGSEnums.DetArea.eDetLegendLabel;
                    CGSWidget.DataType dataType = legendItem.datatype;
                    switch (legendItem.type) {
                        case 0: {
                            d3 = this.m_internalWidth;
                            detArea = CGSEnums.DetArea.eDetLegendTitle;
                            dataType = CGSWidget.DataType.eIgnore;
                            break;
                        }
                        case 3: 
                        case 4: {
                            if (legendItem.icon != null) {
                                n2 = (int)gRDevice.fromPixels((legendItem.height - this.m_iconSize) / 2);
                                n = this.m_mirrorLegend ? GRHelper.GR_ROUND(d5 + gRDevice.fromPixels(d3 - 1.0 - (double)this.m_iconSize)) : GRHelper.GR_ROUND(d5 + gRDevice.fromPixels(1.0));
                                int n3 = GRHelper.GR_ROUND((double)gRDevice.m_height - d12 + (double)n2);
                                this.addIconToLegend(gRDevice, legendItem, n, n3);
                            }
                            d5 += this.m_mirrorLegend ? 0.0 : gRDevice.fromPixels(this.m_iconSize + 1 + 3);
                            d3 -= (double)(this.m_iconSize + 1 + 3);
                            if (legendItem.subtype != 18) break;
                            dataType = CGSWidget.DataType.eCategory;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    if (d3 > 0.0) {
                        if (gRDevice.isSVG()) {
                            n2 = GRHelper.GR_ROUND(d5) + this.m_parent.getLocation().m_left;
                            if ((legendItem.type == 0 || legendItem.type == 4) && legendItem.pText.getFont().getHorAlignment() == CGSPropFont.HorAlign.eHorAlignCenter) {
                                n2 = (int)((double)n2 + (this.m_internalWidth - (double)legendItem.width) / 2.0);
                            }
                            this.m_parent.addSVGLabel(legendItem.text, n2, GRHelper.GR_ROUND((double)gRDevice.m_height - d12), legendItem.pText, false);
                        } else if (gRDevice.isRaster()) {
                            BufferedImage bufferedImage = legendItem.pText.getTextImage(GRHelper.GR_ROUND(d3));
                            gRDevice.pasteImage(bufferedImage, GRHelper.GR_ROUND(d5), GRHelper.GR_ROUND((double)gRDevice.m_height - d12));
                        } else {
                            byte[] byArray = legendItem.pText.getTextVectorBlob(GRHelper.GR_ROUND(d3));
                            ((GRDeviceVector)gRDevice).pasteVectorBlob(byArray, d5, (double)gRDevice.m_height - d12);
                        }
                        if (legendItem.genDetArea) {
                            Point[] pointArray = new Point[]{new Point((int)d5, (int)((double)gRDevice.m_height - d12)), new Point((int)(d5 + d3), (int)((double)gRDevice.m_height - d12)), new Point((int)(d5 + d3), (int)((double)gRDevice.m_height - d12 + gRDevice.fromPixels(legendItem.height))), new Point((int)d5, (int)((double)gRDevice.m_height - d12 + gRDevice.fromPixels(legendItem.height)))};
                            n = this.m_parent.getWidgetIndex();
                            CGSDetectArea cGSDetectArea = new CGSDetectArea(detArea, dataType, i, pointArray, legendItem.row, -1, CGSWidget.DataTableId.eDataTableDefault, n, this.m_parent);
                            cGSDetectArea.setFirstSortIndex(legendItem.row);
                            if (legendItem.type == 0 || legendItem.type == 4) {
                                HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
                                hashMap.put(CGSEnums.FormattedStringIndex.eFormattedStringTitle.getValue(), legendItem.text);
                                cGSDetectArea.addFormattedValues(hashMap);
                            }
                            this.m_pDetAreas.add(cGSDetectArea);
                        }
                    }
                }
                d12 -= gRDevice.fromPixels(legendItem.height);
            }
            d5 = d11;
        } else {
            d5 = d11;
            d4 = d13;
            for (int i = 0; i < this.m_items.size(); ++i) {
                int n;
                LegendItem legendItem = this.m_items.elementAt(i);
                if (!legendItem.show || legendItem.pText == null) continue;
                double d14 = this.m_internalItemWidth;
                CGSEnums.DetArea detArea = CGSEnums.DetArea.eDetLegendLabel;
                CGSWidget.DataType dataType = legendItem.datatype;
                int n4 = 0;
                switch (legendItem.type) {
                    case 0: {
                        d14 = this.m_internalWidth;
                        detArea = CGSEnums.DetArea.eDetLegendTitle;
                        dataType = CGSWidget.DataType.eIgnore;
                        d4 = d5;
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (legendItem.icon != null) {
                            int n5 = (int)gRDevice.fromPixels((legendItem.height - this.m_iconSize) / 2);
                            n = this.m_mirrorLegend ? GRHelper.GR_ROUND(d4 - gRDevice.fromPixels(1 + this.m_iconSize)) : GRHelper.GR_ROUND(d5 + gRDevice.fromPixels(1.0));
                            int n6 = GRHelper.GR_ROUND((double)gRDevice.m_height - d12 + (double)n5);
                            this.addIconToLegend(gRDevice, legendItem, n, n6);
                        }
                        n4 = this.m_iconSize + 1 + 3;
                        d5 += gRDevice.fromPixels(n4);
                        d4 -= gRDevice.fromPixels(this.m_internalItemWidth);
                        d14 -= (double)n4;
                        if (legendItem.subtype != 18) break;
                        dataType = CGSWidget.DataType.eCategory;
                        break;
                    }
                }
                if (d14 > 0.0) {
                    if (gRDevice.isSVG()) {
                        int n7 = GRHelper.GR_ROUND(d5) + this.m_parent.getLocation().m_left;
                        if ((legendItem.type == 0 || legendItem.type == 4) && legendItem.pText.getFont().getHorAlignment() == CGSPropFont.HorAlign.eHorAlignCenter) {
                            n7 = (int)((double)n7 + (this.m_internalWidth - (double)legendItem.width) / 2.0);
                        }
                        this.m_parent.addSVGLabel(legendItem.text, n7, GRHelper.GR_ROUND((double)gRDevice.m_height - d12), legendItem.pText, false);
                    } else if (gRDevice.isRaster()) {
                        BufferedImage bufferedImage = legendItem.pText.getTextImage(GRHelper.GR_ROUND(d14));
                        gRDevice.pasteImage(bufferedImage, GRHelper.GR_ROUND(this.m_mirrorLegend ? d4 : d5), GRHelper.GR_ROUND((double)gRDevice.m_height - d12));
                    } else {
                        byte[] byArray = legendItem.pText.getTextVectorBlob(GRHelper.GR_ROUND(d14));
                        ((GRDeviceVector)gRDevice).pasteVectorBlob(byArray, this.m_mirrorLegend ? d4 : d5, (double)gRDevice.m_height - d12);
                    }
                    if (legendItem.genDetArea) {
                        Point[] pointArray = new Point[]{new Point((int)(this.m_mirrorLegend ? d4 : d5), (int)((double)gRDevice.m_height - d12)), new Point((int)(this.m_mirrorLegend ? d4 + d14 : d5 + d14), (int)((double)gRDevice.m_height - d12)), new Point((int)(this.m_mirrorLegend ? d4 + d14 : d5 + d14), (int)((double)gRDevice.m_height - d12 + gRDevice.fromPixels(legendItem.height))), new Point((int)(this.m_mirrorLegend ? d4 : d5), (int)((double)gRDevice.m_height - d12 + gRDevice.fromPixels(legendItem.height)))};
                        n = this.m_parent.getWidgetIndex();
                        CGSDetectArea cGSDetectArea = new CGSDetectArea(detArea, dataType, i, pointArray, legendItem.row, -1, CGSWidget.DataTableId.eDataTableDefault, n, this.m_parent);
                        cGSDetectArea.setFirstSortIndex(legendItem.row);
                        if (legendItem.type == 0 || legendItem.type == 4) {
                            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
                            hashMap.put(CGSEnums.FormattedStringIndex.eFormattedStringTitle.getValue(), legendItem.text);
                            cGSDetectArea.addFormattedValues(hashMap);
                        }
                        this.m_pDetAreas.add(cGSDetectArea);
                    }
                }
                if (!(Math.abs((d5 += gRDevice.fromPixels(d14)) - d11 - gRDevice.fromPixels(this.m_internalWidth)) < 0.1)) continue;
                d5 = d11;
                d4 = d13;
                d12 -= gRDevice.fromPixels(legendItem.height);
            }
            if (this.m_mirrorLegend) {
                d5 = d4 - gRDevice.fromPixels(this.m_internalItemWidth);
            }
        }
        if (!this.m_allItemsShown && this.m_truncatorHeight > 0.0) {
            if (gRDevice.isSVG()) {
                int n = GRHelper.GR_ROUND(d5) + this.m_parent.getLocation().m_left;
                this.m_parent.addSVGLabel(gRText.getLabel(), n, GRHelper.GR_ROUND((double)gRDevice.m_height - d12), gRText, false);
            } else if (gRDevice.isRaster()) {
                BufferedImage bufferedImage = gRText.getTextImage(GRHelper.GR_ROUND(this.m_internalItemWidth));
                gRDevice.pasteImage(bufferedImage, GRHelper.GR_ROUND(d5), GRHelper.GR_ROUND((double)gRDevice.m_height - d12 - gRDevice.fromPixels(d6 - this.m_truncatorHeight)));
            } else {
                byte[] byArray = gRText.getTextVectorBlob(GRHelper.GR_ROUND(this.m_internalItemWidth));
                ((GRDeviceVector)gRDevice).pasteVectorBlob(byArray, d5, (double)gRDevice.m_height - d12 - gRDevice.fromPixels(d6 - this.m_truncatorHeight));
            }
        }
    }

    private void addIconToLegend(GRDevice gRDevice, LegendItem legendItem, int n, int n2) {
        if (gRDevice.isSVG()) {
            String string = this.getSVGIconImage(legendItem, (int)gRDevice.fromPixels(this.m_iconSize));
            this.m_parent.addSVGImage(string, n + this.m_parent.getLocation().m_left, n2);
        } else if (gRDevice.isRaster() || legendItem.icon.iconType == 2) {
            BufferedImage bufferedImage = this.getIconImage(legendItem, (int)gRDevice.fromPixels(this.m_iconSize));
            gRDevice.pasteImage(bufferedImage, n, n2);
        } else {
            if (!gRDevice.isRaster() && legendItem.icon.dataPointShapeFill != null && !legendItem.icon.dataPointShapeFill.isSimple(gRDevice.isRaster() || gRDevice.isSVG())) {
                legendItem.icon.dataPointShapeFill.setSolidColor(legendItem.icon.dataPointShapeFill.getDefaultColor());
            }
            this.m_pDrawContext.addViewportToLegend(gRDevice, legendItem.icon, n, n2, this.m_iconSize, this.m_mirrorLegend);
        }
    }

    public Vector<CGSDetectArea> getDetectionAreas() {
        return this.m_pDetAreas;
    }

    private BufferedImage getIconImage(LegendItem legendItem, int n) {
        return this.m_pDrawContext.getLegendGlyph(legendItem.icon, n, this.m_mirrorLegend);
    }

    private String getSVGIconImage(LegendItem legendItem, int n) {
        return this.m_pDrawContext.getSVGLegendGlyph(legendItem.icon, n, this.m_mirrorLegend);
    }

    class LegendItem
    implements Comparable<LegendItem> {
        public int type = 1;
        public int subtype = 10;
        public CGSWidget.DataType datatype = CGSWidget.DataType.eIgnore;
        public int axisIndex = 0;
        public String text = null;
        public GRLegendItemIcon icon = null;
        public Color[] colors = null;
        public String[] values = null;
        public GRText pText = null;
        public int width = 0;
        public int height = 0;
        public int truncWidth = 0;
        public boolean show = false;
        public int row = -1;
        public boolean genDetArea = false;

        LegendItem() {
        }

        @Override
        public int compareTo(LegendItem legendItem) {
            if (legendItem instanceof LegendItem) {
                LegendItem legendItem2 = legendItem;
                if (legendItem2.type == 3 && this.type == 3) {
                    return this.subtype - legendItem2.subtype;
                }
            }
            return 0;
        }
    }
}

