/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Logging;

import java.util.HashMap;
import java.util.Map;

public class CGSConsoleLogger {
    public static final String NO_PID = "<pid>";
    public boolean m_outputEnabled = true;
    public int m_level = 0;
    public Map<String, Long> m_startTimes = null;
    public String m_pid = "<pid>";

    public CGSConsoleLogger() {
    }

    public CGSConsoleLogger(boolean bl) {
        this.m_outputEnabled = bl;
    }

    public void open() {
    }

    public void close() {
    }

    public void setOutputEnabled(boolean bl) {
        this.m_outputEnabled = bl;
    }

    public void setLevel(int n) {
        this.m_level = n;
        if (n == 0) {
            this.setOutputEnabled(false);
        }
    }

    public void setProcessPid(String string) {
        this.m_pid = string;
    }

    public String getProcessPid() {
        return this.m_pid;
    }

    public void logError(String string) {
        switch (this.m_level) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.log("ERROR" + this.getSeparator() + string);
                break;
            }
        }
    }

    public void logInfo(String string) {
        switch (this.m_level) {
            case 1: 
            case 4: {
                this.log("INFO" + this.getSeparator() + string);
                break;
            }
        }
    }

    public void logWarning(String string) {
        switch (this.m_level) {
            case 1: 
            case 3: 
            case 4: {
                this.log("WARNING" + this.getSeparator() + string);
                break;
            }
        }
    }

    public synchronized void logStartTime(String string) {
        if (!this.m_outputEnabled) {
            return;
        }
        switch (this.m_level) {
            case 1: 
            case 5: {
                this.createStartTimes();
                long l = System.currentTimeMillis();
                Long l2 = new Long(l);
                this.m_startTimes.put(string, l2);
                break;
            }
        }
    }

    public synchronized void logStopTime(String string) {
        if (!this.m_outputEnabled) {
            return;
        }
        switch (this.m_level) {
            case 1: 
            case 5: {
                long l = System.currentTimeMillis();
                if (this.m_startTimes == null) {
                    return;
                }
                Long l2 = this.m_startTimes.get(string);
                if (l2 == null) {
                    return;
                }
                this.m_startTimes.remove(string);
                long l3 = l - l2;
                this.log("TIME" + this.getSeparator() + string + this.getSeparator() + Long.toString(l3) + this.getSeparator() + " ms.");
                break;
            }
        }
    }

    protected void log(String string) {
        if (!this.m_outputEnabled) {
            return;
        }
        this.open();
        System.out.println("cgsJava" + this.getSeparator() + this.getProcessPid() + this.getSeparator() + string);
        this.close();
    }

    private void createStartTimes() {
        if (this.m_startTimes == null) {
            this.m_startTimes = new HashMap<String, Long>();
        }
    }

    protected String getSeparator() {
        return " : ";
    }
}

