/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Properties;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.FrameWork.CGSProp;
import com.ibm.cgsBus.Interfaces.CGSIPropAvoidLabelCollision;
import com.ibm.cgsBus.Interfaces.CGSIPropDepth;
import com.ibm.cgsBus.Interfaces.CGSIPropDepthDirection;
import com.ibm.cgsBus.Interfaces.CGSIPropFillRect;
import com.ibm.cgsBus.Interfaces.CGSIPropMarker;
import com.ibm.cgsBus.Interfaces.CGSIPropMatchSeriesColor;
import com.ibm.cgsBus.Interfaces.CGSIPropVerticalOrientation;
import com.ibm.cgsBus.Properties.CGSPropChart;
import com.ibm.cgsBus.Properties.CGSPropComboElem;
import com.ibm.cgsBus.Properties.CGSPropComboElemArea;
import com.ibm.cgsBus.Properties.CGSPropComboElemBar;
import com.ibm.cgsBus.Properties.CGSPropComboElemLine;
import com.ibm.cgsBus.Properties.CGSPropFillRect;
import com.ibm.cgsBus.Properties.CGSPropMarker;
import com.ibm.cgsBus.Properties.CGSPropOthersGroupB;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeBool;
import com.ibm.cgsBus.Types.CGSTypeEnum;
import com.ibm.cgsBus.Types.CGSTypeInt;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.dom4j.Element;

public class CGSPropChartCombo
extends CGSPropChart
implements CGSIPropAvoidLabelCollision,
CGSIPropDepthDirection,
CGSIPropDepth,
CGSIPropFillRect,
CGSIPropMarker,
CGSIPropMatchSeriesColor,
CGSIPropVerticalOrientation {
    protected CGSTypeBool m_AvoidLabelCollision = null;
    protected CGSTypeBool m_VerticalOrientation = null;
    protected CGSTypeBool m_RotateDataValuesWithChart = null;
    protected CGSTypeInt m_Depth = null;
    protected CGSTypeInt m_DepthDirection = null;
    protected CGSTypeBool m_MatchSeriesColor = null;
    protected CGSTypeEnum<CGSEnums.MarkerTextLocation> m_MarkerTextLocation = null;
    protected CGSTypeBool m_Bipolar = null;
    protected CGSPropOthersGroupB m_othersGroup = null;
    protected Vector<CGSPropMarker> m_Marker = new Vector();
    protected Vector<CGSPropFillRect> m_FillRect = new Vector();
    protected Vector<CGSPropComboElem> m_elements = new Vector();

    public CGSPropChartCombo() {
        super(CGSEnums.PropType.ePropChartCombo);
        this.initializeChartCombo();
    }

    public CGSPropChartCombo(CGSEnums.PropType propType) {
        super(propType);
        this.initializeChartCombo();
    }

    protected void initializeChartCombo() {
        this.m_AvoidLabelCollision = new CGSTypeBool(true);
        this.m_VerticalOrientation = new CGSTypeBool(true);
        this.m_RotateDataValuesWithChart = new CGSTypeBool(false);
        this.m_Depth = new CGSTypeInt(0);
        this.m_DepthDirection = new CGSTypeInt(45);
        this.m_MatchSeriesColor = new CGSTypeBool(false);
        this.m_MarkerTextLocation = new CGSTypeEnum<CGSEnums.MarkerTextLocation>(CGSEnums.MarkerTextLocation.eMarkerTextChart);
        this.m_Bipolar = new CGSTypeBool(false);
        this.m_othersGroup = new CGSPropOthersGroupB();
        this.m_props.add(this.m_othersGroup);
    }

    @Override
    public void copyAttributes(CGSProp cGSProp) {
        super.copyAttributes(cGSProp);
        CGSPropChartCombo cGSPropChartCombo = (CGSPropChartCombo)cGSProp;
        this.m_AvoidLabelCollision.setValue(cGSPropChartCombo.m_AvoidLabelCollision.getValue());
        this.m_VerticalOrientation.setValue(cGSPropChartCombo.m_VerticalOrientation.getValue());
        this.m_RotateDataValuesWithChart.setValue(cGSPropChartCombo.m_RotateDataValuesWithChart.getValue());
        this.m_Depth.setValue(cGSPropChartCombo.m_Depth.getValue());
        this.m_DepthDirection.setValue(cGSPropChartCombo.m_DepthDirection.getValue());
        this.m_MatchSeriesColor.setValue(cGSPropChartCombo.m_MatchSeriesColor.getValue());
        this.m_MarkerTextLocation.setValue(cGSPropChartCombo.m_MarkerTextLocation.getValue());
        this.m_Bipolar.setValue(cGSPropChartCombo.m_Bipolar.getValue());
    }

    @Override
    public void copy(CGSProp cGSProp) {
        CGSProp cGSProp2;
        int n;
        super.copy(cGSProp);
        CGSPropChartCombo cGSPropChartCombo = (CGSPropChartCombo)cGSProp;
        this.m_Marker.setSize(cGSPropChartCombo.m_Marker.size());
        for (n = 0; n < cGSPropChartCombo.m_Marker.size(); ++n) {
            cGSProp2 = new CGSPropMarker();
            cGSProp2.copy(cGSPropChartCombo.m_Marker.elementAt(n));
            this.m_Marker.setElementAt((CGSPropMarker)cGSProp2, n);
        }
        this.m_FillRect.setSize(cGSPropChartCombo.m_FillRect.size());
        for (n = 0; n < cGSPropChartCombo.m_FillRect.size(); ++n) {
            cGSProp2 = new CGSPropFillRect();
            cGSProp2.copy(cGSPropChartCombo.m_FillRect.elementAt(n));
            this.m_FillRect.setElementAt((CGSPropFillRect)cGSProp2, n);
        }
        n = cGSPropChartCombo.m_elements.size();
        CMHelper.CGS_ASSERT(n == this.m_elements.size() || this.m_elements.size() == 0, "Cannot change the number of combo elements during copyDeep().");
        for (int i = 0; i < n; ++i) {
            if (n != this.m_elements.size()) {
                switch (cGSPropChartCombo.m_elements.get(i).getPropType()) {
                    case ePropComboElemArea: 
                    case ePropComboElemArea3D: {
                        this.addAreaChart();
                        break;
                    }
                    case ePropComboElemBar: 
                    case ePropComboElemBar3D: {
                        this.addBarChart();
                        break;
                    }
                    case ePropComboElemLine: 
                    case ePropComboElemLine3D: {
                        this.addLineChart();
                        break;
                    }
                    default: {
                        CMHelper.CGS_ASSERT(false, "Unknown combo element type found during copyDeep.");
                    }
                }
            }
            this.m_elements.get(i).copy(cGSPropChartCombo.m_elements.get(i));
        }
    }

    @Override
    public void save(DataOutputStream dataOutputStream) {
        super.save(dataOutputStream);
        try {
            this.m_AvoidLabelCollision.save(dataOutputStream);
            this.m_VerticalOrientation.save(dataOutputStream);
            this.m_RotateDataValuesWithChart.save(dataOutputStream);
            this.m_Depth.save(dataOutputStream);
            this.m_DepthDirection.save(dataOutputStream);
            this.m_MatchSeriesColor.save(dataOutputStream);
            this.m_MarkerTextLocation.save(dataOutputStream);
            this.m_Bipolar.save(dataOutputStream);
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to save property:" + iOException.getMessage());
        }
    }

    @Override
    public void restore(DataInputStream dataInputStream) {
        super.restore(dataInputStream);
        try {
            this.m_AvoidLabelCollision.restore(dataInputStream);
            this.m_VerticalOrientation.restore(dataInputStream);
            this.m_RotateDataValuesWithChart.restore(dataInputStream);
            this.m_Depth.restore(dataInputStream);
            this.m_DepthDirection.restore(dataInputStream);
            this.m_MatchSeriesColor.restore(dataInputStream);
            this.m_MarkerTextLocation.restore(dataInputStream);
            this.m_Bipolar.restore(dataInputStream);
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to restore property:" + iOException.getMessage());
        }
    }

    @Override
    public void loadLDX(Element element) {
        if (element == null) {
            return;
        }
        this.m_container.loadLDX(element.element("container"));
        this.m_palette.loadLDX(element.element("palette"));
        this.m_paletteCond.loadLDX(element.element("paletteCond"));
        this.m_paletteConditional.loadLDX(element.element("paletteConditional"));
        this.m_font.loadLDX(element.element("font"));
        this.m_FillEffect.setValueFromLDX(element, "fillEffect");
        this.m_ShowChartAxisShadow.setValueFromLDX(element, "showChartAxisShadow");
        this.m_ChartAxisShadowColor.setValueFromLDX(element, "chartAxisShadowColor");
        this.m_ChartAxisShadowSize.setValueFromLDX(element, "chartAxisShadowSize");
        this.m_ChartAxisShadowBlur.setValueFromLDX(element, "chartAxisShadowBlur");
        this.m_ShowOutline.setValueFromLDX(element, "showOutline");
        this.m_OutlineColor.setValueFromLDX(element, "outlineColor");
        this.m_MaterialEffect.setValueFromLDX(element, "materialEffect");
        this.m_othersGroup.loadLDX(element.element("othersGroup"));
        List list = element.elements("marker");
        for (int i = 0; i < list.size(); ++i) {
            CGSPropMarker cGSPropMarker = new CGSPropMarker();
            this.m_Marker.addElement(cGSPropMarker);
            cGSPropMarker.loadLDX((Element)list.get(i));
        }
        List list2 = element.elements("fillRect");
        for (int i = 0; i < list2.size(); ++i) {
            CGSPropFillRect cGSPropFillRect = new CGSPropFillRect();
            this.m_FillRect.addElement(cGSPropFillRect);
            cGSPropFillRect.loadLDX((Element)list2.get(i));
        }
        List list3 = element.elements("comboElement");
        for (int i = 0; i < list3.size(); ++i) {
            CGSPropComboElem cGSPropComboElem = null;
            Element element2 = null;
            if (((Element)list3.get(i)).element("area") != null) {
                cGSPropComboElem = new CGSPropComboElemArea();
                element2 = ((Element)list3.get(i)).element("area");
            } else if (((Element)list3.get(i)).element("bar") != null) {
                cGSPropComboElem = new CGSPropComboElemBar();
                element2 = ((Element)list3.get(i)).element("bar");
            } else if (((Element)list3.get(i)).element("line") != null) {
                cGSPropComboElem = new CGSPropComboElemLine();
                element2 = ((Element)list3.get(i)).element("line");
            } else {
                CMHelper.CGS_ASSERT(false, "LDX decode error: Unknow combo element type.");
            }
            cGSPropComboElem.m_id.setValueFromLDX((Element)list3.get(i), "comboElemId");
            cGSPropComboElem.loadLDX(element2);
            this.m_elements.addElement(cGSPropComboElem);
        }
        this.m_VerticalOrientation.setValueFromLDX(element, "verticalOrientation");
        this.m_RotateDataValuesWithChart.setValueFromLDX(element, "rotateDataValuesWithChart");
        this.m_Depth.setValueFromLDX(element, "depth");
        this.m_DepthDirection.setValueFromLDX(element, "depthDirection");
        this.m_MatchSeriesColor.setValueFromLDX(element, "matchSeriesColor");
        this.m_MarkerTextLocation.setValueFromLDX(element, "markerTextLocation");
        this.m_Bipolar.setValueFromLDX(element, "bipolar");
    }

    @Override
    public void setAvoidLabelCollision(boolean bl) {
        this.m_AvoidLabelCollision.setValue(bl);
    }

    @Override
    public boolean getAvoidLabelCollision() {
        return this.m_AvoidLabelCollision.getValue();
    }

    @Override
    public void setVerticalOrientation(boolean bl) {
        this.m_VerticalOrientation.setValue(bl);
    }

    @Override
    public boolean getVerticalOrientation() {
        return this.m_VerticalOrientation.getValue();
    }

    @Override
    public void setRotateDataValuesWithChart(boolean bl) {
        this.m_RotateDataValuesWithChart.setValue(bl);
    }

    @Override
    public boolean getRotateDataValuesWithChart() {
        return this.m_RotateDataValuesWithChart.getValue();
    }

    @Override
    public void setDepth(int n) {
        this.m_Depth.setValue(n);
    }

    @Override
    public int getDepth() {
        return this.m_Depth.getValue();
    }

    @Override
    public void setDepthDirection(int n) {
        this.m_DepthDirection.setValue(n);
    }

    @Override
    public int getDepthDirection() {
        return this.m_DepthDirection.getValue();
    }

    @Override
    public void setMatchSeriesColor(boolean bl) {
        this.m_MatchSeriesColor.setValue(bl);
    }

    @Override
    public boolean getMatchSeriesColor() {
        return this.m_MatchSeriesColor.getValue();
    }

    @Override
    public void setMarkerTextLocation(CGSEnums.MarkerTextLocation markerTextLocation) {
        this.m_MarkerTextLocation.setValue(markerTextLocation);
    }

    @Override
    public CGSEnums.MarkerTextLocation getMarkerTextLocation() {
        return this.m_MarkerTextLocation.getValue();
    }

    public void setBipolar(boolean bl) {
        this.m_Bipolar.setValue(bl);
    }

    public boolean getBipolar() {
        return this.m_Bipolar.getValue();
    }

    @Override
    public void setMarkerCount(int n) {
        int n2 = this.m_Marker.size();
        this.m_Marker.setSize(n);
        for (int i = n2; i < n; ++i) {
            this.m_Marker.setElementAt(new CGSPropMarker(), i);
        }
    }

    @Override
    public int getMarkerCount() {
        return this.m_Marker.size();
    }

    @Override
    public CGSPropMarker getMarker(int n) {
        return this.m_Marker.elementAt(n);
    }

    @Override
    public CGSPropMarker appendMarker() {
        this.setMarkerCount(this.m_Marker.size() + 1);
        return this.m_Marker.set(this.m_Marker.size() - 1, new CGSPropMarker());
    }

    @Override
    public Vector<CGSPropMarker> getMarkerList() {
        return this.m_Marker;
    }

    @Override
    public void setFillRectCount(int n) {
        int n2 = this.m_FillRect.size();
        this.m_FillRect.setSize(n);
        for (int i = n2; i < n; ++i) {
            this.m_FillRect.setElementAt(new CGSPropFillRect(), i);
        }
    }

    @Override
    public int getFillRectCount() {
        return this.m_FillRect.size();
    }

    @Override
    public CGSPropFillRect getFillRect(int n) {
        return this.m_FillRect.elementAt(n);
    }

    @Override
    public CGSPropFillRect appendFillRect() {
        this.setFillRectCount(this.m_FillRect.size() + 1);
        return this.m_FillRect.set(this.m_FillRect.size() - 1, new CGSPropFillRect());
    }

    @Override
    public Vector<CGSPropFillRect> getFillRectList() {
        return this.m_FillRect;
    }

    public void addAreaChart() {
        this.m_elements.add(new CGSPropComboElemArea());
    }

    public void addBarChart() {
        this.m_elements.add(new CGSPropComboElemBar());
    }

    public void addLineChart() {
        this.m_elements.add(new CGSPropComboElemLine());
    }

    public int getChartCount() {
        return this.m_elements.size();
    }

    public CGSPropComboElem getChart(int n) {
        return this.m_elements.get(n);
    }

    @Override
    public void mirror() {
        for (CGSPropMarker cGSProp : this.m_Marker) {
            cGSProp.mirror();
        }
        for (CGSPropFillRect cGSPropFillRect : this.m_FillRect) {
            cGSPropFillRect.mirror();
        }
        for (CGSPropComboElem cGSPropComboElem : this.m_elements) {
            cGSPropComboElem.mirror();
        }
    }
}

