/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Properties;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.FrameWork.CGSProp;
import com.ibm.cgsBus.Interfaces.CGSIPropMatchSeriesColor;
import com.ibm.cgsBus.Interfaces.CGSIPropViewAngle;
import com.ibm.cgsBus.Properties.CGSPropChart;
import com.ibm.cgsBus.Properties.CGSPropComboElem;
import com.ibm.cgsBus.Properties.CGSPropComboElemArea3D;
import com.ibm.cgsBus.Properties.CGSPropComboElemBar3D;
import com.ibm.cgsBus.Properties.CGSPropComboElemLine3D;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeBool;
import com.ibm.cgsBus.Types.CGSTypeEnum;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.dom4j.Element;

public class CGSPropChartCombo3D
extends CGSPropChart
implements CGSIPropMatchSeriesColor,
CGSIPropViewAngle {
    protected CGSTypeEnum<CGSEnums.ViewAngle> m_ViewAngle = null;
    protected CGSTypeBool m_MatchSeriesColor = null;
    protected Vector<CGSPropComboElem> m_elements = new Vector();

    public CGSPropChartCombo3D() {
        super(CGSEnums.PropType.ePropChartCombo3D);
        this.initializeChartCombo3D();
    }

    public CGSPropChartCombo3D(CGSEnums.PropType propType) {
        super(propType);
        this.initializeChartCombo3D();
    }

    protected void initializeChartCombo3D() {
        this.m_ViewAngle = new CGSTypeEnum<CGSEnums.ViewAngle>(CGSEnums.ViewAngle.eViewStandard);
        this.m_MatchSeriesColor = new CGSTypeBool(false);
    }

    @Override
    public void copyAttributes(CGSProp cGSProp) {
        super.copyAttributes(cGSProp);
        CGSPropChartCombo3D cGSPropChartCombo3D = (CGSPropChartCombo3D)cGSProp;
        this.m_ViewAngle.setValue(cGSPropChartCombo3D.m_ViewAngle.getValue());
        this.m_MatchSeriesColor.setValue(cGSPropChartCombo3D.m_MatchSeriesColor.getValue());
    }

    @Override
    public void save(DataOutputStream dataOutputStream) {
        super.save(dataOutputStream);
        try {
            this.m_ViewAngle.save(dataOutputStream);
            this.m_MatchSeriesColor.save(dataOutputStream);
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to save property:" + iOException.getMessage());
        }
    }

    @Override
    public void restore(DataInputStream dataInputStream) {
        super.restore(dataInputStream);
        try {
            this.m_ViewAngle.restore(dataInputStream);
            this.m_MatchSeriesColor.restore(dataInputStream);
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to restore property:" + iOException.getMessage());
        }
    }

    @Override
    public void loadLDX(Element element) {
        if (element == null) {
            return;
        }
        this.m_container.loadLDX(element.element("container"));
        this.m_palette.loadLDX(element.element("palette"));
        this.m_paletteCond.loadLDX(element.element("paletteCond"));
        this.m_paletteConditional.loadLDX(element.element("paletteConditional"));
        this.m_font.loadLDX(element.element("font"));
        this.m_FillEffect.setValueFromLDX(element, "fillEffect");
        this.m_ShowChartAxisShadow.setValueFromLDX(element, "showChartAxisShadow");
        this.m_ChartAxisShadowColor.setValueFromLDX(element, "chartAxisShadowColor");
        this.m_ChartAxisShadowSize.setValueFromLDX(element, "chartAxisShadowSize");
        this.m_ChartAxisShadowBlur.setValueFromLDX(element, "chartAxisShadowBlur");
        this.m_ShowOutline.setValueFromLDX(element, "showOutline");
        this.m_OutlineColor.setValueFromLDX(element, "outlineColor");
        this.m_MaterialEffect.setValueFromLDX(element, "materialEffect");
        List list = element.elements("comboElement");
        for (int i = 0; i < list.size(); ++i) {
            CGSPropComboElem cGSPropComboElem = null;
            Element element2 = null;
            if (((Element)list.get(i)).element("area3D") != null) {
                cGSPropComboElem = new CGSPropComboElemArea3D();
                element2 = ((Element)list.get(i)).element("area3D");
            } else if (((Element)list.get(i)).element("bar3D") != null) {
                cGSPropComboElem = new CGSPropComboElemBar3D();
                element2 = ((Element)list.get(i)).element("bar3D");
            } else if (((Element)list.get(i)).element("line3D") != null) {
                cGSPropComboElem = new CGSPropComboElemLine3D();
                element2 = ((Element)list.get(i)).element("line3D");
            } else {
                CMHelper.CGS_ASSERT(false, "LDX decode error: Unknow combo element type.");
            }
            cGSPropComboElem.m_id.setValueFromLDX((Element)list.get(i), "comboElemId");
            cGSPropComboElem.loadLDX(element2);
            this.m_elements.addElement(cGSPropComboElem);
        }
        this.m_MatchSeriesColor.setValueFromLDX(element, "matchSeriesColor");
    }

    @Override
    public void setViewAngle(CGSEnums.ViewAngle viewAngle) {
        this.m_ViewAngle.setValue(viewAngle);
    }

    @Override
    public CGSEnums.ViewAngle getViewAngle() {
        return this.m_ViewAngle.getValue();
    }

    @Override
    public void setMatchSeriesColor(boolean bl) {
        this.m_MatchSeriesColor.setValue(bl);
    }

    @Override
    public boolean getMatchSeriesColor() {
        return this.m_MatchSeriesColor.getValue();
    }

    public void addAreaChart() {
        this.m_elements.add(new CGSPropComboElemArea3D());
    }

    public void addBarChart() {
        this.m_elements.add(new CGSPropComboElemBar3D());
    }

    public void addLineChart() {
        this.m_elements.add(new CGSPropComboElemLine3D());
    }

    public int getChartCount() {
        return this.m_elements.size();
    }

    public CGSPropComboElem getChart(int n) {
        return this.m_elements.get(n);
    }
}

