/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Properties;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.FrameWork.CGSProp;
import com.ibm.cgsBus.Interfaces.CGSIPropFillRect;
import com.ibm.cgsBus.Properties.CGSPropChart;
import com.ibm.cgsBus.Properties.CGSPropFillRect;
import com.ibm.cgsBus.Properties.CGSPropGanttDependencyLine;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeBool;
import com.ibm.cgsBus.Types.CGSTypeColor;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.dom4j.Element;

public class CGSPropChartGantt
extends CGSPropChart
implements CGSIPropFillRect {
    protected CGSTypeColor m_ProgressBarColor = null;
    protected CGSTypeColor m_MilestoneGlyphColor = null;
    protected CGSTypeBool m_ShowTaskSegmentLabels = null;
    protected CGSPropGanttDependencyLine m_dependencyLine = null;
    protected Vector<CGSPropFillRect> m_FillRect = new Vector();

    public CGSPropChartGantt() {
        super(CGSEnums.PropType.ePropChartGantt);
        this.initializeChartGantt();
    }

    public CGSPropChartGantt(CGSEnums.PropType propType) {
        super(propType);
        this.initializeChartGantt();
    }

    protected void initializeChartGantt() {
        this.m_ProgressBarColor = new CGSTypeColor(Color.BLACK);
        this.m_MilestoneGlyphColor = new CGSTypeColor(Color.RED);
        this.m_ShowTaskSegmentLabels = new CGSTypeBool(false);
        this.m_dependencyLine = new CGSPropGanttDependencyLine();
        this.m_props.add(this.m_dependencyLine);
    }

    @Override
    public void copyAttributes(CGSProp cGSProp) {
        super.copyAttributes(cGSProp);
        CGSPropChartGantt cGSPropChartGantt = (CGSPropChartGantt)cGSProp;
        this.m_ProgressBarColor.setValue(cGSPropChartGantt.m_ProgressBarColor.getValue());
        this.m_MilestoneGlyphColor.setValue(cGSPropChartGantt.m_MilestoneGlyphColor.getValue());
        this.m_ShowTaskSegmentLabels.setValue(cGSPropChartGantt.m_ShowTaskSegmentLabels.getValue());
    }

    @Override
    public void copy(CGSProp cGSProp) {
        super.copy(cGSProp);
        CGSPropChartGantt cGSPropChartGantt = (CGSPropChartGantt)cGSProp;
        this.m_FillRect.setSize(cGSPropChartGantt.m_FillRect.size());
        for (int i = 0; i < cGSPropChartGantt.m_FillRect.size(); ++i) {
            CGSPropFillRect cGSPropFillRect = new CGSPropFillRect();
            cGSPropFillRect.copy(cGSPropChartGantt.m_FillRect.elementAt(i));
            this.m_FillRect.setElementAt(cGSPropFillRect, i);
        }
    }

    @Override
    public void save(DataOutputStream dataOutputStream) {
        super.save(dataOutputStream);
        try {
            this.m_ProgressBarColor.save(dataOutputStream);
            this.m_MilestoneGlyphColor.save(dataOutputStream);
            this.m_ShowTaskSegmentLabels.save(dataOutputStream);
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to save property:" + iOException.getMessage());
        }
    }

    @Override
    public void restore(DataInputStream dataInputStream) {
        super.restore(dataInputStream);
        try {
            this.m_ProgressBarColor.restore(dataInputStream);
            this.m_MilestoneGlyphColor.restore(dataInputStream);
            this.m_ShowTaskSegmentLabels.restore(dataInputStream);
        }
        catch (IOException iOException) {
            CMHelper.CGS_ASSERT(false, "Failed to restore property:" + iOException.getMessage());
        }
    }

    @Override
    public void loadLDX(Element element) {
        if (element == null) {
            return;
        }
        this.m_container.loadLDX(element.element("container"));
        this.m_palette.loadLDX(element.element("palette"));
        this.m_paletteCond.loadLDX(element.element("paletteCond"));
        this.m_paletteConditional.loadLDX(element.element("paletteConditional"));
        this.m_font.loadLDX(element.element("font"));
        this.m_FillEffect.setValueFromLDX(element, "fillEffect");
        this.m_ShowChartAxisShadow.setValueFromLDX(element, "showChartAxisShadow");
        this.m_ChartAxisShadowColor.setValueFromLDX(element, "chartAxisShadowColor");
        this.m_ChartAxisShadowSize.setValueFromLDX(element, "chartAxisShadowSize");
        this.m_ChartAxisShadowBlur.setValueFromLDX(element, "chartAxisShadowBlur");
        this.m_ShowOutline.setValueFromLDX(element, "showOutline");
        this.m_OutlineColor.setValueFromLDX(element, "outlineColor");
        this.m_MaterialEffect.setValueFromLDX(element, "materialEffect");
        this.m_dependencyLine.loadLDX(element.element("dependencyLine"));
        List list = element.elements("fillRect");
        for (int i = 0; i < list.size(); ++i) {
            CGSPropFillRect cGSPropFillRect = new CGSPropFillRect();
            this.m_FillRect.addElement(cGSPropFillRect);
            cGSPropFillRect.loadLDX((Element)list.get(i));
        }
        this.m_ProgressBarColor.setValueFromLDX(element, "progressBarColor");
        this.m_MilestoneGlyphColor.setValueFromLDX(element, "milestoneGlyphColor");
        this.m_ShowTaskSegmentLabels.setValueFromLDX(element, "showTaskSegmentLabels");
    }

    public void setProgressBarColor(Color color) {
        this.m_ProgressBarColor.setValue(color);
    }

    public Color getProgressBarColor() {
        return this.m_ProgressBarColor.getValue();
    }

    public void setMilestoneGlyphColor(Color color) {
        this.m_MilestoneGlyphColor.setValue(color);
    }

    public Color getMilestoneGlyphColor() {
        return this.m_MilestoneGlyphColor.getValue();
    }

    public void setShowTaskSegmentLabels(boolean bl) {
        this.m_ShowTaskSegmentLabels.setValue(bl);
    }

    public boolean getShowTaskSegmentLabels() {
        return this.m_ShowTaskSegmentLabels.getValue();
    }

    @Override
    public void setFillRectCount(int n) {
        int n2 = this.m_FillRect.size();
        this.m_FillRect.setSize(n);
        for (int i = n2; i < n; ++i) {
            this.m_FillRect.setElementAt(new CGSPropFillRect(), i);
        }
    }

    @Override
    public int getFillRectCount() {
        return this.m_FillRect.size();
    }

    @Override
    public CGSPropFillRect getFillRect(int n) {
        return this.m_FillRect.elementAt(n);
    }

    @Override
    public CGSPropFillRect appendFillRect() {
        this.setFillRectCount(this.m_FillRect.size() + 1);
        return this.m_FillRect.set(this.m_FillRect.size() - 1, new CGSPropFillRect());
    }

    @Override
    public Vector<CGSPropFillRect> getFillRectList() {
        return this.m_FillRect;
    }
}

