/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Types;

import com.ibm.cgsBus.Common.CMHelper;
import com.ibm.cgsBus.Graphics.GRBufferedImage;
import com.ibm.cgsBus.Graphics.GRDevice;
import com.ibm.cgsBus.Graphics.GRHelper;
import com.ibm.cgsBus.Graphics.GRPoint;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeBool;
import com.ibm.cgsBus.Types.CGSTypeColor;
import com.ibm.cgsBus.Types.CGSTypeDouble;
import com.ibm.cgsBus.Types.CGSTypeEnum;
import com.ibm.cgsBus.Types.CGSTypeInt;
import com.ibm.cgsBus.Types.CGSTypeLength;
import com.ibm.cgsBus.Types.CGSTypePointUnit;
import com.ibm.cgsBus.Types.CGSTypeString;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.dom4j.Element;

public class CGSTypeFillEffect {
    private Intersect m_intersect = new Intersect();
    private static int[] patternHorz = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    private static int[] patternVert = new int[]{0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255};
    private static int[] patternForward = new int[]{191, 255, 255, 255, 255, 255, 191, 21, 255, 255, 255, 255, 255, 191, 21, 191, 255, 255, 255, 255, 191, 21, 191, 255, 255, 255, 255, 191, 21, 191, 255, 255, 255, 255, 191, 21, 191, 255, 255, 255, 255, 191, 21, 191, 255, 255, 255, 255, 191, 21, 191, 255, 255, 255, 255, 255, 21, 191, 255, 255, 255, 255, 255, 191};
    private static int[] patternBackward = new int[]{21, 191, 255, 255, 255, 255, 255, 191, 191, 21, 191, 255, 255, 255, 255, 255, 255, 191, 21, 191, 255, 255, 255, 255, 255, 255, 191, 21, 191, 255, 255, 255, 255, 255, 255, 191, 21, 191, 255, 255, 255, 255, 255, 255, 191, 21, 191, 255, 255, 255, 255, 255, 255, 191, 21, 191, 191, 255, 255, 255, 255, 255, 191, 21};
    private static int[] patternCross = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255, 0, 255, 255, 255};
    private static int[] patternDiagonalCross = new int[]{21, 191, 255, 255, 255, 255, 191, 21, 191, 21, 191, 255, 255, 191, 21, 191, 255, 191, 21, 191, 191, 21, 191, 255, 255, 255, 191, 21, 21, 191, 255, 255, 255, 255, 191, 21, 21, 191, 255, 255, 255, 191, 21, 191, 191, 21, 191, 255, 191, 21, 191, 255, 255, 191, 21, 191, 21, 191, 255, 255, 255, 255, 191, 21};
    private CGSTypeEnum<CGSEnums.FillType> m_fillType = new CGSTypeEnum<CGSEnums.FillType>(CGSEnums.FillType.eFillPattern);
    private CGSTypeColor m_defaultColor = new CGSTypeColor(Color.BLACK);
    private CGSTypeEnum<CGSEnums.GradientType> m_gradientType = new CGSTypeEnum<CGSEnums.GradientType>(CGSEnums.GradientType.eGradientLinear);
    private CGSTypeEnum<CGSEnums.GradientDirection> m_gradientDirection = new CGSTypeEnum<CGSEnums.GradientDirection>(CGSEnums.GradientDirection.eGradientDown);
    private double m_gradientAngle = 0.0;
    private CGSTypeLength m_gradientInnerRadius = new CGSTypeLength();
    private CGSTypeLength m_gradientOuterRadius = new CGSTypeLength();
    private CGSTypePointUnit m_gradientBeginPt = new CGSTypePointUnit();
    private CGSTypePointUnit m_gradientEndPt = new CGSTypePointUnit();
    private double m_gradientPercent = 100.0;
    private Vector<Gradient> m_gradient = new Vector();
    private Color m_gradientSolidColor = null;
    private GradientParams m_gradientParams = null;
    private boolean m_adjustForChartRotation = false;
    private CGSTypeEnum<CGSEnums.PatternType> m_patternType = new CGSTypeEnum<CGSEnums.PatternType>(CGSEnums.PatternType.ePatternNone);
    private boolean m_patternTransparent = false;
    private CGSTypeColor m_patternBackColor = new CGSTypeColor(Color.WHITE);
    private CGSTypeColor m_patternForeColor = new CGSTypeColor(Color.BLACK);
    private String m_extFilename = null;
    private String m_extUrl = null;
    private int m_extAlpha = 255;
    private CGSTypeEnum<CGSEnums.ImageLocation> m_extLocation = new CGSTypeEnum<CGSEnums.ImageLocation>(CGSEnums.ImageLocation.eImageStretched);
    private CGSTypeEnum<CGSEnums.TileType> m_extTile = new CGSTypeEnum<CGSEnums.TileType>(CGSEnums.TileType.eTileNone);
    private CGSTypePointUnit m_extManualPosition = new CGSTypePointUnit();
    private BufferedImage m_extImage = null;
    private Color m_forcedBlendingColor = null;

    public CGSTypeFillEffect() {
    }

    public CGSTypeFillEffect(CGSTypeFillEffect cGSTypeFillEffect) {
        this.setValue(cGSTypeFillEffect);
    }

    public void setValue(CGSTypeFillEffect cGSTypeFillEffect) {
        this.m_fillType = cGSTypeFillEffect.m_fillType;
        this.m_gradientType.setValue(cGSTypeFillEffect.m_gradientType);
        this.m_gradientDirection.setValue(cGSTypeFillEffect.m_gradientDirection);
        this.m_gradientAngle = cGSTypeFillEffect.m_gradientAngle;
        this.m_gradientInnerRadius.setValue(cGSTypeFillEffect.m_gradientInnerRadius);
        this.m_gradientOuterRadius.setValue(cGSTypeFillEffect.m_gradientOuterRadius);
        this.m_gradientBeginPt.setValue(cGSTypeFillEffect.m_gradientBeginPt);
        this.m_gradientEndPt.setValue(cGSTypeFillEffect.m_gradientEndPt);
        this.m_gradientPercent = cGSTypeFillEffect.m_gradientPercent;
        this.m_gradient.setSize(0);
        for (int i = 0; i < cGSTypeFillEffect.m_gradient.size(); ++i) {
            this.m_gradient.addElement(new Gradient(cGSTypeFillEffect.m_gradient.elementAt(i)));
        }
        this.m_gradientSolidColor = cGSTypeFillEffect.m_gradientSolidColor;
        this.m_patternType.setValue(cGSTypeFillEffect.m_patternType);
        this.m_patternTransparent = cGSTypeFillEffect.m_patternTransparent;
        this.m_patternBackColor = cGSTypeFillEffect.m_patternBackColor;
        this.m_patternForeColor = cGSTypeFillEffect.m_patternForeColor;
        this.m_extUrl = cGSTypeFillEffect.m_extUrl;
        this.m_extFilename = cGSTypeFillEffect.m_extFilename;
        this.m_extAlpha = cGSTypeFillEffect.m_extAlpha;
        this.m_extLocation.setValue(cGSTypeFillEffect.m_extLocation);
        this.m_extTile.setValue(cGSTypeFillEffect.m_extTile);
        this.m_extManualPosition.setValue(cGSTypeFillEffect.m_extManualPosition);
        this.m_extImage = cGSTypeFillEffect.m_extImage;
        this.m_defaultColor = cGSTypeFillEffect.m_defaultColor;
    }

    public void setValueFromLDX(Element element, String string) {
        Element element2;
        Element element3;
        Element element4 = element3 = string == null ? element : element.element(string);
        if (element3 == null) {
            return;
        }
        Element element5 = (Element)element3.elements().get(0);
        if (element5.getName().compareTo("pattern") == 0) {
            this.m_fillType.setValue(CGSEnums.FillType.eFillPattern);
            this.m_patternType.setValueFromLDX(element5, "type", CGSEnums.PatternType.ePatternNone);
            this.m_patternTransparent = CMHelper.getBooleanValue(element5, "bgTransparent", false);
            this.m_patternBackColor.setValueFromLDX(element5, "bgColor", Color.WHITE);
            this.m_patternForeColor.setValueFromLDX(element5, "fgColor", Color.BLACK);
        } else if (element5.getName().compareTo("gradient") == 0) {
            this.m_fillType.setValue(CGSEnums.FillType.eFillGradient);
            element2 = (Element)element5.elements().get(0);
            if (element2.getName().compareTo("linear") == 0) {
                this.m_gradientType.setValue(CGSEnums.GradientType.eGradientLinear);
                this.setGradientAngle(CMHelper.getDoubleValue(element2, "angle", 0.0));
            } else if (element2.getName().compareTo("radialLine") == 0) {
                this.m_gradientType.setValue(CGSEnums.GradientType.eGradientRadialLine);
                this.m_gradientInnerRadius.setValueFromLDX(element2, "innerRadius");
                this.m_gradientOuterRadius.setValueFromLDX(element2, "outerRadius");
                this.m_gradientBeginPt.setValueFromLDX(element2, "beginPoint");
                this.m_gradientEndPt.setValueFromLDX(element2, "endPoint");
            } else if (element2.getName().compareTo("radialRect") == 0) {
                this.m_gradientType.setValue(CGSEnums.GradientType.eGradientRadialRect);
                this.m_gradientPercent = CMHelper.getDoubleValue(element2, "percent", 0.0);
            }
            List list = element5.elements("colors");
            for (int i = 0; i < list.size(); ++i) {
                Gradient gradient = new Gradient();
                gradient.m_color.setValueFromLDX((Element)list.get(i), "color", Color.RED);
                gradient.m_percent = CMHelper.getDoubleValue((Element)list.get(i), "percent", 0.0);
                this.m_gradient.addElement(gradient);
            }
        } else if (element5.getName().compareTo("image") == 0) {
            this.m_fillType.setValue(CGSEnums.FillType.eFillImage);
            this.m_extUrl = CMHelper.getStringValue(element5, "name", null);
            this.m_extFilename = CMHelper.getStringValue(element5, "filename", null);
            this.m_extAlpha = CMHelper.getIntValue(element5, "alpha", 255);
            this.m_extLocation.setValueFromLDX(element5, "location", CGSEnums.ImageLocation.eImageStretched);
            this.m_extTile.setValueFromLDX(element5, "tile", CGSEnums.TileType.eTileNone);
            this.m_extManualPosition.setValueFromLDX(element5, "manualPosition");
            if (this.m_extUrl != null) {
                this.m_extImage = this.getImageFromURLOrFilename();
            }
        } else {
            CMHelper.CGS_ASSERT(false, "XML parse error. Unknown fillEffect type.");
        }
        if (element3.elements().size() == 2) {
            element2 = (Element)element3.elements().get(1);
            this.m_defaultColor.setValueFromLDX(element2, null, Color.BLACK);
        }
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        CMHelper.CGS_ASSERT(dataOutputStream != null, "NULL pStream");
        this.m_fillType.save(dataOutputStream);
        switch (this.m_fillType.getValue()) {
            case eFillSolid: {
                this.m_defaultColor.save(dataOutputStream);
                break;
            }
            case eFillGradient: {
                this.m_gradientType.save(dataOutputStream);
                switch (this.m_gradientType.getValue()) {
                    case eGradientLinear: {
                        dataOutputStream.writeDouble(this.m_gradientAngle);
                        break;
                    }
                    case eGradientRadialLine: {
                        this.m_gradientInnerRadius.save(dataOutputStream);
                        this.m_gradientOuterRadius.save(dataOutputStream);
                        this.m_gradientBeginPt.save(dataOutputStream);
                        this.m_gradientEndPt.save(dataOutputStream);
                        break;
                    }
                    case eGradientRadialRect: {
                        dataOutputStream.writeDouble(this.m_gradientPercent);
                        break;
                    }
                }
                dataOutputStream.writeInt(this.m_gradient.size());
                for (int i = 0; i < this.m_gradient.size(); ++i) {
                    this.m_gradient.get((int)i).m_color.save(dataOutputStream);
                    dataOutputStream.writeDouble(this.m_gradient.get((int)i).m_percent);
                }
                break;
            }
            case eFillPattern: {
                this.m_patternType.save(dataOutputStream);
                dataOutputStream.writeBoolean(this.m_patternTransparent);
                this.m_patternBackColor.save(dataOutputStream);
                this.m_patternForeColor.save(dataOutputStream);
                break;
            }
            case eFillImage: {
                CMHelper.writeNullableString(dataOutputStream, this.m_extFilename);
                CMHelper.writeNullableString(dataOutputStream, this.m_extUrl);
                dataOutputStream.writeInt(this.m_extAlpha);
                this.m_extLocation.save(dataOutputStream);
                this.m_extTile.save(dataOutputStream);
                this.m_extManualPosition.save(dataOutputStream);
                break;
            }
        }
    }

    public void restore(DataInputStream dataInputStream) throws IOException {
        CMHelper.CGS_ASSERT(dataInputStream != null, "NULL pStream");
        this.m_fillType.restore(dataInputStream);
        switch (this.m_fillType.getValue()) {
            case eFillSolid: {
                this.m_defaultColor.restore(dataInputStream);
                break;
            }
            case eFillGradient: {
                this.m_gradientType.restore(dataInputStream);
                switch (this.m_gradientType.getValue()) {
                    case eGradientLinear: {
                        this.m_gradientAngle = dataInputStream.readDouble();
                        break;
                    }
                    case eGradientRadialLine: {
                        this.m_gradientInnerRadius.restore(dataInputStream);
                        this.m_gradientOuterRadius.restore(dataInputStream);
                        this.m_gradientBeginPt.restore(dataInputStream);
                        this.m_gradientEndPt.restore(dataInputStream);
                        break;
                    }
                    case eGradientRadialRect: {
                        this.m_gradientPercent = dataInputStream.readDouble();
                        break;
                    }
                }
                int n = dataInputStream.readInt();
                this.m_gradient.setSize(n);
                for (int i = 0; i < n; ++i) {
                    Gradient gradient = this.m_gradient.get(i);
                    if (gradient == null) {
                        gradient = new Gradient();
                    }
                    gradient.m_color.restore(dataInputStream);
                    gradient.m_percent = dataInputStream.readDouble();
                    this.m_gradient.setElementAt(gradient, i);
                }
                break;
            }
            case eFillPattern: {
                this.m_patternType.restore(dataInputStream);
                this.m_patternTransparent = dataInputStream.readBoolean();
                this.m_patternBackColor.restore(dataInputStream);
                this.m_patternForeColor.restore(dataInputStream);
                break;
            }
            case eFillImage: {
                this.m_extFilename = CMHelper.readNullableString(dataInputStream);
                this.m_extUrl = CMHelper.readNullableString(dataInputStream);
                this.m_extAlpha = dataInputStream.readInt();
                this.m_extLocation.restore(dataInputStream);
                this.m_extTile.restore(dataInputStream);
                this.m_extManualPosition.restore(dataInputStream);
                break;
            }
        }
    }

    public CGSTypeFillEffect getValue() {
        return this;
    }

    public static int getTokenEnd(String string, int n) {
        CMHelper.CGS_ASSERT(string != null, "null pString");
        while (string.charAt(n) != ',' && string.charAt(n) != '}') {
            CMHelper.CGS_ASSERT(string.length() != n - 1, "malformed fillEffect string");
            ++n;
        }
        return n;
    }

    public static CGSTypeFillEffect decode(String string) {
        CGSTypeFillEffect cGSTypeFillEffect = new CGSTypeFillEffect();
        int n = 1;
        int n2 = CGSTypeFillEffect.getTokenEnd(string, n);
        int n3 = CGSTypeInt.decode(string.substring(n, n2));
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                cGSTypeFillEffect.setSolidColor(CGSTypeColor.decode(string.substring(n, n2)));
                break;
            }
            case 2: {
                cGSTypeFillEffect.setType(CGSEnums.FillType.eFillGradient);
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                cGSTypeFillEffect.setGradientDirection(CGSTypeEnum.decode(CGSEnums.GradientDirection.class, string.substring(n, n2)));
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                cGSTypeFillEffect.setGradientFromColor(CGSTypeColor.decode(string.substring(n, n2)));
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                cGSTypeFillEffect.setGradientToColor(CGSTypeColor.decode(string.substring(n, n2)));
                if (string.charAt(n2) != ',') break;
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                cGSTypeFillEffect.setDefaultColor(CGSTypeColor.decode(string.substring(n, n2)));
                break;
            }
            case 3: {
                cGSTypeFillEffect.setType(CGSEnums.FillType.eFillPattern);
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                cGSTypeFillEffect.setPatternType(CGSTypeEnum.decode(CGSEnums.PatternType.class, string.substring(n, n2)));
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                cGSTypeFillEffect.setPatternBackColor(CGSTypeColor.decode(string.substring(n, n2)));
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                cGSTypeFillEffect.setPatternForeColor(CGSTypeColor.decode(string.substring(n, n2)));
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                cGSTypeFillEffect.setPatternTransparent(CGSTypeBool.decode(string.substring(n, n2)));
                if (string.charAt(n2) != ',') break;
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                cGSTypeFillEffect.setDefaultColor(CGSTypeColor.decode(string.substring(n, n2)));
                break;
            }
            case 4: {
                CMHelper.CGS_ASSERT(false, "FillEffect using a file is not supported.");
                break;
            }
            case 5: {
                Object object;
                cGSTypeFillEffect.setType(CGSEnums.FillType.eFillGradient);
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                cGSTypeFillEffect.setGradientType(CGSTypeEnum.decode(CGSEnums.GradientType.class, string.substring(n, n2)));
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                int n4 = CGSTypeInt.decode(string.substring(n, n2));
                for (int i = 0; i < n4; ++i) {
                    n = n2 + 1;
                    n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                    object = CGSTypeColor.decode(string.substring(n, n2));
                    n = n2 + 1;
                    n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                    double d = CGSTypeDouble.decode(string.substring(n, n2));
                    cGSTypeFillEffect.addGradient((Color)object, d);
                }
                switch (cGSTypeFillEffect.getGradientType()) {
                    case eGradientLinear: {
                        n = n2 + 1;
                        n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                        cGSTypeFillEffect.setGradientAngle(CGSTypeDouble.decode(string.substring(n, n2)));
                        break;
                    }
                    case eGradientRadialLine: {
                        CGSTypePointUnit cGSTypePointUnit = new CGSTypePointUnit();
                        n = n2 + 1;
                        n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                        cGSTypePointUnit.setX(CGSTypeDouble.decode(string.substring(n, n2)));
                        n = n2 + 1;
                        n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                        cGSTypePointUnit.setXUnitType(CGSTypeEnum.decode(CGSTypePointUnit.UnitType.class, string.substring(n, n2)));
                        n = n2 + 1;
                        n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                        cGSTypePointUnit.setY(CGSTypeDouble.decode(string.substring(n, n2)));
                        n = n2 + 1;
                        n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                        cGSTypePointUnit.setYUnitType(CGSTypeEnum.decode(CGSTypePointUnit.UnitType.class, string.substring(n, n2)));
                        cGSTypeFillEffect.setGradientBegin(cGSTypePointUnit);
                        n = n2 + 1;
                        n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                        cGSTypePointUnit.setX(CGSTypeDouble.decode(string.substring(n, n2)));
                        n = n2 + 1;
                        n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                        cGSTypePointUnit.setXUnitType(CGSTypeEnum.decode(CGSTypePointUnit.UnitType.class, string.substring(n, n2)));
                        n = n2 + 1;
                        n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                        cGSTypePointUnit.setY(CGSTypeDouble.decode(string.substring(n, n2)));
                        n = n2 + 1;
                        n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                        cGSTypePointUnit.setYUnitType(CGSTypeEnum.decode(CGSTypePointUnit.UnitType.class, string.substring(n, n2)));
                        cGSTypeFillEffect.setGradientEnd(cGSTypePointUnit);
                        object = new CGSTypeLength();
                        n = n2 + 1;
                        n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                        ((CGSTypeLength)object).setLength(CGSTypeDouble.decode(string.substring(n, n2)));
                        n = n2 + 1;
                        n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                        ((CGSTypeLength)object).setLengthType(CGSTypeEnum.decode(CGSTypeLength.LengthType.class, string.substring(n, n2)));
                        cGSTypeFillEffect.setGradientInnerRadius((CGSTypeLength)object);
                        n = n2 + 1;
                        n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                        ((CGSTypeLength)object).setLength(CGSTypeDouble.decode(string.substring(n, n2)));
                        n = n2 + 1;
                        n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                        ((CGSTypeLength)object).setLengthType(CGSTypeEnum.decode(CGSTypeLength.LengthType.class, string.substring(n, n2)));
                        cGSTypeFillEffect.setGradientOuterRadius((CGSTypeLength)object);
                        break;
                    }
                    case eGradientRadialRect: {
                        n = n2 + 1;
                        n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                        cGSTypeFillEffect.setGradientPercent(CGSTypeDouble.decode(string.substring(n, n2)));
                        break;
                    }
                }
                if (string.charAt(n2) != ',') break;
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                cGSTypeFillEffect.setDefaultColor(CGSTypeColor.decode(string.substring(n, n2)));
                break;
            }
            case 6: {
                CMHelper.CGS_ASSERT(false, "FillEffect using a file is not supported.");
                break;
            }
            case 7: {
                cGSTypeFillEffect.setType(CGSEnums.FillType.eFillImage);
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                String string2 = CGSTypeString.decode(string.substring(n, n2));
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                String string3 = CGSTypeString.decode(string.substring(n, n2));
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                CGSEnums.ImageLocation imageLocation = CGSTypeEnum.decode(CGSEnums.ImageLocation.class, string.substring(n, n2));
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                CGSEnums.TileType tileType = CGSTypeEnum.decode(CGSEnums.TileType.class, string.substring(n, n2));
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                int n5 = 255 - CGSTypeInt.decode(string.substring(n, n2));
                CGSTypePointUnit cGSTypePointUnit = new CGSTypePointUnit();
                if (imageLocation == CGSEnums.ImageLocation.eImageManual) {
                    n = n2 + 1;
                    n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                    cGSTypePointUnit.setX(CGSTypeDouble.decode(string.substring(n, n2)));
                    n = n2 + 1;
                    n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                    cGSTypePointUnit.setY(CGSTypeDouble.decode(string.substring(n, n2)));
                    n = n2 + 1;
                    n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                    cGSTypePointUnit.setXUnitType(CGSTypeEnum.decode(CGSTypePointUnit.UnitType.class, string.substring(n, n2)));
                    n = n2 + 1;
                    n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                    cGSTypePointUnit.setYUnitType(CGSTypeEnum.decode(CGSTypePointUnit.UnitType.class, string.substring(n, n2)));
                    cGSTypeFillEffect.setImage(string2, string3, n5, cGSTypePointUnit, tileType);
                } else {
                    cGSTypeFillEffect.setImage(string2, string3, n5, imageLocation, tileType);
                }
                if (string.charAt(n2) != ',') break;
                n = n2 + 1;
                n2 = CGSTypeFillEffect.getTokenEnd(string, n);
                cGSTypeFillEffect.setDefaultColor(CGSTypeColor.decode(string.substring(n, n2)));
                break;
            }
        }
        return cGSTypeFillEffect;
    }

    public void setType(CGSEnums.FillType fillType) {
        this.m_fillType.setValue(fillType);
    }

    public CGSEnums.FillType getType() {
        return this.m_fillType.getValue();
    }

    public boolean isEmpty() {
        return this.m_fillType.getValue() == CGSEnums.FillType.eFillPattern && this.m_patternType.getValue() == CGSEnums.PatternType.ePatternNone;
    }

    public void setDefaultColor(Color color) {
        this.m_defaultColor.setValue(color);
    }

    public Color getDefaultColor() {
        return this.m_defaultColor.getValue();
    }

    public void setSolidColor(Color color) {
        this.m_fillType.setValue(CGSEnums.FillType.eFillPattern);
        this.m_patternType.setValue(CGSEnums.PatternType.ePatternSolid);
        this.m_patternTransparent = true;
        this.m_patternForeColor.setValue(color);
        this.m_patternBackColor.setValue(color);
        this.m_defaultColor.setValue(color);
    }

    public Color getSolidColor() {
        Color color = this.m_defaultColor.getValue();
        if (this.m_fillType.getValue() == CGSEnums.FillType.eFillGradient) {
            if (this.m_gradientSolidColor == null && this.m_gradient.size() != 0) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                for (int i = 0; i < this.m_gradient.size(); ++i) {
                    color = this.m_gradient.elementAt((int)i).m_color.getValue();
                    n += color.getRed();
                    n2 += color.getGreen();
                    n3 += color.getBlue();
                    n4 += color.getAlpha();
                }
                this.m_gradientSolidColor = new Color(GRHelper.RGB(n4 /= this.m_gradient.size(), n /= this.m_gradient.size(), n2 /= this.m_gradient.size(), n3 /= this.m_gradient.size()));
            }
            color = this.m_gradientSolidColor;
        } else if (this.m_fillType.getValue() == CGSEnums.FillType.eFillPattern) {
            if (this.m_patternType.getValue() == CGSEnums.PatternType.ePatternSolid) {
                color = this.m_patternForeColor.getValue();
            } else if (this.m_patternType.getValue() != CGSEnums.PatternType.ePatternNone) {
                color = this.m_patternTransparent ? this.m_patternForeColor.getValue() : this.m_patternBackColor.getValue();
            }
        }
        return color;
    }

    public void setGradientDirection(CGSEnums.GradientDirection gradientDirection) {
        this.m_gradientDirection.setValue(gradientDirection);
        switch (gradientDirection) {
            case eGradientUp: {
                this.m_gradientAngle = 90.0;
                break;
            }
            case eGradientLeft: {
                this.m_gradientAngle = 180.0;
                break;
            }
            case eGradientRight: {
                this.m_gradientAngle = 0.0;
                break;
            }
            case eGradientDown: {
                this.m_gradientAngle = 270.0;
                break;
            }
        }
    }

    public CGSEnums.GradientDirection getGradientDirection() {
        return this.m_gradientDirection.getValue();
    }

    public void setGradientFromColor(Color color) {
        if (this.m_gradient.size() == 0) {
            Gradient gradient = new Gradient(color, 0.0);
            this.m_gradient.addElement(gradient);
        } else {
            this.m_gradient.elementAt((int)0).m_color.setValue(color);
        }
    }

    public Color getGradientFromColor() {
        return this.getGradientColor(0.0);
    }

    public void setGradientToColor(Color color) {
        Gradient gradient;
        if (this.m_gradient.size() == 0) {
            gradient = new Gradient(Color.RED, 0.0);
            this.m_gradient.addElement(gradient);
        }
        if (this.m_gradient.size() == 1) {
            gradient = new Gradient(color, 100.0);
            this.m_gradient.addElement(gradient);
        } else {
            this.m_gradient.elementAt((int)1).m_color.setValue(color);
        }
    }

    public Color getGradientToColor() {
        return this.getGradientColor(100.0);
    }

    public void setGradientType(CGSEnums.GradientType gradientType) {
        this.m_gradientType.setValue(gradientType);
    }

    public CGSEnums.GradientType getGradientType() {
        return this.m_gradientType.getValue();
    }

    public void setGradientAngle(double d) {
        this.m_gradientAngle = d;
        if (d < 45.0 || d >= 315.0) {
            this.m_gradientDirection.setValue(CGSEnums.GradientDirection.eGradientRight);
        } else if (d < 135.0) {
            this.m_gradientDirection.setValue(CGSEnums.GradientDirection.eGradientUp);
        } else if (d < 225.0) {
            this.m_gradientDirection.setValue(CGSEnums.GradientDirection.eGradientLeft);
        } else {
            this.m_gradientDirection.setValue(CGSEnums.GradientDirection.eGradientDown);
        }
    }

    public void adjustForChartRotation(boolean bl, boolean bl2) {
        if (!this.m_adjustForChartRotation) {
            if (this.isSimple(bl || bl2) && this.m_fillType.getValue() == CGSEnums.FillType.eFillGradient) {
                double d = this.getGradientAngle();
                double d2 = Math.cos(d * Math.PI / 180.0);
                double d3 = Math.sin(d * Math.PI / 180.0);
                double d4 = Math.atan2(d3, -d2) * 180.0 / Math.PI;
                d4 -= 90.0;
                while (d4 < 0.0) {
                    d4 += 360.0;
                }
                while (d4 >= 360.0) {
                    d4 -= 360.0;
                }
                this.setGradientAngle(d4);
            }
            this.m_adjustForChartRotation = true;
        }
    }

    public double getGradientAngle() {
        return this.m_gradientAngle;
    }

    public void setGradientInnerRadius(CGSTypeLength cGSTypeLength) {
        this.m_gradientInnerRadius.setValue(cGSTypeLength);
    }

    public CGSTypeLength getGradientInnerRadius() {
        return this.m_gradientInnerRadius;
    }

    public void setGradientOuterRadius(CGSTypeLength cGSTypeLength) {
        this.m_gradientOuterRadius.setValue(cGSTypeLength);
    }

    public CGSTypeLength getGradientOuterRadius() {
        return this.m_gradientOuterRadius;
    }

    public void setGradientBegin(CGSTypePointUnit cGSTypePointUnit) {
        this.m_gradientBeginPt.setValue(cGSTypePointUnit);
    }

    public CGSTypePointUnit getGradientBegin() {
        return this.m_gradientBeginPt;
    }

    public void setGradientEnd(CGSTypePointUnit cGSTypePointUnit) {
        this.m_gradientEndPt = cGSTypePointUnit;
    }

    public CGSTypePointUnit getGradientEnd() {
        return this.m_gradientEndPt;
    }

    public void setGradientPercent(double d) {
        this.m_gradientPercent = d;
    }

    public double getGradientPercent() {
        return this.m_gradientPercent;
    }

    public void addGradient(Color color, double d) {
        Gradient gradient = new Gradient(color, d);
        this.m_gradient.addElement(gradient);
    }

    public int getGradientCount() {
        return this.m_gradient.size();
    }

    public double getGradientPercentAt(int n) {
        return this.m_gradient.get((int)n).m_percent;
    }

    public Color getGradientColorAt(int n) {
        return this.m_gradient.get((int)n).m_color.getValue();
    }

    public Color getGradientColor(double d) {
        Color color = Color.WHITE;
        Color color2 = Color.WHITE;
        double d2 = 0.0;
        if (this.m_gradient.size() == 0) {
            return Color.WHITE;
        }
        if (this.m_gradient.size() == 1) {
            return this.m_gradient.elementAt((int)0).m_color.getValue();
        }
        double d3 = 0.0;
        d3 = d < 0.0 ? 0.0 : (d > 1.0 ? 100.0 : d * 100.0);
        int n = 0;
        for (n = 0; n < this.m_gradient.size(); ++n) {
            if (!(this.m_gradient.elementAt((int)n).m_percent >= d3)) continue;
            color2 = this.m_gradient.elementAt((int)n).m_color.getValue();
            color = n == 0 ? color2 : this.m_gradient.elementAt((int)(n - 1)).m_color.getValue();
            double d4 = this.m_gradient.elementAt((int)n).m_percent;
            double d5 = n == 0 ? 0.0 : this.m_gradient.elementAt((int)(n - 1)).m_percent;
            d2 = d5 == d4 ? 1.0 : (d3 - d5) / (d4 - d5);
            break;
        }
        if (n == this.m_gradient.size()) {
            color2 = color = this.m_gradient.elementAt((int)(this.m_gradient.size() - 1)).m_color.getValue();
            d2 = 1.0;
        }
        int n2 = color.getAlpha();
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        int n6 = color2.getAlpha();
        int n7 = color2.getRed();
        int n8 = color2.getGreen();
        int n9 = color2.getBlue();
        int n10 = (int)((double)n2 * (1.0 - d2) + (double)n6 * d2 + 0.5);
        int n11 = (int)((double)n3 * (1.0 - d2) + (double)n7 * d2 + 0.5);
        int n12 = (int)((double)n4 * (1.0 - d2) + (double)n8 * d2 + 0.5);
        int n13 = (int)((double)n5 * (1.0 - d2) + (double)n9 * d2 + 0.5);
        return new Color(n11, n12, n13, n10);
    }

    public void setPatternType(CGSEnums.PatternType patternType) {
        this.m_patternType.setValue(patternType);
    }

    public CGSEnums.PatternType getPatternType() {
        return this.m_patternType.getValue();
    }

    public void setPatternTransparent(boolean bl) {
        this.m_patternTransparent = bl;
    }

    public boolean getPatternTransparent() {
        return this.m_patternTransparent;
    }

    public void setPatternBackColor(Color color) {
        this.m_patternBackColor.setValue(color);
    }

    public Color getPatternBackColor() {
        return this.m_patternBackColor.getValue();
    }

    public void setPatternForeColor(Color color) {
        this.m_patternForeColor.setValue(color);
    }

    public Color getPatternForeColor() {
        return this.m_patternForeColor.getValue();
    }

    public void setImage(String string, String string2, int n, CGSEnums.ImageLocation imageLocation, CGSEnums.TileType tileType) {
        this.m_extFilename = string;
        this.m_extUrl = string2;
        this.m_extAlpha = n;
        this.m_extLocation.setValue(imageLocation);
        this.m_extTile.setValue(tileType);
        this.m_extImage = null;
        if (this.m_extUrl != null || this.m_extFilename != null) {
            this.m_extImage = this.getImageFromURLOrFilename();
        }
    }

    public void setImage(String string, String string2, int n, CGSTypePointUnit cGSTypePointUnit, CGSEnums.TileType tileType) {
        this.m_extFilename = string;
        this.m_extUrl = string2;
        this.m_extAlpha = n;
        this.m_extLocation.setValue(CGSEnums.ImageLocation.eImageManual);
        this.m_extTile.setValue(tileType);
        this.m_extManualPosition.setValue(cGSTypePointUnit);
        this.m_extImage = null;
        if (this.m_extUrl != null || this.m_extFilename != null) {
            this.m_extImage = this.getImageFromURLOrFilename();
        }
    }

    private BufferedImage getImageFromURLOrFilename() {
        Serializable serializable;
        BufferedImage bufferedImage = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            ImageIO.setUseCache(false);
            serializable = new URL(this.m_extUrl);
            String string = new URI(this.m_extUrl).normalize().getPath();
            String string2 = ((URL)serializable).getPath();
            if (!string2.equals(string)) {
                String string3 = ((URL)serializable).getProtocol();
                String string4 = ((URL)serializable).getHost();
                int n = ((URL)serializable).getPort();
                serializable = new URL(string3, string4, n, string);
            }
            if (!(((URL)serializable).getProtocol().equalsIgnoreCase("http") || ((URL)serializable).getProtocol().equalsIgnoreCase("https") || ((URL)serializable).getProtocol().equalsIgnoreCase("file"))) {
                throw new RuntimeException("Unsupported URL protocol.");
            }
            bufferedImage = ImageIO.read((URL)serializable);
        }
        catch (Exception exception) {
            stringBuilder.append("ImageIO.read URL failed: ");
            stringBuilder.append(this.m_extUrl);
            stringBuilder.append("\n");
            for (Throwable throwable = exception; throwable != null; throwable = throwable.getCause()) {
                stringBuilder.append(throwable.toString());
                stringBuilder.append("\n");
            }
            try {
                bufferedImage = ImageIO.read(new File(this.m_extFilename));
            }
            catch (Exception exception2) {
                stringBuilder.append("ImageIO.read file failed: ");
                stringBuilder.append(this.m_extFilename);
                stringBuilder.append("\n");
                for (Throwable throwable = exception2; throwable != null; throwable = throwable.getCause()) {
                    stringBuilder.append(throwable.toString());
                    stringBuilder.append("\n");
                }
            }
        }
        if (bufferedImage == null && this.m_extUrl.startsWith("http://localhost/cgs/")) {
            serializable = new StringBuilder(".");
            ((StringBuilder)serializable).append(this.m_extUrl.substring(20, this.m_extUrl.length()));
            try {
                bufferedImage = ImageIO.read(new File(((StringBuilder)serializable).toString()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bufferedImage == null) {
            CMHelper.CGS_ASSERT(false, "Error reading image resource\n" + stringBuilder.toString());
        }
        return bufferedImage;
    }

    public boolean isSimple(boolean bl) {
        switch (this.m_fillType.getValue()) {
            case eFillPattern: {
                return true;
            }
            case eFillGradient: {
                if (bl && this.m_gradient.size() == 2 && this.m_gradientType.getValue() == CGSEnums.GradientType.eGradientLinear && (int)this.m_gradientAngle % 90 == 0) {
                    return true;
                }
                if (bl || this.m_gradientType.getValue() != CGSEnums.GradientType.eGradientLinear) break;
                return true;
            }
        }
        return false;
    }

    public BufferedImage createImage(GRDevice gRDevice, int n, int n2, boolean bl, boolean bl2) {
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        if (this.m_adjustForChartRotation && this.m_fillType.getValue() == CGSEnums.FillType.eFillImage) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        GRBufferedImage gRBufferedImage = new GRBufferedImage(n, n2);
        switch (this.m_fillType.getValue()) {
            case eFillPattern: {
                this.createImageFromPattern(gRDevice, gRBufferedImage, bl);
                break;
            }
            case eFillGradient: {
                this.createImageFromGradient(gRDevice, gRBufferedImage, bl);
                break;
            }
            case eFillImage: {
                this.createImageFromImage(gRDevice, gRBufferedImage, bl, bl2);
                break;
            }
        }
        return gRBufferedImage.getImage();
    }

    private void createImageFromPattern(GRDevice gRDevice, GRBufferedImage gRBufferedImage, boolean bl) {
        int n = gRBufferedImage.getWidth();
        int n2 = gRBufferedImage.getHeight();
        switch (this.m_patternType.getValue()) {
            case ePatternNone: {
                break;
            }
            case ePatternSolid: {
                GRHelper.initBufferedImage(gRBufferedImage.getImage(), this.m_patternForeColor.getRGB());
                break;
            }
            default: {
                int n3;
                int[] nArray = null;
                switch (this.m_patternType.getValue()) {
                    case ePatternHorizontal: {
                        nArray = patternHorz;
                        break;
                    }
                    case ePatternVertical: {
                        nArray = patternVert;
                        break;
                    }
                    case ePatternForwardDiagonal: {
                        nArray = patternForward;
                        break;
                    }
                    case ePatternBackwardDiagonal: {
                        nArray = patternBackward;
                        break;
                    }
                    case ePatternCross: {
                        nArray = patternCross;
                        break;
                    }
                    case ePatternDiagonalCross: {
                        nArray = patternDiagonalCross;
                    }
                }
                if (nArray == null) break;
                int[] nArray2 = new int[64];
                int n4 = 0;
                if (!this.m_patternTransparent) {
                    n4 = this.m_patternBackColor.getRGB();
                }
                int n5 = this.m_patternForeColor.getRGB();
                double d = (double)this.m_patternForeColor.getValue().getAlpha() / 255.0;
                for (int i = 0; i < 64; ++i) {
                    int n6 = nArray[i];
                    n3 = GRHelper.updateAlpha((int)((double)(255 - n6) * d), n5);
                    nArray2[i] = GRHelper.blendPixels(n4, n3);
                }
                WritableRaster writableRaster = gRBufferedImage.getImage().getRaster();
                int[] nArray3 = ((DataBufferInt)writableRaster.getDataBuffer()).getData();
                for (n3 = 0; n3 < n2; ++n3) {
                    int n7 = n3 % 8;
                    for (int i = 0; i < n; ++i) {
                        int n8 = i % 8;
                        nArray3[n3 * n + i] = nArray2[n7 * 8 + n8];
                    }
                }
            }
        }
        if (bl) {
            GRHelper.mirrorBufferedImage(gRBufferedImage.getImage());
        }
    }

    private void createImageFromGradient(GRDevice gRDevice, GRBufferedImage gRBufferedImage, boolean bl) {
        int n = gRBufferedImage.getWidth();
        int n2 = gRBufferedImage.getHeight();
        this.initializeGradientParams(gRDevice, n, n2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = this.getGradientScaler(j, i);
                Color color = this.getGradientColor(d);
                gRBufferedImage.setRGB(j, n2 - 1 - i, color.getRGB());
            }
        }
        if (bl) {
            GRHelper.mirrorBufferedImage(gRBufferedImage.getImage());
        }
    }

    public double getGradientXYPercent(double d, double d2, double d3, double d4) {
        if (d == 0.0 || d2 == 0.0) {
            return 0.0;
        }
        this.initializeGradientParams(null, 100, 100);
        int n = GRHelper.GR_ROUND(d3 * 100.0 / d);
        int n2 = GRHelper.GR_ROUND(d4 * 100.0 / d2);
        return this.getGradientScaler(n, n2) * 100.0;
    }

    public int getNativeImageWidth() {
        if (this.m_extImage == null) {
            return 0;
        }
        return this.m_extImage.getWidth();
    }

    public int getNativeImageHeight() {
        if (this.m_extImage == null) {
            return 0;
        }
        return this.m_extImage.getHeight();
    }

    private void createImageFromImage(GRDevice gRDevice, GRBufferedImage gRBufferedImage, boolean bl, boolean bl2) {
        int n;
        if (this.m_extImage == null) {
            return;
        }
        int n2 = gRBufferedImage.getWidth();
        int n3 = gRBufferedImage.getHeight();
        CGSEnums.ImageLocation imageLocation = this.m_extLocation.getValue();
        if (bl) {
            imageLocation = this.getMirroredImageLocation(gRDevice, n2);
        }
        BufferedImage bufferedImage = this.m_extImage;
        if (bl2) {
            bufferedImage = new BufferedImage(this.m_extImage.getWidth(), this.m_extImage.getHeight(), 2);
            bufferedImage.getGraphics().drawImage(this.m_extImage, 0, 0, null);
            GRHelper.mirrorBufferedImage(bufferedImage);
        }
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        int n6 = 0;
        int n7 = 0;
        switch (imageLocation) {
            case eImageBottomLeft: {
                n6 = 0;
                n7 = n3 - n5;
                break;
            }
            case eImageBottomCenter: {
                n6 = n2 / 2 - n4 / 2;
                n7 = n3 - n5;
                break;
            }
            case eImageBottomRight: {
                n6 = n2 - n4;
                n7 = n3 - n5;
                break;
            }
            case eImageCenterLeft: {
                n6 = 0;
                n7 = n3 / 2 - n5 / 2;
                break;
            }
            case eImageCenterCenter: {
                n6 = n2 / 2 - n4 / 2;
                n7 = n3 / 2 - n5 / 2;
                break;
            }
            case eImageCenterRight: {
                n6 = n2 - n4;
                n7 = n3 / 2 - n5 / 2;
                break;
            }
            case eImageTopLeft: {
                n6 = 0;
                n7 = 0;
                break;
            }
            case eImageTopCenter: {
                n6 = n2 / 2 - n4 / 2;
                n7 = 0;
                break;
            }
            case eImageTopRight: {
                n6 = n2 - n4;
                n7 = 0;
                break;
            }
            case eImageManual: {
                double d = this.m_extManualPosition.getX(gRDevice, n2);
                double d2 = this.m_extManualPosition.getY(gRDevice, n3);
                if (bl) {
                    d = (double)n2 - d - (double)n4;
                }
                n6 = (int)Math.max(0.0, d);
                n7 = (int)Math.max(0.0, (double)(n3 - 1) - d2);
                break;
            }
        }
        int n8 = n4 - n6 % n4;
        if (n8 == n4) {
            n8 = 0;
        }
        if ((n = n5 - n7 % n5) == n5) {
            n = 0;
        }
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n9;
                int n10;
                int n11 = 0;
                int n12 = 0;
                boolean bl3 = false;
                if (this.m_extLocation.getValue() == CGSEnums.ImageLocation.eImageStretched) {
                    n11 = j * n4 / n2;
                    n12 = i * n5 / n3;
                } else {
                    n11 = (j + n8) % n4;
                    n12 = (i + n) % n5;
                    switch (this.m_extTile.getValue()) {
                        case eTileNone: {
                            if (j >= n6 && j < n6 + n4 && i >= n7 && i < n7 + n5) break;
                            bl3 = true;
                            break;
                        }
                        case eTileHorizontal: {
                            if (i >= n7 && i < n7 + n5) break;
                            bl3 = true;
                            break;
                        }
                        case eTileVertical: {
                            if (j >= n6 && j < n6 + n4) break;
                            bl3 = true;
                            break;
                        }
                    }
                }
                Color color = this.getForcedBlendingColor();
                if (color != null) {
                    n10 = bufferedImage.getRGB(n11, n12);
                    n9 = color.getRGB();
                    int n13 = GRHelper.blendPixels(n9, n10);
                    gRBufferedImage.setRGB(j, i, n13);
                    continue;
                }
                if (bl3) continue;
                n10 = bufferedImage.getRGB(n11, n12);
                n9 = GRHelper.getAlpha(n10);
                if (this.m_extAlpha != 255) {
                    if ((n9 -= 255 - this.m_extAlpha) < 0) {
                        n9 = 0;
                    }
                    n10 = GRHelper.updateAlpha(n9, n10);
                }
                gRBufferedImage.setRGB(j, i, n10);
            }
        }
    }

    public CGSEnums.ImageLocation getMirroredImageLocation(GRDevice gRDevice, double d) {
        CGSEnums.ImageLocation imageLocation = this.m_extLocation.getValue();
        switch (imageLocation) {
            case eImageBottomLeft: {
                imageLocation = CGSEnums.ImageLocation.eImageBottomRight;
                break;
            }
            case eImageBottomRight: {
                imageLocation = CGSEnums.ImageLocation.eImageBottomLeft;
                break;
            }
            case eImageCenterLeft: {
                imageLocation = CGSEnums.ImageLocation.eImageCenterRight;
                break;
            }
            case eImageCenterRight: {
                imageLocation = CGSEnums.ImageLocation.eImageCenterLeft;
                break;
            }
            case eImageTopLeft: {
                imageLocation = CGSEnums.ImageLocation.eImageTopRight;
                break;
            }
            case eImageTopRight: {
                imageLocation = CGSEnums.ImageLocation.eImageTopLeft;
                break;
            }
        }
        return imageLocation;
    }

    private void initializeGradientParams(GRDevice gRDevice, int n, int n2) {
        if (this.m_gradientParams == null) {
            this.m_gradientParams = new GradientParams();
        }
        this.m_gradientParams.rectWidth = n;
        this.m_gradientParams.rectHeight = n2;
        this.m_gradientParams.xCenter = this.m_gradientParams.rectWidth / 2.0;
        this.m_gradientParams.yCenter = this.m_gradientParams.rectHeight / 2.0;
        switch (this.m_gradientType.getValue()) {
            case eGradientRadialLine: {
                this.m_gradientParams.lineA_point1.x = this.m_gradientBeginPt.getX(gRDevice, this.m_gradientParams.rectWidth);
                this.m_gradientParams.lineA_point1.y = this.m_gradientBeginPt.getY(gRDevice, this.m_gradientParams.rectHeight);
                this.m_gradientParams.lineA_point2.x = this.m_gradientEndPt.getX(gRDevice, this.m_gradientParams.rectWidth);
                this.m_gradientParams.lineA_point2.y = this.m_gradientEndPt.getY(gRDevice, this.m_gradientParams.rectHeight);
                this.m_gradientParams.innerRadius = this.m_gradientInnerRadius.getLength(gRDevice, this.m_gradientParams.rectWidth, this.m_gradientParams.rectHeight);
                this.m_gradientParams.outerRadius = this.m_gradientOuterRadius.getLength(gRDevice, this.m_gradientParams.rectWidth, this.m_gradientParams.rectHeight);
                break;
            }
            case eGradientRadialRect: {
                double d = this.m_gradientPercent;
                double d2 = Math.min(this.m_gradientParams.rectWidth, this.m_gradientParams.rectHeight);
                this.m_gradientParams.innerRadius = 0.0;
                double d3 = Math.min(d2 / 2.0 - this.m_gradientParams.innerRadius, d2 / 2.0 * (100.0 - d) / 100.0);
                this.m_gradientParams.outerRadius = d3 + this.m_gradientParams.innerRadius;
                this.m_gradientParams.left = d3 + this.m_gradientParams.innerRadius;
                this.m_gradientParams.top = this.m_gradientParams.rectHeight - d3 - this.m_gradientParams.innerRadius - 1.0;
                this.m_gradientParams.right = this.m_gradientParams.rectWidth - d3 - this.m_gradientParams.innerRadius - 1.0;
                this.m_gradientParams.bottom = d3 + this.m_gradientParams.innerRadius;
                break;
            }
            default: {
                double d = this.m_gradientAngle * 100.0 / 360.0;
                this.m_gradientParams.pointFrom = this.getGradientLinearPoint(d);
                double d4 = d + 50.0;
                if (d4 > 100.0) {
                    d4 -= 100.0;
                }
                this.m_gradientParams.pointTo = this.getGradientLinearPoint(d4);
                break;
            }
        }
    }

    private GRPoint getGradientLinearPoint(double d) {
        GRPoint gRPoint = new GRPoint();
        if (d >= 12.5 && d < 37.5) {
            gRPoint.x = this.m_gradientParams.rectWidth * (d - 12.5) / 25.0;
            gRPoint.y = 0.0;
        } else if (d >= 37.5 && d < 62.5) {
            gRPoint.x = this.m_gradientParams.rectWidth;
            gRPoint.y = this.m_gradientParams.rectHeight * (d - 37.5) / 25.0;
        } else if (d >= 62.5 && d < 87.5) {
            gRPoint.x = this.m_gradientParams.rectWidth * (1.0 - (d - 62.5) / 25.0);
            gRPoint.y = this.m_gradientParams.rectHeight;
        } else {
            if (d < 87.5) {
                d += 100.0;
            }
            gRPoint.x = 0.0;
            gRPoint.y = this.m_gradientParams.rectHeight * (1.0 - (d - 87.5) / 25.0);
        }
        return gRPoint;
    }

    private double getGradientScaler(int n, int n2) {
        double d = 0.0;
        Intersect intersect = null;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (this.m_gradientType.getValue()) {
            case eGradientRadialLine: {
                GRPoint gRPoint;
                d3 = this.m_gradientParams.lineA_point2.x - this.m_gradientParams.lineA_point1.x;
                d4 = this.m_gradientParams.lineA_point2.y - this.m_gradientParams.lineA_point1.y;
                if (d3 == 0.0 && d4 == 0.0) {
                    d = 0.0;
                } else {
                    gRPoint = new GRPoint();
                    GRPoint gRPoint2 = new GRPoint();
                    gRPoint.x = n;
                    gRPoint.y = n2;
                    gRPoint2.x = (double)n - d4;
                    gRPoint2.y = (double)n2 + d3;
                    intersect = this.lineIntersect(this.m_gradientParams.lineA_point1, this.m_gradientParams.lineA_point2, gRPoint, gRPoint2);
                    d = intersect.lineA_scaler;
                }
                if (d <= 0.0 || d >= 1.0) {
                    gRPoint = d <= 0.0 ? this.m_gradientParams.lineA_point1 : this.m_gradientParams.lineA_point2;
                    d2 = Math.sqrt(((double)n - gRPoint.x) * ((double)n - gRPoint.x) + ((double)n2 - gRPoint.y) * ((double)n2 - gRPoint.y));
                } else {
                    d2 = Math.sqrt(((double)n - intersect.intersectPt.x) * ((double)n - intersect.intersectPt.x) + ((double)n2 - intersect.intersectPt.y) * ((double)n2 - intersect.intersectPt.y));
                }
                d = (d2 - this.m_gradientParams.innerRadius) / (this.m_gradientParams.outerRadius - this.m_gradientParams.innerRadius);
                break;
            }
            case eGradientRadialRect: {
                d2 = (double)n < this.m_gradientParams.left ? ((double)n2 < this.m_gradientParams.bottom ? Math.sqrt((this.m_gradientParams.left - (double)n) * (this.m_gradientParams.left - (double)n) + (this.m_gradientParams.bottom - (double)n2) * (this.m_gradientParams.bottom - (double)n2)) : ((double)n2 > this.m_gradientParams.top ? Math.sqrt((this.m_gradientParams.left - (double)n) * (this.m_gradientParams.left - (double)n) + ((double)n2 - this.m_gradientParams.top) * ((double)n2 - this.m_gradientParams.top)) : this.m_gradientParams.left - (double)n)) : ((double)n > this.m_gradientParams.right ? ((double)n2 < this.m_gradientParams.bottom ? Math.sqrt(((double)n - this.m_gradientParams.right) * ((double)n - this.m_gradientParams.right) + (this.m_gradientParams.bottom - (double)n2) * (this.m_gradientParams.bottom - (double)n2)) : ((double)n2 > this.m_gradientParams.top ? Math.sqrt(((double)n - this.m_gradientParams.right) * ((double)n - this.m_gradientParams.right) + ((double)n2 - this.m_gradientParams.top) * ((double)n2 - this.m_gradientParams.top)) : (double)n - this.m_gradientParams.right)) : ((double)n2 < this.m_gradientParams.bottom ? this.m_gradientParams.bottom - (double)n2 : ((double)n2 > this.m_gradientParams.top ? (double)n2 - this.m_gradientParams.top : 0.0)));
                d = this.m_gradientParams.innerRadius >= this.m_gradientParams.outerRadius ? 0.0 : (d2 - this.m_gradientParams.innerRadius) / (this.m_gradientParams.outerRadius - this.m_gradientParams.innerRadius);
                break;
            }
            default: {
                d3 = this.m_gradientParams.pointTo.x - this.m_gradientParams.pointFrom.x;
                d4 = this.m_gradientParams.pointTo.y - this.m_gradientParams.pointFrom.y;
                GRPoint gRPoint = new GRPoint(n, n2);
                GRPoint gRPoint3 = new GRPoint((double)n - d4, (double)n2 + d3);
                intersect = this.lineIntersect(this.m_gradientParams.pointFrom, this.m_gradientParams.pointTo, gRPoint, gRPoint3);
                d = intersect.lineA_scaler;
                break;
            }
        }
        return d;
    }

    private Intersect lineIntersect(GRPoint gRPoint, GRPoint gRPoint2, GRPoint gRPoint3, GRPoint gRPoint4) {
        this.m_intersect.isIntersect = false;
        double d = (gRPoint4.y - gRPoint3.y) * (gRPoint2.x - gRPoint.x) - (gRPoint4.x - gRPoint3.x) * (gRPoint2.y - gRPoint.y);
        if (d == 0.0) {
            return this.m_intersect;
        }
        double d2 = ((gRPoint4.x - gRPoint3.x) * (gRPoint.y - gRPoint3.y) - (gRPoint4.y - gRPoint3.y) * (gRPoint.x - gRPoint3.x)) / d;
        this.m_intersect.isIntersect = true;
        this.m_intersect.intersectPt.x = gRPoint.x + d2 * (gRPoint2.x - gRPoint.x);
        this.m_intersect.intersectPt.y = gRPoint.y + d2 * (gRPoint2.y - gRPoint.y);
        this.m_intersect.lineA_scaler = d2;
        return this.m_intersect;
    }

    public void setForcedBlendingColor(Color color) {
        this.m_forcedBlendingColor = color;
    }

    public Color getForcedBlendingColor() {
        return this.m_forcedBlendingColor;
    }

    class Intersect {
        public boolean isIntersect = false;
        public GRPoint intersectPt = new GRPoint();
        public double lineA_scaler = 0.0;

        Intersect() {
        }
    }

    class GradientParams {
        public double rectWidth;
        public double rectHeight;
        public double xCenter;
        public double yCenter;
        public double shadowOffset;
        public double innerRadius;
        public double outerRadius;
        public GRPoint lineA_point1 = new GRPoint();
        public GRPoint lineA_point2 = new GRPoint();
        public double left;
        public double top;
        public double right;
        public double bottom;
        public GRPoint pointFrom = new GRPoint();
        public GRPoint pointTo = new GRPoint();

        GradientParams() {
        }
    }

    class Gradient {
        public CGSTypeColor m_color = new CGSTypeColor(Color.RED);
        public double m_percent = 0.0;

        public Gradient() {
        }

        public Gradient(Color color, double d) {
            this.m_color.setValue(color);
            this.m_percent = d;
        }

        public Gradient(Gradient gradient) {
            this.m_color = gradient.m_color;
            this.m_percent = gradient.m_percent;
        }
    }
}

