/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.localizationkit.extension.i18nimage;

import com.cognos.localizationkit.extension.i18nimage.ImageContent;
import com.cognos.localizationkit.extension.i18nimage.ImageGenerator;
import com.cognos.localizationkit.extension.i18nimage.LabelTemplate;
import com.cognos.localizationkit.extension.i18nimage.RootImage;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Label
implements ImageContent {
    private static final char REGISTERED_TRADEMARK = '\uc2ae';
    private static final char COPYRIGHT = '\uc2a9';
    private static final Pattern compiledRegex = Pattern.compile("[\uc2ae\uc2a9]");
    private static final double FONT_SUPERSCRIPT_SCALE = 0.68;
    private int width = -1;
    private String text = null;
    private LabelTemplate template = null;

    public Label(LabelTemplate template) {
        this.template = template;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void write(RootImage container) {
        String locale = container.getLocale().toLowerCase();
        Font font = new Font(this.template.getFont(locale), this.template.getStyle(), this.template.getFontSize());
        ImageGenerator.printLog(this.getClass(), this.template.getType() + " Font is " + font.getFontName());
        Graphics2D g2d = container.getGraphics();
        g2d.setColor(this.template.getColor());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setFont(font);
        if (this.width < 0) {
            this.width = container.getWidth() - container.getMargin() * 2;
        }
        if (container.isLocaleRTL()) {
            Label.drawText(g2d, this.text, container.getMargin(), container.getMargin() + this.template.getY(), this.width, true);
        } else {
            Label.drawText(g2d, this.text, container.getMargin(), container.getMargin() + this.template.getY(), this.width, false);
        }
    }

    private static void drawText(Graphics2D g2d, String text, int x, int y, int width, boolean isRTL) {
        FontRenderContext frc = g2d.getFontRenderContext();
        AttributedString styledText = new AttributedString(text);
        styledText.addAttribute(TextAttribute.FONT, g2d.getFont());
        HashMap<TextAttribute, Number> attrMap = new HashMap<TextAttribute, Number>();
        attrMap.put(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
        float superScriptSize = (float)((double)g2d.getFont().getSize() * 0.68);
        attrMap.put(TextAttribute.SIZE, Float.valueOf(superScriptSize));
        Font superScriptFont = g2d.getFont().deriveFont(attrMap);
        Matcher regexMatcher = compiledRegex.matcher(text);
        while (regexMatcher.find()) {
            int superScriptPos = regexMatcher.start();
            styledText.addAttribute(TextAttribute.FONT, superScriptFont, superScriptPos, superScriptPos + 1);
            superScriptPos = text.indexOf(49838, superScriptPos + 1);
        }
        AttributedCharacterIterator styledTextIterator = styledText.getIterator();
        LineBreakMeasurer measurer = new LineBreakMeasurer(styledTextIterator, frc);
        while (measurer.getPosition() < text.length()) {
            TextLayout textLayout = measurer.nextLayout(width);
            if (isRTL) {
                textLayout.draw(g2d, (float)width - textLayout.getAdvance(), y);
            } else {
                textLayout.draw(g2d, x, y);
            }
            y = (int)((float)y + (textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading()));
        }
    }

    public int getY() {
        return this.template.getY();
    }
}

