/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.localizationkit.extension.i18nimage;

import java.text.MessageFormat;
import java.util.Properties;

public final class MessagesManager {
    private static final MessagesManager m_instance = new MessagesManager();
    private boolean m_bInitialized = false;
    private Properties props = null;

    public synchronized void initialize(Properties props) {
        this.props = props;
        this.m_bInitialized = true;
    }

    public synchronized void terminate() {
        this.m_bInitialized = false;
    }

    public static MessagesManager getInstance() {
        return m_instance;
    }

    public String getMessage(String key, Object[] args) {
        if (!this.m_bInitialized) {
            return new String(key);
        }
        String msgString = this.props.getProperty(key);
        if (msgString == null) {
            return new String(key);
        }
        MessageFormat formatter = this.getMsgFormatter();
        if (formatter == null) {
            return new String(msgString);
        }
        StringBuffer newMsgString = new StringBuffer(msgString.length());
        int idx = 0;
        while ((idx = msgString.indexOf(39)) != -1) {
            newMsgString.append(msgString.substring(0, idx));
            newMsgString.append("''");
            msgString = msgString.substring(idx + 1);
        }
        newMsgString.append(msgString);
        formatter.applyPattern(newMsgString.toString());
        return formatter.format(args).toString();
    }

    public String getMessage(String lang, String key, Object[] args) {
        return this.getMessage(key, args);
    }

    public String getMessage(String key) {
        return this.getMessage(key, null);
    }

    private synchronized MessageFormat getMsgFormatter() {
        MessageFormat msgFormatter = new MessageFormat("");
        return msgFormatter;
    }
}

