/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.util.base64;
import com.ibm.cgsBus.CGSSOAPException;
import com.ibm.cgsBus.CGSServerRequest;
import com.ibm.cgsBus.FrameWork.CGSCanvas;
import com.ibm.cgsBus.Logging.CGSLogging;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGSRequestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CGSRequestHelper.class);
    public static final String UTF8 = "UTF-8";
    public static final String CRLF = "\r\n";
    public static final String EN_US = "en-us";
    public static final String ATTACH_ENCODE_MIME = "MIME";
    public static final String ATTACH_ENCODE_MIME_COMPRESSED = "MIMECompressed";
    public static final Namespace GRAPHICS_NS = Namespace.get((String)"gs", (String)"http://www.ibm.com/xmlns/prod/cognos/graphicsService/201109/");
    public static final String METHOD_RENDERCHART = "renderChart";
    public static final String METHOD_RUN_SPECIFICATION = "runSpecification";
    public static final String IMAGE_ATTACHMENT_CID = "cgsImageData.Id@cognos.ibm.com";
    public static final String IMAGEMAP_ATTACHMENT_CID = "cgsImagemapData.Id@cognos.ibm.com";
    public static final String HEADER_CONTENT_ID = "Content-ID: ";
    public static final String HEADER_CONTENT_TRANSFER_ENCODING_BINARY = "Content-Transfer-Encoding: binary";
    public static final String HEADER_CONTENT_ENCODING_GZIP = "Content-Encoding: gzip";
    public static final String HEADER_CONTENT_LENGTH = "Content-Length: ";
    public static final String HEADER_CONTENT_TYPE = "Content-Type: ";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition: ";
    public static final String HEADER_CONTENT_TYPE_XML = "Content-Type: text/xml; charset=UTF-8";
    public static final String HEADER_CONTENT_TYPE_TEXT = "Content-Type: text/plain; charset=UTF-8";
    public static final String HEADER_CONTENT_TYPE_PNG = "Content-Type: image/png";
    public static final String HEADER_CONTENT_TYPE_MULTIPART = "Content-Type: multipart/related";
    public static final String HEADER_TRANSFER_ENCODING_CHUNKED = "Transfer-Encoding: chunked";

    public static byte[] generateBytesFromSpecification(String string) throws InterruptedException {
        CGSCanvas cGSCanvas = new CGSCanvas(EN_US);
        byte[] byArray = cGSCanvas.drawAsBytes(string);
        char[] cArray = new char[]{(char)byArray[0], (char)byArray[1], (char)byArray[2]};
        LOGGER.info("Drawing code [" + cArray[0] + cArray[1] + cArray[2] + "] :: Byte count = " + byArray.length);
        return byArray;
    }

    public static StringBuilder appendHeader(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string);
        stringBuilder.append(string2);
        stringBuilder.append(CRLF);
        return stringBuilder;
    }

    public static StringBuilder appendHeader(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string);
        stringBuilder.append(CRLF);
        return stringBuilder;
    }

    public static StringBuilder clearHeaders(StringBuilder stringBuilder) {
        stringBuilder.delete(0, stringBuilder.length());
        return stringBuilder;
    }

    public static boolean isResponseCompressed(String string) {
        return ATTACH_ENCODE_MIME_COMPRESSED.equals(string);
    }

    public static String decompressSpecification(String string) throws IOException {
        try {
            int n;
            byte[] byArray = base64.decode((int)0, (String)string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            byte[] byArray2 = new byte[1024];
            while ((n = gZIPInputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            gZIPInputStream.close();
            String string2 = byteArrayOutputStream.toString(UTF8);
            CGSLogging.logInfo("Compressed spec length = " + string.length());
            CGSLogging.logInfo("Uncompressed spec length = " + string2.length());
            return string2;
        }
        catch (IOException iOException) {
            LOGGER.error("Unable to decompress input specification");
            throw iOException;
        }
    }

    public static BIBusEnvelope buildRenderChartResponse(BIBusEnvelope bIBusEnvelope, String string, Map<String, byte[]> map) throws IOException, CGSSOAPException {
        BIBusEnvelope bIBusEnvelope2 = CGSRequestHelper.buildResponse(bIBusEnvelope);
        Element element = bIBusEnvelope2.getBody().addElement(new QName("renderChartResponse", GRAPHICS_NS));
        element.addAttribute(BIBusEnvelope.XSI_TYPE, "attachment[" + map.size() + "]");
        boolean bl = CGSRequestHelper.isResponseCompressed(string);
        for (String string2 : map.keySet()) {
            String string3 = CGSRequestHelper.createCID(string2);
            if (bl && map.get(string2) != null) {
                ByteArrayOutputStream byteArrayOutputStream = CGSServerRequest.compressDataByGZIP(map.get(string2));
                byte[] byArray = byteArrayOutputStream.toByteArray();
                map.put(string2, byArray);
            }
            CGSRequestHelper.buildResponseAttachmentElement(element, string, string3);
        }
        return bIBusEnvelope2;
    }

    public static String createCID(String string) {
        if ("imagemap.xml".equalsIgnoreCase(string)) {
            return IMAGEMAP_ATTACHMENT_CID;
        }
        if ("image.png".equalsIgnoreCase(string)) {
            return IMAGE_ATTACHMENT_CID;
        }
        return string + "@cognos.ibm.com";
    }

    static void buildResponseAttachmentElement(Element element, String string, String string2) {
        Element element2 = element.addElement(new QName("attachment", element.getNamespace()));
        element2.addAttribute(BIBusEnvelope.XSI_TYPE, "bus:attachment");
        Element element3 = element2.addElement(new QName("encoding", element.getNamespace()));
        element3.addText(string);
        Element element4 = element2.addElement(new QName("id", element.getNamespace()));
        element4.addText(string2);
    }

    public static BIBusEnvelope buildResponse(BIBusEnvelope bIBusEnvelope) {
        BIBusEnvelope bIBusEnvelope2 = new BIBusEnvelope();
        if (bIBusEnvelope != null) {
            bIBusEnvelope.getHeader();
            bIBusEnvelope.copyHeaderTo((SOAPEnvelope)bIBusEnvelope2);
        }
        return bIBusEnvelope2;
    }

    public static String getAttachmentEncoding(BIBusEnvelope bIBusEnvelope) {
        Element element = (Element)bIBusEnvelope.getBody().elements().get(0);
        Element element2 = element.element(new QName("specification", element.getNamespace()));
        return element2.attributeValue("attachmentEncoding");
    }

    public static String getChartSpecification(BIBusEnvelope bIBusEnvelope) throws IOException, CGSSOAPException {
        Element element = (Element)bIBusEnvelope.getBody().elements().get(0);
        Element element2 = element.element(new QName("specification", element.getNamespace()));
        String string = CGSRequestHelper.getAttachmentEncoding(bIBusEnvelope);
        if (!ATTACH_ENCODE_MIME.equals(string) && !ATTACH_ENCODE_MIME_COMPRESSED.equals(string)) {
            String string2 = "Invalid attachmentEncoding attribute '" + string + "'";
            LOGGER.warn(string2);
            throw new CGSSOAPException(bIBusEnvelope, false, string2, null);
        }
        boolean bl = Boolean.parseBoolean(element2.attributeValue("compressed"));
        if (bl) {
            return CGSRequestHelper.decompressSpecification(element2.getTextTrim());
        }
        StringWriter stringWriter = new StringWriter();
        try {
            element2.write((Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            LOGGER.error("Error reading chart specification");
            throw iOException;
        }
    }

    public static byte[] compressChartData(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.finish();
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private CGSRequestHelper() {
    }
}

