/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.misc.CAMSSLSocketFactory;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cclcorej.util.CCLUsageData;
import com.cognos.pogo.pdk.xml.SAXReaderPool;
import com.ibm.cgsBus.CGSServerNonAsyncRequest;
import com.ibm.cgsBus.CGSServerRequest;
import com.ibm.cgsBus.CGSVisOutputRequestHelper;
import com.ibm.cgsBus.Graphics.GRHelper;
import com.ibm.cgsBus.Logging.CGSFileLogger;
import com.ibm.cgsBus.Logging.CGSLogging;
import com.ibm.cgsBus.Warmup;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;

public class CGSServerImpl {
    private static final Object theObj = new Object();
    private HashMap<String, Thread> m_primaryRequestThreadReferences = new HashMap();
    private static ServerSocket m_serverSocket = null;
    private static boolean m_listening = true;
    private boolean m_logging = false;
    private int m_loggingLevel = 0;
    private boolean m_usessl = false;
    private String m_internalDispatcherURL;
    private String m_rootFolder = null;

    public String getInternalDispatcherURL() {
        return this.m_internalDispatcherURL;
    }

    public String getRootFolder() {
        return this.m_rootFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopListening() {
        Object object = theObj;
        synchronized (object) {
            m_listening = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getPrimaryRequestThreadReference(String string) {
        CGSServerImpl cGSServerImpl = this;
        synchronized (cGSServerImpl) {
            return this.m_primaryRequestThreadReferences.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrimaryRequestThreadReference(String string, Thread thread) {
        CGSServerImpl cGSServerImpl = this;
        synchronized (cGSServerImpl) {
            this.m_primaryRequestThreadReferences.put(string, thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrimaryRequestThreadReference(String string) {
        CGSServerImpl cGSServerImpl = this;
        synchronized (cGSServerImpl) {
            this.m_primaryRequestThreadReferences.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputPrimaryRequestThreadReferencesMap() {
        Set<String> set;
        if (!this.m_logging) {
            return;
        }
        Object object = this;
        synchronized (object) {
            set = this.m_primaryRequestThreadReferences.keySet();
        }
        CGSLogging.logInfo("List of thread references:");
        object = set.iterator();
        while (object.hasNext()) {
            CGSLogging.logInfo("   " + (String)object.next());
        }
    }

    private static void createSSLSocket(int n) throws IOException {
        CGSServerImpl.createSocket(n);
    }

    private static void createSocket(int n) throws IOException {
        CGSLogging.logInfo("Creating non-SSL socket");
        try {
            CAMFactory cAMFactory = new CAMFactory();
            cAMFactory.initialize("<initializeDocument><serviceID>CGSVIS</serviceID></initializeDocument>".getBytes());
            m_serverSocket = cAMFactory.createServerSocket(n, false);
        }
        catch (CAMCryptoException cAMCryptoException) {
            CGSLogging.logError("Could not create socket: " + cAMCryptoException.getMessage());
            System.err.println("Could not create socket: " + cAMCryptoException.getMessage());
            System.exit(-1);
        }
    }

    public void run(String[] stringArray) {
        Object object;
        Object object2;
        int n = 0;
        String string = null;
        boolean bl = false;
        int n2 = 900;
        String string2 = null;
        try {
            CGSVisOutputRequestHelper.initHttpClient();
            SAXReaderPool.prepare((boolean)true, (int)15);
            string = ManagementFactory.getRuntimeMXBean().getName();
            string = string.substring(0, string.indexOf("@"));
            for (int i = 0; i < stringArray.length; ++i) {
                Object object3;
                object2 = stringArray[i];
                if (((String)object2).compareTo("-p") == 0) {
                    n = Integer.parseInt(stringArray[++i]);
                    continue;
                }
                if (((String)object2).compareTo("-l") == 0) {
                    Configurator.initialize((Configuration)new DefaultConfiguration());
                    continue;
                }
                if (((String)object2).startsWith("-cgslog")) {
                    this.m_logging = true;
                    object3 = ((String)object2).split("\\s");
                    this.m_loggingLevel = ((String[])object3).length > 1 ? Integer.parseInt(object3[1]) : 1;
                    CGSLogging.set(new CGSFileLogger(this.m_logging));
                    CGSLogging.setLevel(this.m_loggingLevel);
                    continue;
                }
                if (((String)object2).startsWith("-preventssl")) {
                    this.m_usessl = false;
                    continue;
                }
                if (((String)object2).startsWith("-DuseNonAsync")) {
                    bl = true;
                    continue;
                }
                if (((String)object2).startsWith("COG_ROOT")) {
                    this.m_rootFolder = string2 = ((String)object2).substring("COG_ROOT=".length());
                    object3 = string2 + "/configuration/cogstartup.xml";
                    FileInputStream fileInputStream = new FileInputStream((String)object3);
                    ICCLConfiguration iCCLConfiguration = CCLConfigurationFactory.getInstance();
                    try {
                        iCCLConfiguration.init((InputStream)fileInputStream);
                        this.m_internalDispatcherURL = iCCLConfiguration.getValue("internalDispatcher", false);
                    }
                    catch (CCLConfigurationException cCLConfigurationException) {
                        CGSLogging.logError("Could not read internal dispatcher URL from Config file:" + (String)object3);
                    }
                    continue;
                }
                if (!((String)object2).startsWith("idleTimeLimitSec")) continue;
                n2 = Integer.parseInt(((String)object2).substring("idleTimeLimitSec=".length()));
            }
            CGSServerImpl.initUsageTracking();
            CGSServerImpl.createSocket(n);
            m_serverSocket.setReceiveBufferSize(65536);
            n = m_serverSocket.getLocalPort();
            System.out.println("port=" + n + " pid=" + string);
            CGSLogging.setProcessPid(string);
            CGSLogging.logInfo("Listening on port: " + n + " with pid = " + string);
            CGSLogging.logInfo("JRE path is: " + System.getProperty("java.home"));
            CGSLogging.logInfo("JRE version is: " + System.getProperty("java.version"));
            CGSLogging.logInfo("JRE vendor is: " + System.getProperty("java.vendor"));
            GRHelper.setJavaFontNames();
        }
        catch (IOException iOException) {
            object2 = new StringWriter();
            iOException.printStackTrace(new PrintWriter((Writer)object2));
            CGSLogging.logError("Could not listen on port: " + n + ", error: " + iOException.getMessage() + " : " + iOException.getCause() + " : " + ((StringWriter)object2).toString());
            System.exit(-1);
        }
        if (this.m_logging) {
            StringBuffer stringBuffer = new StringBuffer("Running with " + stringArray.length + " args:");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(" ");
                stringBuffer.append(stringArray[i]);
                if (i == stringArray.length - 1) continue;
                stringBuffer.append(",");
            }
            CGSLogging.logInfo(stringBuffer.toString());
        }
        ExecutorService executorService = Executors.newCachedThreadPool();
        if (System.getProperty("useNonAsync") != null) {
            bl = true;
        }
        try {
            object = new CGSSSLSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)object);
        }
        catch (CAMCryptoException cAMCryptoException) {
            CGSLogging.logError("Could not create SSL factory: " + cAMCryptoException.getMessage());
            executorService.shutdown();
            System.exit(-1);
        }
        this.warmup(string2, executorService);
        try {
            while (m_listening) {
                try {
                    m_serverSocket.setSoTimeout(n2 * 1000);
                    object = m_serverSocket.accept();
                    CGSLogging.logInfo("Running new executor.");
                    executorService.execute(bl ? new CGSServerNonAsyncRequest(this, (Socket)object) : new CGSServerRequest(this, (Socket)object));
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    CGSLogging.logError("Inactivity timeout: " + socketTimeoutException.getMessage() + " - " + n2 + " seconds.");
                    executorService.shutdown();
                    System.exit(-1);
                }
            }
        }
        catch (IOException iOException) {
            CGSLogging.logError("Could not accept client connection: " + iOException.getMessage());
            executorService.shutdown();
            System.exit(-1);
        }
        CGSLogging.logInfo("Shutting down via Executor.");
        executorService.shutdown();
        CGSLogging.logInfo("Successfully shut down via Executor.");
    }

    private void warmup(String string, ExecutorService executorService) {
        long l = System.nanoTime();
        String string2 = string + "/configuration/warmup/cgs";
        ArrayList<Future<Boolean>> arrayList = new ArrayList<Future<Boolean>>();
        try {
            File file = new File(string2);
            for (File file2 : file.listFiles()) {
                if (!file2.isFile()) continue;
                CGSLogging.logInfo("Warming up " + file2.getAbsolutePath());
                Warmup warmup = new Warmup(file2, this);
                Future<Boolean> future = executorService.submit(warmup);
                arrayList.add(future);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    ((Future)arrayList.get(i)).get();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    CGSLogging.logError("Warmup was interrupted " + interruptedException.getMessage());
                    continue;
                }
                catch (ExecutionException executionException) {
                    CGSLogging.logError("Warmup Failed " + executionException.getMessage());
                }
            }
            long l2 = System.nanoTime();
            long l3 = l2 - l;
            CGSLogging.logInfo("Time to Warmup " + Long.toString(l3 / 1000000L));
        }
        catch (Exception exception) {
            CGSLogging.logInfo("Warmup Failed " + exception.getMessage());
        }
    }

    protected void finalize() {
        try {
            CGSLogging.logInfo("Closing socket");
            m_serverSocket.close();
            CGSLogging.logInfo("Successfully closed socket");
        }
        catch (IOException iOException) {
            CGSLogging.logError("Could not close server socket");
            System.exit(-1);
        }
    }

    public boolean isLogging() {
        return this.m_logging;
    }

    public int getLoggingLevel() {
        return this.m_loggingLevel;
    }

    private static void initUsageTracking() {
        CCLUsageData cCLUsageData = new CCLUsageData();
        int n = cCLUsageData.registerUsageTracking();
        CGSLogging.logInfo("CCLUsageData.registerUsageTracking, return code = " + n);
    }

    private static class CGSSSLSocketFactory
    extends SSLSocketFactory {
        private CAMSSLSocketFactory socketFactory;
        private com.cognos.accman.jcam.crypto.misc.Configuration config = com.cognos.accman.jcam.crypto.misc.Configuration.getInstance();

        public CGSSSLSocketFactory() throws CAMCryptoException {
            this.socketFactory = this.config.getCAMSSLSocketFactory();
        }

        private Socket configureSocket(Socket socket) throws CAMCryptoException {
            SSLSocket sSLSocket = (SSLSocket)socket;
            sSLSocket.setEnabledCipherSuites(this.config.getJSSECipherSuitesList());
            sSLSocket.setEnabledProtocols(this.config.getSSLProtocols());
            return sSLSocket;
        }

        @Override
        public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
            Socket socket2 = null;
            try {
                socket2 = this.configureSocket(this.socketFactory.createSocket(socket, string, n, bl));
            }
            catch (CAMCryptoException cAMCryptoException) {
                throw new IOException(cAMCryptoException);
            }
            return socket2;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.config.getJSSECipherSuitesList();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.config.getJSSECipherSuitesList();
        }

        @Override
        public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
            Socket socket = null;
            try {
                socket = this.configureSocket(this.socketFactory.createSocket(string, n));
            }
            catch (CAMCryptoException cAMCryptoException) {
                throw new IOException(cAMCryptoException);
            }
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
            Socket socket = null;
            try {
                socket = this.configureSocket(this.socketFactory.createSocket(inetAddress, n));
            }
            catch (CAMCryptoException cAMCryptoException) {
                throw new IOException(cAMCryptoException);
            }
            return socket;
        }

        @Override
        public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
            Socket socket = null;
            try {
                socket = this.configureSocket(this.socketFactory.createSocket(string, n, inetAddress, n2));
            }
            catch (CAMCryptoException cAMCryptoException) {
                throw new IOException(cAMCryptoException);
            }
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
            Socket socket = null;
            try {
                socket = this.configureSocket(this.socketFactory.createSocket(inetAddress.getHostName(), n, inetAddress2, n2));
            }
            catch (CAMCryptoException cAMCryptoException) {
                throw new IOException(cAMCryptoException);
            }
            return socket;
        }
    }
}

