/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPException;
import com.ibm.cgsBus.CGSExtnChartingSOAPException;
import com.ibm.cgsBus.CGSRequestHelper;
import com.ibm.cgsBus.CGSSOAPException;
import com.ibm.cgsBus.CGSServerImpl;
import com.ibm.cgsBus.CGSVisOutputRequestHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.dom4j.Element;
import org.dom4j.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGSServerNonAsyncRequest
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(CGSServerNonAsyncRequest.class);
    private static final String SOAP_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String SOAP_SERVER = "SOAP-ENV:Server";
    private static final String SOAP_CLIENT = "SOAP-ENV:Client";
    private static final String CMD_CGS = "cgs2";
    private static final String CMD_CONFIG = "config";
    private static final String CMD_CCL_CONFIG = "cclconfiguration";
    private static final String CMD_STOP = "stop";
    private static final String HTTP_200_OK = "HTTP/1.1 200 OK";
    private static final String HTTP_400_BAD_REQUEST = "HTTP/1.1 400 Bad Request";
    private static final String HTTP_500_ERROR = "HTTP/1.1 500 Internal Server Error";
    private static final String HTTP_RECEIVED_RESPONSE = "Received";
    private static final String MIME_BOUNDARY_DASH = "--";
    private static final String MIME_BOUNDARY_START = "cgsBoundary-";
    private static final Map<String, String> FILETYPEMAP = new HashMap<String, String>();
    private Socket socket;
    private CGSServerImpl server;
    private boolean doneRequest;

    public CGSServerNonAsyncRequest(CGSServerImpl cGSServerImpl, Socket socket) {
        this.server = cGSServerImpl;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new BufferedInputStream(this.socket.getInputStream(), 65536);
            outputStream = new BufferedOutputStream(this.socket.getOutputStream());
            while (!this.doneRequest) {
                this.handleRequest(inputStream, outputStream);
            }
        }
        catch (IOException iOException) {
            LOGGER.error("CGSServerNonAsyncRequest - IOException", (Throwable)iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                LOGGER.error("Exception caught while trying to close connection", (Throwable)iOException);
            }
        }
    }

    private void processVisOutputRequest(BIBusEnvelope bIBusEnvelope, OutputStream outputStream) throws IOException {
        try {
            String string = CGSRequestHelper.getAttachmentEncoding(bIBusEnvelope);
            try {
                Map<String, byte[]> map = CGSVisOutputRequestHelper.generateChartOutput(bIBusEnvelope, this.server.getInternalDispatcherURL(), this.server.getRootFolder(), "renderChart");
                BIBusEnvelope bIBusEnvelope2 = CGSRequestHelper.buildRenderChartResponse(bIBusEnvelope, string, map);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                bIBusEnvelope2.writeAsXML((OutputStream)byteArrayOutputStream);
                this.sendMultipartHTTPResponse(outputStream, byteArrayOutputStream.toByteArray(), map, CGSRequestHelper.isResponseCompressed(string));
            }
            catch (Exception exception) {
                LOGGER.error("LOG_CREATE_RESPONSE_FAILED : " + exception);
                throw new CGSExtnChartingSOAPException(bIBusEnvelope, true, "Internal server error. Failed to create response.", exception);
            }
        }
        catch (CGSExtnChartingSOAPException cGSExtnChartingSOAPException) {
            LOGGER.error("ExtnChartingSOAPException", (Throwable)cGSExtnChartingSOAPException);
            this.sendSOAPFault(outputStream, cGSExtnChartingSOAPException.getRequest(), cGSExtnChartingSOAPException.isServerError(), cGSExtnChartingSOAPException.getErrorMessage(), cGSExtnChartingSOAPException.getCause());
        }
    }

    private void handleRequest(InputStream inputStream, OutputStream outputStream) throws IOException {
        String string = HttpParser.readLine((InputStream)inputStream, (String)"UTF-8");
        if (string == null) {
            LOGGER.warn("CGSServerNonAsyncRequest - received empty request");
            this.doneRequest = true;
            return;
        }
        LOGGER.info("HTTP command: " + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken().substring(1);
        LOGGER.info("Received command: " + string2);
        Header[] headerArray = HttpParser.parseHeaders((InputStream)inputStream, (String)"UTF-8");
        boolean bl = false;
        long l = 0L;
        for (int i = 0; i < headerArray.length; ++i) {
            Header header = headerArray[i];
            LOGGER.info("HTTP Header received: " + header.getName() + " " + header.getValue());
            if ("Transfer-Encoding".compareTo(header.getName()) == 0 && "chunked".compareTo(header.getValue()) == 0) {
                bl = true;
                continue;
            }
            if ("Connection".compareTo(header.getName()) == 0 && "close".compareToIgnoreCase(header.getValue()) == 0) {
                this.doneRequest = true;
                LOGGER.info("Received close connection header for thread " + this.getId());
                continue;
            }
            if ("Content-Length".compareTo(header.getName()) != 0) continue;
            l = Long.parseLong(header.getValue());
        }
        inputStream = bl ? new ChunkedInputStream(inputStream) : new BoundedInputStream(inputStream, l);
        if (CMD_CGS.equals(string2)) {
            this.processCgsRequest(inputStream, outputStream);
        } else if (CMD_CONFIG.equals(string2)) {
            this.processConfigRequest(inputStream, outputStream);
        } else if (CMD_CCL_CONFIG.equals(string2)) {
            this.processConfigRequest(inputStream, outputStream);
        } else if (CMD_STOP.equals(string2)) {
            this.processStopRequest(inputStream, outputStream);
        } else {
            String string3 = "Received unknown command: " + string2;
            LOGGER.warn(string3);
            this.readAllAvailableData(inputStream);
            this.sendErrorResponse(outputStream, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFileForWarmup(File file) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            this.processCgsRequest(bufferedInputStream, byteArrayOutputStream);
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
    }

    private void processCgsRequest(InputStream inputStream, OutputStream outputStream) throws IOException {
        block8: {
            BIBusEnvelope bIBusEnvelope = null;
            try {
                bIBusEnvelope = new BIBusEnvelope(inputStream);
            }
            catch (SOAPException sOAPException) {
                String string = "Unable to parse SOAP envelope";
                LOGGER.warn(string, (Throwable)sOAPException);
                this.doneRequest = true;
                this.readAllAvailableData(inputStream);
                this.sendHTTPResponse(outputStream, string.getBytes("UTF-8"), HTTP_400_BAD_REQUEST);
                return;
            }
            try {
                Element element = bIBusEnvelope.getBody();
                String string = ((Element)element.elements().get(0)).getQName().getName();
                if ("renderChart".equals(string)) {
                    if (CGSVisOutputRequestHelper.isVisOutputServiceRequest(element, "renderChart")) {
                        this.processVisOutputRequest(bIBusEnvelope, outputStream);
                    } else {
                        this.processRenderChart(bIBusEnvelope, outputStream);
                    }
                    break block8;
                }
                throw new CGSSOAPException(bIBusEnvelope, false, "Unknown SOAP method: " + string, null);
            }
            catch (CGSSOAPException cGSSOAPException) {
                this.sendSOAPFault(outputStream, cGSSOAPException.getRequest(), cGSSOAPException.isServerError(), cGSSOAPException.getErrorMessage(), cGSSOAPException.getCause());
            }
            catch (Exception exception) {
                String string = "Invalid SOAP body, reading all data and closing connection";
                LOGGER.warn(string, (Throwable)exception);
                this.doneRequest = true;
                this.readAllAvailableData(inputStream);
                this.sendHTTPResponse(outputStream, string.getBytes("UTF-8"), HTTP_400_BAD_REQUEST);
            }
        }
    }

    private void processRenderChart(BIBusEnvelope bIBusEnvelope, OutputStream outputStream) throws IOException, CGSSOAPException {
        byte[] byArray = null;
        String string = CGSRequestHelper.getAttachmentEncoding(bIBusEnvelope);
        String string2 = CGSRequestHelper.getChartSpecification(bIBusEnvelope);
        try {
            byArray = CGSRequestHelper.generateBytesFromSpecification(string2);
            HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>(1);
            hashMap.put("image.png", byArray);
            BIBusEnvelope bIBusEnvelope2 = CGSRequestHelper.buildRenderChartResponse(bIBusEnvelope, string, hashMap);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bIBusEnvelope2.writeAsXML((OutputStream)byteArrayOutputStream);
            this.sendMultipartHTTPResponse(outputStream, byteArrayOutputStream.toByteArray(), hashMap, CGSRequestHelper.isResponseCompressed(string));
        }
        catch (InterruptedException interruptedException) {
            LOGGER.error("Chart render interrupted!", (Throwable)interruptedException);
            this.sendSOAPFault(outputStream, bIBusEnvelope, true, "Chart rendering interrupted", interruptedException);
        }
    }

    private void processConfigRequest(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.readAllAvailableData(inputStream);
        this.sendReceivedResponse(outputStream);
    }

    private void readAllAvailableData(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[1024];
        while (inputStream.read(byArray) > 0) {
        }
    }

    private void processStopRequest(InputStream inputStream, OutputStream outputStream) throws IOException {
        CGSServerImpl.stopListening();
        this.readAllAvailableData(inputStream);
        this.sendReceivedResponse(outputStream);
    }

    private void sendReceivedResponse(OutputStream outputStream) throws IOException {
        this.sendHTTPResponse(outputStream, HTTP_RECEIVED_RESPONSE.getBytes("UTF-8"), HTTP_200_OK, "Content-Type: text/plain; charset=UTF-8");
    }

    private void sendErrorResponse(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = null;
        byArray = string != null && string.length() > 0 ? string.getBytes("UTF-8") : new byte[]{};
        this.doneRequest = true;
        this.sendHTTPResponse(outputStream, byArray, HTTP_500_ERROR);
    }

    private void sendSOAPFault(OutputStream outputStream, BIBusEnvelope bIBusEnvelope, boolean bl, String string, Throwable throwable) throws IOException {
        Object object;
        BIBusEnvelope bIBusEnvelope2 = CGSRequestHelper.buildResponse(bIBusEnvelope);
        Element element = bIBusEnvelope2.getBody();
        Element element2 = element.addElement(new QName("Fault", element.getNamespaceForURI(SOAP_URI)));
        element2.addElement("faultcode").addText(bl ? SOAP_SERVER : SOAP_CLIENT);
        if (string != null && string.length() > 0) {
            element2.addElement("faultstring").addText(string);
        }
        if (throwable != null) {
            LOGGER.warn("Returning SOAP fault from throwable", throwable);
            object = new StringBuilder();
            ((StringBuilder)object).append("Error: " + throwable.getMessage());
            if (throwable.getMessage().equals(throwable.getCause().toString())) {
                ((StringBuilder)object).append("\r\n");
            } else {
                ((StringBuilder)object).append(" : " + throwable.getCause() + "\r\n");
            }
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                ((StringBuilder)object).append("at " + stackTraceElementArray[i].getClassName() + "(" + stackTraceElementArray[i].getFileName() + ":" + stackTraceElementArray[i].getLineNumber() + ")" + "\r\n");
            }
            element2.addElement("details").addText(((StringBuilder)object).toString());
        }
        object = new ByteArrayOutputStream();
        bIBusEnvelope2.writeAsXML((OutputStream)object);
        this.sendHTTPResponse(outputStream, ((ByteArrayOutputStream)object).toByteArray(), bl ? HTTP_500_ERROR : HTTP_400_BAD_REQUEST);
    }

    private void sendHTTPResponse(OutputStream outputStream, byte[] byArray, String string) throws IOException {
        this.sendHTTPResponse(outputStream, byArray, string, "Content-Type: text/xml; charset=UTF-8");
    }

    private void sendHTTPResponse(OutputStream outputStream, byte[] byArray, String string, String string2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CGSRequestHelper.appendHeader(stringBuilder, string);
        CGSRequestHelper.appendHeader(stringBuilder, string2);
        CGSRequestHelper.appendHeader(stringBuilder, "Content-Length: ", Integer.toString(byArray.length));
        outputStream.write(stringBuilder.toString().getBytes());
        outputStream.write("\r\n".getBytes());
        this.writeData(outputStream, byArray, false);
        outputStream.flush();
    }

    private void sendMultipartHTTPResponse(OutputStream outputStream, byte[] byArray, Map<String, byte[]> map, boolean bl) throws IOException {
        boolean bl2 = true;
        StringBuilder stringBuilder = new StringBuilder();
        String string = MIME_BOUNDARY_START + UUID.randomUUID().toString();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write("\r\n".getBytes());
        byteArrayOutputStream.write(MIME_BOUNDARY_DASH.getBytes());
        byteArrayOutputStream.write(string.getBytes());
        byteArrayOutputStream.write("\r\n".getBytes());
        CGSRequestHelper.appendHeader(stringBuilder, "Content-ID: ", "envelope");
        CGSRequestHelper.appendHeader(stringBuilder, "Content-Length: ", Integer.toString(byArray.length));
        CGSRequestHelper.appendHeader(stringBuilder, "Content-Transfer-Encoding: binary");
        CGSRequestHelper.appendHeader(stringBuilder, "Content-Type: text/xml; charset=UTF-8");
        byteArrayOutputStream.write(stringBuilder.toString().getBytes());
        byteArrayOutputStream.write("\r\n".getBytes());
        byteArrayOutputStream.write(byArray);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            if (entry == null || entry.getValue() == null) continue;
            this.addAttachment(byteArrayOutputStream2, entry.getKey(), entry.getValue(), bl, bl2, string);
        }
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        byteArrayOutputStream3.write("\r\n".getBytes());
        byteArrayOutputStream3.write(MIME_BOUNDARY_DASH.getBytes());
        byteArrayOutputStream3.write(string.getBytes());
        byteArrayOutputStream3.write(MIME_BOUNDARY_DASH.getBytes());
        byteArrayOutputStream3.write("\r\n".getBytes());
        CGSRequestHelper.clearHeaders(stringBuilder);
        CGSRequestHelper.appendHeader(stringBuilder, HTTP_200_OK);
        CGSRequestHelper.appendHeader(stringBuilder, "Content-Type: multipart/related; boundary=" + string);
        if (bl2) {
            CGSRequestHelper.appendHeader(stringBuilder, "Transfer-Encoding: chunked");
        } else {
            int n = byteArrayOutputStream.size() + byteArrayOutputStream2.size() + byteArrayOutputStream3.size();
            CGSRequestHelper.appendHeader(stringBuilder, "Content-Length: ", Integer.toString(n));
        }
        ByteArrayOutputStream byteArrayOutputStream4 = new ByteArrayOutputStream();
        byteArrayOutputStream4.write(stringBuilder.toString().getBytes());
        this.writeData(byteArrayOutputStream4, byteArrayOutputStream.toByteArray(), bl2);
        this.writeData(byteArrayOutputStream4, byteArrayOutputStream2.toByteArray(), bl2);
        this.writeData(byteArrayOutputStream4, byteArrayOutputStream3.toByteArray(), bl2);
        byteArrayOutputStream4.write("\r\n".getBytes());
        if (bl2) {
            byteArrayOutputStream4.write(Integer.toString(0).getBytes());
        }
        byteArrayOutputStream4.write("\r\n".getBytes());
        byteArrayOutputStream4.write("\r\n".getBytes());
        outputStream.write(byteArrayOutputStream4.toByteArray());
        outputStream.flush();
    }

    private ByteArrayOutputStream addAttachment(ByteArrayOutputStream byteArrayOutputStream, String string, byte[] byArray, boolean bl, boolean bl2, String string2) throws IOException {
        byteArrayOutputStream.write("\r\n".getBytes());
        byteArrayOutputStream.write(MIME_BOUNDARY_DASH.getBytes());
        byteArrayOutputStream.write(string2.getBytes());
        byteArrayOutputStream.write("\r\n".getBytes());
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = CGSRequestHelper.createCID(string);
        String string4 = this.getContentType(string);
        CGSRequestHelper.appendHeader(stringBuilder, "Content-ID: ", "<" + string3 + ">");
        CGSRequestHelper.appendHeader(stringBuilder, "Content-Transfer-Encoding: binary");
        CGSRequestHelper.appendHeader(stringBuilder, "Content-Type: ", string4);
        CGSRequestHelper.appendHeader(stringBuilder, "Content-Disposition: ", "attachment; filename=\"" + string + "\"");
        if (!bl2) {
            CGSRequestHelper.appendHeader(stringBuilder, "Content-Length: ", Integer.toString(byArray.length));
        }
        if (bl) {
            CGSRequestHelper.appendHeader(stringBuilder, "Content-Encoding: gzip");
        }
        byteArrayOutputStream.write(stringBuilder.toString().getBytes());
        byteArrayOutputStream.write("\r\n".getBytes());
        byteArrayOutputStream.write(byArray);
        return byteArrayOutputStream;
    }

    private String getContentType(String string) {
        String string2 = FilenameUtils.getExtension((String)string);
        String string3 = FILETYPEMAP.get(string2);
        if (string3 == null) {
            string3 = URLConnection.guessContentTypeFromName(string);
        }
        return string3;
    }

    private void writeData(OutputStream outputStream, byte[] byArray, boolean bl) throws IOException {
        int n = 4096;
        int n2 = 0;
        for (int i = byArray.length; i > 0; i -= n) {
            if (i < n) {
                n = i;
            }
            if (bl) {
                outputStream.write("\r\n".getBytes());
                outputStream.write(Integer.toHexString(n).getBytes());
                outputStream.write("\r\n".getBytes());
            }
            outputStream.write(byArray, n2, n);
            n2 += n;
        }
    }

    static {
        FILETYPEMAP.put("xml", "text/xml");
        FILETYPEMAP.put("html", "text/html");
        FILETYPEMAP.put("json", "application/json");
        FILETYPEMAP.put("js", "text/javascript");
        FILETYPEMAP.put("png", "image/png");
        FILETYPEMAP.put("gif", "image/gif");
        FILETYPEMAP.put("jpg", "image/jpeg");
        FILETYPEMAP.put("svg", "image/svg+xml");
    }
}

