/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus;

import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.ccl4j.util.CCLWeb64;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.ibm.ba.vis.service.VisualizationException;
import com.ibm.ba.vis.service.VisualizationService;
import com.ibm.ba.vis.service.VisualizationServiceFactory;
import com.ibm.ba.vis.service.gallery.CognosGallery;
import com.ibm.ba.vis.service.gallery.Gallery;
import com.ibm.cgsBus.CGSExtnChartingSOAPException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CGSVisOutputRequestHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CGSVisOutputRequestHelper.class);
    public static final String UTF8 = "UTF-8";
    public static final String CRLF = "\r\n";
    public static final String HEADER_CONTENT_TYPE_XML = "Content-Type: text/xml; charset=UTF-8";
    public static final String HEADER_CONTENT_TYPE_TEXT = "Content-Type: text/plain; charset=UTF-8";
    public static final String HEADER_CONTENT_TYPE_JSON = "Content-Type: application/json; charset=UTF-8";
    private static final String IMAGEMAP = "imagemap";
    private static final String IMAGE_PNG = "image/png";
    private static final QName BUS_GENERIC_OPTION_ANYURI = DocumentHelper.createQName((String)"genericOptionAnyURI", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName BUS_EXTN_CHARTING_SPEC = DocumentHelper.createQName((String)"extnChartingSpecification", (Namespace)BIBusEnvelope.NS_BUS);
    private static HttpClient httpClient;
    private static final int CAM_COOKIE_VERSION = 1;
    private static final String FLAG_NOT_SET = "0";

    public static void initHttpClient() {
        try {
            CAMFactory cAMFactory = new CAMFactory();
            cAMFactory.initialize("<initializeDocument><serviceID>CGSVIS</serviceID></initializeDocument>".getBytes());
            httpClient = cAMFactory.createHttpClient();
            MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager = new MultiThreadedHttpConnectionManager();
            httpClient.setHttpConnectionManager((HttpConnectionManager)multiThreadedHttpConnectionManager);
        }
        catch (Exception exception) {
            LOGGER.error("Error initializing CAM http client", (Throwable)exception);
            throw new RuntimeException("Error initializing CAM http client", exception);
        }
    }

    static String getContentTypeFromRequest(BIBusEnvelope bIBusEnvelope, String string) throws CGSExtnChartingSOAPException {
        Element element = bIBusEnvelope.getBody();
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            if (!element.getName().equalsIgnoreCase(string)) continue;
            Iterator iterator2 = element.elementIterator();
            while (iterator2.hasNext()) {
                element = (Element)iterator2.next();
                if (!element.getName().equalsIgnoreCase("options")) continue;
                Iterator iterator3 = element.elementIterator();
                while (iterator3.hasNext()) {
                    element = (Element)iterator3.next();
                    if (!element.getName().equalsIgnoreCase("item") || !BUS_GENERIC_OPTION_ANYURI.getQualifiedName().equalsIgnoreCase(element.attribute(BIBusEnvelope.XSI_TYPE).getValue())) continue;
                    Iterator iterator4 = element.elementIterator();
                    while (iterator4.hasNext()) {
                        String string2;
                        String string3;
                        element = (Element)iterator4.next();
                        if (!element.getName().equalsIgnoreCase("name") || !element.getTextTrim().endsWith("extnChartingOptionEnum#contentType") || !iterator4.hasNext() || (string3 = CGSVisOutputRequestHelper.getOutputFormat(string2 = ((Element)iterator4.next()).getText().replaceAll("\\s+", ""))) == null) continue;
                        return string3;
                    }
                }
            }
        }
        throw new CGSExtnChartingSOAPException(bIBusEnvelope, false, "Invalid/Unspecified property value for content type in SOAP request", null);
    }

    private static String getOutputFormat(String string) {
        String string2 = null;
        List<String> list = Arrays.asList(string.split(","));
        string2 = list.contains(IMAGE_PNG) ? (list.contains(IMAGEMAP) ? IMAGEMAP : IMAGE_PNG) : list.get(0);
        return string2;
    }

    static String getInstanceSpecFromRequest(BIBusEnvelope bIBusEnvelope, String string) throws CGSExtnChartingSOAPException {
        Element element = bIBusEnvelope.getBody();
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            if (!element.getName().equalsIgnoreCase(string)) continue;
            Iterator iterator2 = element.elementIterator();
            while (iterator2.hasNext()) {
                element = (Element)iterator2.next();
                if (!element.getName().equalsIgnoreCase("specification") || !BUS_EXTN_CHARTING_SPEC.getQualifiedName().equalsIgnoreCase(element.attribute(BIBusEnvelope.XSI_TYPE).getValue())) continue;
                Iterator iterator3 = element.elementIterator();
                while (iterator3.hasNext()) {
                    element = (Element)iterator3.next();
                    if (!element.getName().equalsIgnoreCase("value")) continue;
                    return element.getTextTrim();
                }
            }
        }
        LOGGER.error("Invalid Instance XML in SOAP request");
        throw new CGSExtnChartingSOAPException(bIBusEnvelope, false, "Invalid Instance XML in SOAP request", null);
    }

    static boolean isVisOutputServiceRequest(Element element, String string) {
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            if (!string.equalsIgnoreCase(element.getName())) continue;
            Iterator iterator2 = element.elementIterator();
            while (iterator2.hasNext()) {
                element = (Element)iterator2.next();
                Attribute attribute = element.attribute(BIBusEnvelope.XSI_TYPE);
                if (!"specification".equalsIgnoreCase(element.getName()) || attribute == null || !BUS_EXTN_CHARTING_SPEC.getQualifiedName().equalsIgnoreCase(attribute.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private static Map<String, String> getHttpHeaders(BIBusEnvelope bIBusEnvelope) {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = bIBusEnvelope.getSetCookieValue("cam_passport");
        if (string2 == null && (string2 = bIBusEnvelope.getCookieValue("cam_passport")) == null && (string = bIBusEnvelope.getPassportID()) != null) {
            string2 = CGSVisOutputRequestHelper.generateCAMCookie(string);
        }
        stringBuilder.append("cam_passport=");
        stringBuilder.append(string2);
        string = bIBusEnvelope.getSetCookieValue("XSRF-TOKEN");
        if (string == null && (string = bIBusEnvelope.getCookieValue("XSRF-TOKEN")) == null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date date = new Date();
            String string3 = simpleDateFormat.format(date);
            Base64.Encoder encoder = Base64.getEncoder();
            string = encoder.encodeToString(string3.getBytes());
        }
        stringBuilder.append("; XSRF-TOKEN=");
        stringBuilder.append(string);
        hashMap.put("Cookie", stringBuilder.toString());
        hashMap.put("X-XSRF-TOKEN", string);
        return hashMap;
    }

    static Map<String, byte[]> generateChartOutput(BIBusEnvelope bIBusEnvelope, String string, String string2, String string3) throws CGSExtnChartingSOAPException {
        String string4 = CGSVisOutputRequestHelper.getContentTypeFromRequest(bIBusEnvelope, string3);
        LOGGER.info("Content-Type request parameter:" + string4);
        try {
            String string5 = CGSVisOutputRequestHelper.getInstanceSpecFromRequest(bIBusEnvelope, string3);
            LOGGER.debug("Instance XML: " + string5);
            CognosGallery cognosGallery = new CognosGallery(string, string2, CGSVisOutputRequestHelper.getPassportCookie(bIBusEnvelope), httpClient);
            Map<String, String> map = CGSVisOutputRequestHelper.getHttpHeaders(bIBusEnvelope);
            VisualizationService visualizationService = VisualizationServiceFactory.getService((Gallery)cognosGallery, map);
            Map map2 = visualizationService.generate(string5, string4);
            LOGGER.debug("Generated chart output through VisOutput service");
            return map2;
        }
        catch (VisualizationException visualizationException) {
            LOGGER.error("LOG_RESULT : Failed to generate chart from Extensible charting service.\nException trace:", (Throwable)visualizationException);
            throw new CGSExtnChartingSOAPException(bIBusEnvelope, true, "Failed to generate chart from Extensible charting service.", visualizationException);
        }
        catch (Exception exception) {
            LOGGER.error("LOG_RESULT : Failed to generate chart from Extensible charting service.\nException trace:", (Throwable)exception);
            throw new CGSExtnChartingSOAPException(bIBusEnvelope, true, "Failed to generate chart from Extensible charting service.", exception);
        }
    }

    static String getPassportCookie(BIBusEnvelope bIBusEnvelope) {
        String string;
        String string2 = bIBusEnvelope.getSetCookieValue("cam_passport");
        if (string2 == null && (string2 = bIBusEnvelope.getCookieValue("cam_passport")) == null && (string = bIBusEnvelope.getPassportID()) != null) {
            string2 = CGSVisOutputRequestHelper.generateCAMCookie(string);
        }
        return string2;
    }

    static String generateCAMCookie(String string) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(1);
        stringBuilder.append(";");
        stringBuilder.append(string);
        stringBuilder.append(";");
        stringBuilder.append(FLAG_NOT_SET);
        stringBuilder.append(";");
        stringBuilder.append(1);
        stringBuilder.append(";");
        stringBuilder.append(FLAG_NOT_SET);
        stringBuilder.append(";");
        try {
            string2 = CCLWeb64.encode((byte[])stringBuilder.toString().getBytes(UTF8));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = "";
        }
        return string2;
    }

    StringBuilder appendHeader(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string);
        stringBuilder.append(CRLF);
        return stringBuilder;
    }
}

