/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CMByteBuffer {
    protected ByteArrayOutputStream m_buffer = new ByteArrayOutputStream();
    protected ByteBuffer m_intBuf = null;
    protected ByteBuffer m_doubleBuf = null;
    protected byte[] m_nullByte = new byte[1];

    public CMByteBuffer() {
        this.m_intBuf = ByteBuffer.allocate(4);
        this.m_intBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_doubleBuf = ByteBuffer.allocate(8);
        this.m_doubleBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_nullByte[0] = 0;
    }

    public void destroy() {
        this.m_buffer = null;
        this.m_intBuf = null;
        this.m_doubleBuf = null;
    }

    public void reset() {
        this.m_buffer = new ByteArrayOutputStream();
    }

    public int pcount() {
        return this.m_buffer.size();
    }

    public byte[] str() {
        return this.m_buffer.toByteArray();
    }

    public void appendBytes(byte[] byArray) {
        try {
            this.m_buffer.write(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void appendRawString(String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            this.appendBytes(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void appendString(String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            this.appendInt(byArray.length);
            this.appendBytes(byArray);
            this.appendBytes(this.m_nullByte);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void appendInt(int n) {
        this.m_intBuf.putInt(0, n);
        this.appendBytes(this.m_intBuf.array());
    }

    public void appendDouble(double d) {
        this.m_doubleBuf.putDouble(0, d);
        this.appendBytes(this.m_doubleBuf.array());
    }
}

