/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Common.Regression;

import com.ibm.cgsBus.Common.CMPointFloat2;
import com.ibm.cgsBus.Common.Regression.CMRegressionEquation;
import java.util.ArrayList;

public class CMMovingAverageEquation
extends CMRegressionEquation {
    private int m_period = 2;
    private ArrayList<Double> m_yData;
    private ArrayList<Double> m_xData;

    protected double calculateY(int n) {
        if (n < 0 || n >= this.m_yData.size()) {
            return Double.NaN;
        }
        int n2 = n - (this.m_period - 1);
        if (n2 < 0) {
            return Double.NaN;
        }
        double d = 0.0;
        for (int i = n2; i <= n; ++i) {
            Double d2 = this.m_yData.get(i);
            d += d2.doubleValue();
        }
        return d / (double)this.m_period;
    }

    public void setPeriod(int n) {
        this.m_period = n;
    }

    public int getPeriod() {
        return this.m_period;
    }

    @Override
    public String getEquationToString() {
        return "";
    }

    @Override
    public boolean hasEquationValue() {
        return false;
    }

    @Override
    public boolean hasRSquaredValue() {
        return false;
    }

    @Override
    public void calculateEquation(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        if (this.m_period < 1) {
            this.m_period = 1;
        } else if (this.m_period > arrayList2.size() - 1) {
            this.m_period = arrayList2.size() - 1;
        }
        this.m_yData = arrayList2;
        this.m_xData = arrayList;
    }

    @Override
    public CMPointFloat2[] calculateLine(float[] fArray, float[] fArray2) {
        CMPointFloat2[] cMPointFloat2Array = new CMPointFloat2[this.m_xData.size()];
        double d = fArray[0];
        double d2 = fArray[1];
        double d3 = 0.0;
        for (int i = 0; i < this.m_xData.size(); ++i) {
            CMPointFloat2 cMPointFloat2;
            Double d4 = this.m_xData.get(i);
            if (d4 < d || d4 > d2 || Double.isNaN(d3 = this.calculateY(i))) continue;
            cMPointFloat2Array[i] = cMPointFloat2 = new CMPointFloat2(d4.floatValue(), (float)d3);
        }
        return cMPointFloat2Array;
    }
}

