/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Common.Regression;

import com.ibm.cgsBus.Common.Regression.CMNumberMatrixRow;
import java.util.ArrayList;
import java.util.Collections;

public class CMNumberMatrix {
    private ArrayList<double[]> m_rows;

    public CMNumberMatrix(ArrayList<double[]> arrayList) {
        this.m_rows = arrayList;
    }

    public ArrayList<Double> solve() {
        ArrayList<double[]> arrayList = this.makeUpperTriangular().getRows();
        double[] dArray = arrayList.get(arrayList.size() - 1);
        int n = dArray.length;
        int n2 = n - 1;
        int n3 = n - 2;
        double d = dArray[n2] / dArray[n3];
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        arrayList2.add(new Double(d));
        for (int i = arrayList.size() - 2; i > -1; --i) {
            double[] dArray2 = arrayList.get(i);
            double d2 = dArray2[n2];
            double d3 = 0.0;
            int n4 = 0;
            int n5 = n3;
            while (n4 < arrayList2.size()) {
                d3 += arrayList2.get(n4) * dArray2[n5];
                ++n4;
                --n5;
            }
            d = (d2 - d3) / dArray2[n5];
            arrayList2.add(new Double(d));
        }
        Collections.reverse(arrayList2);
        return arrayList2;
    }

    private CMNumberMatrix makeUpperTriangular() {
        double[] dArray = this.m_rows.get(0);
        int n = dArray.length - 3;
        CMNumberMatrix cMNumberMatrix = this;
        for (int i = 0; i <= n; ++i) {
            cMNumberMatrix = new CMNumberMatrix(cMNumberMatrix.makePivotRows(i));
        }
        return cMNumberMatrix;
    }

    private ArrayList<double[]> makePivotRows(int n) {
        int n2;
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        int n3 = Math.min(n, this.m_rows.size() - 1);
        for (n2 = 0; n2 <= n3; ++n2) {
            arrayList.add(this.m_rows.get(n2));
        }
        CMNumberMatrixRow cMNumberMatrixRow = new CMNumberMatrixRow((double[])arrayList.get(n3));
        int n4 = this.m_rows.size();
        for (n2 = n3 + 1; n2 < n4; ++n2) {
            CMNumberMatrixRow cMNumberMatrixRow2 = new CMNumberMatrixRow(this.m_rows.get(n2));
            CMNumberMatrixRow cMNumberMatrixRow3 = cMNumberMatrixRow.makePivot(cMNumberMatrixRow2, n3);
            if (cMNumberMatrixRow3 == null) continue;
            arrayList.add(cMNumberMatrixRow3.getData());
        }
        return arrayList;
    }

    public ArrayList<double[]> getRows() {
        return this.m_rows;
    }
}

