/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.Common.Regression;

import com.ibm.cgsBus.Common.CMPointFloat2;
import com.ibm.cgsBus.Common.Regression.CMILineEquation;
import com.ibm.cgsBus.Common.Regression.CMPowerFilter;
import com.ibm.cgsBus.Common.Regression.CMRegressionEquation;
import java.util.ArrayList;

public class CMPowerEquation
extends CMRegressionEquation
implements CMILineEquation {
    @Override
    public double calculateY(double d) {
        return this.m_a * Math.pow(d, this.m_b);
    }

    @Override
    public String getEquationToString() {
        if (Double.isNaN(this.m_a) || Double.isNaN(this.m_b)) {
            return "";
        }
        return "y = " + this.formatValue(this.m_a) + "x^" + this.formatValue(this.m_b);
    }

    @Override
    public void calculateEquation(ArrayList<Double> arrayList, ArrayList<Double> arrayList2) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) != 0.0 && arrayList2.get(i) != 0.0) continue;
            arrayList.remove(i);
            arrayList2.remove(i);
        }
        double[] dArray = this.calculateLeastSquaresCoefficients(arrayList, arrayList2, new CMPowerFilter());
        double d = dArray[0];
        double d2 = dArray[1];
        this.m_rSquared = dArray[2];
        this.m_a = Math.exp(d2);
        this.m_b = d;
    }

    @Override
    public CMPointFloat2[] calculateLine(float[] fArray, float[] fArray2) {
        return this.calculateNonLinearLine(fArray, fArray2);
    }
}

