/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.DrawContext;

import com.avs.openviz3.chart.AnchorPointDepthPositionEnum;
import com.avs.openviz3.chart.BarChart;
import com.avs.openviz3.chart.ChartTypeEnum;
import com.avs.openviz3.fw.BevelStyleEnum;
import com.avs.openviz3.fw.base.ComponentExceptionListener;
import com.avs.openviz3.fw.base.IAttributeSceneNode;
import com.avs.openviz3.fw.base.IAxisMapSource;
import com.avs.openviz3.fw.base.ISceneNode;
import com.avs.openviz3.fw.base.ISurfaceFaceAttributeSceneNode;
import com.avs.openviz3.fw.base.ITextAttributes;
import com.avs.openviz3.viewer.GeometrySceneNode;
import com.ibm.cgsBus.DrawContext.DCDrawContextOV;
import com.ibm.cgsBus.DrawContext.OVChartCartesian;
import com.ibm.cgsBus.DrawContext.OVHelper;
import com.ibm.cgsBus.FrameWork.CGSFormatter;
import com.ibm.cgsBus.FrameWork.CGSWidget;
import com.ibm.cgsBus.Graphics.GRLegendItemIcon;
import com.ibm.cgsBus.Properties.CGSPropChartProgressive;
import com.ibm.cgsBus.Properties.CGSPropConnectingLine;
import com.ibm.cgsBus.Properties.CGSPropDataLabelsB;
import com.ibm.cgsBus.Properties.CGSPropFormatNumeric;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeFillEffect;
import java.awt.Color;

public class OVProgressiveChart
extends OVChartCartesian {
    protected CGSPropChartProgressive m_propChartProgressive = null;
    protected BarChart m_ovProgressiveChart = null;

    public OVProgressiveChart(DCDrawContextOV dCDrawContextOV) {
        super(dCDrawContextOV);
        this.init(dCDrawContextOV);
    }

    @Override
    protected void init(DCDrawContextOV dCDrawContextOV) {
        super.init(dCDrawContextOV);
        this.m_propChartProgressive = (CGSPropChartProgressive)this.getChart();
        if (this.getDepth() >= 1.0f) {
            dCDrawContextOV.getOutputDevice().vectorTransparencyNotSupported();
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_propChartProgressive = null;
        this.m_ovProgressiveChart = null;
    }

    @Override
    protected void prepareData() {
        CGSPropChartProgressive cGSPropChartProgressive = (CGSPropChartProgressive)this.getChart();
        Object[] objectArray = this.m_pData.getGridColumns();
        int n = this.m_pData.getCategoryColumnCount() > 0 ? ((Object[])objectArray[0]).length : ((double[])objectArray[0]).length;
        int n2 = this.m_pData.getGridSeriesIndex(0);
        String[] stringArray = (String[])objectArray[this.m_pData.getShowDataValueColumn(n2)];
        double[] dArray = (double[])objectArray[n2];
        boolean bl = cGSPropChartProgressive.getShowTotalBar();
        boolean bl2 = this.m_pWidget.isCategoriesReversed();
        int n3 = bl2 ? n - 1 : 0;
        int n4 = bl2 ? 0 : n - 1;
        int n5 = bl2 ? -1 : 1;
        int[] nArray = (int[])this.m_pData.getGridColumns()[this.m_pData.getGridRowIndexColumn()];
        double d = 0.0;
        double d2 = 0.0;
        for (int i = n3; i >= 0 && i < n; i += n5) {
            double d3;
            double d4 = d3 = bl2 ? -dArray[i] : dArray[i];
            if (Double.isNaN(d3)) {
                d3 = 0.0;
            }
            double d5 = d3;
            if (cGSPropChartProgressive.getShowDataValues() == CGSEnums.DataValuesType.eDataValuesCumulative) {
                if (i != n4 || !bl) {
                    d += d3;
                }
                d3 = d;
            }
            if (this.useCumulativeValueDA()) {
                if (i != n4 || !bl) {
                    d2 += d5;
                }
                d5 = d2;
            }
            if (i == n4 && bl) {
                CGSPropFormatNumeric cGSPropFormatNumeric = (CGSPropFormatNumeric)cGSPropChartProgressive.getProp(CGSEnums.PropType.ePropFormatNumeric);
                CGSFormatter cGSFormatter = this.m_pWidget.getFormatter(cGSPropFormatNumeric);
                cGSFormatter.setAttributes(cGSPropFormatNumeric);
                if (cGSPropChartProgressive.getShowDataValues() == CGSEnums.DataValuesType.eDataValuesAbsolute) {
                    d3 = -d3;
                }
                if (!this.useCumulativeValueDA()) {
                    d5 = -d5;
                }
                stringArray[i] = cGSFormatter.applyFormat(d3);
                this.m_pData.addFormattedValueToCell(nArray[i], n2, cGSFormatter.applyFormat(d5));
                String string = this.m_propChartProgressive.getTotalBarLabel();
                this.m_pData.addFormattedValueToCell(n - 1, n2, CGSEnums.FormattedStringIndex.eFormattedStringTotalLabel.getValue(), string);
                continue;
            }
            stringArray[i] = this.m_pWidget.getDataValueAsString(nArray[i], n2, d3, CGSWidget.DataTableId.eDataTableDefault);
            this.m_pData.addFormattedValueToCell(nArray[i], n2, this.m_pWidget.getDataValueAsString(i, n2, d5, CGSWidget.DataTableId.eDataTableDefault));
        }
        this.fixGridColumnAmpersandEncoding(n2);
        super.prepareData();
    }

    private void fixGridColumnAmpersandEncoding(int n) {
        if (!this.m_pDrawContext.isDrawingLegend()) {
            this.m_pData.fixGridColumnAmpersandEncoding(this.m_pData.getShowDataValueColumn(n));
        }
    }

    private boolean useCumulativeValueDA() {
        return this.m_propChartProgressive.getDataValuesDA() == CGSEnums.DataValuesTypeDA.eDataValuesCumulativeDA || this.m_propChartProgressive.getDataValuesDA() == CGSEnums.DataValuesTypeDA.eDataValuesDisplayDA && this.m_propChartProgressive.getShowDataValues() == CGSEnums.DataValuesType.eDataValuesCumulative;
    }

    @Override
    public void applyProperties() {
        super.applyProperties();
        this.createChart();
        this.addChartData();
        this.applyChartProperties();
        this.createAxis();
        this.createMarkers(this.m_propChartProgressive.getMarkerList());
    }

    protected void createChart() {
        this.initializeDiscreteAxisMap(false);
        this.m_ovProgressiveChart = new BarChart();
        this.m_ovProgressiveChart.addComponentExceptionListener((ComponentExceptionListener)this);
        this.m_ovProgressiveChart.connectInputField(this.getInputField());
        this.addChartToDomain((ISceneNode)this.m_ovProgressiveChart, 1);
        OVHelper.applyMaterialEffect((IAttributeSceneNode)this.m_ovProgressiveChart, this.m_propChartProgressive.getMaterialEffect());
    }

    protected void addChartData() {
        for (int i = 0; i < this.m_pData.getGridColumnCount(); ++i) {
            if (this.m_pData.getGridColumnType(i) != 4) continue;
            this.m_ovProgressiveChart.newSeries(this.getSeriesIndex(i));
            break;
        }
        this.setImageMapTemplate();
    }

    private void setImageMapTemplate() {
        if (this.m_pWidget.isDetectionAreaRequired(CGSEnums.DetArea.eDetChartElement, 0)) {
            int n = this.getSeriesIndex(this.m_pData.getGridRowIndexColumn());
            this.m_ovProgressiveChart.setImageMapTemplate("[" + CGSEnums.DetArea.eDetChartElement.getValue() + " " + CGSWidget.DataType.eCategory.getValue() + " <SeriesIndex> <Array" + n + "> 0]");
        }
    }

    protected void applyChartProperties() {
        CGSPropConnectingLine cGSPropConnectingLine;
        BarChart.BarSeries barSeries = this.m_ovProgressiveChart.getSeries(0);
        this.m_ovProgressiveChart.setType(ChartTypeEnum.PROGRESSIVE);
        this.m_ovProgressiveChart.setCrossOverValueAsObject((Object)new Double(0.0));
        if (this.m_propChartProgressive.getShowOutline()) {
            this.m_ovProgressiveChart.setShowBorder(true);
            this.applyOutline(this.m_ovProgressiveChart.getLineAttributes(), this.m_propChartProgressive.getOutlineColor());
            if (this.m_pDrawContext.getOutputDevice().isRaster() || this.m_pDrawContext.getOutputDevice().isSVG()) {
                this.m_ovProgressiveChart.getLineAttributes().setExcludeLinesFromImageMap(true);
            }
        } else {
            this.m_ovProgressiveChart.setShowBorder(false);
        }
        if ((cGSPropConnectingLine = (CGSPropConnectingLine)this.m_propChartProgressive.getProp(CGSEnums.PropType.ePropConnectingLine)).getVisible()) {
            this.m_ovProgressiveChart.setShowProgressiveLines(true);
            IAttributeSceneNode iAttributeSceneNode = this.m_ovProgressiveChart.getProgressLineSceneNode();
            this.applyPropLineAttributes(iAttributeSceneNode.getLineAttributes(), cGSPropConnectingLine);
        }
        if (this.m_propChartProgressive.getShowDataValues() != CGSEnums.DataValuesType.eDataValuesNone) {
            int n;
            for (n = 0; n < this.m_pData.getGridColumnCount() && this.m_pData.getGridColumnType(n) != 4; ++n) {
            }
            barSeries.setLabelTemplate("<Array" + this.getShowDataValuesIndex(n) + ">");
            ITextAttributes iTextAttributes = this.m_ovProgressiveChart.getTextAttributes();
            this.applyFontProperties(this.m_propChartProgressive, iTextAttributes);
            CGSPropDataLabelsB cGSPropDataLabelsB = (CGSPropDataLabelsB)this.m_propChartProgressive.getProp(CGSEnums.PropType.ePropDataLabelsB);
            OVProgressiveChart.setDataLabelProperties(barSeries, cGSPropDataLabelsB, this.m_ovProgressiveChart.getLabelProperties());
            barSeries.getLabelSceneNode().getSceneNodeAttributes().setExcludeFromClipping(true);
            barSeries.getLabelSceneNode().getSceneNodeAttributes().setExcludeFromSceneExtents(this.m_pDrawContext.isClipping());
            barSeries.getLabelProperties().setAnchorPointDepthPosition(AnchorPointDepthPositionEnum.FRONT);
            barSeries.getLabelProperties().setAnchorPointHeightPosition(OVHelper.getLabelAnchorPosition(this.m_propChartProgressive.getDataTextLocation()));
        }
        this.m_ovProgressiveChart.setWidthScale(this.m_propChartProgressive.getWidthScale() / 100.0001);
        this.m_ovProgressiveChart.setStyle(OVHelper.getBarStyle(this.m_propChartProgressive.getBarStyle()));
        this.m_ovProgressiveChart.setBevelStyle(OVHelper.getBevelStyle(this.m_propChartProgressive.getBevelType()));
        this.m_ovProgressiveChart.setBevelWidth(0.1);
        if (OVHelper.getBevelStyle(this.m_propChartProgressive.getBevelType()) != BevelStyleEnum.NONE) {
            this.m_pDrawContext.getOutputDevice().disableBackfaceCull();
        }
    }

    protected void createAxis() {
        this.addOutputValueAxisMap((IAxisMapSource)this.m_ovProgressiveChart.getOutputValueAxisMap(), 1);
        this.setOutputSeriesAxisMap((IAxisMapSource)this.m_ovProgressiveChart.getOutputSeriesAxisMap());
        this.createAxesXY(CGSEnums.PropType.ePropDiscreteAxisX, CGSEnums.PropType.ePropNumericAxisY);
    }

    @Override
    protected void postSceneTreeBuild() {
        super.postSceneTreeBuild();
        this.applyPaletteToBars(this.m_ovProgressiveChart, 0);
    }

    @Override
    protected float getDepth() {
        return this.m_propChartProgressive.getDepth();
    }

    @Override
    protected boolean isVerticalOrientation() {
        return this.m_propChartProgressive.getVerticalOrientation();
    }

    protected void addLegendEntry(CGSTypeFillEffect cGSTypeFillEffect, CGSWidget.DataType dataType, String string) {
        if (!this.m_pDrawContext.isDrawingLegend()) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        GRLegendItemIcon gRLegendItemIcon = new GRLegendItemIcon();
        gRLegendItemIcon.dataPointShapeFill = cGSTypeFillEffect;
        gRLegendItemIcon.dataPointShapeB = CGSEnums.MarkerShapeB.eMarkerSquareB;
        gRLegendItemIcon.dataPointShapeOutlineColor = this.m_propChartProgressive.getShowOutline() ? this.m_propChartProgressive.getOutlineColor() : null;
        gRLegendItemIcon.materialEffect = this.m_propChartProgressive.getMaterialEffect();
        boolean bl = this.m_pWidget.isDetectionAreaRequired(CGSEnums.DetArea.eDetLegendLabel, 0);
        this.m_pDrawContext.getLegend().addChartItem(string, dataType, gRLegendItemIcon, 0, bl, 0);
    }

    protected boolean isFillEffectNone(CGSTypeFillEffect cGSTypeFillEffect) {
        return cGSTypeFillEffect.getType() == CGSEnums.FillType.eFillPattern && cGSTypeFillEffect.getPatternType() == CGSEnums.PatternType.ePatternNone;
    }

    protected boolean applyFillEffect(int n, ISurfaceFaceAttributeSceneNode iSurfaceFaceAttributeSceneNode, CGSTypeFillEffect cGSTypeFillEffect) {
        boolean bl = false;
        int n2 = this.getConditionalPaletteIndex(0, n, 0);
        if (n2 == -1) {
            if (this.isFillEffectNone(cGSTypeFillEffect)) {
                this.applyDiscretePaletteItem(iSurfaceFaceAttributeSceneNode, this.getPaletteIndex(0, n, 0), null, null);
            } else {
                this.applyFillEffect(cGSTypeFillEffect, iSurfaceFaceAttributeSceneNode);
                bl = true;
            }
        } else {
            this.applyConditionalPaletteItem(iSurfaceFaceAttributeSceneNode, n2, null, null);
        }
        return bl;
    }

    @Override
    protected void applyPaletteToBars(BarChart barChart, int n) {
        int n2 = this.m_pData.getGridSeriesIndex(0);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        CGSTypeFillEffect cGSTypeFillEffect = this.m_propChartProgressive.getPositiveBarFillEffect();
        CGSTypeFillEffect cGSTypeFillEffect2 = this.m_propChartProgressive.getNegativeBarFillEffect();
        CGSTypeFillEffect cGSTypeFillEffect3 = this.m_propChartProgressive.getFirstBarFillEffect();
        CGSTypeFillEffect cGSTypeFillEffect4 = this.m_propChartProgressive.getTotalBarFillEffect();
        double d = 0.0;
        boolean bl4 = this.m_pWidget.isCategoriesReversed();
        boolean bl5 = this.m_propChartProgressive.getShowTotalBar();
        int n3 = ((Object[])this.m_pData.getGridColumns()[0]).length;
        int n4 = bl4 ? n3 - 1 : 0;
        int n5 = bl4 ? 0 : n3 - 1;
        int n6 = bl4 ? -1 : 1;
        int n7 = n4;
        BarChart.BarSeries barSeries = barChart.getSeries(0);
        for (int i = n7; i >= 0 && i < n3; i += n6) {
            GeometrySceneNode geometrySceneNode = barChart.getSelectedSceneNode(barSeries, i);
            if (!(geometrySceneNode instanceof ISurfaceFaceAttributeSceneNode)) continue;
            if (i == n4 && this.applyFillEffect(i, (ISurfaceFaceAttributeSceneNode)geometrySceneNode, cGSTypeFillEffect3)) {
                bl3 = true;
                if (!this.m_propChartProgressive.getShowFirstBarLabel()) continue;
                String string = this.m_propChartProgressive.getFirstBarLabel();
                if (string.length() == 0) {
                    string = (String)((Object[])this.m_pData.getGridColumns()[0])[n4];
                }
                this.addLegendEntry(cGSTypeFillEffect3, CGSWidget.DataType.eSeries, string);
                continue;
            }
            if (i == n5 && bl5 && this.applyFillEffect(i, (ISurfaceFaceAttributeSceneNode)geometrySceneNode, cGSTypeFillEffect4)) {
                bl3 = true;
                if (this.m_propChartProgressive.getTotalBarLabel().length() == 0) continue;
                this.addLegendEntry(cGSTypeFillEffect4, CGSWidget.DataType.eSeries, this.m_propChartProgressive.getTotalBarLabel());
                continue;
            }
            if (i == n5 && bl5) {
                d = ((double[])this.m_pData.getGridColumns()[n2])[i];
                if (!bl4) {
                    d = -d;
                }
            } else {
                int n8 = i;
                if (bl5 && bl4) {
                    n8 = n3 - i - 1;
                }
                int n9 = this.m_pData.getTableRowIndex(n8, n2);
                int n10 = this.m_pData.getTableColumnIndex(n8, n2);
                d = this.m_pData.getRow(n9).getValueAt(n10);
            }
            if (Double.isNaN(d)) continue;
            if (d >= 0.0) {
                if (!this.applyFillEffect(i, (ISurfaceFaceAttributeSceneNode)geometrySceneNode, cGSTypeFillEffect)) continue;
                bl3 = true;
                if (!bl || this.m_propChartProgressive.getPositiveBarLabel().length() == 0) continue;
                this.addLegendEntry(cGSTypeFillEffect, CGSWidget.DataType.eSeries, this.m_propChartProgressive.getPositiveBarLabel());
                bl = false;
                continue;
            }
            if (!this.applyFillEffect(i, (ISurfaceFaceAttributeSceneNode)geometrySceneNode, cGSTypeFillEffect2)) continue;
            bl3 = true;
            if (!bl2 || this.m_propChartProgressive.getNegativeBarLabel().length() == 0) continue;
            this.addLegendEntry(cGSTypeFillEffect2, CGSWidget.DataType.eSeries, this.m_propChartProgressive.getNegativeBarLabel());
            bl2 = false;
        }
        if (!bl3) {
            this.addLegendEntry(this.getFillEffect(0, CGSEnums.PropType.ePropPaletteDiscreteB, true), CGSWidget.DataType.eMeasure, this.m_pData.getAxisTitle(1));
        }
    }

    @Override
    protected Color getOutlineColor(int n) {
        return this.m_propChartProgressive.getShowOutline() ? this.m_propChartProgressive.getOutlineColor() : null;
    }

    @Override
    protected boolean is3DViewportRequired() {
        return this.hasDepth();
    }
}

