/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cgsBus.DrawContext;

import com.avs.openviz3.chart.AnchorPointDepthPositionEnum;
import com.avs.openviz3.chart.ILabelProperties;
import com.avs.openviz3.chart.LabelFittingEnum;
import com.avs.openviz3.chart.ScatterChart;
import com.avs.openviz3.filter.DiscreteDataMap;
import com.avs.openviz3.fw.base.ComponentExceptionListener;
import com.avs.openviz3.fw.base.ISceneNode;
import com.avs.openviz3.fw.base.ISurfaceFaceAttributeSceneNode;
import com.avs.openviz3.glyphs.CircleGlyph;
import com.avs.openviz3.glyphs.IGlyph;
import com.avs.openviz3.glyphs.Sphere32Glyph;
import com.ibm.cgsBus.DrawContext.DCDrawContextOV;
import com.ibm.cgsBus.DrawContext.OVChart;
import com.ibm.cgsBus.DrawContext.OVChartCartesian;
import com.ibm.cgsBus.DrawContext.OVHelper;
import com.ibm.cgsBus.FrameWork.CGSDataMultimeasure;
import com.ibm.cgsBus.FrameWork.CGSWidget;
import com.ibm.cgsBus.Graphics.GRLegend;
import com.ibm.cgsBus.Graphics.GRLegendItemIcon;
import com.ibm.cgsBus.Properties.CGSPropChart;
import com.ibm.cgsBus.Properties.CGSPropDataLabelsB;
import com.ibm.cgsBus.Properties.CGSPropPaletteConditionalItemB;
import com.ibm.cgsBus.Properties.CGSPropPaletteDiscreteB;
import com.ibm.cgsBus.Properties.CGSPropPaletteDiscreteItemB;
import com.ibm.cgsBus.Types.CGSEnums;
import com.ibm.cgsBus.Types.CGSTypeFillEffect;
import java.awt.Color;

public abstract class OVScatterBase
extends OVChartCartesian {
    protected ScatterChart m_ovScatterChart = null;
    protected IGlyph[] m_glyphs = null;
    protected CGSPropDataLabelsB m_propDataLabels = null;
    protected int m_dataRowIndex = -1;
    protected int m_gridFirstSeriesCol = -1;
    protected int m_gridFirstSeriesColorByValueCol = -1;
    protected int m_gridGlyphSizeCol = -1;
    protected int m_gridSeriesNameCol = -1;
    protected int m_dataLabelIndex = -1;
    protected int m_gridCategoryIndexCol = -1;
    protected int m_gridSeriesIndexCol = -1;

    public OVScatterBase(DCDrawContextOV dCDrawContextOV) {
        super(dCDrawContextOV);
    }

    @Override
    protected void init(DCDrawContextOV dCDrawContextOV) {
        super.init(dCDrawContextOV);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_ovScatterChart = null;
        this.m_glyphs = null;
        this.m_propDataLabels = null;
        this.m_dataRowIndex = -1;
        this.m_gridFirstSeriesCol = -1;
        this.m_gridFirstSeriesColorByValueCol = -1;
        this.m_gridGlyphSizeCol = -1;
        this.m_gridSeriesNameCol = -1;
        this.m_dataLabelIndex = -1;
        this.m_gridCategoryIndexCol = -1;
        this.m_gridSeriesIndexCol = -1;
    }

    protected void setItemIndices() {
        int n = this.m_pData.getGridColumnCount();
        for (int i = 0; i < n; ++i) {
            int n2 = this.m_pData.getGridColumnType(i);
            if (n2 == 15 && this.m_gridSeriesNameCol == -1) {
                this.m_gridSeriesNameCol = i;
                continue;
            }
            if (n2 == 14 && this.m_gridGlyphSizeCol == -1) {
                this.m_gridGlyphSizeCol = i;
                continue;
            }
            if (n2 == 5 && this.m_dataRowIndex == -1) {
                this.m_dataRowIndex = i;
                continue;
            }
            if (n2 == 4 && this.m_gridFirstSeriesCol == -1) {
                this.m_gridFirstSeriesCol = i;
                continue;
            }
            if (n2 == 10 && this.m_gridFirstSeriesColorByValueCol == -1) {
                this.m_gridFirstSeriesColorByValueCol = i;
                continue;
            }
            if (n2 == 0 && this.m_dataLabelIndex == -1) {
                this.m_dataLabelIndex = i;
                continue;
            }
            if (n2 == 17 && this.m_gridCategoryIndexCol == -1) {
                this.m_gridCategoryIndexCol = i;
                continue;
            }
            if (n2 != 16 || this.m_gridSeriesIndexCol != -1) continue;
            this.m_gridSeriesIndexCol = i;
        }
    }

    @Override
    protected void prepareData() {
        int n;
        int n2;
        int n3;
        int n4;
        CGSDataMultimeasure cGSDataMultimeasure = (CGSDataMultimeasure)this.m_pData;
        int n5 = cGSDataMultimeasure.getPointCount();
        int n6 = this.m_pWidget.getMeasureCount();
        Object[] objectArray = this.m_pData.getGridColumns();
        this.setItemIndices();
        for (n4 = 0; n4 < n5; ++n4) {
            int n7 = this.m_gridFirstSeriesCol;
            int n8 = this.m_pData.getShowDataValueColumn(n7);
            for (n3 = 0; n3 < n6; ++n3) {
                String string;
                double d = ((double[])objectArray[n7])[n4];
                n2 = cGSDataMultimeasure.getPointCategoryIndex(n4);
                int n9 = cGSDataMultimeasure.getPointSeriesIndex(n4);
                n = this.m_pData.getGridSeriesIndex(n9);
                int n10 = n + n3;
                ((String[])objectArray[n8])[n4] = string = this.m_pWidget.getDataValueAsString(n2, n10, d, CGSWidget.DataTableId.eDataTableDefault);
                int n11 = this.m_pData.getTableColumnIndex(n2, n10);
                this.m_pData.addFormattedValueToCell(n2, n, n11, string);
                ++n7;
                ++n8;
            }
        }
        this.fixGridColumnAmpersandEncoding(n6);
        for (n4 = 0; n4 < n5; ++n4) {
            double d = ((double[])objectArray[this.m_gridFirstSeriesColorByValueCol])[n4];
            n3 = cGSDataMultimeasure.getPointCategoryIndex(n4);
            int n12 = cGSDataMultimeasure.getPointSeriesIndex(n4);
            int n13 = this.m_pData.getGridSeriesIndex(n12);
            n2 = cGSDataMultimeasure.getBaseColumnByType(10, n13);
            if (n2 < 0) continue;
            String string = this.m_pWidget.getDataValueAsString(n3, n2, d, CGSWidget.DataTableId.eDataTableDefault);
            n = this.m_pData.getTableColumnIndex(n3, n2);
            this.m_pData.addFormattedValueToCell(n3, n13, n, string);
        }
        this.calculateBubbleSizeScale();
        super.prepareData();
    }

    private void fixGridColumnAmpersandEncoding(int n) {
        int n2 = this.m_pData.getShowDataValueColumn(this.m_gridFirstSeriesCol);
        if (!this.m_pDrawContext.isDrawingLegend()) {
            for (int i = 0; i < n; ++i) {
                this.m_pData.fixGridColumnAmpersandEncoding(n2);
                ++n2;
            }
        }
    }

    @Override
    public void applyProperties() {
        super.applyProperties();
        this.m_conditionalIconType = OVChart.ConditionalIconType.ePoint;
        this.createChart();
        this.getProperties();
        this.addChartData();
        this.applyChartProperties();
        this.createAxis();
    }

    protected abstract void createAxis();

    protected abstract void getProperties();

    protected abstract void addChartData();

    protected abstract void applyChartProperties();

    protected abstract CGSPropChart.MaterialEffect getMaterialEffect();

    protected abstract void calculateBubbleSizeScale();

    protected final void createChart() {
        this.m_ovScatterChart = new ScatterChart();
        this.m_ovScatterChart.addComponentExceptionListener((ComponentExceptionListener)this);
        this.m_ovScatterChart.connectInputField(this.m_pTableMapper.getOutputField());
        this.addChartToDomain((ISceneNode)this.m_ovScatterChart, 1);
    }

    protected void populateLegend(CGSEnums.DataPointMode dataPointMode, CGSEnums.MarkerShapeB markerShapeB) {
        GRLegend gRLegend = this.m_pDrawContext.getLegend();
        if (gRLegend == null) {
            return;
        }
        CGSDataMultimeasure cGSDataMultimeasure = (CGSDataMultimeasure)this.m_pData;
        int n = cGSDataMultimeasure.getSeriesNames() != null ? cGSDataMultimeasure.getSeriesNames().length : 0;
        String[] stringArray = cGSDataMultimeasure.getCategoryNames();
        if (this.useContinuousPalette() && dataPointMode == CGSEnums.DataPointMode.eDataPointShapeByCategory) {
            this.addCategoriesToLegend(markerShapeB, dataPointMode, gRLegend, false);
        } else {
            if (this.useContinuousPalette()) {
                return;
            }
            if (dataPointMode == CGSEnums.DataPointMode.eDataPointShapeByCategory) {
                if (n == 0) {
                    this.addMeasureNames(CGSEnums.MarkerShapeB.eMarkerSquareB, gRLegend);
                } else if (stringArray == null) {
                    this.addSeriesToLegend(markerShapeB, dataPointMode, gRLegend, false);
                } else {
                    this.addSeriesToLegend(CGSEnums.MarkerShapeB.eMarkerSquareB, dataPointMode, gRLegend, true);
                }
                this.addCategoriesToLegend(markerShapeB, dataPointMode, gRLegend, false);
            } else if (n == 0) {
                this.addMeasureNames(markerShapeB, gRLegend);
            } else {
                this.addSeriesToLegend(markerShapeB, dataPointMode, gRLegend, false);
            }
        }
    }

    private void addMeasureNames(CGSEnums.MarkerShapeB markerShapeB, GRLegend gRLegend) {
        CGSDataMultimeasure cGSDataMultimeasure = (CGSDataMultimeasure)this.m_pData;
        String[] stringArray = cGSDataMultimeasure.getAxisTitles();
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
            if (string != "") {
                string = string + ", ";
            }
            string = string + stringArray[i];
        }
        GRLegendItemIcon gRLegendItemIcon = new GRLegendItemIcon();
        gRLegendItemIcon.dataPointShapeFill = this.getFillEffect(0, CGSEnums.PropType.ePropPaletteDiscreteB, true);
        gRLegendItemIcon.dataPointShapeB = markerShapeB;
        boolean bl = this.m_pWidget.isDetectionAreaRequired(CGSEnums.DetArea.eDetLegendLabel, 0);
        gRLegend.addChartItem(string, CGSWidget.DataType.eMeasure, gRLegendItemIcon, 0, bl, 0);
    }

    private void addCategoriesToLegend(CGSEnums.MarkerShapeB markerShapeB, CGSEnums.DataPointMode dataPointMode, GRLegend gRLegend, boolean bl) {
        CGSDataMultimeasure cGSDataMultimeasure = (CGSDataMultimeasure)this.m_pData;
        String[] stringArray = cGSDataMultimeasure.getCategoryNames();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            GRLegendItemIcon gRLegendItemIcon = new GRLegendItemIcon();
            CGSTypeFillEffect cGSTypeFillEffect = new CGSTypeFillEffect();
            cGSTypeFillEffect.setSolidColor(Color.GRAY);
            gRLegendItemIcon.dataPointShapeFill = cGSTypeFillEffect;
            gRLegendItemIcon.dataPointShapeB = OVHelper.getShapeByCategory(i);
            for (n = 0; n < cGSDataMultimeasure.getRowCount() && cGSDataMultimeasure.getRow(n).getCategoryIndex() != i; ++n) {
            }
            boolean bl2 = this.m_pWidget.isDetectionAreaRequired(CGSEnums.DetArea.eDetLegendLabel, 0);
            gRLegend.addShapeItem(stringArray[i], gRLegendItemIcon, n, bl2);
        }
    }

    private void addSeriesToLegend(CGSEnums.MarkerShapeB markerShapeB, CGSEnums.DataPointMode dataPointMode, GRLegend gRLegend, boolean bl) {
        CGSDataMultimeasure cGSDataMultimeasure = (CGSDataMultimeasure)this.m_pData;
        String[] stringArray = cGSDataMultimeasure.getSeriesNames();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            GRLegendItemIcon gRLegendItemIcon = new GRLegendItemIcon();
            gRLegendItemIcon.dataPointShapeFill = this.getFillEffect(i, CGSEnums.PropType.ePropPaletteDiscreteB, true);
            gRLegendItemIcon.dataPointShapeOutlineColor = this.getOutlineColor(0);
            gRLegendItemIcon.materialEffect = this.getMaterialEffect();
            gRLegendItemIcon.dataPointShapeB = dataPointMode == CGSEnums.DataPointMode.eDataPointShapeByCategory ? markerShapeB : this.getGlyphShape(markerShapeB, dataPointMode, cGSDataMultimeasure, 0, i, bl);
            gRLegendItemIcon.doRotation = OVHelper.isGlyph3D(gRLegendItemIcon.dataPointShapeB);
            for (n = 0; n < cGSDataMultimeasure.getRowCount() && cGSDataMultimeasure.getRow(n).getSeriesIndex() != i; ++n) {
            }
            boolean bl2 = this.m_pWidget.isDetectionAreaRequired(CGSEnums.DetArea.eDetLegendLabel, 0);
            gRLegend.addChartItem(stringArray[i], gRLegendItemIcon, n, bl2);
        }
    }

    protected final void addGlyph(int n, int n2, CGSEnums.MarkerShapeB markerShapeB, CGSEnums.DataPointMode dataPointMode, boolean bl, boolean bl2, Color color, float f) {
        CGSDataMultimeasure cGSDataMultimeasure = (CGSDataMultimeasure)this.m_pData;
        int n3 = cGSDataMultimeasure.getPointCategoryIndex(n);
        int n4 = cGSDataMultimeasure.getPointSeriesIndex(n);
        CGSEnums.MarkerShapeB markerShapeB2 = this.getGlyphShape(markerShapeB, dataPointMode, cGSDataMultimeasure, n3, n4, false);
        IGlyph iGlyph = OVHelper.getGlyph(markerShapeB2);
        if (OVHelper.isGlyph3D(markerShapeB2)) {
            this.rotateGlyph(iGlyph);
        }
        if (bl2) {
            iGlyph.setShowBorder(true);
            iGlyph.getLineAttributes().setLineColor(color);
            if (this.m_pDrawContext.getOutputDevice().isRaster() || this.m_pDrawContext.getOutputDevice().isSVG()) {
                iGlyph.getLineAttributes().setExcludeLinesFromImageMap(true);
            }
        } else {
            iGlyph.setShowBorder(false);
        }
        if (bl) {
            if (iGlyph instanceof Sphere32Glyph) {
                iGlyph = new CircleGlyph();
                ((CircleGlyph)iGlyph).setRenderQuality(5);
            }
            iGlyph.setShowBorder(true);
            iGlyph.getLineAttributes().setLineColor(Color.black);
            CGSTypeFillEffect cGSTypeFillEffect = new CGSTypeFillEffect();
            cGSTypeFillEffect.setSolidColor(new Color(255, 0, 0, 0));
            this.m_pDrawContext.getOutputDevice().applyFillEffect(cGSTypeFillEffect, (ISurfaceFaceAttributeSceneNode)iGlyph, null, Float.valueOf(f));
        } else {
            this.applyPalette(n3, n4, 0, (ISurfaceFaceAttributeSceneNode)iGlyph, Float.valueOf(f));
        }
        this.m_glyphs[n] = iGlyph;
    }

    protected final void addSeriesImageTemplate() {
        if (this.m_pWidget.isDetectionAreaRequired(CGSEnums.DetArea.eDetChartElement, 0)) {
            this.m_ovScatterChart.setImageMapTemplate("[" + CGSEnums.DetArea.eDetChartElement.getValue() + " " + CGSWidget.DataType.eCategory.getValue() + " <Array" + this.m_gridSeriesIndexCol + "> <Array" + this.m_gridCategoryIndexCol + "> 0]");
        }
    }

    private CGSEnums.MarkerShapeB getGlyphShape(CGSEnums.MarkerShapeB markerShapeB, CGSEnums.DataPointMode dataPointMode, CGSDataMultimeasure cGSDataMultimeasure, int n, int n2, boolean bl) {
        CGSEnums.MarkerShapeB markerShapeB2;
        int n3 = this.getConditionalPaletteIndex(n2, n, 0);
        if (n3 != -1) {
            CGSPropPaletteConditionalItemB cGSPropPaletteConditionalItemB = this.getConditionalPaletteItem(n3);
            CGSPropPaletteDiscreteItemB cGSPropPaletteDiscreteItemB = cGSPropPaletteConditionalItemB == null ? this.getDiscretePaletteItem(n3) : (CGSPropPaletteDiscreteItemB)cGSPropPaletteConditionalItemB.getProp(CGSEnums.PropType.ePropPaletteDiscreteItemB);
            markerShapeB2 = cGSPropPaletteDiscreteItemB.getDataPointShape();
        } else if (dataPointMode == CGSEnums.DataPointMode.eDataPointShapeByCategory) {
            markerShapeB2 = OVHelper.getShapeByCategory(n);
        } else if (dataPointMode == CGSEnums.DataPointMode.eDataPointShapeBySeries) {
            int n4;
            CGSPropPaletteDiscreteB cGSPropPaletteDiscreteB = bl ? null : this.getDiscretePalette();
            int n5 = n4 = cGSPropPaletteDiscreteB == null ? 0 : cGSPropPaletteDiscreteB.getPaletteDiscreteItemBCount();
            markerShapeB2 = this.useContinuousPalette() ? this.getContinuousPalette().getDataPointShape() : (n4 != 0 ? cGSPropPaletteDiscreteB.getPaletteDiscreteItemB(n2 % n4).getDataPointShape() : OVHelper.getGlyphShape(markerShapeB, n2));
        } else {
            markerShapeB2 = markerShapeB;
        }
        return markerShapeB2;
    }

    protected final String getMeasurelLabelTemplate(String string, int n, CGSEnums.DataDisplayType dataDisplayType) {
        string = string.replaceAll("&", "&amp;");
        String string2 = "";
        if (dataDisplayType == CGSEnums.DataDisplayType.eDataDisplayLabelValue) {
            string2 = string2 + string + ": <Array" + n + "><br/>";
        } else if (dataDisplayType == CGSEnums.DataDisplayType.eDataDisplayValue) {
            string2 = string2 + "<Array" + n + "><br/>";
        }
        return string2;
    }

    protected final String getSeriesLabelTemplate(CGSDataMultimeasure cGSDataMultimeasure, CGSEnums.DataDisplayType dataDisplayType) {
        String string = "";
        if (cGSDataMultimeasure.hasSeries()) {
            String string2 = cGSDataMultimeasure.getSeriesTitle();
            string2 = string2.replaceAll("&", "&amp;");
            if (dataDisplayType == CGSEnums.DataDisplayType.eDataDisplayLabelValue) {
                string = string + string2 + ": <Array" + this.m_gridSeriesNameCol + "><br/>";
            } else if (dataDisplayType == CGSEnums.DataDisplayType.eDataDisplayValue) {
                string = string + "<Array" + this.m_gridSeriesNameCol + "><br/>";
            }
        }
        return string;
    }

    protected final String getCategoryLabelTemplate(CGSDataMultimeasure cGSDataMultimeasure, CGSEnums.DataDisplayType dataDisplayType) {
        String string = "";
        if (cGSDataMultimeasure.hasCategory()) {
            String string2 = cGSDataMultimeasure.getCategoryTitle();
            string2 = string2.replaceAll("&", "&amp;");
            if (dataDisplayType == CGSEnums.DataDisplayType.eDataDisplayLabelValue) {
                string = string + string2 + ": <Array" + this.m_dataLabelIndex + "><br/>";
            } else if (dataDisplayType == CGSEnums.DataDisplayType.eDataDisplayValue) {
                string = string + "<Array" + this.m_dataLabelIndex + "><br/>";
            }
        }
        return string;
    }

    protected static void setLabelCollisionMode(ScatterChart.ScatterSeries scatterSeries, CGSPropDataLabelsB cGSPropDataLabelsB, ILabelProperties iLabelProperties) {
        CGSPropDataLabelsB.LabelCollisionMode labelCollisionMode = cGSPropDataLabelsB.getLabelCollisionMode();
        if (labelCollisionMode == CGSPropDataLabelsB.LabelCollisionMode.eLabelCollisionStaggerCoarse) {
            scatterSeries.setLabelFitting(LabelFittingEnum.COARSELY_STAGGERED);
        } else if (labelCollisionMode == CGSPropDataLabelsB.LabelCollisionMode.eLabelCollisionStaggerFine) {
            scatterSeries.setLabelFitting(LabelFittingEnum.FINELY_STAGGERED);
        } else {
            scatterSeries.setLabelFitting(LabelFittingEnum.NONE);
        }
    }

    protected static void setChartLevelLabelProperties(CGSPropDataLabelsB cGSPropDataLabelsB, ILabelProperties iLabelProperties) {
        iLabelProperties.setAnchorPointDepthPosition(AnchorPointDepthPositionEnum.FRONT);
        boolean bl = cGSPropDataLabelsB.getShowLeaders();
        iLabelProperties.setShowLabelLeaders(bl);
    }

    protected final void setSeriesGlyphMap() {
        DiscreteDataMap discreteDataMap = new DiscreteDataMap();
        discreteDataMap.addComponentExceptionListener((ComponentExceptionListener)this);
        int[] nArray = new int[this.m_glyphs.length];
        Object[] objectArray = new Object[this.m_glyphs.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
            if (this.m_glyphs[i] == null) continue;
            objectArray[i] = this.m_glyphs[i].getOutputField();
        }
        discreteDataMap.setSourceValues(Integer.TYPE, (Object)nArray);
        discreteDataMap.setDestinationValues(Object.class, (Object)objectArray);
        this.m_ovScatterChart.getGlyphAttributes().setGlyphMap(discreteDataMap.getOutputDataMap());
    }

    @Override
    protected boolean useInternalColorByValue() {
        return true;
    }

    @Override
    protected boolean is3DViewportRequired() {
        return false;
    }
}

